/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderDescriptor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.nio.file.Path;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BrowseFolderRunnable<T extends JComponent>
implements Runnable {
    private final Project myProject;
    protected final TextComponentAccessor<? super T> myAccessor;
    protected final FileChooserDescriptor myFileChooserDescriptor;
    protected T myTextComponent;

    public BrowseFolderRunnable(@Nullable Project project, @NotNull FileChooserDescriptor fileChooserDescriptor, @Nullable T component, @NotNull TextComponentAccessor<? super T> accessor) {
        if (fileChooserDescriptor == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(0);
        }
        if (accessor == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(1);
        }
        if (fileChooserDescriptor.isChooseMultiple()) {
            Logger.getInstance(BrowseFolderRunnable.class).warn("multiple selection not supported");
        }
        this.myTextComponent = component;
        this.myProject = project;
        this.myFileChooserDescriptor = fileChooserDescriptor;
        this.myAccessor = accessor;
    }

    @Deprecated(forRemoval=true)
    public BrowseFolderRunnable(@NlsContexts.DialogTitle @Nullable String title, @NlsContexts.Label @Nullable String description, @Nullable Project project, @NotNull FileChooserDescriptor fileChooserDescriptor, @Nullable T component, @NotNull TextComponentAccessor<? super T> accessor) {
        if (fileChooserDescriptor == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(2);
        }
        if (accessor == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(3);
        }
        if (fileChooserDescriptor.isChooseMultiple()) {
            Logger.getInstance(BrowseFolderRunnable.class).error("multiple selection not supported");
        }
        if (title != null) {
            fileChooserDescriptor = fileChooserDescriptor.withTitle(title);
        }
        if (description != null) {
            fileChooserDescriptor = fileChooserDescriptor.withDescription(description);
        }
        this.myTextComponent = component;
        this.myProject = project;
        this.myFileChooserDescriptor = fileChooserDescriptor;
        this.myAccessor = accessor;
    }

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    @Override
    public void run() {
        this.chooseFile(this.myFileChooserDescriptor);
    }

    protected void chooseFile(FileChooserDescriptor descriptor2) {
        FileChooser.chooseFile(descriptor2, this.getProject(), this.myTextComponent, this.getInitialFile(), (Consumer<? super VirtualFile>)((Consumer)this::onFileChosen));
    }

    @Nullable
    protected VirtualFile getInitialFile() {
        String text = this.myAccessor.getText(this.myTextComponent);
        if (text == null) {
            return null;
        }
        String directoryName = text.trim();
        if (directoryName.isBlank()) {
            return null;
        }
        Path path = NioFiles.toPath((String)this.expandPath(directoryName));
        if (path == null || !path.isAbsolute()) {
            return null;
        }
        while (path != null) {
            VirtualFile result2 = LocalFileSystem.getInstance().findFileByNioFile(path);
            if (result2 != null) {
                return result2;
            }
            path = path.getParent();
        }
        return null;
    }

    @NotNull
    @NonNls
    protected String expandPath(@NotNull String path) {
        BrowseFolderDescriptor descriptor2;
        Function1<String, String> convertTextToPath;
        if (path == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(4);
        }
        String string = (convertTextToPath = (descriptor2 = BrowseFolderDescriptor.asBrowseFolderDescriptor(this.myFileChooserDescriptor)).getConvertTextToPath()) != null ? (String)convertTextToPath.invoke((Object)path) : path;
        if (string == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
        BrowseFolderDescriptor descriptor2;
        Function1<VirtualFile, String> convertFileToText;
        if (chosenFile == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(6);
        }
        if ((convertFileToText = (descriptor2 = BrowseFolderDescriptor.asBrowseFolderDescriptor(this.myFileChooserDescriptor)).getConvertFileToText()) != null) {
            String string = (String)convertFileToText.invoke((Object)chosenFile);
            if (string == null) {
                BrowseFolderRunnable.$$$reportNull$$$0(7);
            }
            return string;
        }
        Function1<String, String> convertPathToText = descriptor2.getConvertPathToText();
        if (convertPathToText != null) {
            String string = (String)convertPathToText.invoke((Object)chosenFile.getPath());
            if (string == null) {
                BrowseFolderRunnable.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = chosenFile.getPresentableUrl();
        if (string == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected String getComponentText() {
        String text = this.myAccessor.getText(this.myTextComponent);
        if (text == null) {
            return "";
        }
        String string = text.trim();
        if (string == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected void onFileChosen(@NotNull VirtualFile chosenFile) {
        if (chosenFile == null) {
            BrowseFolderRunnable.$$$reportNull$$$0(11);
        }
        this.myAccessor.setText(this.myTextComponent, this.chosenFileToResultingText(chosenFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/BrowseFolderRunnable";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/BrowseFolderRunnable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "chosenFileToResultingText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chosenFileToResultingText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onFileChosen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

