/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FileSaverRunnableKt;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B1\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0018\u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001bH\u0004J\u0015\u0010\u001e\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001f2\u0006\u0010 \u001a\u00020\u001cH\u0004J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010 \u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020\u00162\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010!\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/ui/FileSaverRunnable;", "T", "Ljavax/swing/JComponent;", "Ljava/lang/Runnable;", "Ljava/awt/event/ActionListener;", "project", "Lcom/intellij/openapi/project/Project;", "fileSaverDescriptor", "Lcom/intellij/openapi/fileChooser/FileSaverDescriptor;", "textComponent", "accessor", "Lcom/intellij/openapi/ui/TextComponentAccessor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileChooser/FileSaverDescriptor;Ljavax/swing/JComponent;Lcom/intellij/openapi/ui/TextComponentAccessor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTextComponent", "()Ljavax/swing/JComponent;", "Ljavax/swing/JComponent;", "getAccessor", "()Lcom/intellij/openapi/ui/TextComponentAccessor;", "run", "", "chooseFile", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getInitialFile", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "chosenFileToResultingText", "Lcom/intellij/openapi/util/NlsSafe;", "chosenFile", "componentText", "getComponentText", "()Ljava/lang/String;", "onFileChosen", "Ljava/io/File;", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.ide"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nFileSaverRunnable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSaverRunnable.kt\ncom/intellij/openapi/ui/FileSaverRunnable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,85:1\n1#2:86\n106#3:87\n78#3,22:88\n*S KotlinDebug\n*F\n+ 1 FileSaverRunnable.kt\ncom/intellij/openapi/ui/FileSaverRunnable\n*L\n68#1:87\n68#1:88,22\n*E\n"})
public class FileSaverRunnable<T extends JComponent>
implements Runnable,
ActionListener {
    @Nullable
    private final Project project;
    @NotNull
    private final FileSaverDescriptor fileSaverDescriptor;
    @NotNull
    private final T textComponent;
    @NotNull
    private final TextComponentAccessor<? super T> accessor;

    public FileSaverRunnable(@Nullable Project project, @NotNull FileSaverDescriptor fileSaverDescriptor, @NotNull T textComponent, @NotNull TextComponentAccessor<? super T> accessor) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileSaverDescriptor), (String)"fileSaverDescriptor");
        Intrinsics.checkNotNullParameter(textComponent, (String)"textComponent");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        this.project = project;
        this.fileSaverDescriptor = fileSaverDescriptor;
        this.textComponent = textComponent;
        this.accessor = accessor;
        if (this.fileSaverDescriptor.isChooseMultiple()) {
            FileSaverRunnableKt.access$getLogger$p().error("multiple selection not supported");
        }
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final T getTextComponent() {
        return this.textComponent;
    }

    @NotNull
    public final TextComponentAccessor<? super T> getAccessor() {
        return this.accessor;
    }

    @Override
    public void run() {
        this.chooseFile(this.fileSaverDescriptor);
    }

    protected final void chooseFile(@NotNull FileChooserDescriptor descriptor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            FileSaverDescriptor saverDescriptor = new FileSaverDescriptor(descriptor2);
            Pair<VirtualFile, String> initialFile = this.getInitialFile();
            VirtualFileWrapper virtualFileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(saverDescriptor, (Component)this.textComponent).save((VirtualFile)initialFile.getFirst(), (String)initialFile.getSecond());
            Object object = virtualFileWrapper;
            if (object == null || (object = ((VirtualFileWrapper)object).getFile()) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.onFileChosen((File)it);
        }
    }

    @NotNull
    protected final Pair<VirtualFile, String> getInitialFile() {
        String directoryName;
        String string = this.accessor.getText((Component)this.textComponent);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            string = "";
        }
        if (StringsKt.isBlank((CharSequence)(directoryName = string))) {
            return new Pair(null, null);
        }
        Object object = this.project;
        Path projectPath = object != null && (object = object.getBasePath()) != null ? NioPathUtil.toNioPathOrNull((String)object) : null;
        Path path = NioFiles.toPath((String)directoryName);
        if (path == null) {
            return new Pair(null, null);
        }
        if (!path.isAbsolute() && projectPath != null) {
            Path path2 = projectPath.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            path = path2;
        }
        Path path3 = path = path.toAbsolutePath();
        Intrinsics.checkNotNull((Object)path3);
        String fileName = ((Object)path3.getFileName()).toString();
        while (path != null) {
            VirtualFile result2 = LocalFileSystem.getInstance().findFileByNioFile(path);
            if (result2 != null) {
                return new Pair((Object)result2, (Object)fileName);
            }
            path = path.getParent();
        }
        return new Pair(null, null);
    }

    @NotNull
    protected final String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
        Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
        String string = chosenFile.getPresentableUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
        return string;
    }

    @NotNull
    protected final String getComponentText() {
        String string;
        block7: {
            block6: {
                string = this.accessor.getText((Component)this.textComponent);
                if (string == null) break block6;
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) != null) break block7;
            }
            string = "";
        }
        return string;
    }

    public void onFileChosen(@NotNull File chosenFile) {
        Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
        Component component = (Component)this.textComponent;
        String string = chosenFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.accessor.setText(component, StringsKt.replace$default((String)string, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        this.run();
    }
}

