/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class IdeGlassPaneUtil {
    private IdeGlassPaneUtil() {
    }

    @NotNull
    public static IdeGlassPane find(@NotNull Component component) {
        if (component == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(0);
        }
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Component must be instance of JComponent");
        }
        JRootPane root = ((JComponent)component).getRootPane();
        if (root == null) {
            throw new IllegalArgumentException("Component must be visible in order to find glass pane for it");
        }
        Component gp = root.getGlassPane();
        if (!(gp instanceof IdeGlassPane)) {
            throw new IllegalArgumentException("Glass pane should be " + IdeGlassPane.class.getName() + " but was " + String.valueOf(gp) + " in " + String.valueOf(root));
        }
        IdeGlassPane ideGlassPane = (IdeGlassPane)((Object)gp);
        if (ideGlassPane == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(1);
        }
        return ideGlassPane;
    }

    public static void installPainter(@NotNull JComponent target, @NotNull Painter painter, @NotNull Disposable parent) {
        if (target == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(2);
        }
        if (painter == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(4);
        }
        Activatable listeners = IdeGlassPaneUtil.createPainterActivatable(target, painter);
        UiNotifyConnector connector = UiNotifyConnector.installOn((Component)target, (Activatable)listeners);
        Disposer.register((Disposable)parent, (Disposable)connector);
    }

    @ApiStatus.Internal
    @NotNull
    public static Activatable createPainterActivatable(final @NotNull JComponent target, final @NotNull Painter painter) {
        if (target == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(5);
        }
        if (painter == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(6);
        }
        return new Activatable(){
            private Disposable panePainterListeners;

            public void showNotify() {
                IdeGlassPane pane = IdeGlassPaneUtil.find(target);
                if (this.panePainterListeners != null) {
                    Disposer.dispose((Disposable)this.panePainterListeners);
                }
                this.panePainterListeners = Disposer.newDisposable((String)"PanePainterListeners");
                pane.addPainter(target, painter, this.panePainterListeners);
            }

            public void hideNotify() {
                if (this.panePainterListeners != null) {
                    Disposer.dispose((Disposable)this.panePainterListeners);
                }
            }
        };
    }

    public static boolean canBePreprocessed(@NotNull MouseEvent e) {
        JBPopupFactory popupFactory;
        Component component;
        if (e == null) {
            IdeGlassPaneUtil.$$$reportNull$$$0(7);
        }
        if ((component = UIUtil.getDeepestComponentAt((Component)e.getComponent(), (int)e.getX(), (int)e.getY())) == null) {
            return true;
        }
        if (e.getID() != 506 && (popupFactory = (JBPopupFactory)ApplicationManager.getApplication().getServiceIfCreated(JBPopupFactory.class)) != null && popupFactory.getParentBalloonFor(component) != null) {
            return false;
        }
        if (component instanceof IdeGlassPane.TopComponent) {
            return ((IdeGlassPane.TopComponent)((Object)component)).canBePreprocessed(e);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/IdeGlassPaneUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/IdeGlassPaneUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installPainter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPainterActivatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBePreprocessed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

