/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0007H\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/psi/codeStyle/AsciiUtils;", "", "<init>", "()V", "nextWordAscii", "", "text", "", "start", "isWordStartAscii", "", "i", "isLetterAscii", "cur", "", "isLetterOrDigitAscii", "isDigitAscii", "toUpperAscii", "c", "toLowerAscii", "isUpperAscii", "isLowerAscii", "isAscii", "string", "intellij.platform.util.text.matching"})
public final class AsciiUtils {
    @NotNull
    public static final AsciiUtils INSTANCE = new AsciiUtils();

    private AsciiUtils() {
    }

    @JvmStatic
    public static final int nextWordAscii(@NotNull String text, int start2) {
        int i;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!INSTANCE.isLetterOrDigitAscii(text.charAt(start2))) {
            return start2 + 1;
        }
        for (i = start2; i < text.length() && INSTANCE.isDigitAscii(text.charAt(i)); ++i) {
        }
        if (i > start2) {
            return i;
        }
        while (i < text.length() && AsciiUtils.isUpperAscii(text.charAt(i))) {
            ++i;
        }
        if (i > start2 + 1) {
            if (i == text.length() || !INSTANCE.isLetterAscii(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start2) {
            ++i;
        }
        while (i < text.length() && INSTANCE.isLetterAscii(text.charAt(i)) && !INSTANCE.isWordStartAscii(text, i)) {
            ++i;
        }
        return i;
    }

    private final boolean isWordStartAscii(String text, int i) {
        Character prev;
        char cur = text.charAt(i);
        Character c = prev = i > 0 ? Character.valueOf(text.charAt(i - 1)) : null;
        if (AsciiUtils.isUpperAscii(cur)) {
            if (prev != null && AsciiUtils.isUpperAscii(prev.charValue())) {
                int nextPos = i + 1;
                if (nextPos >= text.length()) {
                    return false;
                }
                return AsciiUtils.isLowerAscii(text.charAt(nextPos));
            }
            return true;
        }
        if (this.isDigitAscii(cur)) {
            return true;
        }
        if (!this.isLetterAscii(cur)) {
            return false;
        }
        return i == 0 || !this.isLetterOrDigitAscii(text.charAt(i - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLetterAscii(char cur) {
        boolean bl;
        if ('a' <= cur) {
            if (cur < '{') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('A' > cur) return false;
        if (cur >= '[') return false;
        return true;
    }

    private final boolean isLetterOrDigitAscii(char cur) {
        return this.isLetterAscii(cur) || this.isDigitAscii(cur);
    }

    private final boolean isDigitAscii(char cur) {
        return '0' <= cur ? cur < ':' : false;
    }

    @JvmStatic
    public static final char toUpperAscii(char c) {
        return AsciiUtils.isLowerAscii(c) ? (char)(c - 32) : c;
    }

    @JvmStatic
    public static final char toLowerAscii(char c) {
        return AsciiUtils.isUpperAscii(c) ? (char)(c + 32) : c;
    }

    @JvmStatic
    public static final boolean isUpperAscii(char c) {
        return 'A' <= c ? c < '[' : false;
    }

    @JvmStatic
    public static final boolean isLowerAscii(char c) {
        return 'a' <= c ? c < '{' : false;
    }

    @JvmStatic
    public static final boolean isAscii(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') continue;
            return false;
        }
        return true;
    }
}

