/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.AllOccurrencesMatcher;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.FixingLayoutTypoTolerantMatcher;
import com.intellij.psi.codeStyle.MatcherWithFallback;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.PinyinMatcher;
import com.intellij.psi.codeStyle.PreferStartMatchMatcherWrapper;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class NameUtil {
    private static final int MAX_LENGTH = 40;
    private static final int TYPO_AWARE_PATTERN_LIMIT = 13;

    private NameUtil() {
    }

    @NotNull
    public static List<String> nameToWordsLowerCase(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(0);
        }
        List<String> list = NameUtilCore.nameToWordList((String)name).stream().map(Strings::toLowerCase).toList();
        if (list == null) {
            NameUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(2);
        }
        return NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        int eol;
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(3);
        }
        if ((eol = pattern.indexOf(10)) != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        @NonNls StringBuilder buffer = new StringBuilder();
        boolean bl = endsWithSpace = !forCompletion && Strings.endsWithChar((CharSequence)pattern, (char)' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        exactPrefixLen = Math.min(exactPrefixLen, pattern.length());
        boolean prevIsUppercase = false;
        if (exactPrefixLen > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        boolean lastIsUppercase = false;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        String string = buffer.toString();
        if (string == null) {
            NameUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static List<String> getSuggestionsByName(@NotNull String name, @NotNull String prefix, @NotNull String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            NameUtil.$$$reportNull$$$0(6);
        }
        if (suffix == null) {
            NameUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> answer = new ArrayList<String>();
        @NotNull List words = NameUtilCore.nameToWordList((String)name);
        for (int step = 0; step < words.size(); ++step) {
            int wordCount = preferLongerNames ? words.size() - step : step + 1;
            String startWord = (String)words.get(words.size() - wordCount);
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, true) + suffix);
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, false) + suffix);
        }
        ArrayList<String> arrayList = answer;
        if (arrayList == null) {
            NameUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static String compoundSuggestion(@NotNull String prefix, boolean upperCaseStyle, List<@NotNull String> words, int wordCount, @NotNull String startWord, char c, boolean isArray, boolean skip_) {
        if (prefix == null) {
            NameUtil.$$$reportNull$$$0(9);
        }
        if (startWord == null) {
            NameUtil.$$$reportNull$$$0(10);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        startWord = upperCaseStyle ? Strings.toUpperCase((String)startWord) : (prefix.isEmpty() || Strings.endsWithChar((CharSequence)prefix, (char)'_') ? Strings.toLowerCase((String)startWord) : Character.toUpperCase(c) + ((String)startWord).substring(1));
        buffer.append((String)startWord);
        for (int i = words.size() - wordCount + 1; i < words.size(); ++i) {
            Object word = words.get(i);
            String prevWord = words.get(i - 1);
            if (upperCaseStyle) {
                word = Strings.toUpperCase((String)word);
                if (prevWord.charAt(prevWord.length() - 1) != '_' && ((String)word).charAt(0) != '_') {
                    word = "_" + (String)word;
                }
            } else {
                if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = Strings.toLowerCase((String)word);
                }
                if (skip_) {
                    if (((String)word).equals("_")) continue;
                    if (prevWord.equals("_")) {
                        word = Strings.capitalize((String)word);
                    }
                }
            }
            buffer.append((String)word);
        }
        String suggestion = buffer.toString();
        if (isArray) {
            suggestion = Strings.pluralize((String)suggestion);
            if (upperCaseStyle) {
                suggestion = Strings.toUpperCase((String)suggestion);
            }
        }
        String string = suggestion;
        if (string == null) {
            NameUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Deprecated
    public static String @NotNull [] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(12);
        }
        String[] stringArray = NameUtilCore.splitNameIntoWords((String)name);
        if (stringArray == null) {
            NameUtil.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    @NotNull
    public static @NotNull List<@NotNull String> splitNameIntoWordList(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(14);
        }
        List list = NameUtilCore.splitNameIntoWordList((String)name);
        if (list == null) {
            NameUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Deprecated
    public static String @NotNull [] nameToWords(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(16);
        }
        String[] stringArray = NameUtilCore.nameToWords((String)name);
        if (stringArray == null) {
            NameUtil.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @NotNull
    public static @NotNull List<@NotNull String> nameToWordList(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(18);
        }
        List list = NameUtilCore.nameToWordList((String)name);
        if (list == null) {
            NameUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(20);
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    @NotNull
    public static MatcherBuilder buildMatcher(@NotNull String pattern) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(21);
        }
        return new MatcherBuilder(pattern);
    }

    @NotNull
    public static MinusculeMatcher buildMatcher(@NotNull String pattern, @NotNull MatchingCaseSensitivity options) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(22);
        }
        if (options == null) {
            NameUtil.$$$reportNull$$$0(23);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern).withCaseSensitivity(options).build();
        if (minusculeMatcher == null) {
            NameUtil.$$$reportNull$$$0(24);
        }
        return minusculeMatcher;
    }

    public static MinusculeMatcher buildMatcherWithFallback(@NotNull String pattern, @NotNull String fallbackPattern, @NotNull MatchingCaseSensitivity options) {
        if (pattern == null) {
            NameUtil.$$$reportNull$$$0(25);
        }
        if (fallbackPattern == null) {
            NameUtil.$$$reportNull$$$0(26);
        }
        if (options == null) {
            NameUtil.$$$reportNull$$$0(27);
        }
        return pattern.equals(fallbackPattern) ? NameUtil.buildMatcher(pattern, options) : new MatcherWithFallback(NameUtil.buildMatcher(pattern, options), NameUtil.buildMatcher(fallbackPattern, options));
    }

    @NotNull
    public static String capitalizeAndUnderscore(@NotNull String name) {
        if (name == null) {
            NameUtil.$$$reportNull$$$0(28);
        }
        return NameUtil.splitWords(name, '_', Strings::toUpperCase);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static String splitWords(@NotNull String text, char separator, @NotNull Function<? super String, String> transformWord) {
        if (text == null) {
            NameUtil.$$$reportNull$$$0(29);
        }
        if (transformWord == null) {
            NameUtil.$$$reportNull$$$0(30);
        }
        @NotNull List words = NameUtilCore.nameToWordList((String)text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(separator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(separator);
            } else {
                insertSeparator = true;
            }
            buf.append(transformWord.apply(word));
        }
        String string = buf.toString();
        if (string == null) {
            NameUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8, 11, 13, 15, 17, 19, 24, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/NameUtil";
                break;
            }
            case 2: 
            case 3: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startWord";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackPattern";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/NameUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWordsLowerCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegexp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestionsByName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compoundSuggestion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWords";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNameIntoWordList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWordList";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "splitWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nameToWordsLowerCase";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 31: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildRegexp";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestionsByName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compoundSuggestion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWords";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "splitNameIntoWordList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nameToWordList";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcherWithFallback";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeAndUnderscore";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "splitWords";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8, 11, 13, 15, 17, 19, 24, 31 -> new IllegalStateException(string);
        };
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static final class MatcherBuilder {
        private final String pattern;
        private String separators = "";
        private MatchingCaseSensitivity caseSensitivity = MatchingCaseSensitivity.NONE;
        private boolean typoTolerant = false;
        private boolean preferStartMatches = false;
        private boolean allOccurrences = false;

        public MatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        public MatcherBuilder withCaseSensitivity(MatchingCaseSensitivity caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        public MatcherBuilder withSeparators(String separators) {
            this.separators = separators;
            return this;
        }

        public MatcherBuilder typoTolerant() {
            this.typoTolerant = this.pattern.length() <= 13;
            return this;
        }

        public MatcherBuilder preferringStartMatches() {
            this.preferStartMatches = true;
            return this;
        }

        public MatcherBuilder allOccurrences() {
            this.allOccurrences = true;
            return this;
        }

        public MinusculeMatcher build() {
            MinusculeMatcher matcher;
            MinusculeMatcher minusculeMatcher = this.typoTolerant ? FixingLayoutTypoTolerantMatcher.create(this.pattern, this.caseSensitivity, this.separators) : (matcher = this.allOccurrences ? AllOccurrencesMatcher.create(this.pattern, this.caseSensitivity, this.separators) : new FixingLayoutMatcher(this.pattern, this.caseSensitivity, this.separators));
            if (this.preferStartMatches) {
                matcher = new PreferStartMatchMatcherWrapper(matcher);
            }
            matcher = PinyinMatcher.create(matcher);
            return matcher;
        }
    }
}

