/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerValueEditor
extends TextFieldValueEditor<Integer> {
    private int myMinValue;
    private int myMaxValue;
    private boolean myCanBeEmpty;

    public IntegerValueEditor(@NotNull JTextField field, @Nullable String valueName, @NotNull Integer defaultValue) {
        if (field == null) {
            IntegerValueEditor.$$$reportNull$$$0(0);
        }
        if (defaultValue == null) {
            IntegerValueEditor.$$$reportNull$$$0(1);
        }
        super(field, valueName, defaultValue);
    }

    @Override
    @NotNull
    public Integer parseValue(@Nullable String text) throws InvalidDataException {
        block7: {
            Integer n;
            try {
                if (!StringUtil.isEmpty((String)text)) break block7;
                if (!this.myCanBeEmpty) {
                    throw new InvalidDataException(ApplicationBundle.message((String)"integer.field.value.expected", (Object[])new Object[0]));
                }
                n = (Integer)this.getDefaultValue();
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDataException(ApplicationBundle.message((String)"integer.field.value.not.a.number", (Object[])new Object[]{text}));
            }
            if (n == null) {
                IntegerValueEditor.$$$reportNull$$$0(2);
            }
            return n;
        }
        int value2 = Integer.parseInt(text);
        if (value2 < this.myMinValue || value2 > this.myMaxValue) {
            throw new InvalidDataException(ApplicationBundle.message((String)"integer.field.value.out.of.range", (Object[])new Object[]{value2, this.myMinValue, this.myMaxValue}));
        }
        Integer n = value2;
        if (n == null) {
            IntegerValueEditor.$$$reportNull$$$0(3);
        }
        return n;
    }

    @Override
    public String valueToString(@NotNull Integer value2) {
        if (value2 == null) {
            IntegerValueEditor.$$$reportNull$$$0(4);
        }
        if (this.myCanBeEmpty && value2.equals(this.getDefaultValue())) {
            return "";
        }
        return String.valueOf(value2);
    }

    @Override
    public boolean isValid(@NotNull Integer value2) {
        if (value2 == null) {
            IntegerValueEditor.$$$reportNull$$$0(5);
        }
        return value2 >= this.myMinValue && value2 <= this.myMaxValue;
    }

    public int getMinValue() {
        return this.myMinValue;
    }

    public int getMaxValue() {
        return this.myMaxValue;
    }

    public void setMinValue(int minValue) {
        this.myMinValue = minValue;
    }

    public void setMaxValue(int maxValue) {
        this.myMaxValue = maxValue;
    }

    public boolean isCanBeEmpty() {
        return this.myCanBeEmpty;
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.myCanBeEmpty = canBeEmpty;
    }

    @Override
    protected boolean isShowError(@Nullable String errorText) {
        if (StringUtil.isEmpty((String)this.getValueText())) {
            return false;
        }
        return super.isShowError(errorText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/valueEditors/IntegerValueEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/valueEditors/IntegerValueEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "valueToString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

