/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0002\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"ABC_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/ui/tabs/TabInfo;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SCROLL_BAR_THICKNESS", "", "LAYOUT_DONE", "", "Lorg/jetbrains/annotations/NonNls;", "getFocusOwner", "Ljavax/swing/JComponent;", "updateToolbarIfVisibilityChanged", "", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "previousBounds", "Ljava/awt/Rectangle;", "ARC_SIZE", "createToolbar", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "targetComponent", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "sortTabsAlphabetically", "tabs", "", "DUMMY_COMPONENT", "Ljavax/swing/JPanel;", "getDUMMY_COMPONENT", "()Ljavax/swing/JPanel;", "DUMMY_COMPONENT$delegate", "Lkotlin/Lazy;", "isToDeferRemoveForLater", "", "c", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nJBTabsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBTabsImpl.kt\ncom/intellij/ui/tabs/impl/JBTabsImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,3679:1\n388#2,7:3680\n13#3:3687\n*S KotlinDebug\n*F\n+ 1 JBTabsImpl.kt\ncom/intellij/ui/tabs/impl/JBTabsImplKt\n*L\n3393#1:3680,7\n89#1:3687\n*E\n"})
public final class JBTabsImplKt {
    @NotNull
    private static final Comparator<TabInfo> ABC_COMPARATOR = JBTabsImplKt::ABC_COMPARATOR$lambda$0;
    @NotNull
    private static final Logger LOG;
    private static final int SCROLL_BAR_THICKNESS = 5;
    @NotNull
    private static final String LAYOUT_DONE = "Layout.done";
    private static final int ARC_SIZE = 4;
    @NotNull
    private static final Lazy DUMMY_COMPONENT$delegate;

    private static final JComponent getFocusOwner() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component instanceof JComponent ? (JComponent)component : null;
    }

    private static final void updateToolbarIfVisibilityChanged(ActionToolbar toolbar, Rectangle previousBounds) {
        if (toolbar == null) {
            return;
        }
        Rectangle bounds = toolbar.getComponent().getBounds();
        if (bounds.isEmpty() != previousBounds.isEmpty()) {
            toolbar.updateActionsAsync();
        }
    }

    private static final ActionToolbar createToolbar(ActionGroup group, JComponent targetComponent, ActionManager actionManager) {
        ActionToolbar actionToolbar = actionManager.createActionToolbar("TabsMoreToolbar", group, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(targetComponent);
        toolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        toolbar.getComponent().setOpaque(false);
        toolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        return toolbar;
    }

    private static final void sortTabsAlphabetically(List<TabInfo> tabs) {
        int lastPinnedIndex;
        block3: {
            int n;
            List<TabInfo> $this$indexOfLast$iv = tabs;
            boolean $i$f$indexOfLast = false;
            ListIterator<TabInfo> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                TabInfo it = iterator$iv.previous();
                boolean bl = false;
                if (!it.isPinned()) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = lastPinnedIndex = -1;
        }
        if (lastPinnedIndex == -1 || !AdvancedSettings.Companion.getBoolean("editor.keep.pinned.tabs.on.left")) {
            CollectionsKt.sortWith(tabs, ABC_COMPARATOR);
        } else {
            CollectionsKt.sortWith(tabs.subList(0, lastPinnedIndex + 1), ABC_COMPARATOR);
            CollectionsKt.sortWith(tabs.subList(lastPinnedIndex + 1, tabs.size()), ABC_COMPARATOR);
        }
    }

    private static final JPanel getDUMMY_COMPONENT() {
        Lazy lazy = DUMMY_COMPONENT$delegate;
        return (JPanel)lazy.getValue();
    }

    private static final boolean isToDeferRemoveForLater(JComponent c) {
        return c.getRootPane() != null;
    }

    private static final int ABC_COMPARATOR$lambda$0(TabInfo o1, TabInfo o2) {
        return NaturalComparator.INSTANCE.compare(o1.getText(), o2.getText());
    }

    private static final JPanel DUMMY_COMPONENT_delegate$lambda$0() {
        return new JPanel();
    }

    public static final /* synthetic */ ActionToolbar access$createToolbar(ActionGroup group, JComponent targetComponent, ActionManager actionManager) {
        return JBTabsImplKt.createToolbar(group, targetComponent, actionManager);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ JComponent access$getFocusOwner() {
        return JBTabsImplKt.getFocusOwner();
    }

    public static final /* synthetic */ void access$sortTabsAlphabetically(List tabs) {
        JBTabsImplKt.sortTabsAlphabetically(tabs);
    }

    public static final /* synthetic */ void access$updateToolbarIfVisibilityChanged(ActionToolbar toolbar, Rectangle previousBounds) {
        JBTabsImplKt.updateToolbarIfVisibilityChanged(toolbar, previousBounds);
    }

    public static final /* synthetic */ boolean access$isToDeferRemoveForLater(JComponent c) {
        return JBTabsImplKt.isToDeferRemoveForLater(c);
    }

    public static final /* synthetic */ JPanel access$getDUMMY_COMPONENT() {
        return JBTabsImplKt.getDUMMY_COMPONENT();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JBTabsImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DUMMY_COMPONENT$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, JBTabsImplKt::DUMMY_COMPONENT_delegate$lambda$0);
    }
}

