/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.credentialStore.Credentials;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.net.DisabledProxyAuthPromptsManager;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ProxyAuthentication;
import com.intellij.util.net.ProxyAuthenticationKt;
import com.intellij.util.net.ProxyCredentialStore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/net/PlatformProxyAuthentication;", "Lcom/intellij/util/net/ProxyAuthentication;", "getCredentialStore", "Lkotlin/Function0;", "Lcom/intellij/util/net/ProxyCredentialStore;", "getDisabledPromptsManager", "Lcom/intellij/util/net/DisabledProxyAuthPromptsManager;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getKnownAuthentication", "Lcom/intellij/credentialStore/Credentials;", "host", "", "port", "", "getPromptedAuthentication", "prompt", "isPromptedAuthenticationCancelled", "", "enablePromptedAuthentication", "", "runAboveAll", "runnable", "Ljava/lang/Runnable;", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProxyAuthentication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyAuthentication.kt\ncom/intellij/util/net/PlatformProxyAuthentication\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,191:1\n60#2,5:192\n60#2,5:197\n60#2,5:202\n60#2,5:207\n61#2,4:212\n60#2,5:216\n*S KotlinDebug\n*F\n+ 1 ProxyAuthentication.kt\ncom/intellij/util/net/PlatformProxyAuthentication\n*L\n115#1:192,5\n125#1:197,5\n134#1:202,5\n138#1:207,5\n145#1:212,4\n170#1:216,5\n*E\n"})
public final class PlatformProxyAuthentication
implements ProxyAuthentication {
    @NotNull
    private final Function0<ProxyCredentialStore> getCredentialStore;
    @NotNull
    private final Function0<DisabledProxyAuthPromptsManager> getDisabledPromptsManager;

    public PlatformProxyAuthentication(@NotNull Function0<? extends ProxyCredentialStore> getCredentialStore, @NotNull Function0<? extends DisabledProxyAuthPromptsManager> getDisabledPromptsManager) {
        Intrinsics.checkNotNullParameter(getCredentialStore, (String)"getCredentialStore");
        Intrinsics.checkNotNullParameter(getDisabledPromptsManager, (String)"getDisabledPromptsManager");
        this.getCredentialStore = getCredentialStore;
        this.getDisabledPromptsManager = getDisabledPromptsManager;
    }

    @Override
    @Nullable
    public Credentials getKnownAuthentication(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Credentials credentials = ((ProxyCredentialStore)this.getCredentialStore.invoke()).getCredentials(host, port);
        Logger $this$debug_u24default$iv = ProxyAuthenticationKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(credentials != null ? "returning known credentials for " + host + ":" + port + ", credentials=" + credentials : "no known credentials for " + host + ":" + port, t$iv);
        }
        return credentials;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Credentials getPromptedAuthentication(@NotNull String prompt, @NotNull String host, int port) {
        Logger logger;
        boolean $i$f$debug;
        Throwable t$iv;
        Object login;
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isDisposed()) {
            Logger $this$debug_u24default$iv = ProxyAuthenticationKt.access$getLOG$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("prompted auth for " + host + ":" + port + ": null, application is not initialized yet/already disposed ", t$iv2);
            }
            return null;
        }
        if (app.isUnitTestMode()) {
            ProxyAuthenticationKt.access$getLOG$p().warn("prompted auth for " + host + ":" + port + ": can't prompt proxy authentication in tests");
            return null;
        }
        if (app.isHeadlessEnvironment()) {
            Logger $this$debug_u24default$iv = ProxyAuthenticationKt.access$getLOG$p();
            Throwable t$iv3 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger3 = $this$debug_u24default$iv;
                boolean bl = false;
                logger3.debug("prompted auth for " + host + ":" + port + ": null, can't prompt in headless mode ", t$iv3);
            }
            return null;
        }
        if (this.isPromptedAuthenticationCancelled(host, port)) {
            Logger $this$debug_u24default$iv = ProxyAuthenticationKt.access$getLOG$p();
            Throwable t$iv4 = null;
            boolean $i$f$debug4 = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger4 = $this$debug_u24default$iv;
                boolean bl = false;
                logger4.debug("prompted auth for " + host + ":" + port + ": prompted auth was cancelled ", t$iv4);
            }
            return null;
        }
        ProxyCredentialStore credentialStore = (ProxyCredentialStore)this.getCredentialStore.invoke();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        Object object = credentialStore.getCredentials(host, port);
        if (object == null || (object = ((Credentials)object).getUserName()) == null) {
            object = login = "";
        }
        if (ProxyAuthenticationKt.access$getLOG$p().isDebugEnabled()) {
            void $this$debug$iv;
            Logger bl = ProxyAuthenticationKt.access$getLOG$p();
            t$iv = new Exception("proxy auth stacktrace");
            $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl2 = false;
                logger.debug("prompting auth for " + host + ":" + port, t$iv);
            }
        }
        this.runAboveAll(() -> PlatformProxyAuthentication.getPromptedAuthentication$lambda$4(host, prompt, (String)login, credentialStore, port, result2, this));
        Logger $this$debug_u24default$iv = ProxyAuthenticationKt.access$getLOG$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug((String)(result2.element != null ? "prompted auth for " + host + ":" + port + ": " + result2.element : "prompted auth was cancelled"), t$iv);
        }
        return (Credentials)result2.element;
    }

    @Override
    public boolean isPromptedAuthenticationCancelled(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return ((DisabledProxyAuthPromptsManager)this.getDisabledPromptsManager.invoke()).isPromptedAuthenticationDisabled(host, port);
    }

    @Override
    public void enablePromptedAuthentication(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        ((DisabledProxyAuthPromptsManager)this.getDisabledPromptsManager.invoke()).enablePromptedAuthentication(host, port);
    }

    private final void runAboveAll(Runnable runnable) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isModal()) {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)runnable);
        } else {
            ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.any());
        }
    }

    private static final void getPromptedAuthentication$lambda$4(String $host, String $prompt, String $login, ProxyCredentialStore $credentialStore, int $port, Ref.ObjectRef $result, PlatformProxyAuthentication this$0) {
        Object[] objectArray = new Object[]{$host};
        String string = IdeBundle.message("dialog.title.proxy.authentication", objectArray);
        objectArray = new Object[]{$prompt};
        AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), string, IdeBundle.message("dialog.message.please.enter.credentials.for", objectArray), $login, "", HttpConfigurable.getInstance().KEEP_PROXY_PASSWORD);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            AuthenticationPanel panel2 = dialog.getPanel();
            Credentials credentials = new Credentials(panel2.getLogin(), panel2.getPassword());
            $credentialStore.setCredentials($host, $port, credentials, panel2.isRememberPassword());
            HttpConfigurable.getInstance().KEEP_PROXY_PASSWORD = panel2.isRememberPassword();
            $result.element = credentials;
        } else {
            ((DisabledProxyAuthPromptsManager)this$0.getDisabledPromptsManager.invoke()).disablePromptedAuthentication($host, $port);
        }
    }
}

