/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Extensions {
    @Nullable
    private static Supplier<ExtensionsAreaImpl> rootSupplier = null;
    private static ExtensionsAreaImpl staticRootArea;

    private Extensions() {
    }

    @ApiStatus.Internal
    public static void setRootArea(@NotNull ExtensionsAreaImpl area) {
        if (area == null) {
            Extensions.$$$reportNull$$$0(0);
        }
        staticRootArea = area;
    }

    @ApiStatus.Internal
    public static void setRootAreaSupplier(@NotNull Supplier<ExtensionsAreaImpl> supplier) {
        if (supplier == null) {
            Extensions.$$$reportNull$$$0(1);
        }
        rootSupplier = supplier;
    }

    @ApiStatus.Internal
    @TestOnly
    public static void setRootArea(@NotNull ExtensionsAreaImpl area, @NotNull Disposable parentDisposable) {
        if (area == null) {
            Extensions.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            Extensions.$$$reportNull$$$0(3);
        }
        ExtensionsAreaImpl oldRootArea = staticRootArea;
        staticRootArea = area;
        Disposer.register((Disposable)parentDisposable, () -> {
            staticRootArea.notifyAreaReplaced(oldRootArea);
            staticRootArea = oldRootArea;
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static ExtensionsArea getRootArea() {
        if (rootSupplier != null) {
            return rootSupplier.get();
        }
        return staticRootArea;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static ExtensionsArea getArea(@Nullable(value="null means root") @Nullable(value="null means root") AreaInstance areaInstance) {
        ExtensionsArea extensionsArea = areaInstance == null ? Extensions.getRootArea() : areaInstance.getExtensionArea();
        if (extensionsArea == null) {
            Extensions.$$$reportNull$$$0(4);
        }
        return extensionsArea;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <T> T @NotNull [] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(5);
        }
        T[] TArray = extensionPointName.getExtensions();
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(6);
        }
        return TArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <T> T @NotNull [] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, @Nullable AreaInstance areaInstance) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(7);
        }
        T[] TArray = extensionPointName.getExtensions(areaInstance);
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(8);
        }
        return TArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(9);
        }
        if (extClass == null) {
            Extensions.$$$reportNull$$$0(10);
        }
        U u = extensionPointName.findExtensionOrFail(extClass);
        if (u == null) {
            Extensions.$$$reportNull$$$0(11);
        }
        return u;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/Extensions";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/Extensions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArea";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRootArea";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRootAreaSupplier";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

