/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.debugger.impl.shared.XDebuggerWatchesManager;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ConfigurationState;
import com.intellij.xdebugger.impl.InlineWatchState;
import com.intellij.xdebugger.impl.WatchState;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.XAlwaysEvaluatedWatch;
import com.intellij.xdebugger.impl.XWatch;
import com.intellij.xdebugger.impl.XWatchImpl;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchInplaceEditor;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XDebuggerWatchesManagerImpl
implements XDebuggerWatchesManager {
    private final Map<String, List<XWatch>> watches;
    private final Map<String, Set<InlineWatch>> inlineWatches;
    private final MergingUpdateQueue myInlinesUpdateQueue;
    private final Project myProject;

    public XDebuggerWatchesManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(1);
        }
        this.watches = new ConcurrentHashMap<String, List<XWatch>>();
        this.inlineWatches = new ConcurrentHashMap<String, Set<InlineWatch>>();
        this.myProject = project;
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        editorEventMulticaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
        this.myProject.getMessageBus().connect().subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile file, @NotNull Document document) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                XDebuggerWatchesManagerImpl.this.getDocumentInlines(document).forEach(InlineWatch::setMarker);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/XDebuggerWatchesManagerImpl$1";
                objectArray[2] = "fileContentLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myInlinesUpdateQueue = MergingUpdateQueue.Companion.edtMergingUpdateQueue("XInlineWatches", 300, coroutineScope);
    }

    @NotNull
    public List<XWatch> getWatchEntries(@NotNull String configurationName) {
        if (configurationName == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.notNullize(this.watches.get(configurationName));
        if (list == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setWatchEntries(@NotNull String configurationName, @NotNull List<XWatch> watchList) {
        if (configurationName == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(4);
        }
        if (watchList == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(5);
        }
        if (watchList.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, watchList);
        }
    }

    @Deprecated
    @NotNull
    public List<XExpression> getWatches(String configurationName) {
        List list = ContainerUtil.map((Collection)ContainerUtil.notNullize(this.watches.get(configurationName)), XWatch::getExpression);
        if (list == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Deprecated
    public void setWatches(@NotNull String configurationName, @NotNull List<XExpression> expressions) {
        if (configurationName == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(7);
        }
        if (expressions == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(8);
        }
        if (expressions.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, ContainerUtil.map(expressions, XWatchImpl::new));
        }
    }

    @NotNull
    public List<InlineWatch> getInlineWatches() {
        List<InlineWatch> list = this.inlineWatches.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        if (list == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public WatchesManagerState saveState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(10);
        }
        List<ConfigurationState> expressions = state.getExpressions();
        expressions.clear();
        this.watches.forEach((key, value) -> expressions.add(new ConfigurationState((String)key, (List<? extends XWatch>)value)));
        List<InlineWatchState> inlineExpressionStates = state.getInlineExpressionStates();
        inlineExpressionStates.clear();
        this.inlineWatches.values().stream().flatMap(l -> l.stream()).forEach(value -> inlineExpressionStates.add(new InlineWatchState(value.getExpression(), value.getLine(), value.getPosition().getFile().getUrl())));
        WatchesManagerState watchesManagerState = state;
        if (watchesManagerState == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(11);
        }
        return watchesManagerState;
    }

    public void clearContext() {
        this.watches.clear();
        this.inlineWatches.clear();
    }

    @ApiStatus.Internal
    public void loadState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(12);
        }
        this.clearContext();
        for (ConfigurationState configurationState : state.getExpressions()) {
            List<WatchState> expressionStates = configurationState.getExpressionStates();
            if (ContainerUtil.isEmpty(expressionStates)) continue;
            this.watches.put(configurationState.getName(), ContainerUtil.mapNotNull(expressionStates, watchState -> {
                XExpression expression = watchState.toXExpression();
                if (expression == null) {
                    return null;
                }
                if (!watchState.getCanBePaused()) {
                    return new XAlwaysEvaluatedWatch(expression);
                }
                XWatchImpl watch = new XWatchImpl(expression);
                watch.setPaused(watchState.isPaused());
                return watch;
            }));
        }
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
        for (InlineWatchState inlineWatchState : state.getInlineExpressionStates()) {
            if (inlineWatchState.getFileUrl() == null || inlineWatchState.getWatchState() == null) continue;
            VirtualFile file = fileManager.findFileByUrl(inlineWatchState.getFileUrl());
            XSourcePosition position = debuggerUtil.createPosition(file, inlineWatchState.getLine());
            XExpression expression = inlineWatchState.getWatchState().toXExpression();
            if (position == null || expression == null) continue;
            InlineWatch watch = new InlineWatch(expression, position);
            this.inlineWatches.computeIfAbsent(inlineWatchState.getFileUrl(), k -> new HashSet()).add(watch);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (InlineWatch i : ContainerUtil.flatten(this.inlineWatches.values())) {
                ReadAction.nonBlocking(() -> {
                    if (!i.setMarker()) {
                        this.inlineWatches.get(i.getPosition().getFile().getUrl()).remove(i);
                    }
                }).executeSynchronously();
            }
        });
    }

    public void showInplaceEditor(@NotNull XSourcePosition presentationPosition, @NotNull Editor mainEditor, @NotNull XDebugSessionProxy session, @Nullable XExpression expression) {
        if (presentationPosition == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(13);
        }
        if (mainEditor == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(14);
        }
        if (session == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(15);
        }
        InlineWatchInplaceEditor inplaceEditor = new InlineWatchInplaceEditor(presentationPosition, session, mainEditor, expression);
        inplaceEditor.show();
    }

    public void inlineWatchesRemoved(@NotNull List<InlineWatch> removed, XInlineWatchesView watchesView) {
        if (removed == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(16);
        }
        this.inlineWatches.values().forEach(set -> removed.forEach(set::remove));
        this.getWatchesViews().filter(v -> v != watchesView).forEach(view -> view.removeInlineWatches((Collection)removed));
    }

    public void addInlineWatchExpression(@NotNull XExpression expression, int index, @NotNull XSourcePosition position, boolean navigateToWatchNode) {
        if (expression == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(17);
        }
        if (position == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(18);
        }
        InlineWatch watch = new InlineWatch(expression, position);
        watch.setMarker();
        String fileUrl = position.getFile().getUrl();
        this.inlineWatches.computeIfAbsent(fileUrl, k -> new HashSet()).add(watch);
        this.getWatchesViews().forEach(view -> view.addInlineWatchExpression(watch, index, navigateToWatchNode));
    }

    private void updateInlines(@NotNull Document document) {
        Collection<InlineWatch> inlines;
        if (document == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(19);
        }
        if ((inlines = this.getDocumentInlines(document)).isEmpty()) {
            return;
        }
        HashSet<InlineWatch> toRemove = new HashSet<InlineWatch>();
        for (InlineWatch inlineWatch : inlines) {
            if (inlineWatch.updatePosition()) continue;
            toRemove.add(inlineWatch);
        }
        this.removeInlines(toRemove);
    }

    private void removeInlines(Collection<InlineWatch> remove) {
        for (InlineWatch watch : remove) {
            this.inlineWatches.get(watch.getPosition().getFile().getUrl()).remove(watch);
        }
        this.getWatchesViews().forEach(view -> view.removeInlineWatches(remove));
    }

    private Stream<XInlineWatchesView> getWatchesViews() {
        return ((StreamEx)StreamEx.of((Collection)XDebugManagerProxy.getInstance().getSessions(this.myProject)).map(XDebugSessionProxy::getSessionTab).select(XDebugSessionTab.class).filter(t -> t != null && t.getWatchesView() instanceof XInlineWatchesView)).map(t -> (XInlineWatchesView)t.getWatchesView());
    }

    @NotNull
    public Collection<InlineWatch> getDocumentInlines(@NotNull Document document) {
        Set<InlineWatch> inlineWatches;
        VirtualFile file;
        if (document == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(20);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) != null && (inlineWatches = this.inlineWatches.get(file.getUrl())) != null) {
            return new ArrayList<InlineWatch>(inlineWatches);
        }
        List<InlineWatch> list = Collections.emptyList();
        if (list == null) {
            XDebuggerWatchesManagerImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 11, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerWatchesManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationPosition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainEditor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerWatchesManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchEntries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatches";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineWatches";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentInlines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWatchEntries";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 21: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setWatchEntries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setWatches";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showInplaceEditor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "inlineWatchesRemoved";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addInlineWatchExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateInlines";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentInlines";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 11, 21 -> new IllegalStateException(string);
        };
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Document document;
            Collection<InlineWatch> inlines;
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (!(inlines = XDebuggerWatchesManagerImpl.this.getDocumentInlines(document = e.getDocument())).isEmpty()) {
                XDebuggerWatchesManagerImpl.this.myInlinesUpdateQueue.queue(Update.create((Object)document, () -> XDebuggerWatchesManagerImpl.this.updateInlines(document)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/XDebuggerWatchesManagerImpl$MyDocumentListener", "documentChanged"));
        }
    }
}

