/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class EditBreakpointActionHandler
extends DebuggerActionHandler {
    protected abstract void doShowPopup(Project var1, JComponent var2, Point var3, XBreakpointProxy var4);

    @Override
    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        DataContext dataContext;
        Editor editor;
        if (project == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(0);
        }
        if (event == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(1);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext = event.getDataContext())) == null) {
            return;
        }
        Pair<GutterIconRenderer, XBreakpointProxy> pair = XBreakpointUtil.findSelectedBreakpointProxy(project, editor);
        XBreakpointProxy breakpoint2 = (XBreakpointProxy)pair.second;
        GutterIconRenderer breakpointGutterRenderer = (GutterIconRenderer)pair.first;
        if (breakpointGutterRenderer == null) {
            return;
        }
        this.editBreakpoint(project, editor, breakpoint2, breakpointGutterRenderer);
    }

    public void editBreakpoint(@NotNull Project project, @NotNull Editor editor, @NotNull XBreakpointProxy breakpoint2, @NotNull GutterIconRenderer breakpointGutterRenderer) {
        if (project == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(3);
        }
        if (breakpoint2 == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(4);
        }
        if (breakpointGutterRenderer == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(5);
        }
        if (BreakpointsDialogFactory.getInstance(project).popupRequested(breakpoint2)) {
            return;
        }
        EditorGutterComponentEx gutterComponent = ((EditorEx)editor).getGutterComponentEx();
        Point point = gutterComponent.getCenterPoint(breakpointGutterRenderer);
        if (point == null) {
            point = new Point(gutterComponent.getWidth(), editor.visualPositionToXY((VisualPosition)editor.getCaretModel().getVisualPosition()).y + editor.getLineHeight() / 2);
        }
        this.doShowPopup(project, (JComponent)gutterComponent, point, breakpoint2);
    }

    public void editBreakpoint(@NotNull Project project, @NotNull JComponent parent, @NotNull Point whereToShow, @NotNull BreakpointItem breakpoint2) {
        if (project == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(7);
        }
        if (whereToShow == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(8);
        }
        if (breakpoint2 == null) {
            EditBreakpointActionHandler.$$$reportNull$$$0(9);
        }
        XBreakpointProxy breakpointProxy = breakpoint2.getBreakpoint();
        this.doShowPopup(project, parent, whereToShow, breakpointProxy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointGutterRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whereToShow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/EditBreakpointActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "editBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

