/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerCustomEvaluateHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerCustomEvaluateHandlerKt;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        XDebuggerCustomEvaluateHandler customHandler;
        if (project == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(0);
        }
        if (event == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(1);
        }
        if ((customHandler = XDebuggerCustomEvaluateHandlerKt.getAvailableCustomEvaluateHandler(project, event)) != null) {
            XDebuggerCustomEvaluateHandlerKt.showCustomEvaluateDialog(customHandler, project, event);
            return;
        }
        super.perform(project, event);
    }

    @Override
    protected void perform(@NotNull XDebugSessionProxy session, @NotNull DataContext dataContext) {
        if (session == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(3);
        }
        XDebuggerEditorsProvider editorsProvider = session.getEditorsProvider();
        XStackFrame stackFrame = session.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = session.getCurrentEvaluator();
        if (evaluator == null) {
            return;
        }
        DataContext focusedDataContext = XDebuggerEvaluateActionHandler.extractFocusedDataContext(dataContext);
        if (focusedDataContext != null) {
            dataContext = focusedDataContext;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(dataContext);
        XValue selectedValue = node == null ? null : (XValue)node.getValueContainer();
        XDebuggerEvaluateActionHandler.getSelectedExpressionAsync(project, evaluator, editor, psiFile, selectedValue).onSuccess(expression -> AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session, file, editorsProvider, stackFrame, evaluator, expression)));
    }

    @Nullable
    public static DataContext extractFocusedDataContext(DataContext actionDataContext) {
        Window window;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (focusOwner == null && (window = ComponentUtil.getWindow((Component)((Component)actionDataContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)))) != null) {
            focusOwner = window.getMostRecentFocusOwner();
        }
        if (focusOwner != null && ClientId.isCurrentlyUnderLocalId()) {
            return DataManager.getInstance().getDataContext(focusOwner);
        }
        return null;
    }

    public static Promise<@Nullable XExpression> getSelectedExpressionAsync(@Nullable Project project, @NotNull XDebuggerEvaluator evaluator, @Nullable Editor editor, @Nullable PsiFile psiFile, @Nullable XValue selectedValue) {
        if (evaluator == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(4);
        }
        return XDebuggerEvaluateActionHandler.getSelectedTextAsync(project, evaluator, editor, psiFile).thenAsync(pair -> {
            Promise expressionPromise = Promises.resolvedPromise(null);
            if (pair.first != null) {
                expressionPromise = Promises.resolvedPromise((Object)XExpressionImpl.fromText((String)pair.first, (EvaluationMode)pair.second));
            } else if (selectedValue != null) {
                expressionPromise = selectedValue.calculateEvaluationExpression();
            }
            return expressionPromise;
        });
    }

    public static Promise<Pair<@Nullable String, EvaluationMode>> getSelectedTextAsync(@Nullable Project project, @NotNull XDebuggerEvaluator evaluator, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        String selectedText;
        if (evaluator == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(5);
        }
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
            mode = evaluator.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), psiFile);
        }
        Promise<String> expressionTextPromise = Promises.resolvedPromise((Object)selectedText);
        if (selectedText == null && editor != null) {
            expressionTextPromise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, project, editor);
        }
        EvaluationMode finalMode = mode;
        return expressionTextPromise.then(expression -> Pair.create((Object)expression, (Object)finalMode));
    }

    private static void showDialog(@NotNull XDebugSessionProxy session, VirtualFile file, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator, @Nullable XExpression expression) {
        if (session == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            expression = XExpressionImpl.EMPTY_EXPRESSION;
        }
        if (expression.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file.getFileType());
            }
            expression = new XExpressionImpl(expression.getExpression(), language, expression.getCustomInfo(), expression.getMode());
        }
        XSourcePosition position = stackFrame == null ? null : stackFrame.getSourcePosition();
        new XDebuggerEvaluationDialog(session, editorsProvider, expression, position, evaluator.isCodeFragmentEvaluationSupported()).show();
    }

    @NotNull
    public static Promise<String> getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project, @NotNull Editor editor) {
        if (editor == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(7);
        }
        if (project == null || evaluator == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                XDebuggerEvaluateActionHandler.$$$reportNull$$$0(8);
            }
            return promise;
        }
        Document document = editor.getDocument();
        Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(project, document, editor.getCaretModel().getOffset(), true);
        Promise promise = expressionInfoPromise.then(expressionInfo -> XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, document));
        if (promise == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(9);
        }
        return promise;
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(10);
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getExpressionText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(11);
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getDisplayText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        if (project == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(12);
        }
        if (event == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(13);
        }
        if (XDebuggerCustomEvaluateHandlerKt.getAvailableCustomEvaluateHandler(project, event) != null) {
            return true;
        }
        return super.isEnabled(project, event);
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSessionProxy session, @NotNull DataContext dataContext) {
        if (session == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(14);
        }
        if (dataContext == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(15);
        }
        return session.getCurrentEvaluator() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpressionAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTextAsync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionText";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayText";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

