/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.ide.rpc.util.TextRangeId;
import com.intellij.ide.rpc.util.TextRangeIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionApi;
import com.intellij.platform.debugger.impl.rpc.XSmartStepIntoTargetDto;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XSmartStepIntoHandlerEntry;
import com.intellij.ui.Hint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.actions.handlers.SmartStepData;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerSmartStepIntoHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerSmartStepIntoHandlerKt;
import com.intellij.xdebugger.impl.actions.handlers.XSmartStepIntoTarget;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a.\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a.\u0010\u0015\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a&\u0010\u001b\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a)\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u000b\u0010\"\u001a\u00070\n\u00a2\u0006\u0002\b#2\n\u0010$\u001a\u00060%R\u00020\u001fH\u0002\u001a\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"!\u0010'\u001a\u0015\u0012\f\u0012\n )*\u0004\u0018\u00010\u001f0\u001f0(\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010*\u001a\u0015\u0012\f\u0012\n )*\u0004\u0018\u00010!0!0(\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"target", "Lcom/intellij/xdebugger/impl/actions/handlers/XSmartStepIntoTarget;", "Lcom/intellij/platform/debugger/impl/rpc/XSmartStepIntoTargetDto;", "SHOW_AD", "Lcom/intellij/openapi/util/Ref;", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "COUNTER_PROPERTY", "", "choose", "", "targets", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "session", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "editor", "Lcom/intellij/openapi/editor/Editor;", "showPopup", "highlightVariant", "variant", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoVariant;", "highlighter", "Lcom/intellij/codeInsight/unwrap/ScopeHighlighter;", "inplaceChoose", "variants", "showInfoHint", "data", "Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData;", "showHint", "Lcom/intellij/ui/Hint;", "message", "Lcom/intellij/openapi/util/NlsContexts$HintText;", "currentVariant", "Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$VariantInfo;", "shouldShowElementDescription", "SMART_STEP_INPLACE_DATA", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "SMART_STEP_HINT_DATA", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nXDebuggerSmartStepIntoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XDebuggerSmartStepIntoHandler.kt\ncom/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandlerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,550:1\n1740#2,3:551\n295#2,2:554\n*S KotlinDebug\n*F\n+ 1 XDebuggerSmartStepIntoHandler.kt\ncom/intellij/xdebugger/impl/actions/handlers/XDebuggerSmartStepIntoHandlerKt\n*L\n379#1:551,3\n470#1:554,2\n*E\n"})
public final class XDebuggerSmartStepIntoHandlerKt {
    @NotNull
    private static final Ref<Boolean> SHOW_AD = new Ref((Object)true);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String COUNTER_PROPERTY = "debugger.smart.chooser.counter";
    @NotNull
    private static final Key<SmartStepData> SMART_STEP_INPLACE_DATA;
    @NotNull
    private static final Key<Hint> SMART_STEP_HINT_DATA;

    private static final XSmartStepIntoTarget target(XSmartStepIntoTargetDto $this$target) {
        return new XSmartStepIntoTarget($this$target.getId(), $this$target.getNeedsForcedSmartStepInto(), new XSmartStepIntoVariant($this$target){
            final /* synthetic */ XSmartStepIntoTargetDto $this_target;
            {
                this.$this_target = $receiver;
            }

            public String getText() {
                return this.$this_target.getText();
            }

            public String getDescription() {
                return this.$this_target.getDescription();
            }

            public Icon getIcon() {
                IconId iconId = this.$this_target.getIconId();
                return iconId != null ? IconIdKt.icon((IconId)iconId) : null;
            }

            public TextRange getHighlightRange() {
                TextRangeId textRangeId = this.$this_target.getTextRange();
                return textRangeId != null ? TextRangeIdKt.textRange((TextRangeId)textRangeId) : null;
            }
        });
    }

    private static final void choose(List<XSmartStepIntoTarget> targets, XSourcePosition position, XDebugSessionProxy session, Editor editor) {
        block8: {
            if (Registry.Companion.is("debugger.smart.step.inplace")) {
                boolean bl;
                block7: {
                    Iterable $this$all$iv = targets;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            XSmartStepIntoTarget it = (XSmartStepIntoTarget)element$iv;
                            boolean bl2 = false;
                            if (it.getVariant().getHighlightRange() != null) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    try {
                        XDebuggerSmartStepIntoHandlerKt.inplaceChoose(targets, session, editor);
                        return;
                    }
                    catch (Exception e) {
                        SmartStepData data;
                        LOG.error((Throwable)e);
                        SmartStepData smartStepData = data = (SmartStepData)editor.getUserData(SMART_STEP_INPLACE_DATA);
                        if (smartStepData == null) break block8;
                        smartStepData.clear$intellij_platform_debugger_impl();
                    }
                }
            }
        }
        XDebuggerSmartStepIntoHandlerKt.showPopup(targets, position, session, editor);
    }

    private static final void showPopup(List<XSmartStepIntoTarget> targets, XSourcePosition position, XDebugSessionProxy session, Editor editor) {
        ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        XSmartStepIntoHandlerEntry xSmartStepIntoHandlerEntry = session.getSmartStepIntoHandlerEntry();
        String title = xSmartStepIntoHandlerEntry != null ? xSmartStepIntoHandlerEntry.getPopupTitle() : null;
        ListPopupImpl popup2 = new ListPopupImpl(session.getProject(), (ListPopupStep)new BaseListPopupStep<XSmartStepIntoTarget>(title, targets, session, highlighter){
            final /* synthetic */ XDebugSessionProxy $session;
            final /* synthetic */ ScopeHighlighter $highlighter;
            {
                this.$session = $session;
                this.$highlighter = $highlighter;
                super($title, $targets);
            }

            public Icon getIconFor(XSmartStepIntoTarget aValue) {
                Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
                return aValue.getVariant().getIcon();
            }

            public String getTextFor(XSmartStepIntoTarget value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value.getVariant().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return string;
            }

            public PopupStep<?> onChosen(XSmartStepIntoTarget selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                BuildersKt.launch$default((CoroutineScope)this.$session.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedValue, null){
                    int label;
                    final /* synthetic */ XSmartStepIntoTarget $selectedValue;
                    {
                        this.$selectedValue = $selectedValue;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = XDebugSessionApi.Companion.getInstance((Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = ((XDebugSessionApi)v0).smartStepInto(this.$selectedValue.getId(), (Continuation)this);
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                this.$highlighter.dropHighlight();
                return BaseListPopupStep.FINAL_CHOICE;
            }

            public void canceled() {
                this.$highlighter.dropHighlight();
                super.canceled();
            }
        });
        String[] stringArray = new String[]{"StepInto", "SmartStepInto"};
        DebuggerUIUtil.registerExtraHandleShortcuts(popup2, SHOW_AD, stringArray);
        UIUtil.maybeInstall((InputMap)popup2.getList().getInputMap(0), (String)"selectNextRow", (KeyStroke)KeyStroke.getKeyStroke(9, 0));
        popup2.addListSelectionListener(arg_0 -> XDebuggerSmartStepIntoHandlerKt.showPopup$lambda$0(highlighter, arg_0));
        XSmartStepIntoTarget xSmartStepIntoTarget = (XSmartStepIntoTarget)CollectionsKt.firstOrNull(targets);
        XDebuggerSmartStepIntoHandlerKt.highlightVariant((XSmartStepIntoVariant)(xSmartStepIntoTarget != null ? xSmartStepIntoTarget.getVariant() : null), highlighter);
        DebuggerUIUtil.showPopupForEditorLine((JBPopup)popup2, editor, position.getLine());
    }

    private static final void highlightVariant(XSmartStepIntoVariant variant, ScopeHighlighter highlighter) {
        XSmartStepIntoVariant xSmartStepIntoVariant = variant;
        if (xSmartStepIntoVariant == null || (xSmartStepIntoVariant = xSmartStepIntoVariant.getHighlightRange()) == null) {
            return;
        }
        XSmartStepIntoVariant range = xSmartStepIntoVariant;
        highlighter.highlight(Pair.create((Object)range, (Object)CollectionsKt.listOf((Object)range)));
    }

    private static final void inplaceChoose(List<XSmartStepIntoTarget> variants, XDebugSessionProxy session, Editor editor) {
        VirtualFile virtualFile;
        Object v1;
        SmartStepData data;
        block4: {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)session.getProject());
            data = new SmartStepData(variants, session, editor);
            EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)editor);
            Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
            EditorHyperlinkSupport hyperlinkSupport = editorHyperlinkSupport;
            for (SmartStepData.VariantInfo info : data.getMyVariants$intellij_platform_debugger_impl()) {
                TextRange range = info.getTarget().getVariant().getHighlightRange();
                if (range == null) continue;
                SmartList highlighters = new SmartList();
                highlightManager.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), DebuggerColors.SMART_STEP_INTO_TARGET, 5, (Collection)highlighters);
                RangeHighlighter highlighter = (RangeHighlighter)CollectionsKt.first((List)((List)highlighters));
                hyperlinkSupport.createHyperlink(highlighter, arg_0 -> XDebuggerSmartStepIntoHandlerKt.inplaceChoose$lambda$0(data, info, arg_0));
                data.getMyHighlighters$intellij_platform_debugger_impl().add(highlighter);
            }
            Iterable $this$firstOrNull$iv = data.getMyVariants$intellij_platform_debugger_impl();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SmartStepData.VariantInfo v = (SmartStepData.VariantInfo)element$iv;
                boolean bl = false;
                if (!(v.getTarget() == variants.get(0))) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        SmartStepData.VariantInfo variantInfo = v1;
        if (variantInfo != null) {
            data.select$intellij_platform_debugger_impl(variantInfo);
        }
        LOG.assertTrue(data.getMyCurrentVariant$intellij_platform_debugger_impl() != null);
        editor.putUserData(SMART_STEP_INPLACE_DATA, (Object)data);
        if (AppMode.isRemoteDevHost() && (virtualFile = editor.getVirtualFile()) != null) {
            FileEditorManagerEx.Companion.getInstanceEx(session.getProject()).openFile(virtualFile, true, true);
        }
        IdeFocusManager.getGlobalInstance().requestFocus((Component)editor.getContentComponent(), true);
        XDebuggerSmartStepIntoHandlerKt.showInfoHint(editor, data);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        session.addSessionListener(new XDebugSessionListener(disposable2, editor){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ Editor $editor;
            {
                this.$disposable = $disposable;
                this.$editor = $editor;
            }

            public final void onAnyEvent() {
                Disposer.dispose((Disposable)this.$disposable);
                UIUtil.invokeLaterIfNeeded(() -> inplaceChoose.2.onAnyEvent$lambda$0(this.$editor));
            }

            public void sessionPaused() {
                this.onAnyEvent();
            }

            public void sessionResumed() {
                this.onAnyEvent();
            }

            public void sessionStopped() {
                this.onAnyEvent();
            }

            public void stackFrameChanged() {
                this.onAnyEvent();
            }

            public void settingsChanged() {
                this.onAnyEvent();
            }

            private static final void onAnyEvent$lambda$0(Editor $editor) {
                block0: {
                    SmartStepData stepData;
                    SmartStepData smartStepData = stepData = (SmartStepData)$editor.getUserData(XDebuggerSmartStepIntoHandlerKt.access$getSMART_STEP_INPLACE_DATA$p());
                    if (smartStepData == null) break block0;
                    smartStepData.clear$intellij_platform_debugger_impl();
                }
            }
        }, disposable2);
    }

    private static final void showInfoHint(Editor editor, SmartStepData data) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        int counter = propertiesComponent.getInt(COUNTER_PROPERTY, 0);
        if (counter < 3) {
            String string = XDebuggerBundle.message((String)"message.smart.step", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SmartStepData.VariantInfo variantInfo = data.getMyCurrentVariant$intellij_platform_debugger_impl();
            Intrinsics.checkNotNull((Object)variantInfo);
            Hint hint = XDebuggerSmartStepIntoHandlerKt.showHint(editor, string, variantInfo);
            editor.putUserData(SMART_STEP_HINT_DATA, (Object)hint);
            propertiesComponent.setValue(COUNTER_PROPERTY, counter + 1, 0);
        }
    }

    private static final Hint showHint(Editor editor, String message, SmartStepData.VariantInfo currentVariant) {
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)message));
        JComponent jComponent = HintManagerImpl.getExternalComponent((Editor)editor);
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getExternalComponent(...)");
        JComponent component = jComponent;
        Point convertedPoint = SwingUtilities.convertPoint(editor.getContentComponent(), currentVariant.getMyStartPoint(), component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, convertedPoint, 40, 0, false, (short)1);
        return (Hint)hint;
    }

    private static final boolean shouldShowElementDescription(Editor editor) {
        Hint hint = (Hint)editor.getUserData(SMART_STEP_HINT_DATA);
        return hint == null || !hint.isVisible();
    }

    private static final void showPopup$lambda$0(ScopeHighlighter $highlighter, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object selectedValue = ObjectUtils.doIfCast((Object)e.getSource(), JBList.class, arg_0 -> XDebuggerSmartStepIntoHandlerKt.showPopup$lambda$0$1(XDebuggerSmartStepIntoHandlerKt::showPopup$lambda$0$0, arg_0));
            XSmartStepIntoTarget xSmartStepIntoTarget = selectedValue instanceof XSmartStepIntoTarget ? (XSmartStepIntoTarget)selectedValue : null;
            XDebuggerSmartStepIntoHandlerKt.highlightVariant((XSmartStepIntoVariant)(xSmartStepIntoTarget != null ? xSmartStepIntoTarget.getVariant() : null), $highlighter);
        }
    }

    private static final Object showPopup$lambda$0$0(JBList it) {
        return it.getSelectedValue();
    }

    private static final Object showPopup$lambda$0$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final void inplaceChoose$lambda$0(SmartStepData $data, SmartStepData.VariantInfo $info, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $data.stepInto$intellij_platform_debugger_impl($info);
    }

    public static final /* synthetic */ Key access$getSMART_STEP_INPLACE_DATA$p() {
        return SMART_STEP_INPLACE_DATA;
    }

    public static final /* synthetic */ void access$choose(List targets, XSourcePosition position, XDebugSessionProxy session, Editor editor) {
        XDebuggerSmartStepIntoHandlerKt.choose(targets, position, session, editor);
    }

    public static final /* synthetic */ XSmartStepIntoTarget access$target(XSmartStepIntoTargetDto $receiver) {
        return XDebuggerSmartStepIntoHandlerKt.target($receiver);
    }

    public static final /* synthetic */ boolean access$shouldShowElementDescription(Editor editor) {
        return XDebuggerSmartStepIntoHandlerKt.shouldShowElementDescription(editor);
    }

    public static final /* synthetic */ Hint access$showHint(Editor editor, String message, SmartStepData.VariantInfo currentVariant) {
        return XDebuggerSmartStepIntoHandlerKt.showHint(editor, message, currentVariant);
    }

    public static final /* synthetic */ Key access$getSMART_STEP_HINT_DATA$p() {
        return SMART_STEP_HINT_DATA;
    }

    static {
        Logger logger = Logger.getInstance(XDebuggerSmartStepIntoHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"SMART_STEP_INPLACE_DATA");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SMART_STEP_INPLACE_DATA = key;
        Key key2 = Key.create((String)"SMART_STEP_HINT_DATA");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SMART_STEP_HINT_DATA = key2;
    }
}

