/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointProxy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XBreakpointActionsPanel
extends XBreakpointPropertiesSubPanel {
    public static final String LOG_EXPRESSION_HISTORY_ID = "breakpointLogExpression";
    private JLabel myLogMessageLabel;
    private JCheckBox myLogMessageCheckBox;
    private JCheckBox myLogExpressionCheckBox;
    private JPanel myLogExpressionCheckBoxPanel;
    private JPanel myLogExpressionPanel;
    private JPanel myContentPane;
    private JPanel myMainPanel;
    private JCheckBox myTemporaryCheckBox;
    private JPanel myExpressionPanel;
    private JPanel myLanguageChooserPanel;
    private JCheckBox myLogStack;
    @Nullable
    private XDebuggerExpressionComboBox myLogExpressionComboBox;
    private boolean myShowAllOptions;

    public XBreakpointActionsPanel() {
        this.$$$setupUI$$$();
    }

    public void init(Project project, @NotNull XBreakpointProxy breakpoint2, @Nullable XDebuggerEditorsProvider debuggerEditorsProvider, boolean showAllOptions) {
        if (breakpoint2 == null) {
            XBreakpointActionsPanel.$$$reportNull$$$0(0);
        }
        this.init(project, breakpoint2);
        this.myShowAllOptions = showAllOptions;
        if (debuggerEditorsProvider != null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XBreakpointActionsPanel.this.onCheckboxChanged();
                }
            };
            this.myLogExpressionCheckBox = new JBCheckBox(XDebuggerBundle.message((String)"xbreakpoints.log.expression.checkbox", (Object[])new Object[0]));
            this.myLogExpressionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, LOG_EXPRESSION_HISTORY_ID, null, true, false);
            this.myLanguageChooserPanel.add((Component)this.myLogExpressionComboBox.getLanguageChooser(), "Center");
            this.myLogExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myLogExpressionCheckBox)));
            this.myLogExpressionPanel.add((Component)this.myLogExpressionComboBox.getComponent(), "Center");
            this.myLogExpressionComboBox.setEnabled(false);
            this.myLogExpressionCheckBox.addActionListener(listener);
            DebuggerUIUtil.focusEditorOnCheck(this.myLogExpressionCheckBox, this.myLogExpressionComboBox.getEditorComponent());
        } else {
            this.myExpressionPanel.getParent().remove(this.myExpressionPanel);
        }
        boolean isLineBreakpoint = breakpoint2 instanceof XLineBreakpointProxy;
        this.myTemporaryCheckBox.setVisible(isLineBreakpoint);
        if (isLineBreakpoint) {
            this.myTemporaryCheckBox.addActionListener(e -> ((XLineBreakpointProxy)this.myBreakpoint).setTemporary(this.myTemporaryCheckBox.isSelected()));
        }
    }

    void setSourcePosition(XSourcePosition sourcePosition) {
        if (this.myLogExpressionComboBox != null) {
            this.myLogExpressionComboBox.setSourcePosition(sourcePosition);
        }
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        if (!(showAllOptions || this.myBreakpoint.isLogMessage() || this.myBreakpoint.isLogStack() || this.myBreakpoint.getLogExpressionObjectInt() != null || this.myBreakpoint instanceof XLineBreakpointProxy && ((XLineBreakpointProxy)this.myBreakpoint).isTemporary())) {
            this.myMainPanel.setVisible(false);
            return true;
        }
        this.myMainPanel.setBorder(null);
        return false;
    }

    private void onCheckboxChanged() {
        if (this.myLogExpressionComboBox != null) {
            this.myLogExpressionComboBox.setEnabled(this.myLogExpressionCheckBox.isSelected());
        }
    }

    @Override
    void loadProperties() {
        this.myLogMessageCheckBox.setSelected(this.myBreakpoint.isLogMessage());
        this.myLogStack.setSelected(this.myBreakpoint.isLogStack());
        XBreakpointProxy xBreakpointProxy = this.myBreakpoint;
        if (xBreakpointProxy instanceof XLineBreakpointProxy) {
            XLineBreakpointProxy lineBreakpointProxy = (XLineBreakpointProxy)xBreakpointProxy;
            this.myTemporaryCheckBox.setSelected(lineBreakpointProxy.isTemporary());
        }
        if (this.myLogExpressionComboBox != null) {
            XExpression logExpression = this.myBreakpoint.getLogExpressionObjectInt();
            this.myLogExpressionComboBox.setExpression(logExpression);
            boolean hideCheckbox = !this.myShowAllOptions && logExpression == null;
            this.myLogExpressionCheckBox.setSelected(hideCheckbox || this.myBreakpoint.isLogExpressionEnabled() && logExpression != null);
            this.myLogExpressionCheckBoxPanel.removeAll();
            if (hideCheckbox) {
                JLabel label = new JLabel(XDebuggerBundle.message((String)"xbreakpoints.log.expression.checkbox", (Object[])new Object[0]));
                label.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
                label.setLabelFor((Component)this.myLogExpressionComboBox.getComboBox());
                this.myLogExpressionCheckBoxPanel.add(label);
                this.myLogExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
                this.myLogMessageLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
            } else {
                this.myLogExpressionCheckBoxPanel.add(this.myLogExpressionCheckBox);
                this.myLogExpressionPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myLogExpressionCheckBox)));
            }
        }
        this.onCheckboxChanged();
    }

    @Override
    void saveProperties() {
        this.myBreakpoint.setLogMessage(this.myLogMessageCheckBox.isSelected());
        this.myBreakpoint.setLogStack(this.myLogStack.isSelected());
        XBreakpointProxy xBreakpointProxy = this.myBreakpoint;
        if (xBreakpointProxy instanceof XLineBreakpointProxy) {
            XLineBreakpointProxy lineBreakpointProxy = (XLineBreakpointProxy)xBreakpointProxy;
            lineBreakpointProxy.setTemporary(this.myTemporaryCheckBox.isSelected());
        }
        if (this.myLogExpressionComboBox != null) {
            XExpression expression = this.myLogExpressionComboBox.getExpression();
            XExpression logExpression = !XDebuggerUtilImpl.isEmptyExpression(expression) ? expression : null;
            this.myBreakpoint.setLogExpressionEnabled(logExpression == null || this.myLogExpressionCheckBox.isSelected());
            this.myBreakpoint.setLogExpressionObject(logExpression);
            this.myLogExpressionComboBox.saveTextInHistory();
        }
    }

    JComponent getDefaultFocusComponent() {
        if (this.myLogExpressionComboBox != null && this.myLogExpressionComboBox.getComboBox().isEnabled()) {
            return this.myLogExpressionComboBox.getEditorComponent();
        }
        return null;
    }

    public void dispose() {
    }

    public void hide() {
        this.myContentPane.setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointActionsPanel", "init"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myContentPane = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XBreakpointActionsPanel.class).getString("xbreakpoints.properties.actions.group.title"), (int)0, (int)0, null, null));
        this.myExpressionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myLogExpressionCheckBoxPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myLogExpressionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myLanguageChooserPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTemporaryCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XBreakpointActionsPanel.class).getString("xbreakpoints.remove.once.hit.label"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        this.myLogMessageLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XBreakpointActionsPanel.class).getString("xbreakpoints.log.message.label"));
        jLabel.setVerticalAlignment(0);
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myLogMessageCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XBreakpointActionsPanel.class).getString("xbreakpoints.log.message.checkbox"));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myLogStack = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XBreakpointActionsPanel.class).getString("xbreakpoints.log.stack.checkbox"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

