/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.platform.debugger.impl.rpc.XExecutionStackId;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.frame.StackInfo;
import com.intellij.xdebugger.impl.frame.XDebuggerThreadsListRenderer;
import com.intellij.xdebugger.impl.ui.SplitDebuggerUIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003$%&B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u00028\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList;", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "renderer", "Ljavax/swing/ListCellRenderer;", "<init>", "(Ljavax/swing/ListCellRenderer;)V", "mySelectedFrame", "value", "stackUnderMouse", "getStackUnderMouse", "()Lcom/intellij/xdebugger/impl/frame/StackInfo;", "elementCount", "", "getElementCount", "()I", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "setSelectedStacks", "selection", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "doInit", "onThreadChanged", "stack", "getModel", "Lcom/intellij/ui/CollectionListModel;", "setModel", "model", "Ljavax/swing/ListModel;", "locationToIndex", "location", "Ljava/awt/Point;", "clear", "Companion", "XDebuggerGroupedFrameListRenderer", "XDebuggerListItemDescriptor", "intellij.platform.debugger.impl"})
public final class XDebuggerThreadsList
extends JBList<StackInfo>
implements UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListCellRenderer<StackInfo> renderer;
    @Nullable
    private StackInfo mySelectedFrame;
    @ApiStatus.Obsolete
    @Nullable
    private StackInfo stackUnderMouse;
    @NotNull
    private static final DataKey<XDebuggerThreadsList> THREADS_LIST = DataKey.Companion.create("THREADS_LIST");

    public XDebuggerThreadsList(@NotNull ListCellRenderer<StackInfo> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        super((ListModel)new CollectionListModel((Object[])new StackInfo[0]));
        this.renderer = renderer;
        Font font = this.getFont();
        if (font != null) {
            this.setFont(new FontUIResource(font.getName(), font.getStyle(), font.getSize()));
        }
    }

    @Nullable
    public final StackInfo getStackUnderMouse() {
        return this.stackUnderMouse;
    }

    public final int getElementCount() {
        return this.getModel().getSize();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.set(THREADS_LIST, (Object)this);
            StackInfo stackInfo = this.stackUnderMouse;
            if (stackInfo == null || (stackInfo = stackInfo.getStack()) == null) break block0;
            StackInfo it = stackInfo;
            boolean bl = false;
            this.setSelectedStacks(sink, (XExecutionStack)it);
        }
    }

    private final void setSelectedStacks(DataSink sink, XExecutionStack selection) {
        XDebugManagerProxy xDebugManagerProxy = XDebugManagerProxy.Companion.getInstance();
        XExecutionStackId xExecutionStackId = xDebugManagerProxy.getXExecutionStackId(selection);
        if (xExecutionStackId != null) {
            sink.set(SplitDebuggerUIUtil.SPLIT_SELECTED_STACKS_KEY, (Object)CollectionsKt.listOf((Object)xExecutionStackId));
        }
        DataKey dataKey = XExecutionStack.SELECTED_STACKS;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"SELECTED_STACKS");
        sink.set(dataKey, (Object)CollectionsKt.listOf((Object)selection));
    }

    private final void doInit() {
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(this.renderer);
        this.getSelectionModel().addListSelectionListener(arg_0 -> XDebuggerThreadsList.doInit$lambda$0(this, arg_0));
        this.addMouseMotionListener(new MouseMotionListener(this){
            final /* synthetic */ XDebuggerThreadsList this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkNotNull((Object)point);
                int index = this.this$0.locationToIndex(point);
                if (index == -1) {
                    XDebuggerThreadsList.access$setStackUnderMouse$p(this.this$0, null);
                } else {
                    XDebuggerThreadsList.access$setStackUnderMouse$p(this.this$0, (StackInfo)this.this$0.getModel().getElementAt(index));
                }
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        this.getEmptyText().setText(XDebuggerBundle.message((String)"threads.list.threads.not.available", (Object[])new Object[0]));
    }

    private final void onThreadChanged(StackInfo stack) {
        if (!Intrinsics.areEqual((Object)this.mySelectedFrame, (Object)stack)) {
            SwingUtilities.invokeLater(() -> XDebuggerThreadsList.onThreadChanged$lambda$0(this));
            this.mySelectedFrame = stack;
        }
    }

    @NotNull
    public CollectionListModel<StackInfo> getModel() {
        ListModel listModel = super.getModel();
        Intrinsics.checkNotNull((Object)listModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionListModel<com.intellij.xdebugger.impl.frame.StackInfo>");
        return (CollectionListModel)listModel;
    }

    public void setModel(@Nullable ListModel<StackInfo> model) {
    }

    public int locationToIndex(@NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return location.y <= this.getPreferredSize().height ? super.locationToIndex(location) : -1;
    }

    public final void clear() {
        this.getModel().removeAll();
    }

    private static final void doInit$lambda$0(XDebuggerThreadsList this$0, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this$0.onThreadChanged((StackInfo)this$0.getSelectedValue());
        }
    }

    private static final void onThreadChanged$lambda$0(XDebuggerThreadsList this$0) {
        this$0.repaint();
    }

    public static final /* synthetic */ void access$setStackUnderMouse$p(XDebuggerThreadsList $this, StackInfo stackInfo) {
        $this.stackUnderMouse = stackInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList$Companion;", "", "<init>", "()V", "THREADS_LIST", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList;", "getTHREADS_LIST", "()Lcom/intellij/openapi/actionSystem/DataKey;", "createDefault", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<XDebuggerThreadsList> getTHREADS_LIST() {
            return THREADS_LIST;
        }

        @NotNull
        public final XDebuggerThreadsList createDefault() {
            XDebuggerGroupedFrameListRenderer renderer = new XDebuggerGroupedFrameListRenderer();
            XDebuggerThreadsList list = new XDebuggerThreadsList((ListCellRenderer)((Object)renderer));
            list.doInit();
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList$XDebuggerGroupedFrameListRenderer;", "Lcom/intellij/ui/popup/list/GroupedItemsListRenderer;", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "<init>", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "createItemComponent", "Ljavax/swing/JComponent;", "intellij.platform.debugger.impl"})
    private static class XDebuggerGroupedFrameListRenderer
    extends GroupedItemsListRenderer<StackInfo> {
        public XDebuggerGroupedFrameListRenderer() {
            super((ListItemDescriptor)new XDebuggerListItemDescriptor());
            this.mySeparatorComponent.setCaptionCentered(false);
        }

        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends StackInfo> list, @NotNull StackInfo value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JComponent jComponent = this.getItemComponent();
            ListCellRenderer listCellRenderer = jComponent instanceof ListCellRenderer ? (ListCellRenderer)((Object)jComponent) : null;
            if (listCellRenderer == null) {
                throw new IllegalStateException("Invalid component " + this.getItemComponent());
            }
            ListCellRenderer renderer = listCellRenderer;
            Component component = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
            return component;
        }

        @NotNull
        protected JComponent createItemComponent() {
            this.createLabel();
            return (JComponent)((Object)new XDebuggerThreadsListRenderer());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList$XDebuggerListItemDescriptor;", "Lcom/intellij/openapi/ui/popup/ListItemDescriptor;", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "<init>", "()V", "getTextFor", "", "value", "getTooltipFor", "getIconFor", "Ljavax/swing/Icon;", "hasSeparatorAboveOf", "", "getCaptionAboveOf", "intellij.platform.debugger.impl"})
    private static final class XDebuggerListItemDescriptor
    implements ListItemDescriptor<StackInfo> {
        @Nullable
        public String getTextFor(@Nullable StackInfo value) {
            StackInfo stackInfo = value;
            return stackInfo != null ? stackInfo.getDisplayText() : null;
        }

        @Nullable
        public String getTooltipFor(@Nullable StackInfo value) {
            StackInfo stackInfo = value;
            return stackInfo != null ? stackInfo.getDisplayText() : null;
        }

        @Nullable
        public Icon getIconFor(@Nullable StackInfo value) {
            StackInfo stackInfo = value;
            return stackInfo != null ? stackInfo.getIcon() : null;
        }

        public boolean hasSeparatorAboveOf(@Nullable StackInfo value) {
            return false;
        }

        @Nullable
        public String getCaptionAboveOf(@Nullable StackInfo value) {
            return null;
        }
    }
}

