/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.debugger.impl.shared.XDebuggerWatchesManager;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XEvaluationListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XWatch;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.DebuggerEvaluationStatisticsCollector;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.actions.XToggleEvaluateExpressionFieldAction;
import com.intellij.xdebugger.impl.inline.InlineWatch;
import com.intellij.xdebugger.impl.inline.InlineWatchNode;
import com.intellij.xdebugger.impl.inline.InlineWatchesRootNode;
import com.intellij.xdebugger.impl.inline.XInlineWatchesView;
import com.intellij.xdebugger.impl.messages.XDebuggerImplBundle;
import com.intellij.xdebugger.impl.proxy.MonolithSessionProxyKt;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XDebuggerEmbeddedComboBox;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XWatchTransferable;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XWatchesViewImpl
extends XVariablesView
implements DnDNativeTarget,
XWatchesView,
XInlineWatchesView {
    private static final JBColor EVALUATE_FIELD_BACKGROUND_COLOR = JBColor.namedColor((String)"Debugger.EvaluateExpression.background", (Color)new JBColor(0xFFFFFF, 4540746));
    protected WatchesRootNode myRootNode;
    private XDebuggerExpressionComboBox myEvaluateComboBox;
    private final CompositeDisposable myDisposables;
    @NotNull
    private final String myConfigurationName;
    private final boolean myWatchesInVariables;
    private final boolean inlineWatchesEnabled;

    @Deprecated
    public XWatchesViewImpl(@NotNull XDebugSessionImpl session, boolean watchesInVariables) {
        if (session == null) {
            XWatchesViewImpl.$$$reportNull$$$0(0);
        }
        this(MonolithSessionProxyKt.asProxy(session), watchesInVariables);
    }

    public XWatchesViewImpl(@NotNull XDebugSessionProxy session, boolean watchesInVariables) {
        if (session == null) {
            XWatchesViewImpl.$$$reportNull$$$0(1);
        }
        this(session, watchesInVariables, watchesInVariables);
    }

    @Deprecated
    protected XWatchesViewImpl(@NotNull XDebugSessionImpl session, boolean watchesInVariables, boolean vertical) {
        if (session == null) {
            XWatchesViewImpl.$$$reportNull$$$0(2);
        }
        this(MonolithSessionProxyKt.asProxy(session), watchesInVariables, vertical);
    }

    protected XWatchesViewImpl(@NotNull XDebugSessionProxy session, boolean watchesInVariables, boolean vertical) {
        if (session == null) {
            XWatchesViewImpl.$$$reportNull$$$0(3);
        }
        this(session, watchesInVariables, vertical, true);
    }

    @Deprecated
    public XWatchesViewImpl(@NotNull XDebugSessionImpl session, boolean watchesInVariables, boolean vertical, boolean withToolbar) {
        if (session == null) {
            XWatchesViewImpl.$$$reportNull$$$0(4);
        }
        this(MonolithSessionProxyKt.asProxy(session), watchesInVariables, vertical, withToolbar);
    }

    public XWatchesViewImpl(@NotNull XDebugSessionProxy session, boolean watchesInVariables, boolean vertical, boolean withToolbar) {
        if (session == null) {
            XWatchesViewImpl.$$$reportNull$$$0(5);
        }
        super(session);
        this.myDisposables = new CompositeDisposable();
        this.myConfigurationName = session.getSessionData().getConfigurationName();
        this.myWatchesInVariables = watchesInVariables;
        this.inlineWatchesEnabled = Registry.is((String)"debugger.watches.inline.enabled");
        XDebuggerTree tree = this.getTree();
        this.createNewRootNode(null);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.NewWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.RemoveWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.EditWatch", (JComponent)((Object)tree), (Disposable)this.myDisposables);
        ActionUtil.wrap((String)"XDebugger.NewWatch").registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)((Object)tree));
        ActionUtil.wrap((String)"XDebugger.RemoveWatch").registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)tree));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree));
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object contents;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contents = CopyPasteManager.getInstance().getContents(XWatchTransferable.EXPRESSIONS_FLAVOR)) instanceof List) {
                    List list = (List)contents;
                    for (Object item : list) {
                        if (!(item instanceof XExpression)) continue;
                        XWatchesViewImpl.this.addWatchExpression((XExpression)item, -1, true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getPaste(), (JComponent)((Object)tree), (Disposable)this.myDisposables);
        if (withToolbar) {
            ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", DebuggerSessionTabBase.getCustomizedActionGroup("XDebugger.Watches.Tree.Toolbar"), !vertical);
            toolbar.setBorder((Border)new CustomLineBorder(0, 0, vertical ? 0 : 1, vertical ? 1 : 0));
            toolbar.setTargetComponent((JComponent)((Object)tree));
            this.getPanel().add((Component)toolbar.getComponent(), vertical ? "West" : "North");
        }
        if (!this.myWatchesInVariables) {
            this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
        }
        this.installEditListeners();
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myEvaluateComboBox != null) {
            this.myEvaluateComboBox.fixEditorNotReleasedFalsePositiveException(session.getProject(), (Disposable)this);
        }
    }

    @Override
    protected JPanel createMainPanel(@NotNull JComponent localsPanelComponent) {
        JComponent top;
        if (localsPanelComponent == null) {
            XWatchesViewImpl.$$$reportNull$$$0(6);
        }
        if ((top = this.createTopPanel()) == null) {
            return super.createMainPanel(localsPanelComponent);
        }
        LayoutManager layout = localsPanelComponent.getLayout();
        boolean canAddComponentToTheRightOfToolbar = layout instanceof BorderLayout;
        if (canAddComponentToTheRightOfToolbar) {
            BorderLayoutPanel panel2 = new BorderLayoutPanel().addToCenter(((BorderLayout)layout).getLayoutComponent("Center")).addToTop((Component)top);
            localsPanelComponent.add((Component)panel2, "Center");
            return super.createMainPanel(localsPanelComponent);
        }
        return new BorderLayoutPanel().addToCenter((Component)localsPanelComponent).addToTop((Component)top);
    }

    @Nullable
    private JComponent createTopPanel() {
        final XDebuggerTree tree = this.getTree();
        final Ref addToWatchesActionRef = new Ref();
        XDebuggerEditorsProvider provider = tree.getEditorsProvider();
        if (!provider.isEvaluateExpressionFieldEnabled()) {
            return null;
        }
        this.myEvaluateComboBox = new XDebuggerExpressionComboBox(tree.getProject(), provider, "evaluateExpression", null, false, true){

            @Override
            protected ComboBox<XExpression> createComboBox(CollectionComboBoxModel<XExpression> model, int width) {
                DumbAwareAction addToWatchesAction = new DumbAwareAction(XDebuggerImplBundle.message("action.Debugger.AddToWatch.text", new Object[0]), null, AllIcons.Debugger.AddToWatch){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        XWatchesViewImpl.this.myEvaluateComboBox.saveTextInHistory();
                        XWatchesViewImpl.this.addWatchExpression(this.getExpression(), -1, false);
                        DebuggerEvaluationStatisticsCollector.WATCH_FROM_INLINE_ADD.log((Object)e);
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        e.getPresentation().setEnabled(!XDebuggerUtilImpl.isEmptyExpression(this.getExpression()));
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                        if (actionUpdateThread == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return actionUpdateThread;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionUpdateThread";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "actionPerformed";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "update";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 2 -> new IllegalStateException(string);
                        };
                    }
                };
                ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerVariablesEvaluate", (ActionGroup)new DefaultActionGroup(new AnAction[]{addToWatchesAction}), true);
                addToWatchesActionRef.set((Object)addToWatchesAction);
                toolbar.setOpaque(false);
                toolbar.setReservePlaceAutoPopupIcon(false);
                toolbar.setTargetComponent((JComponent)((Object)tree));
                XDebuggerEmbeddedComboBox<XExpression> comboBox = new XDebuggerEmbeddedComboBox<XExpression>((ComboBoxModel<XExpression>)model, width);
                comboBox.setName("Debugger.EvaluateExpression.combobox");
                comboBox.setExtension((JComponent)toolbar);
                return comboBox;
            }

            @Override
            protected void prepareEditor(EditorEx editor) {
                super.prepareEditor(editor);
                editor.setPlaceholder((CharSequence)XDebuggerBundle.message((String)"debugger.evaluate.expression.or.add.a.watch.hint", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null)), KeymapUtil.getShortcutText((Shortcut)new KeyboardShortcut(XDebuggerEvaluationDialog.getAddWatchKeystroke(), null))}));
                editor.addFocusListener(new FocusChangeListener(){
                    private static final Set<FocusEvent.Cause> myCauses = Set.of(FocusEvent.Cause.UNKNOWN, FocusEvent.Cause.TRAVERSAL_FORWARD, FocusEvent.Cause.TRAVERSAL_BACKWARD);

                    public void focusGained(@NotNull Editor editor, @NotNull FocusEvent event) {
                        boolean shouldBeIgnored;
                        if (editor == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (myCauses.contains((Object)event.getCause()) && !(shouldBeIgnored = XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().isPopupVisible())) {
                            DebuggerEvaluationStatisticsCollector.INPUT_FOCUS.log(XWatchesViewImpl.this.getTree().getProject());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$2$2";
                        objectArray[2] = "focusGained";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                XDebugSessionProxy session = XWatchesViewImpl.this.getSessionProxy();
                if (session != null) {
                    InlineCompletion.INSTANCE.install(editor, session.getCoroutineScope());
                }
            }
        };
        JComponent editorComponent = this.myEvaluateComboBox.getEditorComponent();
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterStroke");
        editorComponent.getActionMap().put("enterStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().isPopupVisible()) {
                    XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().setPopupVisible(false);
                } else {
                    XWatchesViewImpl.this.addExpressionResultNode();
                }
            }
        });
        editorComponent.setBackground((Color)EVALUATE_FIELD_BACKGROUND_COLOR);
        this.myEvaluateComboBox.getComboBox().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            private int selectedIndexOnPopupOpen = -1;

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.selectedIndexOnPopupOpen = XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().getSelectedIndex();
                XWatchesViewImpl.this.myEvaluateComboBox.requestFocusInEditor();
                DebuggerEvaluationStatisticsCollector.HISTORY_SHOW.log(XWatchesViewImpl.this.getTree().getProject());
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (XWatchesViewImpl.this.myEvaluateComboBox.getComboBox().getSelectedIndex() != this.selectedIndexOnPopupOpen) {
                    DebuggerEvaluationStatisticsCollector.HISTORY_CHOOSE.log(XWatchesViewImpl.this.getTree().getProject());
                }
            }
        });
        ((AnAction)addToWatchesActionRef.get()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(XDebuggerEvaluationDialog.getAddWatchKeystroke()), editorComponent);
        JComponent component = this.myEvaluateComboBox.getComponent();
        InternalDecoratorImpl.preventRecursiveBackgroundUpdateOnToolwindow((JComponent)component);
        component.setBackground((Color)EVALUATE_FIELD_BACKGROUND_COLOR);
        component.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        if (!UIExperiment.isNewDebuggerUIEnabled()) {
            XToggleEvaluateExpressionFieldAction.markAsEvaluateExpressionField(component);
        }
        return component;
    }

    @Override
    protected void beforeTreeBuild(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            XWatchesViewImpl.$$$reportNull$$$0(7);
        }
        if (event != XDebugView.SessionEvent.SETTINGS_CHANGED) {
            this.myRootNode.removeResultNode();
        }
    }

    private void addExpressionResultNode() {
        XExpression expression = this.myEvaluateComboBox.getExpression();
        if (!XDebuggerUtilImpl.isEmptyExpression(expression)) {
            this.myEvaluateComboBox.saveTextInHistory();
            XDebugSessionProxy session = this.getSessionProxy();
            if (session != null) {
                ((XEvaluationListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(XEvaluationListener.TOPIC)).inlineEvaluatorInvoked(session.getProject(), expression);
            }
            this.myRootNode.addResultNode(session != null ? session.getCurrentStackFrame() : null, expression);
            DebuggerEvaluationStatisticsCollector.INLINE_EVALUATE.log(this.getTree().getProject());
        }
    }

    @Override
    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        if (stackFrame == null) {
            XWatchesViewImpl.$$$reportNull$$$0(8);
        }
        super.buildTreeAndRestoreState(stackFrame);
        if (this.myEvaluateComboBox != null) {
            this.myEvaluateComboBox.setSourcePosition(stackFrame.getSourcePosition());
        }
    }

    private void installEditListeners() {
        final XDebuggerTree watchTree = this.getTree();
        final SingleEdtTaskScheduler quitePeriod = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        final SingleEdtTaskScheduler editAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        final ClickListener mouseListener2 = new ClickListener(this){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!SwingUtilities.isLeftMouseButton(event) || (event.getModifiers() & 0xF) != 0) {
                    return false;
                }
                boolean sameRow = XWatchesViewImpl.isAboveSelectedItem(event, watchTree, false);
                if (!sameRow || clickCount > 1) {
                    editAlarm.cancel();
                    return false;
                }
                AnAction editWatchAction = ActionManager.getInstance().getAction("XDebugger.EditWatch");
                Presentation presentation = editWatchAction.getTemplatePresentation().clone();
                DataContext context = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                AnActionEvent actionEvent = new AnActionEvent(null, context, "WATCH_TREE", presentation, ActionManager.getInstance(), 0);
                Runnable runnable = () -> editWatchAction.actionPerformed(actionEvent);
                if (editAlarm.isEmpty() && quitePeriod.isEmpty()) {
                    editAlarm.request((long)UIUtil.getMultiClickInterval(), runnable);
                } else {
                    editAlarm.cancel();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$5", "onClick"));
            }
        };
        DoubleClickListener mouseEmptySpaceListener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!XWatchesViewImpl.isAboveSelectedItem(event, watchTree, true)) {
                    XWatchesViewImpl.this.myRootNode.addNewWatch();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$6", "onDoubleClick"));
            }
        };
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseListener2);
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseEmptySpaceListener);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                quitePeriod.cancelAndRequest((long)UIUtil.getMultiClickInterval(), EmptyRunnable.getInstance());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                editAlarm.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListenerUtil.addFocusListener((Component)((Object)watchTree), (FocusListener)focusListener);
        TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                quitePeriod.cancelAndRequest((long)UIUtil.getMultiClickInterval(), EmptyRunnable.getInstance());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$8", "valueChanged"));
            }
        };
        watchTree.addTreeSelectionListener(selectionListener);
        this.myDisposables.add(new Disposable(){
            final /* synthetic */ ClickListener val$mouseEmptySpaceListener;
            final /* synthetic */ FocusListener val$focusListener;
            final /* synthetic */ TreeSelectionListener val$selectionListener;
            {
                this.val$mouseEmptySpaceListener = clickListener2;
                this.val$focusListener = focusListener;
                this.val$selectionListener = treeSelectionListener;
            }

            public void dispose() {
                ListenerUtil.removeClickListener((Component)((Object)watchTree), (ClickListener)mouseListener2);
                ListenerUtil.removeClickListener((Component)((Object)watchTree), (ClickListener)this.val$mouseEmptySpaceListener);
                ListenerUtil.removeFocusListener((Component)((Object)watchTree), (FocusListener)this.val$focusListener);
                watchTree.removeTreeSelectionListener(this.val$selectionListener);
            }
        });
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposables);
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.getTree()));
        super.dispose();
    }

    private static boolean isAboveSelectedItem(MouseEvent event, XDebuggerTree watchTree, boolean fullWidth) {
        Rectangle bounds = watchTree.getRowBounds(watchTree.getLeadSelectionRow());
        if (bounds != null) {
            if (fullWidth) {
                bounds.x = 0;
            }
            bounds.width = watchTree.getWidth();
            if (bounds.contains(event.getPoint())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addWatchExpression(@NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(9);
        }
        this.addWatchExpression(expression, index, navigateToWatchNode, false);
    }

    public void addWatchExpression(@NotNull XExpression expression, int index, boolean navigateToWatchNode, boolean noDuplicates) {
        if (expression == null) {
            XWatchesViewImpl.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        XDebugSessionProxy session = this.getSessionProxy();
        boolean found = false;
        if (noDuplicates) {
            for (WatchNode watchNode : this.myRootNode.getWatchChildren()) {
                if (!watchNode.getExpression().equals((Object)expression)) continue;
                TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)watchNode);
                found = true;
            }
        }
        if (!found) {
            this.myRootNode.addWatchExpression(session != null ? session.getCurrentStackFrame() : null, expression, index, navigateToWatchNode);
            this.updateSessionData();
        }
        if (navigateToWatchNode && session != null) {
            XDebugSessionTab.showWatchesView(session);
        }
    }

    public void computeWatches() {
        this.myRootNode.computeWatches();
    }

    @Override
    protected XValueContainerNode.Root<XValueContainer> doCreateNewRootNode(@Nullable XStackFrame stackFrame, @Nullable XDebuggerTreeState stateToRecover) {
        this.myRootNode = this.inlineWatchesEnabled ? new InlineWatchesRootNode(this.getTree(), (XWatchesView)this, this.myConfigurationName, stackFrame, this.myWatchesInVariables, stateToRecover) : new WatchesRootNode(this.getTree(), (XWatchesView)this, this.myConfigurationName, stackFrame, this.myWatchesInVariables, stateToRecover);
        return this.myRootNode;
    }

    private XDebuggerWatchesManager getWatchesManager() {
        return XDebugManagerProxy.getInstance().getWatchesManager(this.getTree().getProject());
    }

    public void addInlineWatchExpression(@NotNull InlineWatch watch, int index, boolean navigateToWatchNode) {
        if (watch == null) {
            XWatchesViewImpl.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        XDebugSessionProxy session = this.getSessionProxy();
        ((InlineWatchesRootNode)this.myRootNode).addInlineWatchExpression(session != null ? session.getCurrentStackFrame() : null, watch, index, navigateToWatchNode);
        if (navigateToWatchNode && session != null) {
            XDebugSessionTab.showWatchesView(session);
        }
    }

    public void removeInlineWatches(Collection<InlineWatch> watches) {
        InlineWatchesRootNode rootNode = (InlineWatchesRootNode)this.myRootNode;
        List nodesToRemove = ContainerUtil.filter(rootNode.getInlineWatchChildren(), node -> watches.contains(node.getWatch()));
        if (!nodesToRemove.isEmpty()) {
            this.removeInlineNodes(nodesToRemove, false);
        }
    }

    private void removeInlineNodes(List<? extends XDebuggerTreeNode> inlineWatches, boolean updateManager) {
        InlineWatchesRootNode rootNode = (InlineWatchesRootNode)this.myRootNode;
        List<? extends InlineWatchNode> inlineWatchChildren = rootNode.getInlineWatchChildren();
        int[] minIndex = new int[]{Integer.MAX_VALUE};
        ArrayList<InlineWatchNode> toRemoveInlines = new ArrayList<InlineWatchNode>();
        inlineWatches.forEach(node -> {
            int index = inlineWatchChildren.indexOf(node);
            if (index != -1) {
                toRemoveInlines.add((InlineWatchNode)((Object)node));
                minIndex[0] = Math.min(minIndex[0], index);
            }
        });
        rootNode.removeInlineChildren(toRemoveInlines);
        List<? extends InlineWatchNode> newChildren = rootNode.getInlineWatchChildren();
        if (!newChildren.isEmpty()) {
            InlineWatchNode node2 = newChildren.get(Math.min(minIndex[0], newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)node2);
        }
        if (updateManager) {
            this.getWatchesManager().inlineWatchesRemoved(ContainerUtil.map(toRemoveInlines, node -> node.getWatch()), (XInlineWatchesView)this);
        }
    }

    protected void addEmptyMessage(XValueContainerNode root) {
        if (this.myWatchesInVariables) {
            super.addEmptyMessage(root);
        }
    }

    @Deprecated
    @NotNull
    protected List<XExpression> getExpressions() {
        List list = ContainerUtil.map((Collection)ContainerUtil.notNullize((List)this.getWatchesManager().getWatchEntries(this.myConfigurationName)), XWatch::getExpression);
        if (list == null) {
            XWatchesViewImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    protected void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            XWatchesViewImpl.$$$reportNull$$$0(13);
        }
        super.uiDataSnapshot(sink);
        sink.set(XWatchesView.DATA_KEY, (Object)this);
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        ThreadingAssertions.assertEventDispatchThread();
        List ordinaryWatches = ContainerUtil.filter(nodes, node -> !(node instanceof InlineWatchNode));
        List inlineWatches = ContainerUtil.filter(nodes, node -> node instanceof InlineWatchNode);
        if (!inlineWatches.isEmpty()) {
            this.removeInlineNodes(inlineWatches, true);
        }
        if (ordinaryWatches.isEmpty()) {
            return;
        }
        List<? extends WatchNode> children = this.myRootNode.getWatchChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove = new ArrayList<XDebuggerTreeNode>();
        for (TreeNode node2 : ordinaryWatches) {
            int index = children.indexOf(node2);
            if (index == -1) continue;
            toRemove.add((XDebuggerTreeNode)node2);
            minIndex = Math.min(minIndex, index);
        }
        this.myRootNode.removeChildren(toRemove);
        List<? extends WatchNode> newChildren = this.myRootNode.getWatchChildren();
        if (!newChildren.isEmpty()) {
            TreeNode node2;
            node2 = newChildren.get(Math.min(minIndex, newChildren.size() - 1));
            TreeUtil.selectNode((JTree)((Object)this.getTree()), (TreeNode)node2);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        List<? extends InlineWatchNode> children;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.inlineWatchesEnabled && !(children = ((InlineWatchesRootNode)this.myRootNode).getInlineWatchChildren()).isEmpty()) {
            this.removeInlineNodes(children, true);
        }
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    public void moveWatchUp(WatchNode node) {
        this.myRootNode.moveUp(node);
        this.updateSessionData();
    }

    public void moveWatchDown(WatchNode node) {
        this.myRootNode.moveDown(node);
        this.updateSessionData();
    }

    public void updateSessionData() {
        List<XWatch> watches = this.myRootNode.getWatches();
        this.getWatchesManager().setWatchEntries(this.myConfigurationName, watches);
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
            if (((XValueNodeImpl[])object).length == 1) {
                Point point = aEvent.getPoint();
                XDebuggerTree tree = this.getTree();
                TreePath path = tree.getClosestPathForLocation(point.x, point.y);
                if (path != null && path.getLastPathComponent() == ((XValueNodeImpl[])object)[0]) {
                    Rectangle pathBounds = tree.getPathBounds(path);
                    possible = pathBounds != null && pathBounds.y + pathBounds.height < point.y;
                }
            }
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            for (XValueNodeImpl node : (XValueNodeImpl[])object) {
                DebuggerUIUtil.addToWatches((XWatchesView)this, node);
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(XExpressionImpl.fromText(text), -1, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localsPanelComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrame";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XWatchesViewImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeTreeBuild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTreeAndRestoreState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addWatchExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addInlineWatchExpression";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

