/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.hotswap;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.hotswap.HotSwapInDebugSessionEnabler;
import com.intellij.xdebugger.hotswap.HotSwapProvider;
import com.intellij.xdebugger.hotswap.HotSwapSession;
import com.intellij.xdebugger.hotswap.HotSwapSessionManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.hotswap.HotSwapSessionEntry;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u001c\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager;", "Lcom/intellij/xdebugger/XDebuggerManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionEntry;", "findHotSwapSession", "Lcom/intellij/xdebugger/hotswap/HotSwapSession;", "process", "processStarted", "", "debugProcess", "processStopped", "currentSessionChanged", "previousSession", "Lcom/intellij/xdebugger/XDebugSession;", "currentSession", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHotSwapDebugSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotSwapDebugSessionManager.kt\ncom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n295#2,2:70\n*S KotlinDebug\n*F\n+ 1 HotSwapDebugSessionManager.kt\ncom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager\n*L\n53#1:70,2\n*E\n"})
public final class HotSwapDebugSessionManager
implements XDebuggerManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<XDebugProcess, HotSwapSessionEntry> sessions;

    public HotSwapDebugSessionManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.sessions = new ConcurrentHashMap();
        SimpleMessageBusConnection simpleMessageBusConnection = project.getMessageBus().connect(cs);
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)this);
    }

    @Nullable
    public final HotSwapSession<?> findHotSwapSession(@NotNull XDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        HotSwapSessionEntry hotSwapSessionEntry = this.sessions.get(process);
        return hotSwapSessionEntry != null ? hotSwapSessionEntry.getHotSwapSession() : null;
    }

    public void processStarted(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (!Registry.Companion.is("debugger.hotswap.floating.toolbar")) {
            return;
        }
        HotSwapProvider hotSwapProvider = HotSwapInDebugSessionEnabler.Companion.createProviderForProcess(debugProcess);
        if (hotSwapProvider == null) {
            return;
        }
        HotSwapProvider provider = hotSwapProvider;
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        XDebugSessionImpl xDebugSession2 = (XDebugSessionImpl)xDebugSession;
        Disposable disposable = CoroutineScopeKt.asDisposable((CoroutineScope)xDebugSession2.getCoroutineScope());
        HotSwapSession hotSwapSession = HotSwapSessionManager.Companion.getInstance(xDebugSession2.getProject()).createSession(provider, disposable);
        ((Map)this.sessions).put(debugProcess, new HotSwapSessionEntry(hotSwapSession, disposable));
    }

    public void processStopped(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        HotSwapSessionEntry hotSwapSessionEntry = this.sessions.remove(debugProcess);
        if (hotSwapSessionEntry == null) {
            return;
        }
        HotSwapSessionEntry sessionEntry = hotSwapSessionEntry;
        Disposer.dispose((Disposable)sessionEntry.getDisposable());
    }

    public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
        Object v2;
        block3: {
            if (currentSession == null) {
                return;
            }
            Set<Map.Entry<XDebugProcess, HotSwapSessionEntry>> set = this.sessions.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                XDebugProcess process = (XDebugProcess)k;
                if (!(process.getSession() == currentSession)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        Map.Entry entry = v2;
        if (entry == null) {
            return;
        }
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
        HotSwapSessionEntry entry2 = (HotSwapSessionEntry)v;
        Project project = currentSession.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HotSwapSessionManager.Companion.getInstance(project).onSessionSelected(entry2.getHotSwapSession());
    }

    @JvmStatic
    @NotNull
    public static final HotSwapDebugSessionManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nHotSwapDebugSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotSwapDebugSessionManager.kt\ncom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,69:1\n30#2,2:70\n*S KotlinDebug\n*F\n+ 1 HotSwapDebugSessionManager.kt\ncom/intellij/xdebugger/impl/hotswap/HotSwapDebugSessionManager$Companion\n*L\n59#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HotSwapDebugSessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HotSwapDebugSessionManager> serviceClass$iv = HotSwapDebugSessionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HotSwapDebugSessionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

