/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.hotswap;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.debugger.impl.rpc.HotSwapVisibleStatus;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.hotswap.HotSwapProvider;
import com.intellij.xdebugger.hotswap.HotSwapResultListener;
import com.intellij.xdebugger.hotswap.HotSwapSession;
import com.intellij.xdebugger.hotswap.SourceFileChangesCollector;
import com.intellij.xdebugger.hotswap.SourceFileChangesListener;
import com.intellij.xdebugger.impl.hotswap.HotSwapSessionImpl;
import com.intellij.xdebugger.impl.hotswap.HotSwapSessionManagerImpl;
import com.intellij.xdebugger.impl.hotswap.HotSwapSessionManagerImplKt;
import com.intellij.xdebugger.impl.hotswap.HotSwapStatusNotificationManager;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001%B'\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\r\u0010\u001c\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionImpl;", "T", "Lcom/intellij/xdebugger/hotswap/HotSwapSession;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/xdebugger/hotswap/HotSwapProvider;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/hotswap/HotSwapProvider;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "coroutineScope", "changesCollector", "Lcom/intellij/xdebugger/hotswap/SourceFileChangesCollector;", "currentStatus", "Lcom/intellij/platform/debugger/impl/rpc/HotSwapVisibleStatus;", "getCurrentStatus$intellij_platform_debugger_impl", "()Lcom/intellij/platform/debugger/impl/rpc/HotSwapVisibleStatus;", "_currentStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "setStatus", "", "status", "fireUpdate", "", "init", "init$intellij_platform_debugger_impl", "dispose", "performHotSwap", "getChanges", "", "startHotSwapListening", "Lcom/intellij/xdebugger/hotswap/HotSwapResultListener;", "showSuccessNotification", "SessionSourceFileChangesListener", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class HotSwapSessionImpl<T>
implements HotSwapSession<T>,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final HotSwapProvider<T> provider;
    @NotNull
    private final CoroutineScope coroutineScope;
    private SourceFileChangesCollector<T> changesCollector;
    @NotNull
    private final AtomicReference<HotSwapVisibleStatus> _currentStatus;

    public HotSwapSessionImpl(@NotNull Project project, @NotNull HotSwapProvider<T> provider, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.project = project;
        this.provider = provider;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)("HotSwapSession " + this), null, (boolean)false, (int)6, null);
        this._currentStatus = new AtomicReference<HotSwapVisibleStatus>(HotSwapVisibleStatus.NO_CHANGES);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final HotSwapVisibleStatus getCurrentStatus$intellij_platform_debugger_impl() {
        HotSwapVisibleStatus hotSwapVisibleStatus = this._currentStatus.get();
        if (hotSwapVisibleStatus == null) {
            hotSwapVisibleStatus = HotSwapVisibleStatus.NO_CHANGES;
        }
        return hotSwapVisibleStatus;
    }

    private final void setStatus(HotSwapVisibleStatus status, boolean fireUpdate) {
        HotSwapVisibleStatus curStatus;
        do {
            if ((curStatus = this._currentStatus.get()) != HotSwapSessionManagerImplKt.access$getCOMPLETED_STATUS$p()) continue;
            return;
        } while (!this._currentStatus.compareAndSet(curStatus, status));
        if (HotSwapSessionManagerImplKt.access$getLogger$p().isDebugEnabled()) {
            HotSwapSessionManagerImplKt.access$getLogger$p().debug("Session status changed: " + status + " (fire=" + fireUpdate + ")");
        }
        if (fireUpdate) {
            HotSwapSessionManagerImpl.fireStatusChanged$intellij_platform_debugger_impl$default(HotSwapSessionManagerImpl.Companion.getInstance(this.getProject()), this, null, 2, null);
        }
    }

    static /* synthetic */ void setStatus$default(HotSwapSessionImpl hotSwapSessionImpl, HotSwapVisibleStatus hotSwapVisibleStatus, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        hotSwapSessionImpl.setStatus(hotSwapVisibleStatus, bl);
    }

    public final void init$intellij_platform_debugger_impl() {
        this.changesCollector = this.provider.createChangesCollector((HotSwapSession)this, this.coroutineScope, (SourceFileChangesListener)new SessionSourceFileChangesListener());
        Disposable disposable = this;
        SourceFileChangesCollector<T> sourceFileChangesCollector = this.changesCollector;
        if (sourceFileChangesCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changesCollector");
            sourceFileChangesCollector = null;
        }
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)sourceFileChangesCollector));
    }

    public void dispose() {
        block1: {
            HotSwapStatusNotificationManager hotSwapStatusNotificationManager = HotSwapStatusNotificationManager.Companion.getInstanceOrNull$intellij_platform_debugger_impl(this.getProject());
            if (hotSwapStatusNotificationManager != null) {
                hotSwapStatusNotificationManager.clearNotifications$intellij_platform_debugger_impl();
            }
            this.setStatus(HotSwapSessionManagerImplKt.access$getCOMPLETED_STATUS$p(), false);
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
            HotSwapSessionManagerImpl hotSwapSessionManagerImpl = HotSwapSessionManagerImpl.Companion.getInstanceOrNull$intellij_platform_debugger_impl(this.getProject());
            if (hotSwapSessionManagerImpl == null) break block1;
            hotSwapSessionManagerImpl.onSessionDispose$intellij_platform_debugger_impl(this);
        }
    }

    public final void performHotSwap() {
        this.provider.performHotSwap((HotSwapSession)this);
    }

    @NotNull
    public Set<T> getChanges() {
        SourceFileChangesCollector<T> sourceFileChangesCollector = this.changesCollector;
        if (sourceFileChangesCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changesCollector");
            sourceFileChangesCollector = null;
        }
        return sourceFileChangesCollector.getChanges();
    }

    @NotNull
    public HotSwapResultListener startHotSwapListening(boolean showSuccessNotification2) {
        HotSwapStatusNotificationManager.Companion.getInstance(this.getProject()).clearNotifications$intellij_platform_debugger_impl();
        HotSwapVisibleStatus statusBefore = this.getCurrentStatus$intellij_platform_debugger_impl();
        HotSwapSessionImpl.setStatus$default(this, HotSwapVisibleStatus.IN_PROGRESS, false, 2, null);
        AtomicBoolean completed = new AtomicBoolean();
        return new HotSwapResultListener(statusBefore, completed, this, showSuccessNotification2){
            final /* synthetic */ HotSwapVisibleStatus $statusBefore;
            final /* synthetic */ AtomicBoolean $completed;
            final /* synthetic */ HotSwapSessionImpl<T> this$0;
            final /* synthetic */ boolean $showSuccessNotification;
            {
                this.$statusBefore = $statusBefore;
                this.$completed = $completed;
                this.this$0 = $receiver;
                this.$showSuccessNotification = $showSuccessNotification;
            }

            public void onSuccessfulReload() {
                this.completeHotSwap(true, HotSwapVisibleStatus.NO_CHANGES, HotSwapVisibleStatus.SUCCESS);
            }

            public void onFinish() {
                startHotSwapListening.1.completeHotSwap$default(this, true, HotSwapVisibleStatus.NO_CHANGES, null, 4, null);
            }

            public void onFailure() {
                startHotSwapListening.1.completeHotSwap$default(this, false, HotSwapVisibleStatus.NO_CHANGES, null, 4, null);
            }

            public void onCanceled() {
                startHotSwapListening.1.completeHotSwap$default(this, false, this.$statusBefore, null, 4, null);
            }

            private final void completeHotSwap(boolean resetChanges, HotSwapVisibleStatus status, HotSwapVisibleStatus forceStatus) {
                if (!this.$completed.compareAndSet(false, true)) {
                    return;
                }
                if (resetChanges) {
                    SourceFileChangesCollector sourceFileChangesCollector = HotSwapSessionImpl.access$getChangesCollector$p(this.this$0);
                    if (sourceFileChangesCollector == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"changesCollector");
                        sourceFileChangesCollector = null;
                    }
                    sourceFileChangesCollector.resetChanges();
                }
                boolean customFire = forceStatus != null;
                HotSwapSessionImpl.access$setStatus(this.this$0, status, !customFire);
                if (customFire) {
                    HotSwapSessionManagerImpl.Companion.getInstance(this.this$0.getProject()).fireStatusChanged$intellij_platform_debugger_impl((HotSwapSession)this.this$0, forceStatus);
                }
                if (forceStatus == HotSwapVisibleStatus.SUCCESS && this.$showSuccessNotification) {
                    HotSwapStatusNotificationManager.Companion.getInstance(this.this$0.getProject()).showSuccessNotification$intellij_platform_debugger_impl(HotSwapSessionImpl.access$getCoroutineScope$p(this.this$0));
                }
            }

            static /* synthetic */ void completeHotSwap$default(startHotSwapListening.1 var0, boolean bl, HotSwapVisibleStatus hotSwapVisibleStatus, HotSwapVisibleStatus hotSwapVisibleStatus2, int n, Object object) {
                if ((n & 4) != 0) {
                    hotSwapVisibleStatus2 = null;
                }
                var0.completeHotSwap(bl, hotSwapVisibleStatus, hotSwapVisibleStatus2);
            }
        };
    }

    public static final /* synthetic */ SourceFileChangesCollector access$getChangesCollector$p(HotSwapSessionImpl $this) {
        return $this.changesCollector;
    }

    public static final /* synthetic */ void access$setStatus(HotSwapSessionImpl $this, HotSwapVisibleStatus status, boolean fireUpdate) {
        $this.setStatus(status, fireUpdate);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(HotSwapSessionImpl $this) {
        return $this.coroutineScope;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionImpl$SessionSourceFileChangesListener;", "Lcom/intellij/xdebugger/hotswap/SourceFileChangesListener;", "<init>", "(Lcom/intellij/xdebugger/impl/hotswap/HotSwapSessionImpl;)V", "onNewChanges", "", "onChangesCanceled", "intellij.platform.debugger.impl"})
    private final class SessionSourceFileChangesListener
    implements SourceFileChangesListener {
        public void onNewChanges() {
            HotSwapSessionImpl.setStatus$default(HotSwapSessionImpl.this, HotSwapVisibleStatus.CHANGES_READY, false, 2, null);
        }

        public void onChangesCanceled() {
            HotSwapSessionImpl.setStatus$default(HotSwapSessionImpl.this, HotSwapVisibleStatus.NO_CHANGES, false, 2, null);
        }
    }
}

