/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.debugger.impl.shared.XDebuggerWatchesManager;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerTreePopup;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.proxy.MonolithSessionProxyKt;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Point;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

public class XDebuggerTreeInlayPopup<D>
extends XDebuggerTreePopup<D> {
    @NotNull
    private final XSourcePosition myPresentationPosition;
    @NotNull
    private final XDebugSessionProxy mySession;
    @NotNull
    private final XValueNodeImpl myValueNode;

    private XDebuggerTreeInlayPopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition presentationPosition, @NotNull XDebugSessionProxy session, @Nullable Runnable hideRunnable, @NotNull XValueNodeImpl valueNode2) {
        if (creator == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(1);
        }
        if (point == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(2);
        }
        if (presentationPosition == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(3);
        }
        if (session == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(4);
        }
        if (valueNode2 == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(5);
        }
        super(creator, editor, point, session.getProject(), hideRunnable);
        this.myPresentationPosition = presentationPosition;
        this.mySession = session;
        this.myValueNode = valueNode2;
    }

    @Override
    @NotNull
    protected DefaultActionGroup getToolbarActions() {
        DefaultActionGroup toolbarActions = super.getToolbarActions();
        if (Registry.is((String)"debugger.watches.inline.enabled")) {
            AnAction watchAction = this.myValueNode instanceof InlineWatchNodeImpl ? new EditInlineWatch() : new AddInlineWatch();
            toolbarActions.add(watchAction, Constraints.LAST);
        }
        DefaultActionGroup defaultActionGroup = toolbarActions;
        if (defaultActionGroup == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(6);
        }
        return defaultActionGroup;
    }

    @ApiStatus.Obsolete
    public static <D> void showTreePopup(DebuggerTreeCreator<D> creator, D initialItem, XValueNodeImpl valueNode2, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition position, @NotNull XDebugSession session, Runnable hideRunnable) {
        if (editor == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(7);
        }
        if (point == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(8);
        }
        if (position == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(9);
        }
        if (session == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(10);
        }
        XDebugSessionProxy proxy = MonolithSessionProxyKt.asProxy(session);
        new XDebuggerTreeInlayPopup<D>(creator, editor, point, position, proxy, hideRunnable, valueNode2).show(initialItem);
    }

    @ApiStatus.Internal
    public static <D> void showTreePopup(DebuggerTreeCreator<D> creator, D initialItem, XValueNodeImpl valueNode2, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition position, @NotNull XDebugSessionProxy session, Runnable hideRunnable) {
        if (editor == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(11);
        }
        if (point == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(12);
        }
        if (position == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(13);
        }
        if (session == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(14);
        }
        new XDebuggerTreeInlayPopup<D>(creator, editor, point, position, session, hideRunnable, valueNode2).show(initialItem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationPosition";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showTreePopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private class EditInlineWatch
    extends AnAction {
        EditInlineWatch() {
            super(XDebuggerBundle.message((String)"debugger.inline.watches.edit.watch.expression.text", (Object[])new Object[0]));
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditInlineWatch.$$$reportNull$$$0(0);
            }
            InlineWatchNodeImpl watch = (InlineWatchNodeImpl)XDebuggerTreeInlayPopup.this.myValueNode;
            XDebuggerWatchesManager watchesManager = XDebugManagerProxy.getInstance().getWatchesManager(XDebuggerTreeInlayPopup.this.mySession.getProject());
            XDebugSessionProxy session = DebuggerUIUtil.getSessionProxy(e);
            if (session != null) {
                if (XDebuggerTreeInlayPopup.this.myPopup != null) {
                    XDebuggerTreeInlayPopup.this.myPopup.cancel();
                }
                watchesManager.inlineWatchesRemoved(Collections.singletonList(watch.getWatch()), null);
                watchesManager.showInplaceEditor(watch.getPosition(), XDebuggerTreeInlayPopup.this.myEditor, session, watch.getExpression());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$EditInlineWatch", "actionPerformed"));
        }
    }

    private class AddInlineWatch
    extends XDebuggerTreeActionBase {
        private AddInlineWatch() {
            ActionUtil.mergeFrom((AnAction)this, (String)"Debugger.AddInlineWatch");
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(XDebuggerBundle.message((String)"debugger.inline.watches.popup.action.add.as.inline.watch", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddInlineWatch.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @Override
        protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
            if (nodeName == null) {
                AddInlineWatch.$$$reportNull$$$0(1);
            }
            node.calculateEvaluationExpression().thenAsync(expr -> {
                if (expr == null && node != XDebuggerTreeInlayPopup.this.myValueNode) {
                    return XDebuggerTreeInlayPopup.this.myValueNode.calculateEvaluationExpression();
                }
                return Promises.resolvedPromise((Object)expr);
            }).onSuccess(expr -> AppUIUtil.invokeOnEdt(() -> {
                XDebuggerWatchesManager manager = XDebugManagerProxy.getInstance().getWatchesManager(XDebuggerTreeInlayPopup.this.mySession.getProject());
                manager.showInplaceEditor(XDebuggerTreeInlayPopup.this.myPresentationPosition, XDebuggerTreeInlayPopup.this.myEditor, XDebuggerTreeInlayPopup.this.mySession, expr);
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$AddInlineWatch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$AddInlineWatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

