/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.pinned.items;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.PinToTopManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.pinned.items.PinToTopUtilKt;
import com.intellij.xdebugger.impl.pinned.items.PinToTopValue;
import com.intellij.xdebugger.impl.pinned.items.PinnedItemInfo;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import icons.PlatformDebuggerImplIcons;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\nJ\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\bJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u0010J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u0010J\u0010\u0010+\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\rJ\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u0010J\b\u0010.\u001a\u00020\u001eH\u0002J\u000e\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u001e2\u0006\u00100\u001a\u000201J\u0010\u00103\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0015j\b\u0012\u0004\u0012\u00020\r`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0015j\b\u0012\u0004\u0012\u00020\r`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u00065"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopManager;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "listeners", "", "Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopListener;", "nodeHoverLifetime", "Lcom/intellij/openapi/Disposable;", "activeNode", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "pinnedMembers", "Ljava/util/HashSet;", "Lcom/intellij/xdebugger/impl/pinned/items/PinnedItemInfo;", "Lkotlin/collections/HashSet;", "pinToTopIconAlarm", "Lcom/intellij/util/Alarm;", "pinToTopComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getPinToTopComparator", "()Ljava/util/Comparator;", "compoundComparator", "getCompoundComparator", "isEnabled", "", "onNodeHovered", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "lifetimeHolder", "addListener", "listener", "disposable", "removeListener", "getPinnedItemInfos", "", "addItemInfo", "info", "removeItemInfo", "isItemPinned", "isPinned", "pinnedItemInfo", "disposeCurrentNodeHoverSubscription", "saveState", "state", "Lcom/intellij/xdebugger/impl/PinToTopManagerState;", "loadState", "isPinToTopSupported", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class XDebuggerPinToTopManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<XDebuggerPinToTopListener> listeners;
    @Nullable
    private Disposable nodeHoverLifetime;
    @Nullable
    private WeakReference<XValueNodeImpl> activeNode;
    @NotNull
    private HashSet<PinnedItemInfo> pinnedMembers;
    @NotNull
    private final Alarm pinToTopIconAlarm;
    @NotNull
    private final Comparator<XValueNodeImpl> pinToTopComparator;
    @NotNull
    private final Comparator<XValueNodeImpl> compoundComparator;
    private static final long DEFAULT_ICON_DELAY = 300L;

    public XDebuggerPinToTopManager(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.listeners = new ArrayList();
        this.pinnedMembers = new HashSet();
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        this.pinToTopIconAlarm = new Alarm(coroutineScope, threadToUse);
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> XDebuggerPinToTopManager.pinToTopComparator$lambda$1(arg_0 -> XDebuggerPinToTopManager.pinToTopComparator$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        this.pinToTopComparator = comparator;
        Comparator<XValueNodeImpl> comparator2 = XValueNodeImpl.COMPARATOR;
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"COMPARATOR");
        this.compoundComparator = ComparisonsKt.then(this.pinToTopComparator, comparator2);
    }

    @NotNull
    public final Comparator<XValueNodeImpl> getPinToTopComparator() {
        return this.pinToTopComparator;
    }

    @NotNull
    public final Comparator<XValueNodeImpl> getCompoundComparator() {
        return this.compoundComparator;
    }

    public final boolean isEnabled() {
        return Registry.Companion.is("debugger.field.pin.to.top", true);
    }

    public final void onNodeHovered(@Nullable XDebuggerTreeNode node, @NotNull Disposable lifetimeHolder) {
        Intrinsics.checkNotNullParameter((Object)lifetimeHolder, (String)"lifetimeHolder");
        WeakReference<XValueNodeImpl> weakReference = this.activeNode;
        if (Intrinsics.areEqual((Object)(weakReference != null ? (XValueNodeImpl)weakReference.get() : null), (Object)node)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.disposeCurrentNodeHoverSubscription();
        if (!this.isPinToTopSupported(node)) {
            return;
        }
        XValueNodeImpl xValueNodeImpl = node instanceof XValueNodeImpl ? (XValueNodeImpl)node : null;
        if (xValueNodeImpl == null) {
            return;
        }
        XValueNodeImpl valueNode2 = xValueNodeImpl;
        if (!PinToTopUtilKt.canBePinned(valueNode2) || PinToTopUtilKt.isPinned((XValueNodeImpl)node, this)) {
            return;
        }
        Ref.ObjectRef oldIcon = new Ref.ObjectRef();
        oldIcon.element = valueNode2.getIcon();
        WeakReference<XDebuggerTreeNode> nodeRef = new WeakReference<XDebuggerTreeNode>(node);
        Disposable changeIconLifetime = () -> XDebuggerPinToTopManager.onNodeHovered$lambda$0(nodeRef, this, oldIcon);
        this.activeNode = nodeRef;
        this.nodeHoverLifetime = changeIconLifetime;
        this.pinToTopIconAlarm.addRequest(() -> XDebuggerPinToTopManager.onNodeHovered$lambda$1(node, oldIcon), 300L);
        Disposer.register((Disposable)lifetimeHolder, (Disposable)changeIconLifetime);
    }

    public final void addListener(@NotNull XDebuggerPinToTopListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.listeners.add(listener);
        Disposer.register((Disposable)disposable, () -> XDebuggerPinToTopManager.addListener$lambda$0(this, listener));
    }

    public final void removeListener(@NotNull XDebuggerPinToTopListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @NotNull
    public final List<PinnedItemInfo> getPinnedItemInfos() {
        return CollectionsKt.toList((Iterable)this.pinnedMembers);
    }

    public final void addItemInfo(@NotNull PinnedItemInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.pinnedMembers.add(info);
        for (XDebuggerPinToTopListener listener : this.listeners) {
            listener.onPinnedItemAdded(info);
        }
    }

    public final void removeItemInfo(@NotNull PinnedItemInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.pinnedMembers.remove(info);
        for (XDebuggerPinToTopListener listener : this.listeners) {
            listener.onPinnedItemRemoved(info);
        }
    }

    public final boolean isItemPinned(@Nullable XValueNodeImpl node) {
        return PinToTopUtilKt.isPinned(node, this);
    }

    public final boolean isPinned(@NotNull PinnedItemInfo pinnedItemInfo) {
        Intrinsics.checkNotNullParameter((Object)pinnedItemInfo, (String)"pinnedItemInfo");
        return this.pinnedMembers.contains(pinnedItemInfo);
    }

    private final void disposeCurrentNodeHoverSubscription() {
        Disposable disposable = this.nodeHoverLifetime;
        if (disposable == null) {
            return;
        }
        Disposer.dispose((Disposable)disposable);
        this.nodeHoverLifetime = null;
        this.pinToTopIconAlarm.cancelAllRequests();
    }

    public final void saveState(@NotNull PinToTopManagerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        state.setPinnedMembersList(CollectionsKt.toMutableList((Collection)this.pinnedMembers));
    }

    public final void loadState(@NotNull PinToTopManagerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.pinnedMembers.addAll((Collection<PinnedItemInfo>)state.getPinnedMembersList());
    }

    public final boolean isPinToTopSupported(@Nullable XDebuggerTreeNode node) {
        XValueContainerNode xValueContainerNode = node instanceof XValueContainerNode ? (XValueContainerNode)node : null;
        Object ValueContainer = xValueContainerNode != null ? xValueContainerNode.getValueContainer() : null;
        PinToTopValue pinToTopValue = ValueContainer instanceof PinToTopValue ? (PinToTopValue)ValueContainer : null;
        return pinToTopValue != null ? pinToTopValue.canBePinned() : false;
    }

    private static final Boolean pinToTopComparator$lambda$0(XDebuggerPinToTopManager this$0, XValueNodeImpl it) {
        return !this$0.isItemPinned(it);
    }

    private static final Boolean pinToTopComparator$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void onNodeHovered$lambda$0(WeakReference $nodeRef, XDebuggerPinToTopManager this$0, Ref.ObjectRef $oldIcon) {
        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)$nodeRef.get();
        if (xValueNodeImpl == null) {
            return;
        }
        XValueNodeImpl node = xValueNodeImpl;
        XValuePresentation xValuePresentation = node.getValuePresentation();
        if (Intrinsics.areEqual((Object)node.getIcon(), (Object)PlatformDebuggerImplIcons.PinToTop.UnpinnedItem) && xValuePresentation != null) {
            WriteIntentReadAction.run(() -> XDebuggerPinToTopManager.onNodeHovered$lambda$0$0(node, $oldIcon, xValuePresentation));
        }
        this$0.activeNode = null;
        this$0.nodeHoverLifetime = null;
    }

    private static final void onNodeHovered$lambda$0$0(XValueNodeImpl $node, Ref.ObjectRef $oldIcon, XValuePresentation $xValuePresentation) {
        $node.setPresentation((Icon)$oldIcon.element, $xValuePresentation, !$node.isLeaf());
    }

    private static final void onNodeHovered$lambda$1(XDebuggerTreeNode $node, Ref.ObjectRef $oldIcon) {
        XValuePresentation xValuePresentation = ((XValueNodeImpl)$node).getValuePresentation();
        if (xValuePresentation == null) {
            return;
        }
        XValuePresentation xValuePresentation2 = xValuePresentation;
        $oldIcon.element = ((XValueNodeImpl)$node).getIcon();
        ((XValueNodeImpl)$node).setPresentation(PlatformDebuggerImplIcons.PinToTop.UnpinnedItem, xValuePresentation2, !((XValueNodeImpl)$node).isLeaf());
    }

    private static final void addListener$lambda$0(XDebuggerPinToTopManager this$0, XDebuggerPinToTopListener $listener) {
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/xdebugger/impl/pinned/items/XDebuggerPinToTopManager;", "project", "Lcom/intellij/openapi/project/Project;", "DEFAULT_ICON_DELAY", "", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XDebuggerPinToTopManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)xDebuggerManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerManagerImpl");
            XDebuggerPinToTopManager xDebuggerPinToTopManager = ((XDebuggerManagerImpl)xDebuggerManager).getPinToTopManager();
            Intrinsics.checkNotNullExpressionValue((Object)xDebuggerPinToTopManager, (String)"getPinToTopManager(...)");
            return xDebuggerPinToTopManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

