/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.proxy;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.proxy.XStackFramesListColorsCache;
import com.intellij.ui.FileColorManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.proxy.ColorState;
import com.intellij.xdebugger.impl.proxy.VirtualFileColor;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/xdebugger/impl/proxy/MonolithFramesColorCache;", "Lcom/intellij/platform/debugger/impl/shared/proxy/XStackFramesListColorsCache;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "onAllComputed", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/xdebugger/impl/XDebugSessionImpl;Lkotlin/jvm/functions/Function0;)V", "myFileColors", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/xdebugger/impl/proxy/ColorState;", "myCurrentlyComputingFiles", "Ljava/util/concurrent/atomic/AtomicInteger;", "get", "Ljava/awt/Color;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
public final class MonolithFramesColorCache
implements XStackFramesListColorsCache {
    @NotNull
    private final XDebugSessionImpl session;
    @NotNull
    private final Map<VirtualFile, ColorState> myFileColors;
    @NotNull
    private final AtomicInteger myCurrentlyComputingFiles;

    public MonolithFramesColorCache(@NotNull XDebugSessionImpl session, @NotNull Function0<Unit> onAllComputed) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(onAllComputed, (String)"onAllComputed");
        this.session = session;
        this.myFileColors = new LinkedHashMap();
        this.myCurrentlyComputingFiles = new AtomicInteger(0);
        BuildersKt.launch$default((CoroutineScope)this.session.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onAllComputed, null){
            int label;
            final /* synthetic */ MonolithFramesColorCache this$0;
            final /* synthetic */ Function0<Unit> $onAllComputed;
            {
                this.this$0 = $receiver;
                this.$onAllComputed = $onAllComputed;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.session.getFileColorsComputer().getFileColors().collect(new FlowCollector(){

                            public final Object emit(VirtualFileColor virtualFileColor, Continuation<? super Unit> $completion) {
                                VirtualFile file = virtualFileColor.component1();
                                ColorState colorState = virtualFileColor.component2();
                                ColorState oldState = this$0.myFileColors.put(file, colorState);
                                if (colorState instanceof ColorState.Computing) {
                                    this$0.myCurrentlyComputingFiles.incrementAndGet();
                                } else if (oldState == ColorState.Computing.INSTANCE && this$0.myCurrentlyComputingFiles.decrementAndGet() == 0) {
                                    $onAllComputed.invoke();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public Color get(@NotNull XStackFrame stackFrame, @NotNull Project project) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XSourcePosition xSourcePosition = stackFrame.getSourcePosition();
        Object object = virtualFile = xSourcePosition != null ? xSourcePosition.getFile() : null;
        if (virtualFile == null) {
            return FileColorManager.getInstance((Project)project).getScopeColor("Non-Project Files");
        }
        ColorState res = this.myFileColors.get(virtualFile);
        if (res != null) {
            return res.getColor();
        }
        this.session.getFileColorsComputer().sendRequest(virtualFile);
        return null;
    }
}

