/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.rpc.models;

import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.platform.debugger.impl.rpc.XValueId;
import com.intellij.platform.debugger.impl.rpc.XValueMarkerDto;
import com.intellij.platform.debugger.impl.rpc.XValueSerializedPresentation;
import com.intellij.platform.kernel.ids.BackendGlobalIdsKt;
import com.intellij.platform.kernel.ids.BackendValueIdType;
import com.intellij.platform.rpc.Id;
import com.intellij.ui.JBColor;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.rpc.models.BackendXValueModel;
import com.intellij.xdebugger.impl.rpc.models.XValuePresentationBridgeKt;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010(\u001a\u00020)J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0%J\u0010\u0010+\u001a\u00020)2\b\u0010\u0019\u001a\u0004\u0018\u00010,J\b\u0010-\u001a\u00020)H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006/"}, d2={"Lcom/intellij/xdebugger/impl/rpc/models/BackendXValueModel;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "xValue", "Lcom/intellij/xdebugger/frame/XValue;", "precomputePresentation", "", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/xdebugger/impl/XDebugSessionImpl;Lcom/intellij/xdebugger/frame/XValue;Z)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "getSession", "()Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "getXValue", "()Lcom/intellij/xdebugger/frame/XValue;", "id", "Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "getId", "()Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "_marker", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/debugger/impl/rpc/XValueMarkerDto;", "marker", "Lkotlinx/coroutines/flow/StateFlow;", "getMarker", "()Lkotlinx/coroutines/flow/StateFlow;", "_fullValueEvaluator", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "fullValueEvaluator", "getFullValueEvaluator", "_presentation", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/debugger/impl/rpc/XValueSerializedPresentation;", "presentation", "Lkotlinx/coroutines/flow/Flow;", "getPresentation", "()Lkotlinx/coroutines/flow/Flow;", "computeValuePresentation", "", "computeTooltipPresentation", "setMarker", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "delete", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBackendXValueModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendXValueModel.kt\ncom/intellij/xdebugger/impl/rpc/models/BackendXValueModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,224:1\n230#2,5:225\n*S KotlinDebug\n*F\n+ 1 BackendXValueModel.kt\ncom/intellij/xdebugger/impl/rpc/models/BackendXValueModel\n*L\n106#1:225,5\n*E\n"})
public final class BackendXValueModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final XDebugSessionImpl session;
    @NotNull
    private final XValue xValue;
    @NotNull
    private final XValueId id;
    @NotNull
    private final MutableStateFlow<XValueMarkerDto> _marker;
    @NotNull
    private final StateFlow<XValueMarkerDto> marker;
    @NotNull
    private final MutableStateFlow<XFullValueEvaluator> _fullValueEvaluator;
    @NotNull
    private final StateFlow<XFullValueEvaluator> fullValueEvaluator;
    @NotNull
    private final MutableSharedFlow<XValueSerializedPresentation> _presentation;
    @NotNull
    private final Flow<XValueSerializedPresentation> presentation;

    public BackendXValueModel(@NotNull CoroutineScope cs, @NotNull XDebugSessionImpl session, @NotNull XValue xValue, boolean precomputePresentation) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)xValue, (String)"xValue");
        this.cs = cs;
        this.session = session;
        this.xValue = xValue;
        this.id = (XValueId)BackendGlobalIdsKt.storeValueGlobally((CoroutineScope)this.cs, (Object)this, (BackendValueIdType)Companion.BackendXValueIdType.INSTANCE);
        this._marker = StateFlowKt.MutableStateFlow(null);
        this.marker = FlowKt.asStateFlow(this._marker);
        this._fullValueEvaluator = StateFlowKt.MutableStateFlow(null);
        this.fullValueEvaluator = FlowKt.asStateFlow(this._fullValueEvaluator);
        this._presentation = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.presentation = (Flow)FlowKt.asSharedFlow(this._presentation);
        if (precomputePresentation) {
            this.computeValuePresentation();
        }
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @NotNull
    public final XDebugSessionImpl getSession() {
        return this.session;
    }

    @NotNull
    public final XValue getXValue() {
        return this.xValue;
    }

    @NotNull
    public final XValueId getId() {
        return this.id;
    }

    @NotNull
    public final StateFlow<XValueMarkerDto> getMarker() {
        return this.marker;
    }

    @NotNull
    public final StateFlow<XFullValueEvaluator> getFullValueEvaluator() {
        return this.fullValueEvaluator;
    }

    @NotNull
    public final Flow<XValueSerializedPresentation> getPresentation() {
        return this.presentation;
    }

    public final void computeValuePresentation() {
        XValuePresentationBridgeKt.computePresentation(this.xValue, this.cs, XValuePlace.TREE, (Function1<? super XValueSerializedPresentation, Unit>)((Function1)arg_0 -> BackendXValueModel.computeValuePresentation$lambda$0(this, arg_0)), (Function1<? super XFullValueEvaluator, Unit>)((Function1)arg_0 -> BackendXValueModel.computeValuePresentation$lambda$1(this, arg_0)));
    }

    @NotNull
    public final Flow<XValueSerializedPresentation> computeTooltipPresentation() {
        return FlowKt.buffer$default((Flow)FlowKt.channelFlow((Function2)((Function2)new Function2<ProducerScope<? super XValueSerializedPresentation>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BackendXValueModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ProducerScope producerScope = (ProducerScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$channelFlow;
                        ResultKt.throwOnFailure((Object)$result);
                        void channelCs = $this$channelFlow;
                        XValuePresentationBridgeKt.computePresentation(this.this$0.getXValue(), (CoroutineScope)channelCs, XValuePlace.TOOLTIP, (Function1<? super XValueSerializedPresentation, Unit>)((Function1)arg_0 -> computeTooltipPresentation.1.invokeSuspend$lambda$0((ProducerScope)$this$channelFlow, arg_0)), (Function1<? super XFullValueEvaluator, Unit>)((Function1)computeTooltipPresentation.1::invokeSuspend$lambda$1));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super XValueSerializedPresentation> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ProducerScope $$this$channelFlow, XValueSerializedPresentation it) {
                $$this$channelFlow.trySend-JP2dKIU((Object)it);
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(XFullValueEvaluator it) {
                return Unit.INSTANCE;
            }
        })), (int)1, null, (int)2, null);
    }

    public final void setMarker(@Nullable ValueMarkup marker) {
        Color color;
        String string;
        XValueMarkerDto nextValue$iv;
        Object prevValue$iv;
        if (marker == null) {
            this._marker.setValue(null);
            return;
        }
        MutableStateFlow<XValueMarkerDto> $this$update$iv = this._marker;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            XValueMarkerDto it = (XValueMarkerDto)prevValue$iv;
            boolean bl = false;
            string = marker.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Color color2 = marker.getColor();
            if (color2 == null) {
                color2 = (Color)JBColor.RED;
            }
            color = color2;
            Intrinsics.checkNotNull((Object)color);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new XValueMarkerDto(string, ColorIdKt.rpcId((Color)color), marker.getToolTipText()))));
    }

    @ApiStatus.Internal
    public final void delete() {
        BackendGlobalIdsKt.deleteValueById((Id)((Id)this.id), (BackendValueIdType)Companion.BackendXValueIdType.INSTANCE);
    }

    private static final Unit computeValuePresentation$lambda$0(BackendXValueModel this$0, XValueSerializedPresentation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0._presentation.tryEmit((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit computeValuePresentation$lambda$1(BackendXValueModel this$0, XFullValueEvaluator it) {
        this$0._fullValueEvaluator.setValue((Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/rpc/models/BackendXValueModel$Companion;", "", "<init>", "()V", "findById", "Lcom/intellij/xdebugger/impl/rpc/models/BackendXValueModel;", "id", "Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "BackendXValueIdType", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        @Nullable
        public final BackendXValueModel findById(@NotNull XValueId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return (BackendXValueModel)BackendGlobalIdsKt.findValueById((Id)((Id)id), (BackendValueIdType)BackendXValueIdType.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/xdebugger/impl/rpc/models/BackendXValueModel$Companion$BackendXValueIdType;", "Lcom/intellij/platform/kernel/ids/BackendValueIdType;", "Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "Lcom/intellij/xdebugger/impl/rpc/models/BackendXValueModel;", "<init>", "()V", "intellij.platform.debugger.impl"})
        private static final class BackendXValueIdType
        extends BackendValueIdType<XValueId, BackendXValueModel> {
            @NotNull
            public static final BackendXValueIdType INSTANCE = new BackendXValueIdType();

            private BackendXValueIdType() {
                super((Function1)1.INSTANCE);
            }
        }
    }
}

