/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@State(name="XDebuggerSettings", storages={@Storage(value="debugger.xml")}, category=SettingsCategory.TOOLS)
public final class XDebuggerSettingManagerImpl
extends XDebuggerSettingsManager
implements PersistentStateComponent<SettingsState>,
Disposable {
    private static final ExtensionPointName<XDebuggerSettings> SETTINGS_EP = ExtensionPointName.create((String)"com.intellij.xdebugger.settings");
    private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
    private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

    public static XDebuggerSettingManagerImpl getInstanceImpl() {
        return (XDebuggerSettingManagerImpl)XDebuggerSettingsManager.getInstance();
    }

    public SettingsState getState() {
        SettingsState settingsState = new SettingsState();
        settingsState.setDataViewSettings(this.myDataViewSettings);
        settingsState.setGeneralSettings(this.myGeneralSettings);
        SETTINGS_EP.forEachExtensionSafe(settings -> {
            Element serializedState;
            Object subState = settings.getState();
            if (subState != null && (serializedState = XmlSerializer.serialize((Object)subState)) != null) {
                SpecificSettingsState state = new SpecificSettingsState();
                state.id = settings.getId();
                state.configuration = serializedState;
                settingsState.specificStates.add(state);
            }
        });
        return settingsState;
    }

    @NotNull
    public XDebuggerDataViewSettings getDataViewSettings() {
        XDebuggerDataViewSettings xDebuggerDataViewSettings = this.myDataViewSettings;
        if (xDebuggerDataViewSettings == null) {
            XDebuggerSettingManagerImpl.$$$reportNull$$$0(0);
        }
        return xDebuggerDataViewSettings;
    }

    public XDebuggerGeneralSettings getGeneralSettings() {
        return this.myGeneralSettings;
    }

    public void loadState(@NotNull SettingsState state) {
        if (state == null) {
            XDebuggerSettingManagerImpl.$$$reportNull$$$0(1);
        }
        this.myDataViewSettings = state.getDataViewSettings();
        this.myGeneralSettings = state.getGeneralSettings();
        for (SpecificSettingsState settingsState : state.specificStates) {
            XDebuggerSettings settings = (XDebuggerSettings)SETTINGS_EP.findFirstSafe(e -> settingsState.id.equals(e.getId()));
            if (settings == null) continue;
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)settings, (Element)settingsState.configuration);
        }
    }

    public void noStateLoaded() {
        this.loadState(new SettingsState());
    }

    public void dispose() {
    }

    public void forEachSettings(Consumer<XDebuggerSettings> consumer) {
        SETTINGS_EP.forEachExtensionSafe(consumer);
    }

    @Nullable
    public <T extends XDebuggerSettings<?>> T getSettings(Class<T> aClass) {
        return (T)((XDebuggerSettings)SETTINGS_EP.findExtension(aClass));
    }

    @Nullable
    public XDebuggerSettings<?> findFirstSettings(Predicate<XDebuggerSettings> predicate) {
        return (XDebuggerSettings)SETTINGS_EP.findFirstSafe(predicate);
    }

    @VisibleForTesting
    public static ExtensionPointName<XDebuggerSettings> getSettingsEP() {
        return SETTINGS_EP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/settings/XDebuggerSettingManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataViewSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/settings/XDebuggerSettingManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class SettingsState {
        @XCollection(propertyElementName="debuggers")
        public List<SpecificSettingsState> specificStates = new SmartList();
        private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();
        private XDebuggerGeneralSettings myGeneralSettings = new XDebuggerGeneralSettings();

        @Property(surroundWithTag=false)
        public XDebuggerDataViewSettings getDataViewSettings() {
            return this.myDataViewSettings;
        }

        public void setDataViewSettings(XDebuggerDataViewSettings dataViewSettings) {
            this.myDataViewSettings = dataViewSettings;
        }

        @Property(surroundWithTag=false)
        public XDebuggerGeneralSettings getGeneralSettings() {
            return this.myGeneralSettings;
        }

        public void setGeneralSettings(XDebuggerGeneralSettings generalSettings) {
            this.myGeneralSettings = generalSettings;
        }
    }

    @Tag(value="debugger")
    static class SpecificSettingsState {
        @Attribute
        public String id;
        @Tag
        public Element configuration;

        SpecificSettingsState() {
        }
    }
}

