/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.execution.configurations.RemoteRunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.platform.debugger.impl.rpc.XDebuggerTreeSelectedValueId;
import com.intellij.platform.debugger.impl.rpc.XValueId;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.collection.visualizer.XDebuggerNodeLinkActionProvider;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.SplitDebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRenderer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSpeedSearch;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTree
extends DnDAwareTree
implements UiCompatibleDataProvider,
Disposable {
    private final ComponentListener myMoveListener;
    private static final Logger LOG = Logger.getInstance(XDebuggerTree.class);
    public static final DataKey<XDebuggerTree> XDEBUGGER_TREE_KEY = DataKey.create((String)"xdebugger.tree");
    public static final DataKey<List<XValueNodeImpl>> SELECTED_NODES = DataKey.create((String)"xdebugger.selected.nodes");
    private final SingleAlarm myAlarm;
    private static final Function<TreePath, String> SPEED_SEARCH_CONVERTER = o -> {
        Object node;
        String text = null;
        if (o != null && (node = o.getLastPathComponent()) instanceof XDebuggerTreeNode) {
            text = ((XDebuggerTreeNode)node).getText().toString();
        }
        return StringUtil.notNullize(text);
    };
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof XDebuggerTree)) {
                return null;
            }
            XDebuggerTree tree = (XDebuggerTree)((Object)c);
            TreePath[] selectedPaths = tree.getSelectionPaths();
            if (selectedPaths == null || selectedPaths.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (TreePath path : selectedPaths) {
                htmlBuf.append("  <li>");
                Object node = path.getLastPathComponent();
                if (node != null) {
                    if (node instanceof XDebuggerTreeNode) {
                        ((XDebuggerTreeNode)node).appendToComponent((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(new StringBuilder[]{plainBuf, htmlBuf});
                    } else {
                        String text = node.toString();
                        plainBuf.append(text);
                        htmlBuf.append(text);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable((CharSequence)htmlBuf, (CharSequence)plainBuf);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    };
    private final DefaultTreeModel myTreeModel;
    private final Project myProject;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private XSourcePosition mySourcePosition;
    private final List<XDebuggerTreeListener> myListeners;
    private final XValueMarkers<?, ?> myValueMarkers;
    private final TreeExpansionListener myTreeExpansionListener;
    private final XDebuggerPinToTopManager myPinToTopManager;
    private XDebuggerTreeRestorer myCurrentRestorer;
    @Nullable
    private TreeSpeedSearch myTreeSpeedSearch;

    public XDebuggerTree(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @NotNull String popupActionGroupId, @Nullable XValueMarkers<?, ?> valueMarkers) {
        if (project == null) {
            XDebuggerTree.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            XDebuggerTree.$$$reportNull$$$0(1);
        }
        if (popupActionGroupId == null) {
            XDebuggerTree.$$$reportNull$$$0(2);
        }
        super((TreeModel)new DefaultTreeModel(null));
        this.myMoveListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                XDebuggerTree.this.repaint();
            }
        };
        this.myAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                DebuggerUIUtil.repaintCurrentEditor(XDebuggerTree.this.myProject);
            }
        }, 100, (Disposable)this);
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myValueMarkers = valueMarkers;
        this.myProject = project;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.myTreeModel = (DefaultTreeModel)this.getModel();
        this.myPinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(project);
        this.setCellRenderer((TreeCellRenderer)((Object)new XDebuggerTreeRenderer(this.myProject)));
        new TreeLinkMouseListener(new XDebuggerTreeRenderer(this.myProject)){

            protected boolean doCacheLastNode() {
                return false;
            }

            protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (tag instanceof XDebuggerTreeNodeHyperlink) {
                    ((XDebuggerTreeNodeHyperlink)tag).onClick(event);
                }
            }

            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                if (!XDebuggerTree.this.myPinToTopManager.isEnabled()) {
                    return;
                }
                TreePath pathForLocation = XDebuggerTree.this.getPathForLocation(e.getX(), e.getY());
                if (pathForLocation == null) {
                    XDebuggerTree.this.myPinToTopManager.onNodeHovered(null, XDebuggerTree.this);
                    return;
                }
                Object lastPathComponent = pathForLocation.getLastPathComponent();
                XDebuggerTree.this.myPinToTopManager.onNodeHovered(lastPathComponent instanceof XDebuggerTreeNode ? (XDebuggerTreeNode)lastPathComponent : null, XDebuggerTree.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$4", "handleTagClick"));
            }
        }.installOn((Component)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                return XDebuggerTree.this.expandIfEllipsis(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$5", "onDoubleClick"));
            }
        }.installOn((Component)((Object)this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    XDebuggerTree.this.expandIfEllipsis(XDebuggerTree.this.dummyMouseClickEvent());
                }
            }
        });
        this.installSpeedSearch();
        PopupHandler.installPopupMenu((JComponent)((Object)this), (String)popupActionGroupId, (String)"XDebuggerTreePopup");
        this.registerShortcuts();
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreePath[] paths;
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if ((paths = XDebuggerTree.this.getSelectionPaths()) != null) {
                    for (TreePath path : paths) {
                        XDebuggerTreeNodeHyperlink link;
                        Object component = path.getLastPathComponent();
                        if (!(component instanceof XDebuggerTreeNode) || (link = ((XDebuggerTreeNode)component).getLink()) == null) continue;
                        link.onClick(XDebuggerTree.this.dummyMouseClickEvent());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$7", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this), (Disposable)this);
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        this.addComponentListener(this.myMoveListener);
        this.myTreeExpansionListener = new TreeExpansionListener(this){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                8.handleExpansion(event, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                8.handleExpansion(event, false);
            }

            private static void handleExpansion(TreeExpansionEvent event, boolean expanded) {
                Object component;
                TreePath path = event.getPath();
                Object object = component = path != null ? path.getLastPathComponent() : null;
                if (component instanceof XValueGroupNodeImpl) {
                    ((XValueGroupNodeImpl)component).onExpansion(expanded);
                }
            }
        };
        this.addTreeExpansionListener(this.myTreeExpansionListener);
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                if (node == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (!(node instanceof XValueNodeImpl) || ((XValueNodeImpl)node).isObsolete()) {
                    return;
                }
                XDebuggerNodeLinkActionProvider.computeHyperlink(XDebuggerTree.this.myProject, (XValueNodeImpl)node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$9";
                objectArray[2] = "nodeLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @ApiStatus.Internal
    public void findElementAndRequestFocus(String searchQuery) {
        if (this.myTreeSpeedSearch == null) {
            return;
        }
        this.myTreeSpeedSearch.findAndSelectElement(searchQuery);
    }

    protected void installSpeedSearch() {
        this.myTreeSpeedSearch = Registry.is((String)"debugger.variablesView.rss") ? XDebuggerTreeSpeedSearch.installOn(this, SPEED_SEARCH_CONVERTER) : TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)false, SPEED_SEARCH_CONVERTER);
    }

    @NotNull
    private MouseEvent dummyMouseClickEvent() {
        return new MouseEvent((Component)((Object)this), 0, 0L, 0, 0, 0, 1, false);
    }

    public void updateEditor() {
        this.myAlarm.cancelAndRequest();
    }

    public boolean isUnderRemoteDebug() {
        DataContext context = DataManager.getInstance().getDataContext((Component)((Object)this));
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(context);
        return env != null && env.getRunProfile() instanceof RemoteRunProfile;
    }

    private boolean expandIfEllipsis(@NotNull MouseEvent e) {
        XDebuggerTreeNodeHyperlink link;
        MessageTreeNode node;
        MessageTreeNode[] treeNodes;
        if (e == null) {
            XDebuggerTree.$$$reportNull$$$0(3);
        }
        if ((treeNodes = (MessageTreeNode[])this.getSelectedNodes(MessageTreeNode.class, null)).length == 1 && (node = treeNodes[0]).isEllipsis() && (link = node.getLink()) != null) {
            link.onClick(e);
            return true;
        }
        return false;
    }

    public void addTreeListener(@NotNull XDebuggerTreeListener listener) {
        if (listener == null) {
            XDebuggerTree.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener);
    }

    public void addTreeListener(@NotNull XDebuggerTreeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            XDebuggerTree.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            XDebuggerTree.$$$reportNull$$$0(6);
        }
        this.addTreeListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> this.removeTreeListener(listener));
    }

    public void removeTreeListener(@NotNull XDebuggerTreeListener listener) {
        if (listener == null) {
            XDebuggerTree.$$$reportNull$$$0(7);
        }
        this.myListeners.remove(listener);
    }

    public void setRoot(XDebuggerTreeNode root, boolean rootVisible) {
        this.setRootVisible(rootVisible);
        this.myTreeModel.setRoot(root);
    }

    public XDebuggerTreeNode getRoot() {
        return (XDebuggerTreeNode)this.myTreeModel.getRoot();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        this.mySourcePosition = sourcePosition;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        XDebuggerEditorsProvider xDebuggerEditorsProvider = this.myEditorsProvider;
        if (xDebuggerEditorsProvider == null) {
            XDebuggerTree.$$$reportNull$$$0(8);
        }
        return xDebuggerEditorsProvider;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            XDebuggerTree.$$$reportNull$$$0(9);
        }
        return project;
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        return this.myValueMarkers;
    }

    @ApiStatus.Internal
    @NotNull
    public XDebuggerPinToTopManager getPinToTopManager() {
        XDebuggerPinToTopManager xDebuggerPinToTopManager = this.myPinToTopManager;
        if (xDebuggerPinToTopManager == null) {
            XDebuggerTree.$$$reportNull$$$0(10);
        }
        return xDebuggerPinToTopManager;
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            XDebuggerTree.$$$reportNull$$$0(11);
        }
        XValueNodeImpl[] selection = (XValueNodeImpl[])this.getSelectedNodes(XValueNodeImpl.class, null);
        sink.set(XDEBUGGER_TREE_KEY, (Object)this);
        XDebuggerTree.setSelectedNodes(sink, selection);
        if (selection.length == 1 && selection[0].getFullValueEvaluator() == null) {
            sink.set(PlatformDataKeys.PREDEFINED_TEXT, (Object)DebuggerUIUtil.getNodeRawValue(selection[0]));
        }
    }

    private static void setSelectedNodes(@NotNull DataSink sink, XValueNodeImpl[] selection) {
        if (sink == null) {
            XDebuggerTree.$$$reportNull$$$0(12);
        }
        XDebugManagerProxy xDebugManagerProxy = XDebugManagerProxy.getInstance();
        List<XDebuggerTreeSelectedValueId> xValueIdsList = Arrays.stream(selection).map(node -> {
            XValueId xValueId = xDebugManagerProxy.getXValueId((XValue)node.getValueContainer());
            return xValueId != null ? new XDebuggerTreeSelectedValueId(xValueId, node.getName()) : null;
        }).filter(Objects::nonNull).toList();
        sink.set(SplitDebuggerUIUtil.SPLIT_SELECTED_VALUES_KEY, xValueIdsList);
        sink.set(SELECTED_NODES, List.of(selection));
    }

    public void rebuild() {
        this.rebuildAndRestore(XDebuggerTreeState.saveState(this));
    }

    @ApiStatus.Internal
    public void rebuildAndRestore(XDebuggerTreeState treeState) {
        Object rootNode = this.myTreeModel.getRoot();
        if (rootNode instanceof XDebuggerTreeNode) {
            ((XDebuggerTreeNode)rootNode).clearChildren();
            if (this.isRootVisible() && rootNode instanceof XValueNodeImpl) {
                ((XValue)((XValueNodeImpl)rootNode).getValueContainer()).computePresentation((XValueNode)rootNode, XValuePlace.TREE);
            }
            treeState.restoreState(this);
            this.repaint();
        }
    }

    public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children, boolean last) {
        if (node == null) {
            XDebuggerTree.$$$reportNull$$$0(13);
        }
        if (children == null) {
            XDebuggerTree.$$$reportNull$$$0(14);
        }
        for (XDebuggerTreeListener listener : this.myListeners) {
            listener.childrenLoaded(node, children, last);
        }
    }

    public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
        if (node == null) {
            XDebuggerTree.$$$reportNull$$$0(15);
        }
        if (name == null) {
            XDebuggerTree.$$$reportNull$$$0(16);
        }
        for (XDebuggerTreeListener listener : this.myListeners) {
            listener.nodeLoaded(node, name);
        }
    }

    public void markNodesObsolete() {
        Object root = this.myTreeModel.getRoot();
        if (root instanceof XValueContainerNode) {
            StreamEx.ofTree((Object)((XValueContainerNode)root), n -> StreamEx.of(n.getLoadedChildren())).forEach(XValueContainerNode::setObsolete);
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.setModel(null);
            this.myTreeModel.setRoot(null);
            this.setCellRenderer(null);
            UIUtil.dispose((Component)((Object)this));
            this.setLeadSelectionPath(null);
            this.setAnchorSelectionPath(null);
            this.accessibleContext = null;
            this.removeComponentListener(this.myMoveListener);
            this.removeTreeExpansionListener(this.myTreeExpansionListener);
            this.myListeners.clear();
            this.disposeRestorer();
        });
    }

    void setCurrentRestorer(@NotNull XDebuggerTreeRestorer restorer) {
        if (restorer == null) {
            XDebuggerTree.$$$reportNull$$$0(17);
        }
        this.disposeRestorer();
        this.myCurrentRestorer = restorer;
    }

    @ApiStatus.Internal
    public void disposeRestorer() {
        if (this.myCurrentRestorer != null) {
            this.myCurrentRestorer.dispose();
            this.myCurrentRestorer = null;
        }
    }

    private void registerShortcuts() {
        DebuggerUIUtil.registerActionOnComponent("XDebugger.SetValue", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.CopyValue", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.JumpToSource", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("XDebugger.JumpToTypeSource", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("Debugger.MarkObject", (JComponent)((Object)this), this);
        DebuggerUIUtil.registerActionOnComponent("EvaluateExpression", (JComponent)((Object)this), this);
    }

    @Nullable
    public static XDebuggerTree getTree(AnActionEvent e) {
        return (XDebuggerTree)((Object)e.getData(XDEBUGGER_TREE_KEY));
    }

    @Nullable
    public static XDebuggerTree getTree(@NotNull DataContext context) {
        if (context == null) {
            XDebuggerTree.$$$reportNull$$$0(18);
        }
        return (XDebuggerTree)((Object)XDEBUGGER_TREE_KEY.getData(context));
    }

    @NotNull
    public static List<XValueNodeImpl> getSelectedNodes(@NotNull DataContext context) {
        if (context == null) {
            XDebuggerTree.$$$reportNull$$$0(19);
        }
        if (SplitDebuggerMode.showSplitWarnings() && AppMode.isRemoteDevHost()) {
            LOG.error("[Split debugger] XDebuggerTree.getSelectedNodes should not be called on the backend as it returns frontend node instances (XValueNodeImpl) which are only available on the frontend.\nThe action will not work correctly in Split mode. Please use XDebuggerTreeBackendOnlyActionBase to make your action backend-only and operates with XValue instances instead.");
        }
        List list = ContainerUtil.notNullize((List)((List)SELECTED_NODES.getData(context)));
        if (list == null) {
            XDebuggerTree.$$$reportNull$$$0(20);
        }
        return list;
    }

    public void invokeLater(Runnable runnable) {
        EdtExecutorService.getInstance().execute(runnable);
    }

    public void selectNodeOnLoad(final Condition<? super TreeNode> nodeFilter, final Condition<? super TreeNode> obsoleteChecker) {
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                if (node == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (obsoleteChecker.value((Object)node)) {
                    XDebuggerTree.this.removeTreeListener(this);
                }
                if (nodeFilter.value((Object)node)) {
                    XDebuggerTree.this.setSelectionPath(node.getPath());
                    XDebuggerTree.this.removeTreeListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$10";
                objectArray[2] = "nodeLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void expandNodesOnLoad(final Condition<? super TreeNode> nodeFilter) {
        this.addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                if (node == null) {
                    11.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    11.$$$reportNull$$$0(1);
                }
                if (nodeFilter.value((Object)node) && !node.isLeaf()) {
                    node.getChildCount();
                }
            }

            @Override
            public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children, boolean last) {
                if (node == null) {
                    11.$$$reportNull$$$0(2);
                }
                if (children == null) {
                    11.$$$reportNull$$$0(3);
                }
                if (nodeFilter.value((Object)node)) {
                    XDebuggerTree.this.expandPath(node.getPath());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "children";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "nodeLoaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean isDetached() {
        return DataManager.getInstance().getDataContext((Component)((Object)this)).getData(XDebugSessionTab.TAB_KEY) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActionGroupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restorer";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPinToTopManager";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandIfEllipsis";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTreeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeTreeListener";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedNodes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "childrenLoaded";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "nodeLoaded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentRestorer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTree";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 20 -> new IllegalStateException(string);
        };
    }
}

