/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/JsonEncodingUtil;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "tryParseJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "value", "", "prettifyJson", "element", "intellij.platform.debugger.impl"})
public final class JsonEncodingUtil {
    @NotNull
    public static final JsonEncodingUtil INSTANCE = new JsonEncodingUtil();

    private JsonEncodingUtil() {
    }

    private final ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Nullable
    public final JsonNode tryParseJson(@NotNull String value) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            jsonNode = this.objectMapper().readTree(value);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonNode = null;
        }
        return jsonNode;
    }

    @NotNull
    public final String prettifyJson(@NotNull JsonNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }
}

