/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.impl.NotificationGroupEP;
import com.intellij.notification.impl.NotificationGroupManagerImplKt;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/notification/impl/NotificationGroupManagerImpl;", "Lcom/intellij/notification/NotificationGroupManager;", "<init>", "()V", "registeredGroups", "", "", "Lcom/intellij/notification/NotificationGroup;", "registeredNotificationIds", "", "getNotificationIds", "getNotificationGroup", "groupId", "isGroupRegistered", "", "getRegisteredNotificationGroups", "", "isRegisteredNotificationId", "notificationId", "intellij.platform.ide.core.impl"})
public final class NotificationGroupManagerImpl
implements NotificationGroupManager {
    @NotNull
    private final Map<String, NotificationGroup> registeredGroups = NotificationGroupManagerImplKt.access$computeGroups();
    @Nullable
    private volatile Set<String> registeredNotificationIds;

    public NotificationGroupManagerImpl() {
        NotificationGroupEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<NotificationGroupEP>(){

            public void extensionAdded(NotificationGroupEP extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                NotificationGroupManagerImplKt.access$registerNotificationGroup(extension, pluginDescriptor, registeredGroups);
                if (extension.notificationIds != null) {
                    registeredNotificationIds = null;
                }
            }

            public void extensionRemoved(NotificationGroupEP extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                Object v = registeredGroups.get(extension.id);
                Intrinsics.checkNotNull(v);
                NotificationGroup group = (NotificationGroup)v;
                if (Intrinsics.areEqual((Object)group.getPluginId(), (Object)pluginDescriptor.getPluginId())) {
                    registeredGroups.remove(extension.id);
                }
                if (extension.notificationIds != null) {
                    registeredNotificationIds = null;
                }
            }
        }, null);
    }

    private final Set<String> getNotificationIds() {
        Set<String> existing = this.registeredNotificationIds;
        if (existing != null) {
            return existing;
        }
        HashSet result = new HashSet();
        NotificationGroupEP.EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> NotificationGroupManagerImpl.getNotificationIds$lambda$0(result, arg_0, arg_1));
        this.registeredNotificationIds = result;
        return result;
    }

    @Nullable
    public NotificationGroup getNotificationGroup(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.registeredGroups.get(groupId);
    }

    public boolean isGroupRegistered(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.registeredGroups.containsKey(groupId);
    }

    @NotNull
    public Collection<NotificationGroup> getRegisteredNotificationGroups() {
        return this.registeredGroups.values();
    }

    public boolean isRegisteredNotificationId(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        return this.getNotificationIds().contains(notificationId);
    }

    private static final Unit getNotificationIds$lambda$0(HashSet $result, NotificationGroupEP extension, PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (extension.notificationIds != null && PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)pluginDescriptor)) {
            List<String> list = extension.notificationIds;
            Intrinsics.checkNotNull(list);
            $result.addAll((Collection)list);
        }
        return Unit.INSTANCE;
    }
}

