/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationGroupEP;
import com.intellij.notification.impl.NotificationGroupManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\u001a,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "computeGroups", "", "", "Lcom/intellij/notification/NotificationGroup;", "registerNotificationGroup", "", "extension", "Lcom/intellij/notification/impl/NotificationGroupEP;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "registeredGroups", "intellij.platform.ide.core.impl"})
@SourceDebugExtension(value={"SMAP\nNotificationGroupManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationGroupManagerImpl.kt\ncom/intellij/notification/impl/NotificationGroupManagerImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n13#2:100\n*S KotlinDebug\n*F\n+ 1 NotificationGroupManagerImpl.kt\ncom/intellij/notification/impl/NotificationGroupManagerImplKt\n*L\n12#1:100\n*E\n"})
public final class NotificationGroupManagerImplKt {
    @NotNull
    private static final Logger LOG;

    private static final Map<String, NotificationGroup> computeGroups() {
        HashMap result = new HashMap(NotificationGroupEP.EP_NAME.getPoint().size());
        NotificationGroupEP.EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> NotificationGroupManagerImplKt.computeGroups$lambda$0(result, arg_0, arg_1));
        return new ConcurrentHashMap(result);
    }

    private static final void registerNotificationGroup(NotificationGroupEP extension, PluginDescriptor pluginDescriptor, Map<String, NotificationGroup> registeredGroups) {
        try {
            String groupId = extension.id;
            NotificationDisplayType type = extension.getDisplayType();
            if (type == null) {
                LOG.warn("Cannot create notification group \"" + groupId + "`\": displayType should be not null");
                return;
            }
            Intrinsics.checkNotNull((Object)groupId);
            NotificationGroup notificationGroup = NotificationGroup.Companion.create(groupId, type, extension.isLogByDefault, extension.toolWindowId, extension.getDisplayName(pluginDescriptor), pluginDescriptor.getPluginId());
            notificationGroup.setHideFromSettings(extension.hideFromSettings);
            NotificationGroup notificationGroup2 = registeredGroups.put(groupId, notificationGroup);
            if (notificationGroup2 != null) {
                NotificationGroup old = notificationGroup2;
                boolean bl = false;
                LOG.warn("Notification group " + groupId + " is already registered (group=" + old + "). Plugin descriptor: " + pluginDescriptor);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot create notification group: " + extension, (Throwable)e);
        }
    }

    private static final Unit computeGroups$lambda$0(HashMap $result, NotificationGroupEP extension, PluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNull((Object)extension);
        NotificationGroupManagerImplKt.registerNotificationGroup(extension, descriptor, $result);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$computeGroups() {
        return NotificationGroupManagerImplKt.computeGroups();
    }

    public static final /* synthetic */ void access$registerNotificationGroup(NotificationGroupEP extension, PluginDescriptor pluginDescriptor, Map registeredGroups) {
        NotificationGroupManagerImplKt.registerNotificationGroup(extension, pluginDescriptor, registeredGroups);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NotificationGroupManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

