/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtilService;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.progress.util.UtilKt;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProgressIndicatorUtils {
    private static final Logger LOG = Logger.getInstance(ProgressIndicatorUtils.class);
    private static final int MAX_REJECTED_EXECUTIONS_BEFORE_CANCELLATION = 16;

    @Deprecated
    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable parentDisposable) {
        if (progress == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!progress.isCanceled()) {
                    progress.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$1", "beforeWriteActionStart"));
            }
        }, parentDisposable);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(2);
        }
        return progressIndicator;
    }

    @Deprecated
    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(3);
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((ProgressIndicator)new ProgressIndicatorBase(false, false), task);
    }

    @Deprecated
    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(4);
        }
        if (readTask == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(5);
        }
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator, AppExecutorUtil.getAppExecutorService(), readTask);
    }

    @Deprecated
    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator progressIndicator) {
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(6);
        }
        AtomicBoolean readActionAcquired = new AtomicBoolean();
        boolean executed = ProgressIndicatorUtils.runWithWriteActionPriority(() -> readActionAcquired.set(ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), (ProgressIndicator)(progressIndicator == null ? new ProgressIndicatorBase(false, false) : progressIndicator));
        return readActionAcquired.get() && executed;
    }

    @Deprecated
    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action) {
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(7);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, null);
    }

    @Deprecated
    public static boolean runWithWriteActionPriority(@NotNull Runnable action, @NotNull ProgressIndicator progressIndicator) {
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(8);
        }
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(9);
        }
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        application.assertIsNonDispatchThread();
        Runnable cancellation = ProgressIndicatorUtils.indicatorCancellation(progressIndicator);
        if (ProgressIndicatorUtils.isWriteActionRunningOrPending(application)) {
            cancellation.run();
            return false;
        }
        return (Boolean)ProgressManager.getInstance().runProcess(() -> {
            try {
                return ProgressIndicatorUtils.runActionAndCancelBeforeWrite(application, cancellation, action);
            }
            catch (ProcessCanceledException ignore) {
                return false;
            }
        }, progressIndicator);
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public static boolean runActionAndCancelBeforeWrite(@NotNull ApplicationEx application, @NotNull Runnable cancellation, @NotNull Runnable action) {
        if (application == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(10);
        }
        if (cancellation == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(11);
        }
        if (action == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(12);
        }
        return ProgressIndicatorUtilService.getInstance((Application)application).runActionAndCancelBeforeWrite(cancellation, action);
    }

    @NotNull
    private static Runnable indicatorCancellation(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(13);
        }
        Runnable runnable = () -> {
            if (!progressIndicator.isCanceled()) {
                progressIndicator.cancel();
            }
        };
        if (runnable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(14);
        }
        return runnable;
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public static boolean isWriteActionRunningOrPending(@NotNull ApplicationEx application) {
        if (application == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(15);
        }
        return application.isWriteActionPending() || application.isWriteActionInProgress();
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Obsolete
    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(16);
        }
        if (executor == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(17);
        }
        if (readTask == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(18);
        }
        final CompletableFuture future = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (application.isDisposed() || progressIndicator.isCanceled() || future.isCancelled()) {
                future.complete(null);
                return;
            }
            final Disposable listenerDisposable = Disposer.newDisposable();
            ApplicationListener listener = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!progressIndicator.isCanceled()) {
                        progressIndicator.cancel();
                        readTask.onCanceled(progressIndicator);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$2", "beforeWriteActionStart"));
                }
            };
            application.addApplicationListener(listener, listenerDisposable);
            future.whenComplete((__, ___) -> Disposer.dispose((Disposable)listenerDisposable));
            try {
                executor.execute(ClientId.decorateRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator, readTask);
                        }
                        catch (Throwable e) {
                            future.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future.complete(null);
                        } else if (!future.isCancelled()) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (future.isCancelled()) {
                                        return;
                                    }
                                    Disposer.dispose((Disposable)listenerDisposable);
                                    try {
                                        if (!progressIndicator.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + String.valueOf(readTask);
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                }));
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                throw e;
            }
        }, ModalityState.any());
        CompletableFuture completableFuture = future;
        if (completableFuture == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(19);
        }
        return completableFuture;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator, @NotNull ReadTask task) {
        if (progressIndicator == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(20);
        }
        if (task == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(21);
        }
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            try {
                return task.runBackgroundProcess(progressIndicator);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator);
    }

    @Deprecated
    public static void yieldToPendingWriteActions(@Nullable ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            throw new IllegalStateException("Mustn't be called from within read action");
        }
        application.assertIsNonDispatchThread();
        Semaphore semaphore = new Semaphore(1);
        application.invokeLater(() -> ((Semaphore)semaphore).up(), ModalityState.any());
        UtilKt.waitWithParallelismCompensation(() -> ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, indicator));
    }

    @Deprecated
    public static void yieldToPendingWriteActions() {
        ProgressIndicatorUtils.yieldToPendingWriteActions(ProgressIndicatorProvider.getGlobalProgressIndicator());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T withTimeout(long timeoutMs, @NotNull Computable<T> computable) {
        if (computable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        ProgressIndicator outer = ProgressIndicatorProvider.getGlobalProgressIndicator();
        SensitiveProgressWrapper inner = outer != null ? new SensitiveProgressWrapper(outer) : new ProgressIndicatorBase(false, false);
        AtomicBoolean canceledByTimeout = new AtomicBoolean();
        ScheduledFuture<?> cancelProgress = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ProgressIndicatorUtils.lambda$withTimeout$7(canceledByTimeout, (ProgressIndicator)inner), timeoutMs, TimeUnit.MILLISECONDS);
        try {
            void computation;
            Object object = ProgressManager.getInstance().runProcess((Computable)computation, (ProgressIndicator)inner);
            return (T)object;
        }
        catch (ProcessCanceledException e) {
            if (canceledByTimeout.get()) {
                T t = null;
                return t;
            }
            throw e;
        }
        finally {
            cancelProgress.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithLockAndCheckingCanceled(@NotNull Lock lock, int timeout, @NotNull TimeUnit timeUnit, @NotNull ThrowableComputable<T, E> computable) throws E, ProcessCanceledException {
        if (lock == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(23);
        }
        if (timeUnit == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(24);
        }
        if (computable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(25);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> lock.tryLock(timeout, timeUnit)));
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    public static void awaitWithCheckCanceled(long millis) {
        long start = System.nanoTime();
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> {
            if (TimeoutUtil.getDurationMillis((long)start) > millis) {
                return true;
            }
            TimeoutUtil.sleep((long)10L);
            return false;
        }));
    }

    public static void awaitWithCheckCanceled(@NotNull Condition condition) {
        if (condition == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(26);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> condition.await(10L, TimeUnit.MILLISECONDS)));
    }

    public static void awaitWithCheckCanceled(@NotNull CountDownLatch waiter) {
        if (waiter == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(27);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> waiter.await(10L, TimeUnit.MILLISECONDS)));
    }

    public static <T> T awaitWithCheckCanceled(@NotNull Future<T> future) {
        if (future == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(28);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return ProgressIndicatorUtils.awaitWithCheckCanceled(future, indicator);
    }

    public static <T> T awaitWithCheckCanceled(@NotNull Future<T> future, @Nullable ProgressIndicator indicator) {
        if (future == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(29);
        }
        int rejectedExecutions = 0;
        while (true) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (RejectedExecutionException ree) {
                if (++rejectedExecutions <= 16) continue;
                throw new ProcessCanceledException((Throwable)ree);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)cause;
                }
                if (cause instanceof CancellationException) {
                    throw new ProcessCanceledException(cause);
                }
                ExceptionUtil.rethrow((Throwable)e);
                continue;
            }
            break;
        }
    }

    public static void awaitWithCheckCanceled(@NotNull Lock lock) {
        if (lock == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(30);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> lock.tryLock(10L, TimeUnit.MILLISECONDS)));
    }

    public static void awaitWithCheckCanceled(@NotNull ThrowableComputable<Boolean, ? extends Exception> waiter) {
        if (waiter == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(31);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        boolean success = false;
        while (!success) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                success = (Boolean)waiter.compute();
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException)) {
                    LOG.warn((Throwable)e);
                }
                throw new ProcessCanceledException((Throwable)e);
            }
        }
    }

    public static void checkCancelledEvenWithPCEDisabled(@Nullable ProgressIndicator indicator) {
        boolean isNonCancelable = Cancellation.isInNonCancelableSection();
        if (isNonCancelable || indicator == null) {
            ((CoreProgressManager)ProgressManager.getInstance()).runCheckCanceledHooks(indicator);
        }
        if (isNonCancelable) {
            return;
        }
        Cancellation.ensureActive();
        if (indicator == null) {
            return;
        }
        indicator.checkCanceled();
        if (indicator.isCanceled()) {
            indicator.checkCanceled();
            throw new ProcessCanceledException();
        }
    }

    public static void awaitWithCheckCanceled(@NotNull Semaphore semaphore, @Nullable ProgressIndicator indicator) {
        if (semaphore == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(32);
        }
        while (!semaphore.waitFor(10L)) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
        }
    }

    private static /* synthetic */ void lambda$withTimeout$7(AtomicBoolean canceledByTimeout, ProgressIndicator inner) {
        canceledByTimeout.set(true);
        inner.cancel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 14, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/ProgressIndicatorUtils";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readTask";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waiter";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semaphore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/ProgressIndicatorUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forceWriteActionPriority";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "indicatorCancellation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleWithWriteActionPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forceWriteActionPriority";
                break;
            }
            case 2: 
            case 14: 
            case 19: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWithWriteActionPriority";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runWithWriteActionPriority";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runActionAndCancelBeforeWrite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCancellation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isWriteActionRunningOrPending";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgress";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeWithLockAndCheckingCanceled";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "awaitWithCheckCanceled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 14, 19 -> new IllegalStateException(string);
        };
    }
}

