/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.ui.icons.CoreIconManager;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0003"}, d2={"findIconDescription", "", "path", "intellij.platform.ide.core.impl"})
@SourceDebugExtension(value={"SMAP\nCoreIconManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreIconManager.kt\ncom/intellij/ui/icons/CoreIconManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,332:1\n13#2:333\n*S KotlinDebug\n*F\n+ 1 CoreIconManager.kt\ncom/intellij/ui/icons/CoreIconManagerKt\n*L\n329#1:333\n*E\n"})
public final class CoreIconManagerKt {
    private static final String findIconDescription(String path) {
        String string;
        String pathWithoutExt = StringsKt.removeSuffix((String)path, (CharSequence)".svg");
        if (StringsKt.startsWith$default((CharSequence)pathWithoutExt, (char)'/', (boolean)false, (int)2, null)) {
            String string2 = pathWithoutExt.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = pathWithoutExt;
        }
        String key = "icon." + StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null) + ".tooltip";
        Ref.ObjectRef result = new Ref.ObjectRef();
        IconDescriptionBundleEP.EP_NAME.processWithPluginDescriptor((arg_0, arg_1) -> CoreIconManagerKt.findIconDescription$lambda$0(key, result, arg_0, arg_1));
        if (result.element == null && Registry.Companion.is("ide.icon.tooltips.trace.missing", false)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(CoreIconManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Icon tooltip requested but not found for " + path);
        }
        return (String)result.element;
    }

    private static final Unit findIconDescription$lambda$0(String $key, Ref.ObjectRef $result, IconDescriptionBundleEP ep, PluginDescriptor descriptor) {
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ClassLoader classLoader2 = descriptor.getPluginClassLoader();
        if (classLoader2 == null) {
            classLoader2 = CoreIconManager.class.getClassLoader();
        }
        ClassLoader classLoader3 = classLoader = classLoader2;
        Intrinsics.checkNotNull((Object)classLoader3);
        ResourceBundle resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)classLoader3, (String)ep.resourceBundle);
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getResourceBundle(...)");
        ResourceBundle bundle = resourceBundle;
        String description = AbstractBundle.Companion.messageOrNull(bundle, $key, new Object[0]);
        if (description != null) {
            $result.element = description;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$findIconDescription(String path) {
        return CoreIconManagerKt.findIconDescription(path);
    }
}

