/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.platform.backend.observation.PlatformActivityTrackerServiceKt;
import com.intellij.util.TrackedUpdate;
import com.intellij.util.ui.update.MergingUpdateQueueTracker;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/MergingUpdateQueueTrackerImpl;", "Lcom/intellij/util/ui/update/MergingUpdateQueueTracker;", "<init>", "()V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "hasTrackedUpdates", "", "trackUpdate", "Lcom/intellij/util/ui/update/Update;", "update", "registerEnter", "", "Lcom/intellij/util/TrackedUpdate;", "registerExit", "intellij.platform.ide.core.impl"})
final class MergingUpdateQueueTrackerImpl
implements MergingUpdateQueueTracker {
    @NotNull
    private final AtomicInteger counter = new AtomicInteger(0);

    public final boolean hasTrackedUpdates() {
        return this.counter.get() > 0;
    }

    @NotNull
    public Update trackUpdate(@NotNull Update update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        return new TrackedUpdate(update);
    }

    public final void registerEnter(@NotNull TrackedUpdate update) {
        Intrinsics.checkNotNullParameter((Object)((Object)update), (String)"update");
        this.counter.incrementAndGet();
        PlatformActivityTrackerServiceKt.traceObservedComputation(update.getId());
    }

    public final void registerExit(@NotNull TrackedUpdate update) {
        Intrinsics.checkNotNullParameter((Object)((Object)update), (String)"update");
        PlatformActivityTrackerServiceKt.removeObservedComputation(update.getId());
        this.counter.decrementAndGet();
    }
}

