/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SubTaskProgressIndicator
extends SensitiveProgressWrapper {
    private final ConcurrentTasksProgressManager myProgressManager;
    private final AtomicLong myFraction;
    private final int myTaskWeight;

    SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager, int taskWeight) {
        super(progressManager.getParent());
        this.myProgressManager = progressManager;
        this.myTaskWeight = taskWeight;
        this.myFraction = new AtomicLong();
    }

    public void setIndeterminate(boolean indeterminate) {
    }

    public void setText(String text) {
        this.myProgressManager.setText2(this, text);
    }

    public void setFraction(double newValue) {
        double oldValue = Double.longBitsToDouble(this.myFraction.getAndSet(Double.doubleToRawLongBits(newValue)));
        this.myProgressManager.updateTaskFraction(newValue - oldValue, this.myTaskWeight);
    }

    public void setText2(String text) {
    }

    public double getFraction() {
        return Double.longBitsToDouble(this.myFraction.get());
    }

    public void finished() {
        this.setFraction(1.0);
        this.myProgressManager.setText2(this, null);
    }
}

