/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlighterRecycler;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextHighlightingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class BackgroundUpdateHighlightersUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundUpdateHighlightersUtil.class);

    @RequiresBackgroundThread
    @RequiresReadLock
    public static void setHighlightersToEditor(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull Document document, int startOffset, int endOffset, @NotNull @NotNull Collection<? extends @NotNull HighlightInfo> highlights, int group) {
        if (project == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(1);
        }
        if (document == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(2);
        }
        if (highlights == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        HighlightingSession session = HighlightingSessionImpl.getFromCurrentIndicator(psiFile);
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        TextRange range = new TextRange(startOffset, endOffset);
        BackgroundUpdateHighlightersUtil.setHighlightersInRange(range, new ArrayList<HighlightInfo>(highlights), markup, group, session);
    }

    static void setHighlightersOutsideRange(@NotNull @NotNull List<? extends @NotNull HighlightInfo> infos, @NotNull TextRange restrictedRange, @NotNull TextRange priorityRange, int group, @NotNull HighlightingSession session) {
        if (infos == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(4);
        }
        if (restrictedRange == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(5);
        }
        if (priorityRange == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(6);
        }
        if (session == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = session.getPsiFile();
        Project project = session.getProject();
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.HighlightInfoPostFilters.applyPostAndAdditionalFilter(project, infos, info -> !info.isFromAnnotator() && !info.isFromInspection());
        Document document = session.getDocument();
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        ContainerUtil.quickSort(filteredInfos, UpdateHighlightersUtil.BY_ACTUAL_START_OFFSET_NO_DUPS);
        HashSet<HighlightInfo> infoSet = new HashSet<HighlightInfo>(filteredInfos);
        boolean[] changed = new boolean[]{false};
        HighlighterRecycler.runWithRecycler(session, toReuse -> {
            Processor processor = info -> {
                RangeHighlighterEx highlighter = info.getHighlighter();
                if (highlighter != null && info.getGroup() == group && !info.isFromAnnotator() && !info.isFromInspection()) {
                    boolean toRemove;
                    int hiStart = highlighter.getStartOffset();
                    int hiEnd = highlighter.getEndOffset();
                    if (!info.isFromInjection() && hiEnd < document.getTextLength() && !restrictedRange.contains((Segment)highlighter) && hiEnd != 0) {
                        return true;
                    }
                    boolean bl = toRemove = infoSet.contains(info) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
                    if (toRemove) {
                        toReuse.recycleHighlighter((HighlightInfo)info);
                    }
                }
                return true;
            };
            Long2ObjectOpenHashMap range2markerCache = new Long2ObjectOpenHashMap(10);
            SweepProcessor.Generator generator = proc -> ContainerUtil.process((List)filteredInfos, (Processor)proc);
            ArrayList fileLevelHighlights = new ArrayList();
            ArrayList infosToCreateHighlightersFor = new ArrayList(filteredInfos.size());
            DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside((MarkupModelEx)markup, priorityRange.getStartOffset(), priorityRange.getEndOffset(), session.getCodeInsightContext(), (Processor<? super HighlightInfo>)processor);
            SweepProcessor.sweep(generator, (offset, info, atStart, overlappingIntervals) -> {
                if (!atStart) {
                    return true;
                }
                if (!info.isFromInjection() && info.getEndOffset() < document.getTextLength() && !restrictedRange.contains((Segment)info)) {
                    return true;
                }
                if (info.isFileLevelAnnotation()) {
                    fileLevelHighlights.add(info);
                    changed[0] = true;
                    return true;
                }
                if (UpdateHighlightersUtil.isWarningCoveredByError(info, severityRegistrar, overlappingIntervals)) {
                    return true;
                }
                if (!(info.getStartOffset() >= priorityRange.getStartOffset() && info.getEndOffset() <= priorityRange.getEndOffset() || info.isFromAnnotator())) {
                    infosToCreateHighlightersFor.add(info);
                    changed[0] = true;
                }
                return true;
            });
            for (HighlightInfo info2 : infosToCreateHighlightersFor) {
                BackgroundUpdateHighlightersUtil.createOrReuseHighlighterFor(info2, document, group, psiFile, (MarkupModelEx)markup, toReuse, (Long2ObjectMap<RangeMarker>)range2markerCache, severityRegistrar, session);
            }
            boolean shouldClean = restrictedRange.getStartOffset() == 0 && restrictedRange.getEndOffset() == document.getTextLength();
            ((HighlightingSessionImpl)session).updateFileLevelHighlights(fileLevelHighlights, group, shouldClean, (HighlighterRecycler)toReuse);
            changed[0] = changed[0] | !toReuse.isEmpty();
        });
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    @RequiresReadLock
    public static void setHighlightersInRange(@NotNull TextRange range, @NotNull @NotNull List<? extends @NotNull HighlightInfo> infos, @NotNull MarkupModelEx markup, int group, @NotNull HighlightingSession session) {
        if (range == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(8);
        }
        if (infos == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(9);
        }
        if (markup == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(10);
        }
        if (session == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = session.getProject();
        Document document = session.getDocument();
        PsiFile psiFile = session.getPsiFile();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        boolean[] changed = new boolean[]{false};
        Long2ObjectOpenHashMap range2markerCache = new Long2ObjectOpenHashMap(10);
        HighlighterRecycler.runWithRecycler(session, arg_0 -> BackgroundUpdateHighlightersUtil.lambda$setHighlightersInRange$8(markup, project, range, session, group, document, infos, changed, severityRegistrar, psiFile, (Long2ObjectMap)range2markerCache, arg_0));
    }

    static long getRangeToCreateHighlighter(@NotNull HighlightInfo info, @NotNull Document document) {
        if (info == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(12);
        }
        if (document == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(13);
        }
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return -1L;
            }
            ++infoEndOffset;
        }
        return TextRangeScalarUtil.toScalarRange((int)infoStartOffset, (int)infoEndOffset);
    }

    @Deprecated
    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @NotNull HighlighterRecycler recycler, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightingSession session) {
        TextAttributes actualAttributes;
        boolean attributesSet;
        RangeHighlighterEx highlighter;
        if (info == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(14);
        }
        if (document == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(15);
        }
        if (psiFile == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(16);
        }
        if (markup == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(17);
        }
        if (recycler == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(18);
        }
        if (range2markerCache == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(19);
        }
        if (severityRegistrar == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(20);
        }
        if (session == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(21);
        }
        assert (!info.isFileLevelAnnotation());
        long finalInfoRange = BackgroundUpdateHighlightersUtil.getRangeToCreateHighlighter(info, document);
        if (finalInfoRange == -1L) {
            return;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        int infoStartOffset = TextRangeScalarUtil.startOffset((long)finalInfoRange);
        int infoEndOffset = TextRangeScalarUtil.endOffset((long)finalInfoRange);
        CodeInsightContext context = session.getCodeInsightContext();
        EditorColorsScheme colorsScheme = session.getColorsScheme();
        TextAttributes infoAttributes = info.getTextAttributes((PsiElement)psiFile, colorsScheme);
        Consumer changeAttributes = finalHighlighter -> {
            BackgroundUpdateHighlightersUtil.changeAttributes(finalHighlighter, info, colorsScheme, psiFile, infoAttributes, context);
            info.updateQuickFixFields(document, range2markerCache, finalInfoRange);
        };
        RangeHighlighterEx salvagedHighlighter = (RangeHighlighterEx)recycler.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer, info.getDescription());
        if (info.isFileLevelAnnotation()) {
            HighlightInfo oldFileInfo;
            HighlightInfo highlightInfo = oldFileInfo = salvagedHighlighter == null ? null : HighlightInfo.fromRangeHighlighter((RangeHighlighter)salvagedHighlighter);
            if (oldFileInfo == null) {
                ((HighlightingSessionImpl)session).addFileLevelHighlight(info, salvagedHighlighter);
            } else {
                ((HighlightingSessionImpl)session).replaceFileLevelHighlight(oldFileInfo, info, salvagedHighlighter);
            }
        }
        if (salvagedHighlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(null, infoStartOffset, infoEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
        } else {
            highlighter = salvagedHighlighter;
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        range2markerCache.put(finalInfoRange, (Object)highlighter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("createOrReuseHighlighter " + String.valueOf(highlighter) + (salvagedHighlighter == null ? "" : " (recycled)"));
        }
        if (infoAttributes != null && !(attributesSet = Comparing.equal((Object)infoAttributes, (Object)(actualAttributes = highlighter.getTextAttributes(colorsScheme))))) {
            TextAttributes forcedTextAttributes = highlighter.getForcedTextAttributes();
            highlighter.setTextAttributes(infoAttributes);
            TextAttributes afterSet = highlighter.getTextAttributes(colorsScheme);
            LOG.error("Expected to set " + String.valueOf(infoAttributes) + " but actual attributes are: " + String.valueOf(actualAttributes) + "; forcedTextAttributes: '" + String.valueOf(forcedTextAttributes) + "'; colorsScheme: '" + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "'; highlighter:" + String.valueOf(highlighter) + " (" + String.valueOf(highlighter.getClass()) + "); was reused from the bin: " + (salvagedHighlighter != null) + "; markup: " + String.valueOf(markup) + " (" + String.valueOf(markup.getClass()) + "); attributes after the second .setAttributes(): " + String.valueOf(afterSet) + " (set " + (infoAttributes.equals((Object)afterSet) ? "successfully" : "not successfully") + ")");
        }
    }

    @ApiStatus.Internal
    public static void associateInfoAndHighlighter(@NotNull HighlightInfo info, @NotNull RangeHighlighterEx highlighter) {
        if (info == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(22);
        }
        if (highlighter == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(23);
        }
        if (info.getHighlighter() == null) {
            info.setHighlighter(highlighter);
        }
        assert (info.getHighlighter() == highlighter);
        highlighter.setErrorStripeTooltip((Object)info);
    }

    static void changeAttributes(@NotNull RangeHighlighterEx highlighter, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull PsiFile psiFile, @Nullable TextAttributes infoAttributes, @NotNull CodeInsightContext context) {
        Color attributesErrorStripeColor;
        if (highlighter == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(24);
        }
        if (info == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(25);
        }
        if (psiFile == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            BackgroundUpdateHighlightersUtil.$$$reportNull$$$0(27);
        }
        TextAttributesKey textAttributesKey = info.forcedTextAttributesKey == null ? info.type.getAttributesKey() : info.forcedTextAttributesKey;
        highlighter.setTextAttributesKey(textAttributesKey);
        if (infoAttributes == TextAttributes.ERASE_MARKER || infoAttributes != null && !infoAttributes.equals((Object)highlighter.getTextAttributes(colorsScheme))) {
            highlighter.setTextAttributes(infoAttributes);
        }
        CodeInsightContextHighlightingUtil.installCodeInsightContext((RangeHighlighter)highlighter, psiFile.getProject(), context);
        highlighter.setAfterEndOfLine(info.isAfterEndOfLine());
        Color infoErrorStripeColor = info.getErrorStripeMarkColor((PsiElement)psiFile, colorsScheme);
        Color color = attributesErrorStripeColor = infoAttributes != null ? infoAttributes.getErrorStripeColor() : null;
        if (infoErrorStripeColor != null && !infoErrorStripeColor.equals(attributesErrorStripeColor)) {
            highlighter.setErrorStripeMarkColor(infoErrorStripeColor);
        }
        BackgroundUpdateHighlightersUtil.associateInfoAndHighlighter(info, highlighter);
        GutterMark renderer = info.getGutterIconRenderer();
        highlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
        if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info.type)) {
            highlighter.setVisibleIfFolded(true);
        }
        if (info.type.equals(HighlightInfoType.WRONG_REF)) {
            highlighter.setGreedyToRight(true);
            highlighter.setGreedyToLeft(true);
        }
    }

    private static /* synthetic */ void lambda$setHighlightersInRange$8(MarkupModelEx markup, Project project, TextRange range, HighlightingSession session, int group, Document document, List infos, boolean[] changed, SeverityRegistrar severityRegistrar, PsiFile psiFile, Long2ObjectMap range2markerCache, HighlighterRecycler recycler) {
        DaemonCodeAnalyzerEx.processHighlights(markup, project, null, range.getStartOffset(), range.getEndOffset(), session.getCodeInsightContext(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.getGroup() == group) {
                RangeHighlighterEx highlighter;
                boolean willBeRemoved;
                int hiEnd = info.getEndOffset();
                boolean bl = willBeRemoved = range.contains((Segment)info) || hiEnd == document.getTextLength() && range.getEndOffset() == hiEnd;
                if (willBeRemoved && (highlighter = info.getHighlighter()) != null) {
                    recycler.recycleHighlighter((HighlightInfo)info);
                }
            }
            return true;
        }));
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.HighlightInfoPostFilters.applyPostFilter(project, infos);
        ContainerUtil.quickSort(filteredInfos, UpdateHighlightersUtil.BY_ACTUAL_START_OFFSET_NO_DUPS);
        SweepProcessor.Generator generator = processor -> ContainerUtil.process((List)filteredInfos, (Processor)processor);
        ArrayList fileLevelHighlights = new ArrayList();
        ArrayList infosToCreateHighlightersFor = new ArrayList(filteredInfos.size());
        SweepProcessor.sweep(generator, (__, info, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (info.isFileLevelAnnotation()) {
                fileLevelHighlights.add(info);
                changed[0] = true;
                return true;
            }
            if (range.contains((Segment)info) && !UpdateHighlightersUtil.isWarningCoveredByError(info, severityRegistrar, overlappingIntervals)) {
                infosToCreateHighlightersFor.add(info);
                changed[0] = true;
            }
            return true;
        });
        for (HighlightInfo info2 : infosToCreateHighlightersFor) {
            assert (!(info2.isFromInspection() || info2.isFromAnnotator() || info2.isFromHighlightVisitor() || info2.isInjectionRelated())) : info2;
            BackgroundUpdateHighlightersUtil.createOrReuseHighlighterFor(info2, document, group, psiFile, markup, recycler, (Long2ObjectMap<RangeMarker>)range2markerCache, severityRegistrar, session);
        }
        ((HighlightingSessionImpl)session).updateFileLevelHighlights(fileLevelHighlights, group, range.equalsToRange(0, document.getTextLength()), recycler);
        changed[0] = changed[0] | !recycler.isEmpty();
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictedRange";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 7: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 12: 
            case 14: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recycler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2markerCache";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/BackgroundUpdateHighlightersUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersToEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersOutsideRange";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersInRange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeToCreateHighlighter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrReuseHighlighterFor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "associateInfoAndHighlighter";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "changeAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

