/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.codeInsight.daemon.impl.AnnotatorRunner;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitorRunner;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InjectedLanguageFragmentSyntaxUtil;
import com.intellij.codeInsight.daemon.impl.ManagedHighlighterRecycler;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ResultSink;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class InjectedGeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(InjectedGeneralHighlightingPass.class);
    private final @Nullable List<? extends @NotNull TextRange> myReducedRanges;
    private final boolean myUpdateAll;
    private final ProperTextRange myPriorityRange;
    @NotNull
    private final EditorColorsScheme myGlobalScheme;
    private final List<HighlightInfo> myHighlights;
    private final boolean myRunAnnotators;
    private final boolean myRunVisitors;
    private final boolean myHighlightErrorElements;
    private final HighlightInfoUpdater myHighlightInfoUpdater;

    InjectedGeneralHighlightingPass(@NotNull PsiFile psiFile, @NotNull Document document, @Nullable List<? extends @NotNull TextRange> reducedRanges, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, boolean runAnnotators, boolean runVisitors, boolean highlightErrorElements, @NotNull HighlightInfoUpdater highlightInfoUpdater) {
        if (psiFile == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoUpdater == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        super(psiFile.getProject(), document, AnalysisBundle.message((String)"highlighting.pass.injected.presentable.name", (Object[])new Object[0]), psiFile, editor, TextRange.create((int)startOffset, (int)endOffset), true, HighlightInfoProcessor.getEmpty());
        this.myHighlights = new ArrayList<HighlightInfo>();
        this.myReducedRanges = reducedRanges;
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        this.myGlobalScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
        this.myRunAnnotators = runAnnotators;
        this.myRunVisitors = runVisitors;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myHighlightInfoUpdater = highlightInfoUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        if (!Registry.is((String)"editor.injected.highlighting.enabled")) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, (TextRange)this.myPriorityRange, GeneralHighlightingPass.SHOULD_HIGHLIGHT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List allInsideElements = ContainerUtil.concat((List)ContainerUtil.map(allDivided, d -> d.inside()));
        List allOutsideElements = ContainerUtil.concat((List)ContainerUtil.map(allDivided, d -> d.outside()));
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        TextAttributesKey fragmentKey = EditorColors.createInjectedLanguageFragmentKey((Language)this.myFile.getLanguage());
        @NotNull Set injected = ConcurrentCollectionFactory.createConcurrentSet();
        ManagedHighlighterRecycler.runWithRecycler(this.getHighlightingSession(), recycler -> this.processInjectedPsiFiles(allInsideElements, allOutsideElements, progress, injected, (injectedPsi, places) -> this.runAnnotatorsAndVisitorsOnInjectedPsi(injectedLanguageManager, injectedPsi, places, fragmentKey, (toolId, psiElement, infos) -> {
            this.myHighlightInfoUpdater.psiElementVisited(toolId, psiElement, infos, this.getDocument(), injectedPsi, this.myProject, this.getHighlightingSession(), (ManagedHighlighterRecycler)recycler);
            if (!infos.isEmpty()) {
                List<HighlightInfo> list = this.myHighlights;
                synchronized (list) {
                    this.myHighlights.addAll(infos);
                }
            }
        })));
        List<HighlightInfo> list = this.myHighlights;
        synchronized (list) {
            this.myHighlightInfoUpdater.removeInfosForInjectedFilesOtherThan(this.myFile, this.myRestrictRange, this.getHighlightingSession(), injected);
        }
    }

    private void processInjectedPsiFiles(@NotNull List<? extends PsiElement> elements1, @NotNull List<? extends PsiElement> elements2, @NotNull ProgressIndicator progress, @NotNull Set<? super FileViewProvider> visitedInjected, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (elements1 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        if (elements2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        if (visitedInjected == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        if (visitor == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InjectedLanguageManagerImpl injectedLanguageManager = InjectedLanguageManagerImpl.getInstanceImpl(this.myProject);
        List<DocumentWindow> cachedInjected = injectedLanguageManager.getCachedInjectedDocumentsInRange(this.myFile, this.myFile.getTextRange());
        HashSet<PsiLanguageInjectionHost> hosts = new HashSet<PsiLanguageInjectionHost>(elements1.size() + elements2.size() + cachedInjected.size());
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (DocumentWindow documentRange : cachedInjected) {
            PsiLanguageInjectionHost context;
            PsiFile psiFile;
            ProgressManager.checkCanceled();
            if (!documentRange.isValid() || (psiFile = psiDocumentManager.getPsiFile((Document)documentRange)) == null || (context = injectedLanguageManager.getInjectionHost((PsiElement)psiFile)) == null || !context.isValid() || psiFile.getProject().isDisposed() || !this.myUpdateAll && !this.myRestrictRange.contains(context.getTextRange()) || this.myReducedRanges != null && !ContainerUtil.exists(this.myReducedRanges, arg_0 -> InjectedGeneralHighlightingPass.lambda$processInjectedPsiFiles$5((PsiElement)context, arg_0))) continue;
            hosts.add(context);
        }
        CommonProcessors.CollectProcessor<PsiElement> collectInjectableProcessor = new CommonProcessors.CollectProcessor<PsiElement>(this, hosts){

            public boolean process(PsiElement t) {
                ProgressManager.checkCanceled();
                if (InjectedLanguageUtil.isInjectable(t, false)) {
                    super.process((Object)t);
                }
                return true;
            }
        };
        injectedLanguageManager.processInjectableElements(elements1, (Processor<? super PsiElement>)collectInjectableProcessor);
        injectedLanguageManager.processInjectableElements(elements2, (Processor<? super PsiElement>)collectInjectableProcessor);
        this.setProgressLimit(hosts.size());
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(hosts), progress, element -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            try {
                injectedLanguageManager.enumerateEx((PsiElement)element, this.myFile, false, (injectedPsi, places) -> {
                    if (visitedInjected.add(injectedPsi.getViewProvider())) {
                        visitor.visit(injectedPsi, places);
                    }
                });
            }
            catch (Exception e) {
                if (Logger.shouldRethrow((Throwable)e)) {
                    throw e;
                }
                LOG.error((Throwable)e);
            }
            this.advanceProgress(1L);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private HighlightInfoHolder createInfoHolder(@NotNull PsiFile injectedPsi) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        HighlightInfoFilter[] filters = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensionList().toArray(HighlightInfoFilter.EMPTY_ARRAY);
        final EditorColorsScheme actualScheme = this.getColorsScheme() == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.getColorsScheme();
        return new HighlightInfoHolder(this, injectedPsi, filters){

            @Override
            @NotNull
            public TextAttributesScheme getColorsScheme() {
                EditorColorsScheme editorColorsScheme = actualScheme;
                if (editorColorsScheme == null) {
                    2.$$$reportNull$$$0(0);
                }
                return editorColorsScheme;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass$2", "getColorsScheme"));
            }
        };
    }

    private void runAnnotatorsAndVisitorsOnInjectedPsi(@NotNull InjectedLanguageManager injectedLanguageManager, @NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places, @Nullable TextAttributesKey attributesKey, @NotNull ResultSink resultSink) {
        DocumentWindow documentWindow;
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        if (places == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(13);
        }
        if (resultSink == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if ((documentWindow = (DocumentWindow)PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(injectedPsi)) == null) {
            return;
        }
        InjectedGeneralHighlightingPass.highlightInjectedBackground(injectedPsi, places, attributesKey, resultSink);
        AnnotationSession session = AnnotationSessionImpl.create(injectedPsi);
        GeneralHighlightingPass.setupAnnotationSession(session, (TextRange)this.myPriorityRange, this.myRestrictRange, ((HighlightingSessionImpl)this.getHighlightingSession()).getMinimumSeverity());
        AnnotatorRunner annotatorRunner = this.myRunAnnotators ? new AnnotatorRunner(session, false) : null;
        Divider.divideInsideAndOutsideAllRoots(injectedPsi, injectedPsi.getTextRange(), injectedPsi.getTextRange(), GeneralHighlightingPass.SHOULD_HIGHLIGHT_FILTER, (Processor<? super Divider.DividedElements>)((Processor)dividedElements -> {
            List<? extends @NotNull PsiElement> inside = dividedElements.inside();
            Runnable runnable = () -> {
                HighlightVisitorRunner highlightVisitorRunner = new HighlightVisitorRunner(injectedPsi, (TextAttributesScheme)this.myGlobalScheme, this.myRunVisitors, this.myHighlightErrorElements);
                highlightVisitorRunner.createHighlightVisitorsFor((Consumer<? super HighlightVisitor[]>)((Consumer)visitors -> {
                    @NotNull int chunkSize = Math.max(1, inside.size() / 100);
                    highlightVisitorRunner.runVisitors(injectedPsi, inside, List.of(), (HighlightVisitor[])visitors, false, chunkSize, true, () -> this.createInfoHolder(injectedPsi), (toolId, psiElement, infos) -> {
                        List hostInfos = infos.isEmpty() ? List.of() : ContainerUtil.flatMap((Iterable)infos, info -> InjectedGeneralHighlightingPass.createPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager));
                        resultSink.accept(toolId, psiElement, hostInfos);
                    });
                }));
                this.highlightInjectedSyntax(injectedPsi, places, resultSink);
            };
            if (annotatorRunner == null) {
                runnable.run();
            } else {
                annotatorRunner.runAnnotatorsAsync((Document)documentWindow, inside, List.of(), runnable, resultSink);
            }
            return true;
        }));
    }

    private static void highlightInjectedBackground(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places, @Nullable TextAttributesKey attributesKey, @NotNull ResultSink resultSink) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        if (places == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if (resultSink == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        boolean addTooltips = places.size() < 100;
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(places.size());
        for (PsiLanguageInjectionHost.Shred shred : places) {
            TextRange textRange;
            PsiLanguageInjectionHost host = shred.getHost();
            if (host == null || (textRange = shred.getRangeInsideHost().shiftRight(host.getTextRange().getStartOffset())).isEmpty()) continue;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(textRange);
            if (attributesKey != null && InjectedLanguageUtil.isHighlightInjectionBackground(host)) {
                builder.textAttributes(attributesKey);
            }
            if (addTooltips) {
                String desc = injectedPsi.getLanguage().getDisplayName() + ": " + injectedPsi.getText();
                builder.unescapedToolTip(desc);
            }
            HighlightInfo info = builder.createUnconditionally();
            info.markFromInjection();
            info.toolId = InjectedLanguageManagerImpl.INJECTION_BACKGROUND_TOOL_ID;
            info.setGroup(-6);
            result.add(info);
        }
        resultSink.accept(InjectedLanguageManagerImpl.INJECTION_BACKGROUND_TOOL_ID, (PsiElement)injectedPsi, result);
    }

    @NotNull
    private static @NotNull List<@NotNull HighlightInfo> createPatchedInfos(@NotNull HighlightInfo info, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull InjectedLanguageManager injectedLanguageManager) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        ProperTextRange infoRange = new ProperTextRange(info.startOffset, info.endOffset);
        List editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)infoRange);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(editables.size());
        for (TextRange editable : editables) {
            TextRange hostRange = documentWindow.injectedToHost(editable);
            boolean isAfterEndOfLine = info.isAfterEndOfLine();
            if (isAfterEndOfLine) {
                int hostEndOffset = hostRange.getEndOffset();
                int lineNumber = documentWindow.getDelegate().getLineNumber(hostEndOffset);
                int hostLineEndOffset = documentWindow.getDelegate().getLineEndOffset(lineNumber);
                if (hostEndOffset < hostLineEndOffset) {
                    isAfterEndOfLine = false;
                    hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
                }
            }
            HighlightInfo.Builder builder = info.copy(false).range(hostRange);
            if (isAfterEndOfLine) {
                builder.endOfLine();
            }
            HighlightInfo patched = builder.createUnconditionally();
            info.findRegisteredQuickFix((descriptor, quickfixTextRange) -> {
                List editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, quickfixTextRange);
                List fixes = ContainerUtil.map((Collection)editableQF, editableRange -> {
                    TextRange patchedFixRange = documentWindow.injectedToHost(editableRange);
                    return descriptor.withFixRange((Segment)patchedFixRange);
                });
                patched.registerFixes(fixes, documentWindow.getDelegate());
                return null;
            });
            patched.markFromInjection();
            result.add(patched);
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private void highlightInjectedSyntax(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places, @NotNull ResultSink resultSink) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        if (places == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        if (resultSink == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        ArrayList result = new ArrayList(places.size() * 2);
        InjectedLanguageUtil.processTokens(injectedPsi, places, (hostRange, keys) -> {
            if (result == null) {
                InjectedGeneralHighlightingPass.$$$reportNull$$$0(27);
            }
            if (hostRange == null) {
                InjectedGeneralHighlightingPass.$$$reportNull$$$0(28);
            }
            List<HighlightInfo> infos = InjectedLanguageFragmentSyntaxUtil.addSyntaxInjectedFragmentInfo(this.myGlobalScheme, hostRange, keys, InjectedLanguageManagerImpl.INJECTION_SYNTAX_TOOL_ID);
            result.addAll(infos);
        });
        resultSink.accept(InjectedLanguageManagerImpl.INJECTION_SYNTAX_TOOL_ID, (PsiElement)injectedPsi, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = this.myHighlights;
        // MONITORENTER : list2
        List<HighlightInfo> list = this.myHighlights;
        // MONITOREXIT : list2
        if (list != null) return list;
        InjectedGeneralHighlightingPass.$$$reportNull$$$0(26);
        return list;
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    private static /* synthetic */ boolean lambda$processInjectedPsiFiles$5(PsiElement context, TextRange reducedRange) {
        return reducedRange.contains(context.getTextRange());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoUpdater";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedInjected";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguageManager";
                break;
            }
            case 13: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 14: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSink";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatchedInfos";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedPsiFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHolder";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorsAndVisitorsOnInjectedPsi";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightInjectedBackground";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPatchedInfos";
                break;
            }
            case 22: 
            case 26: {
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "highlightInjectedSyntax";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$highlightInjectedSyntax$16";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 26 -> new IllegalStateException(string);
        };
    }
}

