/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public class GlobalInspectionContextBase
extends UserDataHolderBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextBase.class);
    private static final HashingStrategy<Tools> TOOLS_HASHING_STRATEGY = new HashingStrategy<Tools>(){

        public int hashCode(@Nullable Tools object) {
            return object == null ? 0 : object.getShortName().hashCode();
        }

        public boolean equals(@Nullable Tools o1, @Nullable Tools o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getShortName().equals(o2.getShortName());
        }
    };
    private RefManager myRefManager;
    private AnalysisScope myCurrentScope;
    @NotNull
    private final Project myProject;
    private final List<JobDescriptor> myJobDescriptors;
    private final StdJobDescriptors myStdJobDescriptors;
    @NotNull
    protected ProgressIndicator myProgressIndicator;
    private InspectionProfileImpl myExternalProfile;
    @NotNull
    private Runnable myRerunAction;
    protected final Map<Key<?>, GlobalInspectionContextExtension<?>> myExtensions;
    private @Unmodifiable Map<String, Tools> myTools;
    @NonNls
    public static final String PROBLEMS_TAG_NAME = "problems";
    @NonNls
    public static final String LOCAL_TOOL_ATTRIBUTE = "is_local_tool";

    public GlobalInspectionContextBase(@NotNull Project project) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(0);
        }
        this.myJobDescriptors = new ArrayList<JobDescriptor>();
        this.myStdJobDescriptors = new StdJobDescriptors();
        this.myProgressIndicator = new EmptyProgressIndicator();
        this.myRerunAction = EmptyRunnable.getInstance();
        this.myExtensions = new HashMap();
        this.myProject = project;
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            GlobalInspectionContextExtension extension = factory.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension.getID(), extension);
        }
    }

    public AnalysisScope getCurrentScope() {
        return this.myCurrentScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(1);
        }
        return project;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(2);
        }
        return (T)this.myExtensions.get(key);
    }

    @NotNull
    public InspectionProfileImpl getCurrentProfile() {
        if (this.myExternalProfile != null) {
            InspectionProfileImpl inspectionProfileImpl = this.myExternalProfile;
            if (inspectionProfileImpl == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(3);
            }
            return inspectionProfileImpl;
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject)).getCurrentProfile();
        InspectionProfileImpl profile = ProjectInspectionProfileManager.getInstance(this.myProject).getProfile(currentProfile, false);
        InspectionProfileImpl inspectionProfileImpl = profile == null ? InspectionProfileManager.getInstance().getProfile(currentProfile) : profile;
        if (inspectionProfileImpl == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(4);
        }
        return inspectionProfileImpl;
    }

    public boolean shouldCheck(@NotNull RefEntity entity, @NotNull GlobalInspectionTool tool) {
        RefElementImpl refElement;
        if (entity == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(5);
        }
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(6);
        }
        return !(entity instanceof RefElementImpl) || this.isToCheckMember(refElement = (RefElementImpl)entity, (InspectionProfileEntry)tool);
    }

    public boolean isSuppressed(@NotNull PsiElement element, @NotNull String id) {
        RefManagerImpl refManager;
        if (element == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(7);
        }
        if (id == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(8);
        }
        if ((refManager = (RefManagerImpl)this.getRefManager()).isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element);
            return refElement instanceof RefElementImpl && refElement.isSuppressed(new String[]{id});
        }
        return SuppressionUtil.isSuppressed(element, id);
    }

    void cleanupTools() {
        EntryPointsManager entryPointsManager;
        this.myProgressIndicator.cancel();
        for (GlobalInspectionContextExtension<?> extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        if (this.myTools != null) {
            for (Tools tools : this.myTools.values()) {
                for (ScopeToolState state : tools.getTools()) {
                    InspectionToolWrapper toolWrapper = state.getTool();
                    toolWrapper.cleanup(this.myProject);
                }
            }
            this.myTools = null;
        }
        EntryPointsManager entryPointsManager2 = entryPointsManager = this.getProject().isDisposed() ? null : EntryPointsManager.getInstance((Project)this.getProject());
        if (entryPointsManager != null) {
            entryPointsManager.cleanup();
        }
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
        this.myJobDescriptors.clear();
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public boolean areToolsInitialized() {
        return this.myTools != null;
    }

    public void setCurrentScope(@NotNull AnalysisScope currentScope) {
        if (currentScope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(9);
        }
        this.myCurrentScope = currentScope;
    }

    public void setRerunAction(@NotNull Runnable action) {
        if (action == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(10);
        }
        this.myRerunAction = action;
    }

    public void doInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(11);
        }
        if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, true, this.myRerunAction)) {
            return;
        }
        this.cleanup();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myCurrentScope = scope;
            this.launchInspections(scope);
        }, this.myProject.getDisposed());
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.myRefManager;
        if (refManager == null) {
            this.myRefManager = refManager = (RefManager)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> new RefManagerImpl(this.myProject, this.myCurrentScope, this));
        }
        RefManager refManager2 = refManager;
        if (refManager2 == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(12);
        }
        return refManager2;
    }

    public boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool) {
        if (owner == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(13);
        }
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(14);
        }
        return this.isToCheckFile((PsiFileSystemItem)((RefElementImpl)owner).getContainingFile(), tool) && !owner.isSuppressed(new String[]{tool.getShortName(), tool.getAlternativeID()});
    }

    public boolean isToCheckFile(@Nullable PsiFileSystemItem file, @NotNull InspectionProfileEntry tool) {
        Tools tools;
        if (tool == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(15);
        }
        if ((tools = this.getTools().get(tool.getShortName())) != null && file != null) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope(file.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && state.getTool().getTool() == tool;
            }
        }
        return false;
    }

    protected void launchInspections(final @NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        LOG.info("Code inspection started");
        InspectionProfileImpl profile = this.getCurrentProfile();
        String title = profile.getSingleTool() == null ? AnalysisBundle.message((String)"inspection.progress.profile.title", (Object[])new Object[]{profile.getName()}) : AnalysisBundle.message((String)"inspection.progress.single.inspection.title", (Object[])new Object[]{profile.getName()});
        boolean modalProgress = Registry.is((String)"batch.inspections.modal.progress.when.building.global.reference.graph") && this.needsGlobalReferenceGraph();
        Task.Backgroundable task = new Task.Backgroundable(this.getProject(), title, true, this.createOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextBase.this.performInspectionsWithProgress(scope, false, false);
            }

            public void onSuccess() {
                GlobalInspectionContextBase.this.notifyInspectionsFinished(scope);
            }

            public void onCancel() {
                GlobalInspectionContextBase.this.cleanup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextBase$2", "run"));
            }
        };
        ProgressManager.getInstance().run(task.toModalIfNeeded(modalProgress));
    }

    private boolean needsGlobalReferenceGraph() {
        return ContainerUtil.exists(this.getUsedTools(), tool -> {
            GlobalInspectionToolWrapper globalWrapper;
            InspectionToolWrapper patt0$temp = tool.getTool();
            return patt0$temp instanceof GlobalInspectionToolWrapper && ((GlobalInspectionTool)(globalWrapper = (GlobalInspectionToolWrapper)patt0$temp).getTool()).isGraphNeeded();
        });
    }

    @NotNull
    protected PerformInBackgroundOption createOption() {
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        if (performInBackgroundOption == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(17);
        }
        return performInBackgroundOption;
    }

    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(18);
        }
    }

    @RequiresBackgroundThread
    public void performInspectionsWithProgress(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        ProgressIndicatorEx indicatorEx;
        block5: {
            block4: {
                if (scope == null) {
                    GlobalInspectionContextBase.$$$reportNull$$$0(19);
                }
                ThreadingAssertions.assertBackgroundThread();
                ProgressIndicator progressIndicator = this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (!(progressIndicator instanceof ProgressIndicatorEx)) break block4;
                indicatorEx = (ProgressIndicatorEx)progressIndicator;
                if (this.myProgressIndicator instanceof ProgressIndicatorWithDelayedPresentation) break block5;
            }
            throw new IllegalStateException("Inspections must be run under ProgressWindow but got: " + String.valueOf(this.myProgressIndicator));
        }
        this.myProgressIndicator.setIndeterminate(false);
        indicatorEx.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

            public void cancel() {
                LOG.info("Cancelling inspection progress");
                super.cancel();
                GlobalInspectionContextBase.this.canceled();
            }
        });
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ((RefManagerImpl)this.getRefManager()).runInsideInspectionReadAction(() -> psiManager.runInBatchFilesMode(() -> {
            try {
                this.getStdJobDescriptors().BUILD_GRAPH.setTotalAmount(scope.getFileCount());
                this.getStdJobDescriptors().LOCAL_ANALYSIS.setTotalAmount(scope.getFileCount());
                this.getStdJobDescriptors().FIND_EXTERNAL_USAGES.setTotalAmount(0);
                this.runTools(scope, runGlobalToolsOnly, isOfflineInspections);
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                if (Logger.shouldRethrow((Throwable)e)) {
                    throw e;
                }
                LOG.error(e);
            }
            return null;
        }));
    }

    protected void canceled() {
    }

    @RequiresBackgroundThread
    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.assertBackgroundThread();
    }

    public void initializeTools(@NotNull List<Tools> outGlobalTools, @NotNull List<Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools) {
        if (outGlobalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(21);
        }
        if (outLocalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(22);
        }
        if (outGlobalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(23);
        }
        List<Tools> usedTools = this.getUsedTools();
        for (GlobalInspectionContextExtension<?> extension : this.myExtensions.values()) {
            extension.performPreInitToolsActivities(usedTools, (GlobalInspectionContext)this);
        }
        HashMap<String, Tools> tools = new HashMap<String, Tools>(usedTools.size());
        for (Tools tools2 : usedTools) {
            JobDescriptor[] jobDescriptors;
            String shortName = tools2.getShortName();
            tools.put(shortName, tools2);
            InspectionToolWrapper toolWrapper = tools2.getTool();
            this.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, tools2, toolWrapper);
            for (ScopeToolState state : tools2.getTools()) {
                state.getTool().initialize((GlobalInspectionContext)this);
            }
            for (JobDescriptor jobDescriptor : jobDescriptors = toolWrapper.getJobDescriptors((GlobalInspectionContext)this)) {
                this.appendJobDescriptor(jobDescriptor);
            }
        }
        this.appendPairedInspectionsForUnfairTools(outGlobalTools, outGlobalSimpleTools, outLocalTools, tools);
        this.myTools = Collections.unmodifiableMap(tools);
        for (GlobalInspectionContextExtension globalInspectionContextExtension : this.myExtensions.values()) {
            globalInspectionContextExtension.performPreRunActivities(outGlobalTools, outLocalTools, (GlobalInspectionContext)this);
        }
    }

    @NotNull
    public List<Tools> getUsedTools() {
        InspectionProfileImpl profile = this.getCurrentProfile();
        List<Tools> tools = profile.getAllEnabledInspectionTools(this.myProject);
        LinkedHashSet dependentTools = new LinkedHashSet();
        for (Tools tool : tools) {
            profile.collectDependentInspections(tool.getTool(), dependentTools, this.getProject());
        }
        if (dependentTools.isEmpty()) {
            List<Tools> list = tools;
            if (list == null) {
                GlobalInspectionContextBase.$$$reportNull$$$0(24);
            }
            return list;
        }
        Set set = CollectionFactory.createCustomHashingStrategySet(TOOLS_HASHING_STRATEGY);
        set.addAll(tools);
        set.addAll(ContainerUtil.map(dependentTools, toolWrapper -> new ToolsImpl((InspectionToolWrapper<?, ?>)toolWrapper, toolWrapper.getDefaultLevel(), true, true)));
        return new ArrayList<Tools>(set);
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<? super Tools> globalTools, @NotNull List<? super Tools> globalSimpleTools, @NotNull List<Tools> localTools, @NotNull Map<String, Tools> toolsMap) {
        Tools[] lArray;
        if (globalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(25);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(26);
        }
        if (localTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(27);
        }
        if (toolsMap == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(28);
        }
        for (Tools tool : lArray = localTools.toArray(new Tools[0])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            PairedUnfairLocalInspectionTool unfair = (PairedUnfairLocalInspectionTool)localTool;
            String batchShortName = unfair.getInspectionForBatchShortName();
            InspectionProfileImpl currentProfile = this.getCurrentProfile();
            InspectionToolWrapper pairedWrapper = currentProfile.getInspectionTool(batchShortName, this.getProject());
            InspectionToolWrapper inspectionToolWrapper = batchInspection = pairedWrapper != null ? pairedWrapper.createCopy() : null;
            if (batchInspection == null || toolsMap.containsKey(batchShortName)) continue;
            InspectionProfileEntry batchTool = batchInspection.getTool();
            ScopeToolState defaultState = tool.getDefaultState();
            ToolsImpl newTool = new ToolsImpl(batchInspection, defaultState.getLevel(), true, defaultState.isEnabled());
            for (ScopeToolState state : tool.getTools()) {
                NamedScope scope = state.getScope(this.getProject());
                if (scope == null) continue;
                newTool.addTool(scope, batchInspection, state.isEnabled(), state.getLevel());
            }
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                GlobalInspectionTool globalTool = (GlobalInspectionTool)batchTool;
                if (globalTool.isGlobalSimpleInspectionTool()) {
                    globalSimpleTools.add(newTool);
                } else {
                    globalTools.add(newTool);
                }
            } else {
                throw new AssertionError(batchTool);
            }
            toolsMap.put(batchShortName, newTool);
            batchInspection.initialize((GlobalInspectionContext)this);
        }
    }

    protected void classifyTool(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (outGlobalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(29);
        }
        if (outLocalTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(30);
        }
        if (outGlobalSimpleTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(31);
        }
        if (currentTools == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(32);
        }
        if (toolWrapper == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(33);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            outLocalTools.add((Tools)currentTools);
        } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionToolWrapper globalToolWrapper = (GlobalInspectionToolWrapper)toolWrapper;
            if (((GlobalInspectionTool)globalToolWrapper.getTool()).isGlobalSimpleInspectionTool()) {
                outGlobalSimpleTools.add((Tools)currentTools);
            } else {
                outGlobalTools.add((Tools)currentTools);
            }
        } else {
            throw new RuntimeException("unknown tool " + String.valueOf(toolWrapper));
        }
    }

    @NotNull
    public Map<String, Tools> getTools() {
        Map<String, Tools> tools = this.myTools;
        if (tools == null) {
            throw new IllegalStateException("Tools are not initialized. Please call initializeTools() before use");
        }
        Map<String, Tools> map = tools;
        if (map == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(34);
        }
        return map;
    }

    protected void appendJobDescriptor(@NotNull JobDescriptor job) {
        if (job == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(35);
        }
        if (!this.myJobDescriptors.contains(job)) {
            this.myJobDescriptors.add(job);
            job.setDoneAmount(0);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(36);
        }
        if (profile == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(37);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(38);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal) {
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(39);
        }
        if (profile == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(40);
        }
        this.codeCleanup(scope, profile, commandName, postRunnable, modal, Predicates.alwaysTrue());
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable, PsiElement ... scope) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(42);
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable, (Predicate<? super ProblemDescriptor>)Predicates.alwaysTrue(), scope);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix, @Nullable InspectionProfile profile, PsiElement ... scope) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(43);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(44);
        }
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(45);
        }
        InspectionProfile activeProfile = profile == null ? InspectionProjectProfileManager.getInstance(project).getCurrentProfile() : profile;
        List<PsiElement> psiElements = Stream.of(scope).filter(e -> e != null && e.isPhysical()).toList();
        if (psiElements.isEmpty()) {
            return;
        }
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project).createNewGlobalContext();
        AnalysisScope analysisScope = new AnalysisScope((SearchScope)new LocalSearchScope(psiElements.toArray(PsiElement.EMPTY_ARRAY)), project);
        globalContext.codeCleanup(analysisScope, activeProfile, null, runnable, false, shouldApplyFix);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix, PsiElement ... scope) {
        if (project == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(46);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(47);
        }
        if (scope == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(48);
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable, shouldApplyFix, null, scope);
    }

    public void close(boolean noSuspiciousCodeFound) {
        this.cleanup();
    }

    public void cleanup() {
        this.cleanupTools();
    }

    public void incrementJobDoneAmount(@NotNull JobDescriptor job, @NlsContexts.ProgressText @NotNull String message) {
        if (job == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(49);
        }
        if (message == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(50);
        }
        ProgressManager.checkCanceled();
        int old = job.getDoneAmount();
        job.setDoneAmount(old + 1);
        float totalProgress = this.getTotalProgress();
        this.myProgressIndicator.setFraction((double)totalProgress);
        this.myProgressIndicator.setText(job.getDisplayName() + " " + message);
    }

    private float getTotalProgress() {
        int totalDone = 0;
        int totalTotal = 0;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalDone += jobDescriptor.getDoneAmount();
            totalTotal += jobDescriptor.getTotalAmount();
        }
        return totalTotal == 0 ? 1.0f : 1.0f * (float)totalDone / (float)totalTotal;
    }

    public void setExternalProfile(InspectionProfileImpl profile) {
        this.myExternalProfile = profile;
    }

    @NotNull
    public StdJobDescriptors getStdJobDescriptors() {
        StdJobDescriptors stdJobDescriptors = this.myStdJobDescriptors;
        if (stdJobDescriptors == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(51);
        }
        return stdJobDescriptors;
    }

    @NotNull
    public static DaemonProgressIndicator assertUnderDaemonProgress() {
        ProgressIndicator original;
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ProgressIndicator progressIndicator = original = indicator == null ? null : ProgressWrapper.unwrapAll((ProgressIndicator)indicator);
        if (!(original instanceof DaemonProgressIndicator)) {
            throw new IllegalStateException("must be run under DaemonProgressIndicator, but got: " + (String)(original == null ? "null" : ": " + String.valueOf(original.getClass())) + ": " + String.valueOf(original));
        }
        DaemonProgressIndicator daemon = (DaemonProgressIndicator)original;
        DaemonProgressIndicator daemonProgressIndicator = daemon;
        if (daemonProgressIndicator == null) {
            GlobalInspectionContextBase.$$$reportNull$$$0(52);
        }
        return daemonProgressIndicator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 12, 17, 24, 34, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 34: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 39: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outGlobalTools";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outLocalTools";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outGlobalSimpleTools";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSimpleTools";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolsMap";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTools";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 35: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 38: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldApplyFix";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProfile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createOption";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedTools";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTools";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdJobDescriptors";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "assertUnderDaemonProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 24: 
            case 34: 
            case 51: 
            case 52: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRerunAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doInspections";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isToCheckMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isToCheckFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "launchInspections";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyInspectionsFinished";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performInspectionsWithProgress";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runTools";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initializeTools";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendPairedInspectionsForUnfairTools";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "classifyTool";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendJobDescriptor";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "codeCleanup";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "cleanupElements";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "incrementJobDoneAmount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 12, 17, 24, 34, 51, 52 -> new IllegalStateException(string);
        };
    }
}

