/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.MyVirtualFileEnumeration;
import com.intellij.openapi.module.impl.scopes.ScopeConstant;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\"\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"getOrderEnumeratorForOptions", "Lcom/intellij/openapi/roots/OrderEnumerator;", "module", "Lcom/intellij/openapi/module/Module;", "options", "", "hasOption", "", "option", "calcModules", "", "myOptions", "getFileEnumerationUnderRoots", "Lcom/intellij/psi/search/impl/VirtualFileEnumeration;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "COMPILE_ONLY", "LIBRARIES", "MODULES", "TESTS", "intellij.platform.analysis.impl"})
@ApiStatus.Internal
@JvmName(name="ModuleScopeUtil")
public final class ModuleScopeUtil {
    public static final int COMPILE_ONLY = 1;
    public static final int LIBRARIES = 2;
    public static final int MODULES = 4;
    public static final int TESTS = 8;

    @NotNull
    public static final OrderEnumerator getOrderEnumeratorForOptions(@NotNull Module module, int options) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"orderEntries(...)");
        OrderEnumerator en = orderEnumerator;
        en.recursively();
        if (ModuleScopeUtil.hasOption(options, 1)) {
            en.exportedOnly().compileOnly();
        }
        if (!ModuleScopeUtil.hasOption(options, 2)) {
            en.withoutLibraries().withoutSdk();
        }
        if (!ModuleScopeUtil.hasOption(options, 4)) {
            en.withoutDepModules();
        }
        if (!ModuleScopeUtil.hasOption(options, 8)) {
            en.productionOnly();
        }
        return en;
    }

    public static final boolean hasOption(int $this$hasOption, @ScopeConstant int option) {
        return BitUtil.isSet((int)$this$hasOption, (int)option);
    }

    @NotNull
    public static final Set<Module> calcModules(@NotNull Module module, int myOptions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        HashSet modules = new HashSet();
        OrderEnumerator en = ModuleScopeUtil.getOrderEnumeratorForOptions(module, myOptions);
        en.forEach(arg_0 -> ModuleScopeUtil.calcModules$lambda$1(arg_0 -> ModuleScopeUtil.calcModules$lambda$0(modules, arg_0), arg_0));
        return modules;
    }

    @NotNull
    public static final VirtualFileEnumeration getFileEnumerationUnderRoots(@NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        IntSet result = (IntSet)new IntOpenHashSet();
        for (VirtualFile virtualFile : roots) {
            if (!(virtualFile instanceof VirtualFileWithId)) continue;
            int[] children = VirtualFileManager.getInstance().listAllChildIds(((VirtualFileWithId)virtualFile).getId());
            result.addAll((IntCollection)IntList.of((int[])Arrays.copyOf(children, children.length)));
        }
        return new MyVirtualFileEnumeration(result);
    }

    private static final boolean calcModules$lambda$0(HashSet $modules, OrderEntry each) {
        if (each instanceof ModuleOrderEntry) {
            ContainerUtil.addIfNotNull((Collection)$modules, (Object)((ModuleOrderEntry)each).getModule());
        } else if (each instanceof ModuleSourceOrderEntry) {
            ContainerUtil.addIfNotNull((Collection)$modules, (Object)((ModuleSourceOrderEntry)each).getOwnerModule());
        }
        return true;
    }

    private static final boolean calcModules$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

