/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InputMapExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> myKeysExternalizer;
    private final boolean myValuesAreNullAlways;

    public InputMapExternalizer(@NotNull DataExternalizer<Collection<Key>> keysExternalizer, @NotNull DataExternalizer<Value> valueExternalizer, boolean valueIsAbsent) {
        if (keysExternalizer == null) {
            InputMapExternalizer.$$$reportNull$$$0(0);
        }
        if (valueExternalizer == null) {
            InputMapExternalizer.$$$reportNull$$$0(1);
        }
        this.myKeysExternalizer = keysExternalizer;
        this.myValueExternalizer = valueExternalizer;
        this.myValuesAreNullAlways = valueIsAbsent;
    }

    public void save(@NotNull DataOutput stream, Map<Key, Value> data) throws IOException {
        if (stream == null) {
            InputMapExternalizer.$$$reportNull$$$0(2);
        }
        int size = data.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
        if (size == 0) {
            return;
        }
        Collection[] keysForNullValue = new Collection[]{null};
        HashMap keysPerValue = null;
        if (this.myValuesAreNullAlways) {
            keysForNullValue[0] = data.keySet();
        } else {
            HashMap finalKeysPerValue = keysPerValue = new HashMap();
            data.forEach((key, value) -> {
                Collection keys;
                Collection collection = keys = value != null ? (Collection)finalKeysPerValue.get(value) : keysForNullValue[0];
                if (keys == null) {
                    keys = new SmartList();
                    if (value != null) {
                        finalKeysPerValue.put(value, keys);
                    } else {
                        keysForNullValue[0] = keys;
                    }
                }
                keys.add(key);
            });
        }
        if (keysForNullValue[0] != null) {
            this.myValueExternalizer.save(stream, null);
            this.myKeysExternalizer.save(stream, (Object)keysForNullValue[0]);
        }
        if (keysPerValue != null) {
            for (Object value2 : keysPerValue.keySet()) {
                this.myValueExternalizer.save(stream, value2);
                this.myKeysExternalizer.save(stream, (Object)((Collection)keysPerValue.get(value2)));
            }
        }
    }

    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs;
        if (in == null) {
            InputMapExternalizer.$$$reportNull$$$0(3);
        }
        if ((pairs = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Object value = this.myValueExternalizer.read(in);
            Collection keys = (Collection)this.myKeysExternalizer.read(in);
            for (Object k : keys) {
                result.put(k, value);
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/InputMapExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

