/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.events.IndexingEventsLogger;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class VfsEventsMerger {
    private final ConcurrentIntObjectMap<ChangeInfo> changePerFileId = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private final AtomicInteger publishedEventIndex = new AtomicInteger();

    public void recordFileEvent(@NotNull VirtualFile file, boolean contentChange) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(0);
        }
        IndexingEventsLogger.tryLog(contentChange ? "FILE_CONTENT_CHANGED" : "FILE_ADDED", file);
        this.updateChange(file, contentChange ? 4 : 1);
    }

    public void recordFileRemovedEvent(@NotNull VirtualFile file) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(1);
        }
        IndexingEventsLogger.tryLog("FILE_REMOVED", file);
        this.updateChange(file, 2);
    }

    public void recordTransientStateChangeEvent(@NotNull VirtualFile file) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(2);
        }
        IndexingEventsLogger.tryLog("FILE_TRANSIENT_STATE_CHANGED", file);
        this.updateChange(file, 8);
    }

    public int getPublishedEventIndex() {
        return this.publishedEventIndex.get();
    }

    private void updateChange(@NotNull VirtualFile file, @ChangeInfo.EventMask int mask) {
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(3);
        }
        if (file instanceof VirtualFileWithId) {
            this.updateChange(((VirtualFileWithId)file).getId(), file, mask);
        }
    }

    private void updateChange(int fileId, @NotNull VirtualFile file, @ChangeInfo.EventMask int mask) {
        ChangeInfo newChangeInfo;
        ChangeInfo existingChangeInfo;
        if (file == null) {
            VfsEventsMerger.$$$reportNull$$$0(4);
        }
        do {
            if ((existingChangeInfo = (ChangeInfo)this.changePerFileId.get(fileId)) != null && existingChangeInfo.changeMask == mask) {
                return;
            }
            newChangeInfo = new ChangeInfo(file, mask, existingChangeInfo);
        } while (!(existingChangeInfo == null ? this.changePerFileId.putIfAbsent(fileId, (Object)newChangeInfo) == null : this.changePerFileId.replace(fileId, (Object)existingChangeInfo, (Object)newChangeInfo)));
        this.publishedEventIndex.incrementAndGet();
    }

    @VisibleForTesting
    public boolean processChanges(@NotNull VfsEventProcessor eventProcessor) {
        if (eventProcessor == null) {
            VfsEventsMerger.$$$reportNull$$$0(5);
        }
        if (!this.changePerFileId.isEmpty()) {
            Throwable interruptReason = null;
            try {
                int[] fileIds;
                for (int fileId : fileIds = this.changePerFileId.keys()) {
                    ProgressManager.checkCanceled();
                    ChangeInfo info = (ChangeInfo)this.changePerFileId.remove(fileId);
                    if (info == null) continue;
                    try {
                        IndexingEventsLogger.tryLog(() -> "Processing " + String.valueOf(info));
                        if (eventProcessor.process(info)) continue;
                        eventProcessor.endBatch();
                        boolean bl = false;
                        return bl;
                    }
                    catch (AlreadyDisposedException e) {
                        throw e;
                    }
                    catch (ProcessCanceledException pce) {
                        ((FileBasedIndexEx)FileBasedIndex.getInstance()).getLogger().error((Throwable)new RuntimeException(pce));
                        assert (false);
                    }
                }
                eventProcessor.endBatch();
            }
            catch (Throwable t) {
                interruptReason = t;
                throw t;
            }
            finally {
                Throwable finalInterruptReason = interruptReason;
                IndexingEventsLogger.tryLog(() -> "Processing " + (String)(finalInterruptReason != null ? "interrupted: " + String.valueOf(finalInterruptReason) : "finished"));
            }
        }
        return true;
    }

    public boolean hasChanges() {
        return !this.changePerFileId.isEmpty();
    }

    public int getApproximateChangesCount() {
        return this.changePerFileId.size();
    }

    @NotNull
    public Iterator<VirtualFile> getChangedFiles() {
        Iterator iterator = ContainerUtil.mapIterator(this.changePerFileId.values().iterator(), ChangeInfo::getFile);
        if (iterator == null) {
            VfsEventsMerger.$$$reportNull$$$0(6);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordFileEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordFileRemovedEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordTransientStateChangeEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChanges";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static final class ChangeInfo {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_CONTENT_CHANGED = 4;
        public static final int FILE_TRANSIENT_STATE_CHANGED = 8;
        private final VirtualFile file;
        @EventMask
        private final int changeMask;

        ChangeInfo(@NotNull VirtualFile file, @EventMask int changeMask, @Nullable ChangeInfo previous) {
            if (file == null) {
                ChangeInfo.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.changeMask = ChangeInfo.mergeEventMask(previous == null ? 0 : previous.changeMask, changeMask);
        }

        @EventMask
        private static int mergeEventMask(@EventMask int existingMask, @EventMask int newMask) {
            if (newMask == 2) {
                return 2;
            }
            return existingMask | newMask;
        }

        public boolean isContentChanged() {
            return (this.changeMask & 4) != 0;
        }

        public boolean isFileRemoved() {
            return (this.changeMask & 2) != 0;
        }

        public boolean isFileAdded() {
            return (this.changeMask & 1) != 0;
        }

        public boolean isTransientStateChanged() {
            return (this.changeMask & 8) != 0;
        }

        public int changeMask() {
            return this.changeMask;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                ChangeInfo.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        public int getFileId() {
            return FileBasedIndex.getFileId((VirtualFile)this.file);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[file: ");
            VirtualFile virtualFile = this.file;
            if (virtualFile instanceof VirtualFileWithId) {
                VirtualFileWithId fileWithId = (VirtualFileWithId)virtualFile;
                builder.append(fileWithId.getId());
            } else {
                builder.append(this.file.getPath());
            }
            builder.append(", ").append("operation: {");
            if (this.isTransientStateChanged()) {
                builder.append("TRANSIENT_STATE_CHANGE ");
            }
            if (this.isContentChanged()) {
                builder.append("CONTENT_CHANGE ");
            }
            if (this.isFileRemoved()) {
                builder.append("REMOVE ");
            }
            if (this.isFileAdded()) {
                builder.append("ADD ");
            }
            return builder.append("}]").toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        static @interface EventMask {
        }
    }

    @FunctionalInterface
    public static interface VfsEventProcessor {
        public boolean process(@NotNull ChangeInfo var1);

        default public void endBatch() {
        }
    }
}

