/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.IndexStorageUtil;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import com.intellij.util.indexing.impl.storage.TransientChangeTrackingValueContainer;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TransientChangesIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(TransientChangesIndexStorage.class);
    @NotNull
    private final ID<?, ?> indexId;
    private final ReentrantLock inMemoryContainerLock;
    private final ConcurrentMap<Key, TransientChangeTrackingValueContainer<Value>> inMemoryStorage;
    @NotNull
    private final VfsAwareIndexStorage<Key, Value> underlyingStorage;
    private boolean bufferingEnabled;
    private final List<BufferingStateListener> bufferingStateListeners;

    public TransientChangesIndexStorage(@NotNull IndexStorage<Key, Value> underlyingStorage, @NotNull FileBasedIndexExtension<Key, Value> extension) {
        if (underlyingStorage == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(1);
        }
        this.inMemoryContainerLock = new ReentrantLock();
        this.bufferingStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.underlyingStorage = (VfsAwareIndexStorage)underlyingStorage;
        this.indexId = extension.getName();
        this.inMemoryStorage = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)IndexStorageUtil.adaptKeyDescriptorToStrategy((KeyDescriptor)extension.getKeyDescriptor()));
    }

    public void addBufferingStateListener(@NotNull BufferingStateListener listener2) {
        if (listener2 == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(2);
        }
        this.bufferingStateListeners.add(listener2);
    }

    public void setBufferingEnabled(boolean enabled) {
        boolean wasEnabled = this.bufferingEnabled;
        LOG.assertTrue(wasEnabled != enabled);
        this.bufferingEnabled = enabled;
        for (BufferingStateListener listener2 : this.bufferingStateListeners) {
            listener2.bufferingStateChanged(enabled);
        }
    }

    public boolean clearMemoryMap() {
        boolean modified = !this.inMemoryStorage.isEmpty();
        this.inMemoryStorage.clear();
        if (modified && FileBasedIndexEx.doTraceStubUpdates(this.indexId)) {
            LOG.info("clearMemoryMap,index=" + String.valueOf(this.indexId));
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearMemoryMapForId(Key key, int fileId) {
        TransientChangeTrackingValueContainer container = (TransientChangeTrackingValueContainer)((Object)this.inMemoryStorage.get(key));
        if (container != null) {
            this.inMemoryContainerLock.lock();
            try {
                container.dropAssociatedValue(fileId);
            }
            finally {
                this.inMemoryContainerLock.unlock();
            }
            if (FileBasedIndexEx.doTraceStubUpdates(this.indexId)) {
                LOG.info("clearMemoryMapForId,inputId=" + fileId + ",index=" + String.valueOf(this.indexId) + ",key=" + String.valueOf(key));
            }
            return true;
        }
        return false;
    }

    public void fireMemoryStorageCleared() {
        for (BufferingStateListener listener2 : this.bufferingStateListeners) {
            listener2.memoryStorageCleared();
        }
    }

    public void clearCaches() {
        try {
            if (this.inMemoryStorage.isEmpty()) {
                return;
            }
            if (IndexDebugProperties.DEBUG || FileBasedIndexEx.doTraceStubUpdates(this.indexId)) {
                LOG.info("clearCaches,index=" + String.valueOf(this.indexId) + ",number of items:" + this.inMemoryStorage.size());
            }
            for (ChangeTrackingValueContainer v : this.inMemoryStorage.values()) {
                v.dropMergedData();
            }
        }
        finally {
            this.underlyingStorage.clearCaches();
        }
    }

    public void close() throws IOException {
        this.underlyingStorage.close();
    }

    @ApiStatus.Internal
    public boolean isClosed() {
        return this.underlyingStorage.isClosed();
    }

    public void clear() throws StorageException {
        this.clearMemoryMap();
        this.underlyingStorage.clear();
    }

    public void flush() throws IOException {
        this.underlyingStorage.flush();
    }

    public boolean isDirty() {
        return this.underlyingStorage.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(4);
        }
        HashSet stopList = new HashSet();
        Processor decoratingProcessor = key -> {
            if (stopList.contains(key)) {
                return true;
            }
            UpdatableValueContainer container = (UpdatableValueContainer)this.inMemoryStorage.get(key);
            if (container != null && container.size() == 0) {
                return true;
            }
            return processor.process(key);
        };
        this.inMemoryContainerLock.lock();
        try {
            for (Object key2 : this.inMemoryStorage.keySet()) {
                if (!decoratingProcessor.process(key2)) {
                    boolean bl = false;
                    return bl;
                }
                stopList.add(key2);
            }
        }
        finally {
            this.inMemoryContainerLock.unlock();
        }
        return this.underlyingStorage.processKeys(stopList.isEmpty() ? processor : decoratingProcessor, scope, idFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(Key key, int inputId, Value newValue) throws StorageException {
        if (this.bufferingEnabled) {
            UpdatableValueContainer<Value> memContainer = this.getOrLoadContainerFor(key);
            this.inMemoryContainerLock.lock();
            try {
                memContainer.removeAssociatedValue(inputId);
                memContainer.addValue(inputId, newValue);
            }
            finally {
                this.inMemoryContainerLock.unlock();
            }
            return;
        }
        ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)this.inMemoryStorage.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.underlyingStorage.updateValue(key, inputId, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (FileBasedIndexEx.doTraceStubUpdates(this.indexId)) {
            LOG.info("addValue,inputId=" + inputId + ",index=" + String.valueOf(this.indexId) + ",inMemory=" + this.bufferingEnabled + "," + String.valueOf(value));
        }
        if (this.bufferingEnabled) {
            UpdatableValueContainer<Value> container = this.getOrLoadContainerFor(key);
            this.inMemoryContainerLock.lock();
            try {
                container.addValue(inputId, value);
            }
            finally {
                this.inMemoryContainerLock.unlock();
            }
            return;
        }
        ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)this.inMemoryStorage.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.underlyingStorage.addValue(key, inputId, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(5);
        }
        if (FileBasedIndexEx.doTraceStubUpdates(this.indexId)) {
            LOG.info("removeAllValues,inputId=" + inputId + ",index=" + String.valueOf(this.indexId) + ",inMemory=" + this.bufferingEnabled);
        }
        if (this.bufferingEnabled) {
            UpdatableValueContainer<Value> container = this.getOrLoadContainerFor(key);
            this.inMemoryContainerLock.lock();
            try {
                container.removeAssociatedValue(inputId);
            }
            finally {
                this.inMemoryContainerLock.unlock();
            }
            return;
        }
        ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)this.inMemoryStorage.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.underlyingStorage.removeAllValues(key, inputId);
    }

    private UpdatableValueContainer<Value> getOrLoadContainerFor(Key key) {
        return (UpdatableValueContainer)this.inMemoryStorage.computeIfAbsent(key, k -> new TransientChangeTrackingValueContainer(() -> {
            try {
                return (UpdatableValueContainer)this.underlyingStorage.read(key);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> boolean read(Key key, @NotNull ValueContainerProcessor<Value, E> processor) throws StorageException, E {
        ValueContainer valueContainer;
        if (processor == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(6);
        }
        if ((valueContainer = (ValueContainer)this.inMemoryStorage.get(key)) != null) {
            this.inMemoryContainerLock.lock();
            try {
                boolean bl = processor.process(valueContainer);
                return bl;
            }
            finally {
                this.inMemoryContainerLock.unlock();
            }
        }
        return this.underlyingStorage.read(key, processor);
    }

    public int keysCountApproximately() {
        return this.inMemoryStorage.size() + this.underlyingStorage.keysCountApproximately();
    }

    public boolean isReadLockHeldByCurrentThread() {
        return this.underlyingStorage.isReadLockHeldByCurrentThread();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/storage/TransientChangesIndexStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addBufferingStateListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface BufferingStateListener {
        public void bufferingStateChanged(boolean var1);

        public void memoryStorageCleared();
    }
}

