/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.cache;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingServiceImpl;
import com.intellij.application.options.codeStyle.cache.RollingAvgBuffer;
import com.intellij.application.options.codeStyle.cache.TooFrequentCodeStyleComputationWatcherKt;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u001f\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cacheEvictionTrackingStart", "", "lastCacheAccessTime", "settingsModCountAtTrackingStart", "rollingAvgBuffer", "Lcom/intellij/application/options/codeStyle/cache/RollingAvgBuffer;", "calcCurrentCacheEvictionRate", "", "beforeCacheEntryInserted", "", "currentCacheSize", "", "maxCacheSize", "getCurrentProjectSettingsModCount", "checkEvictionRate", "dumpState", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentEvictionRate", "isTooHighEvictionRateDetected", "", "isEvictionTrackingBlocked", "stopEvictionTracking", "blockTracking", "rate", "(ZLjava/lang/Double;)V", "Companion", "intellij.platform.codeStyle.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTooFrequentCodeStyleComputationWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooFrequentCodeStyleComputationWatcher.kt\ncom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n1#2:156\n774#3:157\n865#3,2:158\n1869#3,2:160\n23#4:162\n*S KotlinDebug\n*F\n+ 1 TooFrequentCodeStyleComputationWatcher.kt\ncom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher\n*L\n92#1:157\n92#1:158,2\n93#1:160,2\n20#1:162\n*E\n"})
public final class TooFrequentCodeStyleComputationWatcher {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    private volatile long cacheEvictionTrackingStart;
    private long lastCacheAccessTime;
    private long settingsModCountAtTrackingStart;
    @NotNull
    private final RollingAvgBuffer rollingAvgBuffer;
    @NotNull
    private static final Logger LOG;

    public TooFrequentCodeStyleComputationWatcher(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.cacheEvictionTrackingStart = -1L;
        this.lastCacheAccessTime = System.currentTimeMillis();
        this.settingsModCountAtTrackingStart = -1L;
        this.rollingAvgBuffer = new RollingAvgBuffer(100, (long)(1.0 / (double)TooFrequentCodeStyleComputationWatcherKt.access$getHIGH_CACHE_EVICTION_RATE_THRESHOLD() * (double)1000 * (double)10));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final double calcCurrentCacheEvictionRate() {
        return 1.0 / this.rollingAvgBuffer.getRollingAvg() * (double)1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeCacheEntryInserted(int currentCacheSize, int maxCacheSize) {
        if (Registry.Companion.is("code.style.cache.high.eviction.rate.automatic.recovery.enabled") && !this.isEvictionTrackingBlocked()) {
            TooFrequentCodeStyleComputationWatcher tooFrequentCodeStyleComputationWatcher = this;
            synchronized (tooFrequentCodeStyleComputationWatcher) {
                boolean bl = false;
                this.checkEvictionRate(currentCacheSize, maxCacheSize);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final long getCurrentProjectSettingsModCount() {
        return CodeStyleSettingsManager.getInstance().getCurrentSettings().getModificationTracker().getModificationCount();
    }

    private final void checkEvictionRate(int currentCacheSize, int maxCacheSize) {
        long currentTime = System.currentTimeMillis();
        if (!this.isEvictionTrackingBlocked() && currentCacheSize >= maxCacheSize) {
            this.rollingAvgBuffer.update(currentTime - this.lastCacheAccessTime);
            double cacheEvictionRate = this.calcCurrentCacheEvictionRate();
            if (cacheEvictionRate > (double)TooFrequentCodeStyleComputationWatcherKt.access$getHIGH_CACHE_EVICTION_RATE_THRESHOLD()) {
                if (this.cacheEvictionTrackingStart == -1L) {
                    this.cacheEvictionTrackingStart = currentTime;
                    this.settingsModCountAtTrackingStart = this.getCurrentProjectSettingsModCount();
                    LOG.info("High cache eviction rate (" + cacheEvictionRate + "), tracking started");
                } else {
                    long evictionTrackingDuration = currentTime - this.cacheEvictionTrackingStart;
                    if (evictionTrackingDuration > TooFrequentCodeStyleComputationWatcherKt.access$getHIGH_CACHE_EVICTION_RATE_MIN_DURATION()) {
                        StringBuilder stringBuilder;
                        StringBuilder $this$checkEvictionRate_u24lambda_u240 = stringBuilder = new StringBuilder();
                        boolean bl = false;
                        $this$checkEvictionRate_u24lambda_u240.append("Too high cache eviction rate detected").append('\n');
                        this.dumpState($this$checkEvictionRate_u24lambda_u240, cacheEvictionRate);
                        String dump = stringBuilder.toString();
                        Attachment attachment = new Attachment("codeStyleCacheDump.txt", dump);
                        String string = ThreadDumper.dumpThreadsToString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dumpThreadsToString(...)");
                        String threadDump = string;
                        Attachment attachment2 = new Attachment("threadDump.txt", threadDump);
                        Attachment[] attachmentArray = new Attachment[]{attachment, attachment2};
                        LOG.error("Too high code style cache eviction rate detected.", attachmentArray);
                        this.stopEvictionTracking(true, cacheEvictionRate);
                    }
                }
            } else {
                this.stopEvictionTracking(false, cacheEvictionRate);
            }
        } else {
            this.stopEvictionTracking(false, null);
        }
        this.lastCacheAccessTime = currentTime;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final synchronized String dumpState(@NotNull StringBuilder sb, double currentEvictionRate) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        sb.append("Opened editors:").append('\n');
        List list2 = EditorFactory.getInstance().getEditorList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEditorList(...)");
        Iterable iterable = list2;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Editor it = (Editor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getProject(), (Object)this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor it = (Editor)element$iv;
            boolean bl = false;
            sb.append(it.toString()).append('\n');
        }
        sb.append("Project settings mod count at the start of the tracking: " + this.settingsModCountAtTrackingStart).append('\n');
        sb.append("Current project settings mod count: " + this.getCurrentProjectSettingsModCount()).append('\n');
        sb.append("Cache eviction tracking started at: " + this.cacheEvictionTrackingStart).append('\n');
        sb.append("Current time: " + System.currentTimeMillis()).append('\n');
        sb.append("Cache eviction tracking duration: " + (System.currentTimeMillis() - this.cacheEvictionTrackingStart)).append('\n');
        sb.append("Cache eviction rate: " + currentEvictionRate + " evictions per second").append('\n');
        CodeStyleCachingService codeStyleCachingService = CodeStyleCachingService.getInstance((Project)this.project);
        CodeStyleCachingServiceImpl codeStyleCachingServiceImpl = codeStyleCachingService instanceof CodeStyleCachingServiceImpl ? (CodeStyleCachingServiceImpl)codeStyleCachingService : null;
        if (codeStyleCachingServiceImpl != null) {
            codeStyleCachingServiceImpl.dumpState(sb);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isTooHighEvictionRateDetected() {
        return this.isEvictionTrackingBlocked();
    }

    private final boolean isEvictionTrackingBlocked() {
        return this.cacheEvictionTrackingStart == -2L;
    }

    private final void stopEvictionTracking(boolean blockTracking, Double rate) {
        if (!(!this.isEvictionTrackingBlocked())) {
            boolean bl = false;
            String string = "Tracking is already blocked";
            throw new IllegalArgumentException(string.toString());
        }
        if (blockTracking) {
            this.cacheEvictionTrackingStart = -2L;
            LOG.info("High cache eviction rate (" + rate + "): tracking stopped and blocked");
            return;
        }
        if (this.cacheEvictionTrackingStart != -1L) {
            this.cacheEvictionTrackingStart = -1L;
            LOG.info("High cache eviction rate (" + rate + "): tracking stopped");
        }
    }

    @JvmStatic
    @NotNull
    public static final TooFrequentCodeStyleComputationWatcher getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.codeStyle.impl"})
    @SourceDebugExtension(value={"SMAP\nTooFrequentCodeStyleComputationWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooFrequentCodeStyleComputationWatcher.kt\ncom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,155:1\n30#2,2:156\n*S KotlinDebug\n*F\n+ 1 TooFrequentCodeStyleComputationWatcher.kt\ncom/intellij/application/options/codeStyle/cache/TooFrequentCodeStyleComputationWatcher$Companion\n*L\n23#1:156,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TooFrequentCodeStyleComputationWatcher getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<TooFrequentCodeStyleComputationWatcher> serviceClass$iv = TooFrequentCodeStyleComputationWatcher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TooFrequentCodeStyleComputationWatcher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

