/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.editor.fonts.AppFontOptionsPanelKt;
import com.intellij.application.options.editor.fonts.FontFamilyCombo;
import com.intellij.application.options.editor.fonts.FontWeightCombo;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u000201B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u0013H\u0014J\u0006\u0010\u001e\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u0013H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010 H\u0014J\f\u0010#\u001a\u00020\u0013*\u00020$H\u0002J\u001b\u0010%\u001a\u0015\u0012\u000b\u0012\t\u0018\u00010'\u00a2\u0006\u0002\b(\u0012\u0004\u0012\u00020)0&H\u0014J\b\u0010*\u001a\u00020\u000bH\u0002J\b\u0010+\u001a\u00020\u000bH\u0002J\u0016\u0010,\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110.H\u0002J\b\u0010/\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel;", "Lcom/intellij/application/options/colors/AbstractFontOptionsPanel;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "defaultPreferences", "Lcom/intellij/openapi/editor/colors/impl/FontPreferencesImpl;", "getDefaultPreferences", "()Lcom/intellij/openapi/editor/colors/impl/FontPreferencesImpl;", "regularWeightCombo", "Lcom/intellij/application/options/editor/fonts/FontWeightCombo;", "boldWeightCombo", "isReadOnly", "", "isDelegating", "getFontPreferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "setFontSize", "", "fontSize", "", "", "getLineSpacing", "setCurrentLineSpacing", "lineSpacing", "createPrimaryFontCombo", "Lcom/intellij/ui/AbstractFontCombo;", "createSecondaryFontCombo", "addControls", "updateOnChangedFont", "createControls", "Ljavax/swing/JComponent;", "updateFontPreferences", "createCustomComponent", "createTypographySettings", "Lcom/intellij/ui/dsl/builder/Panel;", "createBoldFontHint", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "createRegularWeightCombo", "createBoldWeightCombo", "changeFontPreferences", "consumer", "Ljava/util/function/Consumer;", "updateOptionsList", "RegularFontWeightCombo", "BoldFontWeightCombo", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAppFontOptionsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppFontOptionsPanel.kt\ncom/intellij/application/options/editor/fonts/AppFontOptionsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public class AppFontOptionsPanel
extends AbstractFontOptionsPanel {
    @NotNull
    private final EditorColorsScheme scheme;
    @NotNull
    private final FontPreferencesImpl defaultPreferences;
    @Nullable
    private FontWeightCombo regularWeightCombo;
    @Nullable
    private FontWeightCombo boldWeightCombo;

    public AppFontOptionsPanel(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.scheme = scheme;
        this.defaultPreferences = new FontPreferencesImpl();
        this.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                this.updateFontPreferences();
            }
        });
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)((ModifiableFontPreferences)this.defaultPreferences));
        this.updateOptionsList();
    }

    @NotNull
    protected final FontPreferencesImpl getDefaultPreferences() {
        return this.defaultPreferences;
    }

    @Override
    protected boolean isReadOnly() {
        return false;
    }

    @Override
    protected boolean isDelegating() {
        return false;
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.scheme.getFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
        return fontPreferences;
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
    }

    @Override
    protected void setFontSize(float fontSize) {
        this.scheme.setEditorFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.scheme.getLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.scheme.setLineSpacing(lineSpacing);
    }

    @Override
    @Nullable
    protected AbstractFontCombo<?> createPrimaryFontCombo() {
        return new FontFamilyCombo(true);
    }

    @Override
    @Nullable
    protected AbstractFontCombo<?> createSecondaryFontCombo() {
        return new FontFamilyCombo(false);
    }

    @Override
    protected void addControls() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createControls(), "Center");
    }

    public final void updateOnChangedFont() {
        this.updateOptionsList();
        this.fireFontChanged();
    }

    @Override
    @NotNull
    protected JComponent createControls() {
        JBPanel jBPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createControls$lambda$0(this, arg_0))).withBorder(JBUI.Borders.empty((int)5));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (JComponent)jBPanel;
    }

    public void updateFontPreferences() {
        block1: {
            FontWeightCombo fontWeightCombo;
            FontWeightCombo fontWeightCombo2 = this.regularWeightCombo;
            if (fontWeightCombo2 != null) {
                FontWeightCombo $this$updateFontPreferences_u24lambda_u240 = fontWeightCombo = fontWeightCombo2;
                boolean bl = false;
                $this$updateFontPreferences_u24lambda_u240.update(this.getFontPreferences());
            }
            FontWeightCombo fontWeightCombo3 = this.boldWeightCombo;
            if (fontWeightCombo3 == null) break block1;
            FontWeightCombo $this$updateFontPreferences_u24lambda_u241 = fontWeightCombo = fontWeightCombo3;
            boolean bl = false;
            $this$updateFontPreferences_u24lambda_u241.update(this.getFontPreferences());
        }
    }

    @Nullable
    protected JComponent createCustomComponent() {
        return null;
    }

    private final void createTypographySettings(Panel $this$createTypographySettings) {
        String string = ApplicationBundle.message((String)"settings.editor.font.typography.settings", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createTypographySettings.collapsibleGroup(string, false, (Function1<? super Panel, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0(this, arg_0)));
    }

    @NotNull
    protected Pair<String, HyperlinkEventAction> createBoldFontHint() {
        return new Pair(null, (Object)HyperlinkEventAction.HTML_HYPERLINK_INSTANCE);
    }

    private final FontWeightCombo createRegularWeightCombo() {
        RegularFontWeightCombo result2 = new RegularFontWeightCombo();
        AppFontOptionsPanelKt.access$fixComboWidth(result2);
        result2.addActionListener(arg_0 -> AppFontOptionsPanel.createRegularWeightCombo$lambda$0(this, result2, arg_0));
        return result2;
    }

    private final FontWeightCombo createBoldWeightCombo() {
        BoldFontWeightCombo result2 = new BoldFontWeightCombo();
        AppFontOptionsPanelKt.access$fixComboWidth(result2);
        result2.addActionListener(arg_0 -> AppFontOptionsPanel.createBoldWeightCombo$lambda$0(this, result2, arg_0));
        return result2;
    }

    private final void changeFontPreferences(Consumer<FontPreferences> consumer) {
        FontPreferences preferences = this.getFontPreferences();
        consumer.accept(preferences);
        this.fireFontChanged();
    }

    @Override
    public void updateOptionsList() {
        block1: {
            super.updateOptionsList();
            FontWeightCombo fontWeightCombo = this.regularWeightCombo;
            if (fontWeightCombo != null) {
                fontWeightCombo.setEnabled(!this.isReadOnly());
            }
            FontWeightCombo fontWeightCombo2 = this.boldWeightCombo;
            if (fontWeightCombo2 == null) break block1;
            fontWeightCombo2.setEnabled(!this.isReadOnly());
        }
    }

    private static final Unit createControls$lambda$0(AppFontOptionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(this$0.getPrimaryLabel(), (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createControls$lambda$0$0(this$0, arg_0)));
        $this$panel.row(this$0.getSizeLabel(), (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createControls$lambda$0$1(this$0, arg_0))).bottomGap(BottomGap.SMALL);
        Panel.row$default($this$panel, null, arg_0 -> AppFontOptionsPanel.createControls$lambda$0$2(this$0, arg_0), 1, null).layout(RowLayout.INDEPENDENT).bottomGap(BottomGap.SMALL);
        JComponent customComponent = this$0.createCustomComponent();
        if (customComponent != null) {
            Panel.row$default($this$panel, null, arg_0 -> AppFontOptionsPanel.createControls$lambda$0$3(customComponent, arg_0), 1, null);
        }
        if (FontFamilyService.isServiceSupported()) {
            this$0.createTypographySettings($this$panel);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$0(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AbstractFontCombo<?> abstractFontCombo = this$0.getPrimaryCombo();
        Intrinsics.checkNotNullExpressionValue(abstractFontCombo, (String)"getPrimaryCombo(...)");
        $this$row.cell((JComponent)((Object)abstractFontCombo));
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$1(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JTextField jTextField = this$0.getEditorFontSizeField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getEditorFontSizeField(...)");
        $this$row.cell((JComponent)jTextField);
        JTextField jTextField2 = this$0.getLineSpacingField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField2, (String)"getLineSpacingField(...)");
        Cell<JComponent> cell = $this$row.cell((JComponent)jTextField2);
        JLabel jLabel = this$0.getLineSpacingLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"getLineSpacingLabel(...)");
        Cell.label$default(cell, jLabel, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$2(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JCheckBox jCheckBox = this$0.getEnableLigaturesCheckbox();
        Intrinsics.checkNotNullExpressionValue((Object)jCheckBox, (String)"getEnableLigaturesCheckbox(...)");
        $this$row.cell((JComponent)jCheckBox).gap(RightGap.SMALL);
        JLabel jLabel = this$0.getEnableLigaturesHintLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"getEnableLigaturesHintLabel(...)");
        $this$row.cell((JComponent)jLabel);
        return Unit.INSTANCE;
    }

    private static final Unit createControls$lambda$0$3(JComponent $customComponent, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($customComponent);
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0(AppFontOptionsPanel this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        String string = ApplicationBundle.message((String)"settings.editor.font.main.weight", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$collapsibleGroup.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$0(this$0, arg_0)));
        String string2 = ApplicationBundle.message((String)"settings.editor.font.bold.weight", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$collapsibleGroup.row(string2, (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$1(this$0, arg_0))).bottomGap(BottomGap.SMALL);
        JLabel secondaryFont = new JLabel(ApplicationBundle.message((String)"secondary.font", (Object[])new Object[0]));
        this$0.setSecondaryFontLabel(secondaryFont);
        $this$collapsibleGroup.row(secondaryFont, (Function1<? super Row, Unit>)((Function1)arg_0 -> AppFontOptionsPanel.createTypographySettings$lambda$0$2(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$0(AppFontOptionsPanel this$0, Row $this$row) {
        FontWeightCombo component2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.regularWeightCombo = component2 = this$0.createRegularWeightCombo();
        $this$row.cell((JComponent)((Object)component2));
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$1(AppFontOptionsPanel this$0, Row $this$row) {
        FontWeightCombo component2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.boldWeightCombo = component2 = this$0.createBoldWeightCombo();
        Pair<String, HyperlinkEventAction> boldFontHint = this$0.createBoldFontHint();
        $this$row.cell((JComponent)((Object)component2)).comment((String)boldFontHint.getFirst(), 70, (HyperlinkEventAction)boldFontHint.getSecond());
        return Unit.INSTANCE;
    }

    private static final Unit createTypographySettings$lambda$0$2(AppFontOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AbstractFontCombo<?> abstractFontCombo = this$0.getSecondaryCombo();
        Intrinsics.checkNotNullExpressionValue(abstractFontCombo, (String)"getSecondaryCombo(...)");
        Cell.comment$default($this$row.cell((JComponent)((Object)abstractFontCombo)), ApplicationBundle.message((String)"label.fallback.fonts.list.description", (Object[])new Object[0]), 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final void createRegularWeightCombo$lambda$0(AppFontOptionsPanel this$0, RegularFontWeightCombo $result, ActionEvent it) {
        this$0.changeFontPreferences(arg_0 -> AppFontOptionsPanel.createRegularWeightCombo$lambda$0$0($result, arg_0));
    }

    private static final void createRegularWeightCombo$lambda$0$0(RegularFontWeightCombo $result, FontPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        if (preferences instanceof ModifiableFontPreferences) {
            String newSubFamily = $result.getSelectedSubFamily();
            if (!Intrinsics.areEqual((Object)((ModifiableFontPreferences)preferences).getRegularSubFamily(), (Object)newSubFamily)) {
                ((ModifiableFontPreferences)preferences).setBoldSubFamily(null);
            }
            ((ModifiableFontPreferences)preferences).setRegularSubFamily(newSubFamily);
        }
    }

    private static final void createBoldWeightCombo$lambda$0(AppFontOptionsPanel this$0, BoldFontWeightCombo $result, ActionEvent it) {
        this$0.changeFontPreferences(arg_0 -> AppFontOptionsPanel.createBoldWeightCombo$lambda$0$0($result, arg_0));
    }

    private static final void createBoldWeightCombo$lambda$0$0(BoldFontWeightCombo $result, FontPreferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        if (preferences instanceof ModifiableFontPreferences) {
            ((ModifiableFontPreferences)preferences).setBoldSubFamily($result.getSelectedSubFamily());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel$BoldFontWeightCombo;", "Lcom/intellij/application/options/editor/fonts/FontWeightCombo;", "<init>", "(Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel;)V", "getSubFamily", "", "preferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "getRecommendedSubFamily", "family", "intellij.platform.ide.impl"})
    private final class BoldFontWeightCombo
    extends FontWeightCombo {
        public BoldFontWeightCombo() {
            super(true);
        }

        @Override
        @Nullable
        protected String getSubFamily(@NotNull FontPreferences preferences) {
            Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
            return preferences.getBoldSubFamily();
        }

        @Override
        @NotNull
        protected String getRecommendedSubFamily(@NotNull String family) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            FontWeightCombo fontWeightCombo = AppFontOptionsPanel.this.regularWeightCombo;
            String string = FontFamilyService.getRecommendedBoldSubFamily((String)family, (String)((String)ObjectUtils.notNull((Object)(fontWeightCombo != null ? fontWeightCombo.getSelectedSubFamily() : null), (Object)FontFamilyService.getRecommendedSubFamily((String)family))));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRecommendedBoldSubFamily(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/application/options/editor/fonts/AppFontOptionsPanel$RegularFontWeightCombo;", "Lcom/intellij/application/options/editor/fonts/FontWeightCombo;", "<init>", "()V", "getSubFamily", "", "preferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "getRecommendedSubFamily", "family", "intellij.platform.ide.impl"})
    private static final class RegularFontWeightCombo
    extends FontWeightCombo {
        public RegularFontWeightCombo() {
            super(false);
        }

        @Override
        @Nullable
        protected String getSubFamily(@NotNull FontPreferences preferences) {
            Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
            return preferences.getRegularSubFamily();
        }

        @Override
        @NotNull
        protected String getRecommendedSubFamily(@NotNull String family) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            String string = FontFamilyService.getRecommendedSubFamily((String)family);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRecommendedSubFamily(...)");
            return string;
        }
    }
}

