/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialRequestResult;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.RememberCheckBoxState;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AppIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.text.StringKt;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00012\b\b\u0001\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0007\u001aZ\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00012\b\b\u0001\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u00a8\u0006\u0013"}, d2={"askPassword", "", "project", "Lcom/intellij/openapi/project/Project;", "dialogTitle", "passwordFieldLabel", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "resetPassword", "", "error", "askCredentials", "Lcom/intellij/credentialStore/CredentialRequestResult;", "isSaveOnOk", "isCheckExistingBeforeDialog", "isResetPassword", "getTrimmedChars", "", "Ljavax/swing/JPasswordField;", "intellij.platform.ide.impl"})
@JvmName(name="CredentialPromptDialog")
public final class CredentialPromptDialog {
    @JvmOverloads
    @Nullable
    public static final String askPassword(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes, boolean resetPassword, @NlsContexts.DialogMessage @Nullable String error2) {
        String string;
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        CredentialRequestResult credentialRequestResult = CredentialPromptDialog.askCredentials$default(project2, dialogTitle, passwordFieldLabel, attributes, false, true, resetPassword, error2, 16, null);
        return credentialRequestResult != null && (credentials = credentialRequestResult.getCredentials()) != null && (string = credentials.getPasswordAsString()) != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null;
    }

    public static /* synthetic */ String askPassword$default(Project project2, String string, String string2, CredentialAttributes credentialAttributes, boolean bl, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return CredentialPromptDialog.askPassword(project2, string, string2, credentialAttributes, bl, string3);
    }

    @JvmOverloads
    @Nullable
    public static final CredentialRequestResult askCredentials(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes, boolean isSaveOnOk, boolean isCheckExistingBeforeDialog, boolean isResetPassword, @NlsContexts.DialogMessage @Nullable String error2) {
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        PasswordSafe store = PasswordSafe.Companion.getInstance();
        if (isResetPassword) {
            store.set(attributes, null);
        } else if (isCheckExistingBeforeDialog && (credentials = store.get(attributes)) != null) {
            Credentials it = credentials;
            boolean bl = false;
            return new CredentialRequestResult(it, false);
        }
        return (CredentialRequestResult)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), () -> CredentialPromptDialog.askCredentials$lambda$1(project2, dialogTitle, error2, attributes, isSaveOnOk, passwordFieldLabel, store));
    }

    public static /* synthetic */ CredentialRequestResult askCredentials$default(Project project2, String string, String string2, CredentialAttributes credentialAttributes, boolean bl, boolean bl2, boolean bl3, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            string3 = null;
        }
        return CredentialPromptDialog.askCredentials(project2, string, string2, credentialAttributes, bl, bl2, bl3, string3);
    }

    @Nullable
    public static final char[] getTrimmedChars(@NotNull JPasswordField $this$getTrimmedChars) {
        int endIndex;
        Intrinsics.checkNotNullParameter((Object)$this$getTrimmedChars, (String)"<this>");
        Document doc = $this$getTrimmedChars.getDocument();
        int size2 = doc.getLength();
        if (size2 == 0) {
            return null;
        }
        Segment segment = new Segment();
        try {
            doc.getText(0, size2, segment);
        }
        catch (BadLocationException e) {
            return null;
        }
        char[] chars = segment.array;
        int startOffset = segment.offset;
        while (Character.isWhitespace(chars[startOffset])) {
            ++startOffset;
        }
        for (endIndex = segment.count; endIndex > startOffset && Character.isWhitespace(chars[endIndex - 1]); --endIndex) {
        }
        if (startOffset >= endIndex) {
            return null;
        }
        if (startOffset == 0 && endIndex == chars.length) {
            return chars;
        }
        Intrinsics.checkNotNull((Object)chars);
        char[] result2 = ArraysKt.copyOfRange((char[])chars, (int)startOffset, (int)endIndex);
        ArraysKt.fill((char[])chars, (char)'\u0000', (int)segment.offset, (int)segment.count);
        return result2;
    }

    @JvmOverloads
    @Nullable
    public static final String askPassword(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes, boolean resetPassword) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return CredentialPromptDialog.askPassword$default(project2, dialogTitle, passwordFieldLabel, attributes, resetPassword, null, 32, null);
    }

    @JvmOverloads
    @Nullable
    public static final String askPassword(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return CredentialPromptDialog.askPassword$default(project2, dialogTitle, passwordFieldLabel, attributes, false, null, 48, null);
    }

    @JvmOverloads
    @Nullable
    public static final CredentialRequestResult askCredentials(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes, boolean isSaveOnOk, boolean isCheckExistingBeforeDialog, boolean isResetPassword) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return CredentialPromptDialog.askCredentials$default(project2, dialogTitle, passwordFieldLabel, attributes, isSaveOnOk, isCheckExistingBeforeDialog, isResetPassword, null, 128, null);
    }

    @JvmOverloads
    @Nullable
    public static final CredentialRequestResult askCredentials(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes, boolean isSaveOnOk, boolean isCheckExistingBeforeDialog) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return CredentialPromptDialog.askCredentials$default(project2, dialogTitle, passwordFieldLabel, attributes, isSaveOnOk, isCheckExistingBeforeDialog, false, null, 192, null);
    }

    @JvmOverloads
    @Nullable
    public static final CredentialRequestResult askCredentials(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes, boolean isSaveOnOk) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return CredentialPromptDialog.askCredentials$default(project2, dialogTitle, passwordFieldLabel, attributes, isSaveOnOk, false, false, null, 224, null);
    }

    @JvmOverloads
    @Nullable
    public static final CredentialRequestResult askCredentials(@Nullable Project project2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Label @NotNull String passwordFieldLabel, @NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)passwordFieldLabel, (String)"passwordFieldLabel");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return CredentialPromptDialog.askCredentials$default(project2, dialogTitle, passwordFieldLabel, attributes, false, false, false, null, 240, null);
    }

    private static final CredentialRequestResult askCredentials$lambda$1(Project $project, String $dialogTitle, String $error, CredentialAttributes $attributes, boolean $isSaveOnOk, String $passwordFieldLabel, PasswordSafe $store) {
        JPasswordField passwordField = new JPasswordField();
        JCheckBox rememberCheckBox = RememberCheckBoxState.INSTANCE.createCheckBox("The password will be stored between application sessions.");
        DialogPanel panel2 = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> CredentialPromptDialog.askCredentials$lambda$1$0($passwordFieldLabel, passwordField, rememberCheckBox, arg_0)));
        AppIcon.getInstance().requestAttention($project, true);
        if (!ComponentsKt.dialog$default($dialogTitle, (JComponent)panel2, false, passwordField, false, $project, null, $error, null, null, null, 1876, null).showAndGet()) {
            return null;
        }
        RememberCheckBoxState.update(rememberCheckBox);
        Credentials credentials = new Credentials($attributes.getUserName(), CredentialPromptDialog.getTrimmedChars(passwordField));
        if ($isSaveOnOk && rememberCheckBox.isSelected()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CredentialPromptDialog.askCredentials$lambda$1$1($store, $attributes, credentials), $dialogTitle, false, $project);
            credentials.getPasswordAsString();
        }
        return new CredentialRequestResult(credentials, rememberCheckBox.isSelected());
    }

    private static final Unit askCredentials$lambda$1$0(String $passwordFieldLabel, JPasswordField $passwordField, JCheckBox $rememberCheckBox, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> CredentialPromptDialog.askCredentials$lambda$1$0$0($passwordFieldLabel, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> CredentialPromptDialog.askCredentials$lambda$1$0$1($passwordField, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> CredentialPromptDialog.askCredentials$lambda$1$0$2($rememberCheckBox, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit askCredentials$lambda$1$0$0(String $passwordFieldLabel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label((String)(StringsKt.endsWith$default((String)$passwordFieldLabel, (String)":", (boolean)false, (int)2, null) ? $passwordFieldLabel : $passwordFieldLabel + ":"));
        return Unit.INSTANCE;
    }

    private static final Unit askCredentials$lambda$1$0$1(JPasswordField $passwordField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$passwordField).resizableColumn().align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit askCredentials$lambda$1$0$2(JCheckBox $rememberCheckBox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$rememberCheckBox);
        return Unit.INSTANCE;
    }

    private static final void askCredentials$lambda$1$1(PasswordSafe $store, CredentialAttributes $attributes, Credentials $credentials) {
        $store.set($attributes, $credentials);
    }
}

