/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.AWTEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
final class DetailedEventWatcher
implements EventWatcher,
Disposable {
    private static final int PUBLISHER_DELAY = 1000;
    private static final Logger LOG = Logger.getInstance(DetailedEventWatcher.class);
    private static final Pattern DESCRIPTION_BY_EVENT = Pattern.compile("(([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)\\[(?<description>\\w+(,runnable=(?<runnable>[^,]+))?[^]]*)].*");
    private final ConcurrentMap<String, RunnablesListener.WrapperDescription> myWrappers = new ConcurrentHashMap<String, RunnablesListener.WrapperDescription>();
    private final ConcurrentMap<String, RunnablesListener.InvocationInfo> myDurationsByFqn = new ConcurrentHashMap<String, RunnablesListener.InvocationInfo>();
    private final ConcurrentLinkedQueue<RunnablesListener.InvocationDescription> myRunnables = new ConcurrentLinkedQueue();
    private final ConcurrentMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>> myEventsByClass = new ConcurrentHashMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>>();
    private final Map<? super AWTEvent, Long> myCurrentResults = new Object2LongOpenHashMap();
    @NotNull
    private final LogFileWriter myLogFileWriter = new LogFileWriter();
    @NotNull
    private final RegistryValue myThreshold;
    @NotNull
    private final ScheduledExecutorService myExecutor;
    @Nullable
    private ScheduledFuture<?> myFuture;

    DetailedEventWatcher() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(RunnablesListener.TOPIC, (Object)this.myLogFileWriter);
        this.myThreshold = RegistryManager.getInstance().get("ide.event.queue.dispatch.threshold");
        this.myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"EDT Events Logger", (int)1);
        this.myFuture = this.scheduleDumping();
    }

    /*
     * WARNING - void declaration
     */
    public void logTimeMillis(@NotNull String processId, long startedAtMs, @NotNull Class<? extends Runnable> clazz) {
        void runnableClass;
        if (processId == null) {
            DetailedEventWatcher.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            DetailedEventWatcher.$$$reportNull$$$0(1);
        }
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(processId, startedAtMs, System.currentTimeMillis());
        this.logTimeMillis(description, (Class<?>)runnableClass);
    }

    @RequiresEdt
    public void runnableTaskFinished(@NotNull Runnable runnable2, long waitedInQueueNs, int queueSize, long executionDurationNs, boolean bl) {
        if (runnable2 == null) {
            DetailedEventWatcher.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        long finishedAtMs = System.currentTimeMillis();
        long startedExecutionAtMs = finishedAtMs - TimeUnit.NANOSECONDS.toMillis(executionDurationNs);
        Class<?> runnableOrCallableClass = this.getCallableOrRunnableClass(runnable2);
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(runnableOrCallableClass.getName(), startedExecutionAtMs, finishedAtMs);
        this.myRunnables.offer(description);
        this.myDurationsByFqn.compute(description.getProcessId(), (fqn, info) -> RunnablesListener.InvocationInfo.computeNext(fqn, description.getDuration(), info));
        this.logTimeMillis(description, runnableOrCallableClass);
    }

    @RequiresEdt
    public void edtEventStarted(@NotNull AWTEvent event, long startedAtMs) {
        if (event == null) {
            DetailedEventWatcher.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myCurrentResults.put(event, startedAtMs);
    }

    @RequiresEdt
    public void edtEventFinished(@NotNull AWTEvent event, long finishedAtMs) {
        if (event == null) {
            DetailedEventWatcher.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(DetailedEventWatcher.toDescription(event.toString()), Objects.requireNonNull(this.myCurrentResults.remove(event)), finishedAtMs);
        Class<?> eventClass = event.getClass();
        this.myEventsByClass.putIfAbsent(eventClass, new ConcurrentLinkedQueue());
        ((ConcurrentLinkedQueue)this.myEventsByClass.get(eventClass)).offer(description);
    }

    public void reset() {
        this.myWrappers.clear();
        this.myDurationsByFqn.clear();
        this.myRunnables.clear();
        this.myEventsByClass.clear();
        this.reschedule(this.scheduleDumping());
    }

    public void dispose() {
        this.myLogFileWriter.dump();
        this.reschedule(null);
        this.myExecutor.shutdownNow();
    }

    private void reschedule(@Nullable ScheduledFuture<?> future) {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
        }
        this.myFuture = future;
    }

    @NotNull
    private ScheduledFuture<?> scheduleDumping() {
        ScheduledFuture<?> scheduledFuture = this.myExecutor.scheduleWithFixedDelay(() -> {
            Application application = ApplicationManager.getApplication();
            if (application != null && !application.isDisposed()) {
                this.dumpDescriptions((RunnablesListener)application.getMessageBus().syncPublisher(RunnablesListener.TOPIC));
            } else {
                this.reschedule(null);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            DetailedEventWatcher.$$$reportNull$$$0(5);
        }
        return scheduledFuture;
    }

    private void dumpDescriptions(@NotNull RunnablesListener publisher) {
        if (publisher == null) {
            DetailedEventWatcher.$$$reportNull$$$0(6);
        }
        this.myEventsByClass.forEach((eventClass, events) -> publisher.eventsProcessed((Class<? extends AWTEvent>)eventClass, (Collection<RunnablesListener.InvocationDescription>)DetailedEventWatcher.joinPolling(events)));
        publisher.runnablesProcessed(DetailedEventWatcher.joinPolling(this.myRunnables), this.myDurationsByFqn.values(), this.myWrappers.values());
    }

    @NotNull
    private Class<?> getCallableOrRunnableClass(@NotNull Runnable runnable2) {
        Class<?> rootClass;
        Field targetField;
        if (runnable2 == null) {
            DetailedEventWatcher.$$$reportNull$$$0(7);
        }
        Object current = runnable2;
        while (current != null && (targetField = ReflectionUtil.findFieldInHierarchy(rootClass = current.getClass(), field -> ReflectionUtil.isInstanceField((Field)field) && DetailedEventWatcher.isCallableOrRunnable(field))) != null) {
            this.myWrappers.compute(rootClass.getName(), RunnablesListener.WrapperDescription::computeNext);
            current = ReflectionUtil.getFieldValue((Field)targetField, (Object)current);
        }
        Class<?> clazz = (current != null ? current : runnable2).getClass();
        if (clazz == null) {
            DetailedEventWatcher.$$$reportNull$$$0(8);
        }
        return clazz;
    }

    private static boolean isCallableOrRunnable(@NotNull Field field) {
        Class<?> fieldType;
        if (field == null) {
            DetailedEventWatcher.$$$reportNull$$$0(9);
        }
        return ReflectionUtil.isAssignable(Runnable.class, fieldType = field.getType()) || ReflectionUtil.isAssignable(Callable.class, fieldType);
    }

    @NotNull
    private static <T> List<T> joinPolling(@NotNull Queue<? extends T> queue) {
        if (queue == null) {
            DetailedEventWatcher.$$$reportNull$$$0(10);
        }
        ArrayList<T> builder = new ArrayList<T>();
        while (!queue.isEmpty()) {
            builder.add(queue.poll());
        }
        List list2 = Collections.unmodifiableList(builder);
        if (list2 == null) {
            DetailedEventWatcher.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private void logTimeMillis(@NotNull RunnablesListener.InvocationDescription description, @NotNull Class<?> runnableClass) {
        int threshold;
        if (description == null) {
            DetailedEventWatcher.$$$reportNull$$$0(12);
        }
        if (runnableClass == null) {
            DetailedEventWatcher.$$$reportNull$$$0(13);
        }
        if ((threshold = this.myThreshold.asInteger()) < 0 || (long)threshold > description.getDuration()) {
            return;
        }
        LOG.info(description.toString());
        if (runnableClass != Runnable.class) {
            DetailedEventWatcher.addPluginCost(runnableClass, description.getDuration());
        }
    }

    private static void addPluginCost(@NotNull Class<?> runnableClass, long duration2) {
        if (runnableClass == null) {
            DetailedEventWatcher.$$$reportNull$$$0(14);
        }
        ClassLoader loader = runnableClass.getClassLoader();
        String pluginId = PluginUtil.getPluginId((ClassLoader)loader).getIdString();
        StartUpMeasurer.addPluginCost((String)pluginId, (String)"invokeLater", (long)TimeUnit.MILLISECONDS.toNanos(duration2));
    }

    @NotNull
    private static String toDescription(@NotNull String string) {
        Matcher matcher;
        if (string == null) {
            DetailedEventWatcher.$$$reportNull$$$0(15);
        }
        MatchResult matchResult = (matcher = DESCRIPTION_BY_EVENT.matcher(string)).find() ? matcher.toMatchResult() : null;
        String string2 = matchResult instanceof Matcher ? matchResult.group("description") : string;
        if (string2 == null) {
            DetailedEventWatcher.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processId";
                break;
            }
            case 1: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnableClass";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/DetailedEventWatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisher";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/DetailedEventWatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleDumping";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableOrRunnableClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPolling";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logTimeMillis";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runnableTaskFinished";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "edtEventStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "edtEventFinished";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumpDescriptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCallableOrRunnableClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCallableOrRunnable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinPolling";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPluginCost";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 11, 16 -> new IllegalStateException(string);
        };
    }

    private static final class LogFileWriter
    implements RunnablesListener {
        private final File myLogDir = new File(new File(PathManager.getLogPath(), "edt-log"), new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(System.currentTimeMillis())));
        private final ArrayList<RunnablesListener.InvocationInfo> myInfos = new ArrayList();
        private final ArrayList<RunnablesListener.WrapperDescription> myWrappers = new ArrayList();

        private LogFileWriter() {
        }

        @Override
        public void eventsProcessed(@NotNull Class<? extends AWTEvent> eventClass, @NotNull Collection<RunnablesListener.InvocationDescription> descriptions) {
            if (eventClass == null) {
                LogFileWriter.$$$reportNull$$$0(0);
            }
            if (descriptions == null) {
                LogFileWriter.$$$reportNull$$$0(1);
            }
            this.appendToFile(eventClass.getSimpleName(), descriptions);
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            if (invocations == null) {
                LogFileWriter.$$$reportNull$$$0(2);
            }
            if (infos == null) {
                LogFileWriter.$$$reportNull$$$0(3);
            }
            if (wrappers == null) {
                LogFileWriter.$$$reportNull$$$0(4);
            }
            this.appendToFile("Runnables", invocations);
            this.myInfos.addAll(infos);
            this.myWrappers.addAll(wrappers);
        }

        private void dump() {
            this.sortAndDumpToFile("Timings", this.myInfos);
            this.sortAndDumpToFile("Wrappers", this.myWrappers);
        }

        private <T> void appendToFile(@NotNull String fileName, @NotNull Collection<? extends T> entities) {
            if (fileName == null) {
                LogFileWriter.$$$reportNull$$$0(5);
            }
            if (entities == null) {
                LogFileWriter.$$$reportNull$$$0(6);
            }
            this.writeToFile(fileName, entities, true);
        }

        private <T> void writeToFile(@NotNull String fileName, @NotNull Collection<? extends T> entities, boolean append) {
            if (fileName == null) {
                LogFileWriter.$$$reportNull$$$0(7);
            }
            if (entities == null) {
                LogFileWriter.$$$reportNull$$$0(8);
            }
            if (!this.myLogDir.isDirectory() && !this.myLogDir.mkdirs()) {
                LOG.debug(this.myLogDir.getAbsolutePath() + " cannot be created");
                return;
            }
            try {
                FileUtil.writeToFile((File)new File(this.myLogDir, fileName + ".log"), (String)StringUtil.join(entities, Objects::toString, (String)"\n"), (boolean)append);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }

        private <T extends Comparable<? super T>> void sortAndDumpToFile(@NotNull String fileName, @NotNull List<? extends T> entities) {
            if (fileName == null) {
                LogFileWriter.$$$reportNull$$$0(9);
            }
            if (entities == null) {
                LogFileWriter.$$$reportNull$$$0(10);
            }
            this.writeToFile(fileName, ContainerUtil.sorted(entities), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entities";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagnostic/DetailedEventWatcher$LogFileWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eventsProcessed";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runnablesProcessed";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendToFile";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeToFile";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortAndDumpToFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

