/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EdtLockLoadListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionListener;
import com.intellij.openapi.application.WriteIntentReadActionListener;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.CoroutinesKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/EdtLockLoadMonitorService;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "listener", "Lcom/intellij/diagnostic/EdtLockLoadListener;", "initialize", "", "export", "Lcom/intellij/diagnostic/EdtLockLoadMonitorService$MeasurementData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MeasurementData", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEdtLockLoadMonitorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EdtLockLoadMonitorService.kt\ncom/intellij/diagnostic/EdtLockLoadMonitorService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n23#2:83\n*S KotlinDebug\n*F\n+ 1 EdtLockLoadMonitorService.kt\ncom/intellij/diagnostic/EdtLockLoadMonitorService\n*L\n37#1:83\n*E\n"})
public final class EdtLockLoadMonitorService {
    @NotNull
    private final EdtLockLoadListener listener;

    public EdtLockLoadMonitorService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.listener = new EdtLockLoadListener();
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EdtLockLoadMonitorService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.this$0.export((Continuation<? super MeasurementData>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        data = (MeasurementData)v0;
                        $i$f$logger = false;
                        v1 = Logger.getInstance(EdtLockLoadMonitorService.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                        v1.info("EDT lock load monitor data:\n" + data.getReadLockDurationRatio() * (double)100 + "% read lock load (lock acquisition duration: " + Duration.toString-impl((long)data.getTimeToReadLockDuration-UwyO8pc()) + "; lock held duration: " + Duration.toString-impl((long)data.getReadLockDurationTotal-UwyO8pc()) + ");\n" + data.getWriteLockDurationRatio() * (double)100 + "% write lock load (total acquisition duration: " + Duration.toString-impl((long)data.getTimeToWriteLockDuration-UwyO8pc()) + "; lock held duration: " + Duration.toString-impl((long)data.getWriteLockDurationTotal-UwyO8pc()) + ");\n" + data.getWriteIntentLockDurationRatio() * (double)100 + "% write intent lock load (total acquisition duration: " + Duration.toString-impl((long)data.getTimeToWriteIntentLockDuration-UwyO8pc()) + "; lock held duration: " + Duration.toString-impl((long)data.getWriteIntentLockDurationTotal-UwyO8pc()) + ");");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void initialize() {
        Application application = ApplicationManager.getApplication();
        if (!(application instanceof ApplicationEx)) {
            EdtLockLoadMonitorService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(EdtLockLoadMonitorService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("EDT lock load monitor is disabled: application is not an instance of ApplicationEx");
            return;
        }
        ApplicationEx $this$initialize_u24lambda_u240 = (ApplicationEx)application;
        boolean bl = false;
        ((ApplicationEx)application).addApplicationListener((ApplicationListener)this.listener, (Disposable)application);
        ((ApplicationEx)application).addReadActionListener((ReadActionListener)this.listener, (Disposable)application);
        ((ApplicationEx)application).addWriteIntentReadActionListener((WriteIntentReadActionListener)this.listener, (Disposable)application);
    }

    @Nullable
    public final Object export(@NotNull Continuation<? super MeasurementData> $completion) {
        return BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MeasurementData>, Object>(this, null){
            int label;
            final /* synthetic */ EdtLockLoadMonitorService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return EdtLockLoadMonitorService.access$getListener$p(this.this$0).export();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super MeasurementData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ EdtLockLoadListener access$getListener$p(EdtLockLoadMonitorService $this) {
        return $this.listener;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b \u0010\rJ\u0010\u0010!\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010\rJ\u0010\u0010#\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b$\u0010\rJ\u0010\u0010%\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010\rJ\u0010\u0010'\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b(\u0010\rJ\u0010\u0010)\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b*\u0010\rJ\u0010\u0010+\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b,\u0010\rJV\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b.\u0010/J\u0013\u00100\u001a\u0002012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0012\u0010\rR\u0013\u0010\b\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0013\u0010\rR\u0013\u0010\t\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\u00a8\u00066"}, d2={"Lcom/intellij/diagnostic/EdtLockLoadMonitorService$MeasurementData;", "", "totalDuration", "Lkotlin/time/Duration;", "timeToWriteLockDuration", "writeLockDurationTotal", "timeToReadLockDuration", "readLockDurationTotal", "timeToWriteIntentLockDuration", "writeIntentLockDurationTotal", "<init>", "(JJJJJJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getTotalDuration-UwyO8pc", "()J", "J", "getTimeToWriteLockDuration-UwyO8pc", "getWriteLockDurationTotal-UwyO8pc", "getTimeToReadLockDuration-UwyO8pc", "getReadLockDurationTotal-UwyO8pc", "getTimeToWriteIntentLockDuration-UwyO8pc", "getWriteIntentLockDurationTotal-UwyO8pc", "writeLockDurationRatio", "", "getWriteLockDurationRatio", "()D", "readLockDurationRatio", "getReadLockDurationRatio", "writeIntentLockDurationRatio", "getWriteIntentLockDurationRatio", "minus", "other", "component1", "component1-UwyO8pc", "component2", "component2-UwyO8pc", "component3", "component3-UwyO8pc", "component4", "component4-UwyO8pc", "component5", "component5-UwyO8pc", "component6", "component6-UwyO8pc", "component7", "component7-UwyO8pc", "copy", "copy-fepV_jM", "(JJJJJJJ)Lcom/intellij/diagnostic/EdtLockLoadMonitorService$MeasurementData;", "equals", "", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static final class MeasurementData {
        private final long totalDuration;
        private final long timeToWriteLockDuration;
        private final long writeLockDurationTotal;
        private final long timeToReadLockDuration;
        private final long readLockDurationTotal;
        private final long timeToWriteIntentLockDuration;
        private final long writeIntentLockDurationTotal;

        private MeasurementData(long totalDuration, long timeToWriteLockDuration, long writeLockDurationTotal, long timeToReadLockDuration, long readLockDurationTotal, long timeToWriteIntentLockDuration, long writeIntentLockDurationTotal) {
            this.totalDuration = totalDuration;
            this.timeToWriteLockDuration = timeToWriteLockDuration;
            this.writeLockDurationTotal = writeLockDurationTotal;
            this.timeToReadLockDuration = timeToReadLockDuration;
            this.readLockDurationTotal = readLockDurationTotal;
            this.timeToWriteIntentLockDuration = timeToWriteIntentLockDuration;
            this.writeIntentLockDurationTotal = writeIntentLockDurationTotal;
        }

        public final long getTotalDuration-UwyO8pc() {
            return this.totalDuration;
        }

        public final long getTimeToWriteLockDuration-UwyO8pc() {
            return this.timeToWriteLockDuration;
        }

        public final long getWriteLockDurationTotal-UwyO8pc() {
            return this.writeLockDurationTotal;
        }

        public final long getTimeToReadLockDuration-UwyO8pc() {
            return this.timeToReadLockDuration;
        }

        public final long getReadLockDurationTotal-UwyO8pc() {
            return this.readLockDurationTotal;
        }

        public final long getTimeToWriteIntentLockDuration-UwyO8pc() {
            return this.timeToWriteIntentLockDuration;
        }

        public final long getWriteIntentLockDurationTotal-UwyO8pc() {
            return this.writeIntentLockDurationTotal;
        }

        public final double getWriteLockDurationRatio() {
            return (double)Duration.getInWholeNanoseconds-impl((long)Duration.plus-LRDsOJo((long)this.writeLockDurationTotal, (long)this.timeToWriteLockDuration)) / (double)Duration.getInWholeNanoseconds-impl((long)this.totalDuration);
        }

        public final double getReadLockDurationRatio() {
            return (double)Duration.getInWholeNanoseconds-impl((long)Duration.plus-LRDsOJo((long)this.readLockDurationTotal, (long)this.timeToReadLockDuration)) / (double)Duration.getInWholeNanoseconds-impl((long)this.totalDuration);
        }

        public final double getWriteIntentLockDurationRatio() {
            return (double)Duration.getInWholeNanoseconds-impl((long)Duration.plus-LRDsOJo((long)this.writeIntentLockDurationTotal, (long)this.timeToWriteIntentLockDuration)) / (double)Duration.getInWholeNanoseconds-impl((long)this.totalDuration);
        }

        @NotNull
        public final MeasurementData minus(@NotNull MeasurementData other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new MeasurementData(Duration.minus-LRDsOJo((long)this.totalDuration, (long)other.totalDuration), Duration.minus-LRDsOJo((long)this.timeToWriteLockDuration, (long)other.timeToWriteLockDuration), Duration.minus-LRDsOJo((long)this.writeLockDurationTotal, (long)other.writeLockDurationTotal), Duration.minus-LRDsOJo((long)this.timeToReadLockDuration, (long)other.timeToReadLockDuration), Duration.minus-LRDsOJo((long)this.readLockDurationTotal, (long)other.readLockDurationTotal), Duration.minus-LRDsOJo((long)this.timeToWriteIntentLockDuration, (long)other.timeToWriteIntentLockDuration), Duration.minus-LRDsOJo((long)this.writeIntentLockDurationTotal, (long)other.writeIntentLockDurationTotal), null);
        }

        public final long component1-UwyO8pc() {
            return this.totalDuration;
        }

        public final long component2-UwyO8pc() {
            return this.timeToWriteLockDuration;
        }

        public final long component3-UwyO8pc() {
            return this.writeLockDurationTotal;
        }

        public final long component4-UwyO8pc() {
            return this.timeToReadLockDuration;
        }

        public final long component5-UwyO8pc() {
            return this.readLockDurationTotal;
        }

        public final long component6-UwyO8pc() {
            return this.timeToWriteIntentLockDuration;
        }

        public final long component7-UwyO8pc() {
            return this.writeIntentLockDurationTotal;
        }

        @NotNull
        public final MeasurementData copy-fepV_jM(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
            return new MeasurementData(l, l2, l3, l4, l5, l6, l7, null);
        }

        public static /* synthetic */ MeasurementData copy-fepV_jM$default(MeasurementData measurementData, long l, long l2, long l3, long l4, long l5, long l6, long l7, int n, Object object) {
            if ((n & 1) != 0) {
                l = measurementData.totalDuration;
            }
            if ((n & 2) != 0) {
                l2 = measurementData.timeToWriteLockDuration;
            }
            if ((n & 4) != 0) {
                l3 = measurementData.writeLockDurationTotal;
            }
            if ((n & 8) != 0) {
                l4 = measurementData.timeToReadLockDuration;
            }
            if ((n & 0x10) != 0) {
                l5 = measurementData.readLockDurationTotal;
            }
            if ((n & 0x20) != 0) {
                l6 = measurementData.timeToWriteIntentLockDuration;
            }
            if ((n & 0x40) != 0) {
                l7 = measurementData.writeIntentLockDurationTotal;
            }
            return measurementData.copy-fepV_jM(l, l2, l3, l4, l5, l6, l7);
        }

        @NotNull
        public String toString() {
            return "MeasurementData(totalDuration=" + Duration.toString-impl((long)this.totalDuration) + ", timeToWriteLockDuration=" + Duration.toString-impl((long)this.timeToWriteLockDuration) + ", writeLockDurationTotal=" + Duration.toString-impl((long)this.writeLockDurationTotal) + ", timeToReadLockDuration=" + Duration.toString-impl((long)this.timeToReadLockDuration) + ", readLockDurationTotal=" + Duration.toString-impl((long)this.readLockDurationTotal) + ", timeToWriteIntentLockDuration=" + Duration.toString-impl((long)this.timeToWriteIntentLockDuration) + ", writeIntentLockDurationTotal=" + Duration.toString-impl((long)this.writeIntentLockDurationTotal) + ")";
        }

        public int hashCode() {
            int result2 = Duration.hashCode-impl((long)this.totalDuration);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.timeToWriteLockDuration);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.writeLockDurationTotal);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.timeToReadLockDuration);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.readLockDurationTotal);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.timeToWriteIntentLockDuration);
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.writeIntentLockDurationTotal);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeasurementData)) {
                return false;
            }
            MeasurementData measurementData = (MeasurementData)other;
            if (!Duration.equals-impl0((long)this.totalDuration, (long)measurementData.totalDuration)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.timeToWriteLockDuration, (long)measurementData.timeToWriteLockDuration)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.writeLockDurationTotal, (long)measurementData.writeLockDurationTotal)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.timeToReadLockDuration, (long)measurementData.timeToReadLockDuration)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.readLockDurationTotal, (long)measurementData.readLockDurationTotal)) {
                return false;
            }
            if (!Duration.equals-impl0((long)this.timeToWriteIntentLockDuration, (long)measurementData.timeToWriteIntentLockDuration)) {
                return false;
            }
            return Duration.equals-impl0((long)this.writeIntentLockDurationTotal, (long)measurementData.writeIntentLockDurationTotal);
        }

        public /* synthetic */ MeasurementData(long totalDuration, long timeToWriteLockDuration, long writeLockDurationTotal, long timeToReadLockDuration, long readLockDurationTotal, long timeToWriteIntentLockDuration, long writeIntentLockDurationTotal, DefaultConstructorMarker $constructor_marker) {
            this(totalDuration, timeToWriteLockDuration, writeLockDurationTotal, timeToReadLockDuration, readLockDurationTotal, timeToWriteIntentLockDuration, writeIntentLockDurationTotal);
        }
    }
}

