/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.WriteLockMeasurerImplKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteDelayDiagnostics;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.platform.locking.impl.listeners.LockAcquisitionListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/WriteLockMeasurementListener;", "Lcom/intellij/platform/locking/impl/listeners/LockAcquisitionListener;", "Lcom/intellij/diagnostic/WriteLockMeasurementListener$LockAcquisitionResult;", "<init>", "()V", "beforeWriteLockAcquired", "afterWriteLockAcquired", "", "beforeResult", "Holder", "LockAcquisitionResult", "intellij.platform.ide.impl"})
final class WriteLockMeasurementListener
implements LockAcquisitionListener<LockAcquisitionResult> {
    @Override
    @NotNull
    public LockAcquisitionResult beforeWriteLockAcquired() {
        int delay = Holder.INSTANCE.getOurDumpThreadsOnLongWriteActionWaiting();
        Future reportSlowWrite = delay <= 0 || PerformanceWatcher.Companion.getInstanceIfCreated() == null ? null : (Future)AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(WriteLockMeasurementListener::beforeWriteLockAcquired$lambda$0, delay, delay, TimeUnit.MILLISECONDS);
        long t = System.currentTimeMillis();
        return new LockAcquisitionResult(t, reportSlowWrite);
    }

    @Override
    public void afterWriteLockAcquired(@NotNull LockAcquisitionResult beforeResult) {
        block4: {
            long elapsed;
            Future<?> reportSlowWrite;
            block3: {
                Intrinsics.checkNotNullParameter((Object)beforeResult, (String)"beforeResult");
                long acquisitionMoment = beforeResult.component1();
                reportSlowWrite = beforeResult.component2();
                elapsed = System.currentTimeMillis() - acquisitionMoment;
                try {
                    WriteDelayDiagnostics.INSTANCE.registerWrite(elapsed);
                }
                catch (Throwable thr) {
                    if (thr instanceof ControlFlowException) break block3;
                    WriteLockMeasurerImplKt.access$getLogger$p().warn("Failed to register write lock in diagnostics service", thr);
                }
            }
            if (WriteLockMeasurerImplKt.access$getLogger$p().isDebugEnabled() && elapsed != 0L) {
                WriteLockMeasurerImplKt.access$getLogger$p().debug("Write action wait time: " + elapsed);
            }
            Future<?> future = reportSlowWrite;
            if (future == null) break block4;
            future.cancel(false);
        }
    }

    private static final void beforeWriteLockAcquired$lambda$0() {
        Path path = PerformanceWatcher.Companion.getInstance().dumpThreads("waiting", true, true);
        if (path != null && ApplicationManagerEx.isInIntegrationTest()) {
            String message = "Long write action takes more than " + Holder.INSTANCE.getOurDumpThreadsOnLongWriteActionWaiting() + "ms, details saved to " + path;
            WriteLockMeasurerImplKt.access$getLogger$p().error(message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/WriteLockMeasurementListener$Holder;", "", "<init>", "()V", "ourDumpThreadsOnLongWriteActionWaiting", "", "getOurDumpThreadsOnLongWriteActionWaiting", "()I", "intellij.platform.ide.impl"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE;
        private static final int ourDumpThreadsOnLongWriteActionWaiting;

        private Holder() {
        }

        public final int getOurDumpThreadsOnLongWriteActionWaiting() {
            return ourDumpThreadsOnLongWriteActionWaiting;
        }

        static {
            int n;
            INSTANCE = new Holder();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                n = 0;
            } else {
                Integer n2 = Integer.getInteger("dump.threads.on.long.write.action.waiting", 0);
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getInteger(...)");
                n = ((Number)n2).intValue();
            }
            ourDumpThreadsOnLongWriteActionWaiting = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/WriteLockMeasurementListener$LockAcquisitionResult;", "", "acquisitionMoment", "", "reportingFuture", "Ljava/util/concurrent/Future;", "<init>", "(JLjava/util/concurrent/Future;)V", "getAcquisitionMoment", "()J", "getReportingFuture", "()Ljava/util/concurrent/Future;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class LockAcquisitionResult {
        private final long acquisitionMoment;
        @Nullable
        private final Future<?> reportingFuture;

        public LockAcquisitionResult(long acquisitionMoment, @Nullable Future<?> reportingFuture) {
            this.acquisitionMoment = acquisitionMoment;
            this.reportingFuture = reportingFuture;
        }

        public final long getAcquisitionMoment() {
            return this.acquisitionMoment;
        }

        @Nullable
        public final Future<?> getReportingFuture() {
            return this.reportingFuture;
        }

        public final long component1() {
            return this.acquisitionMoment;
        }

        @Nullable
        public final Future<?> component2() {
            return this.reportingFuture;
        }

        @NotNull
        public final LockAcquisitionResult copy(long acquisitionMoment, @Nullable Future<?> reportingFuture) {
            return new LockAcquisitionResult(acquisitionMoment, reportingFuture);
        }

        public static /* synthetic */ LockAcquisitionResult copy$default(LockAcquisitionResult lockAcquisitionResult, long l, Future future, int n, Object object) {
            if ((n & 1) != 0) {
                l = lockAcquisitionResult.acquisitionMoment;
            }
            if ((n & 2) != 0) {
                future = lockAcquisitionResult.reportingFuture;
            }
            return lockAcquisitionResult.copy(l, future);
        }

        @NotNull
        public String toString() {
            return "LockAcquisitionResult(acquisitionMoment=" + this.acquisitionMoment + ", reportingFuture=" + this.reportingFuture + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.acquisitionMoment);
            result2 = result2 * 31 + (this.reportingFuture == null ? 0 : this.reportingFuture.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LockAcquisitionResult)) {
                return false;
            }
            LockAcquisitionResult lockAcquisitionResult = (LockAcquisitionResult)other;
            if (this.acquisitionMoment != lockAcquisitionResult.acquisitionMoment) {
                return false;
            }
            return Intrinsics.areEqual(this.reportingFuture, lockAcquisitionResult.reportingFuture);
        }
    }
}

