/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.action;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.HProfDatabaseKt;
import com.intellij.diagnostic.HeapDumpAnalysisSupport;
import com.intellij.diagnostic.hprof.action.AnalysisRunnable;
import com.intellij.diagnostic.hprof.analysis.LiveInstanceStats;
import com.intellij.diagnostic.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.MemoryDumpHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable;", "Ljava/lang/Runnable;", "reason", "Lcom/intellij/diagnostic/report/MemoryReportReason;", "analysisOption", "Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "<init>", "(Lcom/intellij/diagnostic/report/MemoryReportReason;Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;)V", "run", "", "estimateRequiredFreeSpaceInMB", "", "Companion", "AnalysisOption", "CaptureHeapDumpTask", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHeapDumpSnapshotRunnable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapDumpSnapshotRunnable.kt\ncom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable\n+ 2 HeapDumpSnapshotRunnable.kt\ncom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnableKt\n*L\n1#1,254:1\n49#2,5:255\n49#2,5:260\n*S KotlinDebug\n*F\n+ 1 HeapDumpSnapshotRunnable.kt\ncom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable\n*L\n96#1:255,5\n143#1:260,5\n*E\n"})
public final class HeapDumpSnapshotRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemoryReportReason reason;
    @NotNull
    private final AnalysisOption analysisOption;
    public static final int MINIMUM_USED_MEMORY_TO_CAPTURE_HEAP_DUMP_IN_MB = 800;
    @NotNull
    public static final String NEXT_CHECK_TIMESTAMP_KEY = "heap.dump.snapshot.next.check.timestamp";
    @NotNull
    private static final Logger LOG;

    public HeapDumpSnapshotRunnable(@NotNull MemoryReportReason reason, @NotNull AnalysisOption analysisOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)((Object)analysisOption), (String)"analysisOption");
        this.reason = reason;
        this.analysisOption = analysisOption;
    }

    @Override
    public void run() {
        long estimatedRequiredMB;
        LOG.info("HeapDumpSnapshotRunnable started: reason=" + this.reason + ", analysisOption=" + this.analysisOption);
        boolean userInvoked = this.reason.isUserInvoked();
        if (!userInvoked) {
            long currentTimestampMs;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Disabled for tests.");
                return;
            }
            if (!ApplicationManager.getApplication().isEAP()) {
                LOG.info("Heap dump analysis is enabled only on EAP builds.");
                return;
            }
            if (!Intrinsics.areEqual((Object)System.getProperty("sun.arch.data.model"), (Object)"64")) {
                LOG.info("Heap dump analysis supported only on 64-bit platforms.");
                return;
            }
            boolean withGC$iv = false;
            boolean $i$f$usedMemory = false;
            Runtime rt$iv = Runtime.getRuntime();
            long usedMemoryMB = (rt$iv.totalMemory() - rt$iv.freeMemory()) / (long)1000000;
            if (usedMemoryMB < 800L) {
                LOG.info("Heap dump too small: " + usedMemoryMB + " MB < 800 MB");
                return;
            }
            long nextCheckPropertyMs = PropertiesComponent.getInstance().getLong(NEXT_CHECK_TIMESTAMP_KEY, 0L);
            if (nextCheckPropertyMs > (currentTimestampMs = System.currentTimeMillis())) {
                String nextCheckDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date(nextCheckPropertyMs));
                LOG.info("Don't ask for snapshot until " + nextCheckDateString + ".");
                return;
            }
        }
        if (this.analysisOption == AnalysisOption.SCHEDULE_ON_NEXT_START && HeapDumpAnalysisSupport.Companion.getInstance().checkPendingSnapshot()) {
            return;
        }
        Path hprofPath = HProfDatabaseKt.getHprofDatabase().createHprofTemporaryFilePath();
        long spaceInMB = Files.getFileStore(hprofPath.getParent()).getUsableSpace() / (long)1000000;
        if (spaceInMB < (estimatedRequiredMB = this.estimateRequiredFreeSpaceInMB())) {
            LOG.info("Not enough space for heap dump: " + spaceInMB + " MB < " + estimatedRequiredMB + " MB");
            if (userInvoked) {
                Object[] objectArray = new Object[]{((Object)hprofPath.getParent()).toString(), estimatedRequiredMB, spaceInMB};
                String string = DiagnosticBundle.message("heap.dump.snapshot.no.space", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                Messages.showErrorDialog((String)message, (String)DiagnosticBundle.message("heap.dump.snapshot.title", new Object[0]));
            }
            return;
        }
        LOG.info("Capturing heap dump.");
        new CaptureHeapDumpTask(hprofPath, this.reason, this.analysisOption, userInvoked).queue();
    }

    private final long estimateRequiredFreeSpaceInMB() {
        long l = 100L;
        boolean withGC$iv = false;
        boolean $i$f$usedMemory = false;
        Runtime rt$iv = Runtime.getRuntime();
        long l2 = (long)((double)(rt$iv.totalMemory() - rt$iv.freeMemory()) * 2.0) / (long)1000000;
        return Math.max(l, l2);
    }

    static {
        Logger logger2 = Logger.getInstance(HeapDumpSnapshotRunnable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "", "<init>", "(Ljava/lang/String;I)V", "NO_ANALYSIS", "SCHEDULE_ON_NEXT_START", "IMMEDIATE", "intellij.platform.ide.impl"})
    public static final class AnalysisOption
    extends Enum<AnalysisOption> {
        public static final /* enum */ AnalysisOption NO_ANALYSIS = new AnalysisOption();
        public static final /* enum */ AnalysisOption SCHEDULE_ON_NEXT_START = new AnalysisOption();
        public static final /* enum */ AnalysisOption IMMEDIATE = new AnalysisOption();
        private static final /* synthetic */ AnalysisOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AnalysisOption[] values() {
            return (AnalysisOption[])$VALUES.clone();
        }

        public static AnalysisOption valueOf(String value) {
            return Enum.valueOf(AnalysisOption.class, value);
        }

        @NotNull
        public static EnumEntries<AnalysisOption> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = analysisOptionArray = new AnalysisOption[]{AnalysisOption.NO_ANALYSIS, AnalysisOption.SCHEDULE_ON_NEXT_START, AnalysisOption.IMMEDIATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$CaptureHeapDumpTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "hprofPath", "Ljava/nio/file/Path;", "reason", "Lcom/intellij/diagnostic/report/MemoryReportReason;", "analysisOption", "Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "restart", "", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/diagnostic/report/MemoryReportReason;Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;Z)V", "onSuccess", "", "onThrowable", "error", "", "confirmRestart", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "captureSnapshot", "intellij.platform.ide.impl"})
    public static final class CaptureHeapDumpTask
    extends Task.Modal {
        @NotNull
        private final Path hprofPath;
        @NotNull
        private final MemoryReportReason reason;
        @NotNull
        private final AnalysisOption analysisOption;
        private final boolean restart;

        public CaptureHeapDumpTask(@NotNull Path hprofPath, @NotNull MemoryReportReason reason, @NotNull AnalysisOption analysisOption, boolean restart) {
            Intrinsics.checkNotNullParameter((Object)hprofPath, (String)"hprofPath");
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            Intrinsics.checkNotNullParameter((Object)((Object)analysisOption), (String)"analysisOption");
            super(null, DiagnosticBundle.message("heap.dump.snapshot.task.title", new Object[0]), false);
            this.hprofPath = hprofPath;
            this.reason = reason;
            this.analysisOption = analysisOption;
            this.restart = restart;
        }

        public void onSuccess() {
            if (this.analysisOption == AnalysisOption.SCHEDULE_ON_NEXT_START && this.restart) {
                ApplicationManager.getApplication().invokeLater(this::confirmRestart, ModalityState.nonModal());
            }
        }

        public void onThrowable(@NotNull Throwable error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            LOG.error(error2);
            String string = DiagnosticBundle.message("heap.dump.snapshot.exception", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification2 = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, NotificationType.ERROR);
            notification2.notify(null);
        }

        private final void confirmRestart() {
            String string = DiagnosticBundle.message("heap.dump.snapshot.restart.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title2 = string;
            Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
            String string2 = DiagnosticBundle.message("heap.dump.snapshot.restart.dialog.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(title2, message);
            String string3 = DiagnosticBundle.message("heap.dump.snapshot.restart.dialog.restart.now", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
            String string4 = DiagnosticBundle.message("heap.dump.snapshot.restart.dialog.restart.later", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            if (((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).guessWindowAndAsk()) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
                ((ApplicationEx)application).restart(true);
            }
        }

        public void run(@NotNull ProgressIndicator indicator2) {
            Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
            indicator2.setIndeterminate(true);
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            if (this.reason.isUserInvoked()) {
                var3_3 = new Object[]{productName};
                indicator2.setText(DiagnosticBundle.message("heap.dump.snapshot.indicator.text", var3_3));
            } else {
                var3_3 = new Object[]{productName};
                indicator2.setText(DiagnosticBundle.message("heap.dump.snapshot.indicator.low.memory.text", var3_3));
            }
            Thread.sleep(500L);
            this.captureSnapshot();
            Ref.ObjectRef liveStats = new Ref.ObjectRef();
            liveStats.element = "";
            ApplicationManager.getApplication().invokeAndWait(() -> CaptureHeapDumpTask.run$lambda$0(liveStats));
            HeapReportProperties reportProperties = new HeapReportProperties(this.reason, (String)liveStats.element);
            switch (WhenMappings.$EnumSwitchMapping$0[this.analysisOption.ordinal()]) {
                case 1: {
                    HeapDumpAnalysisSupport.Companion.getInstance().saveSnapshotForAnalysis(this.hprofPath, reportProperties);
                    ApplicationManager.getApplication().invokeLater(() -> CaptureHeapDumpTask.run$lambda$1(this, productName));
                    break;
                }
                case 2: {
                    ApplicationManager.getApplication().invokeLater((Runnable)new AnalysisRunnable(this.hprofPath, reportProperties, true));
                    break;
                }
                case 3: {
                    String string = DiagnosticBundle.message("heap.dump.analysis.notification.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    Object[] objectArray = new Object[]{((Object)this.hprofPath).toString()};
                    String string2 = DiagnosticBundle.message("heap.dump.snapshot.created.no.analysis", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    Notification notification2 = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, string2, NotificationType.INFORMATION);
                    notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)RevealFileAction.getActionName(), () -> CaptureHeapDumpTask.run$lambda$2(this)));
                    notification2.notify(null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void captureSnapshot() {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.hprofPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                File file2 = this.hprofPath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                throw new FileAlreadyExistsException(file2, null, null, 6, null);
            }
            try {
                MemoryDumpHelper.captureMemoryDump((String)((Object)this.hprofPath).toString());
            }
            catch (Throwable t) {
                Files.deleteIfExists(this.hprofPath);
                throw t;
            }
        }

        private static final void run$lambda$0(Ref.ObjectRef $liveStats) {
            Object object;
            Ref.ObjectRef objectRef;
            Ref.ObjectRef objectRef2 = $liveStats;
            try {
                objectRef = objectRef2;
                object = new LiveInstanceStats().createReport();
            }
            catch (Error e) {
                objectRef = objectRef2;
                object = "Error while gathering live statistics: " + ExceptionUtil.getThrowableText((Throwable)e) + "\n";
            }
            objectRef.element = object;
        }

        private static final void run$lambda$1(CaptureHeapDumpTask this$0, String $productName) {
            String string = DiagnosticBundle.message("heap.dump.analysis.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{((Object)this$0.hprofPath).toString(), $productName};
            String string2 = DiagnosticBundle.message("heap.dump.snapshot.created", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Notification notification2 = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, string2, NotificationType.INFORMATION);
            if (ApplicationManager.getApplication().isInternal()) {
                notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)RevealFileAction.getActionName(), () -> CaptureHeapDumpTask.run$lambda$1$0(this$0)));
            }
            notification2.notify(null);
        }

        private static final void run$lambda$1$0(CaptureHeapDumpTask this$0) {
            RevealFileAction.openFile(this$0.hprofPath.toFile());
        }

        private static final void run$lambda$2(CaptureHeapDumpTask this$0) {
            RevealFileAction.openFile(this$0.hprofPath.toFile());
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AnalysisOption.values().length];
                try {
                    nArray[AnalysisOption.SCHEDULE_ON_NEXT_START.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AnalysisOption.IMMEDIATE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AnalysisOption.NO_ANALYSIS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/action/HeapDumpSnapshotRunnable$Companion;", "", "<init>", "()V", "MINIMUM_USED_MEMORY_TO_CAPTURE_HEAP_DUMP_IN_MB", "", "NEXT_CHECK_TIMESTAMP_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

