/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeDisposer;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.TreeNode;
import com.intellij.diagnostic.hprof.util.TreeVisualizer;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import com.intellij.util.ExceptionUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00066789:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J.\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\"\u001a\u00020#J\u001e\u0010$\u001a\u00020%2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010&\u001a\u00020 J \u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020\nJ\u0006\u0010/\u001a\u00020 J0\u00100\u001a\b\u0012\u0004\u0012\u00020\u0018012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0018032\f\u00104\u001a\b\u0012\u0004\u0012\u00020501H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "<init>", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;)V", "prepareException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "prepareDisposerChildren", "", "collectDisposerParentToChildren", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "result", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "goToArrayOfDisposableObjectNodes", "collectDisposerParentToChildrenNew", "visitObjectTreeRecursively", "currentNodeId", "", "parentObjectId", "getObjectNodeChildrenIds", "Lit/unimi/dsi/fastutil/longs/LongList;", "getSmartListChildren", "getMapNodeChildren", "verifyClassIsObjectNode", "clazzObjectTree", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "verifyClassIsObjectTree", "prepareDisposerTreeSummarySection", "", "disposerParentToChildren", "options", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$DisposerTreeSummaryOptions;", "buildDisposerTree", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;", "prepareDisposerTreeSection", "printDisposerTreeReportLine", "buffer", "Lcom/intellij/diagnostic/hprof/util/TruncatingPrintBuffer;", "mapping", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Grouping;", "groupedObjects", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$InstanceStats;", "computeDisposedObjectsIDs", "prepareDisposedObjectsSection", "getInstancesListInPriorityOrder", "", "classToLeakedIdsList", "Ljava/util/HashMap;", "disposedDominatorReportEntries", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposedDominatorReportEntry;", "Grouping", "InstanceStats", "DisposedDominatorReportEntry", "Companion", "DisposerNode", "SubTreeUpdaterOperation", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAnalyzeDisposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeDisposer.kt\ncom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,660:1\n12970#2,2:661\n1869#3,2:663\n1869#3:665\n1870#3:673\n1869#3,2:681\n1869#3,2:683\n1869#3,2:685\n1869#3,2:687\n1068#3:691\n1491#3:692\n1516#3,3:693\n1519#3,3:703\n1869#3,2:707\n1869#3,2:710\n1869#3,2:712\n1869#3,2:714\n1068#3:716\n3301#3,10:717\n1869#3,2:728\n1869#3,2:731\n1068#3:734\n1869#3,2:735\n1869#3:737\n1869#3,2:738\n1870#3:742\n1869#3:743\n1870#3:753\n1068#3:754\n1563#3:755\n1634#3,3:756\n1068#3:759\n1563#3:760\n1634#3,3:761\n1869#3,2:771\n1869#3:773\n1870#3:781\n382#4,7:666\n382#4,7:674\n382#4,7:696\n488#4,7:744\n382#4,7:764\n382#4,7:774\n216#5,2:689\n216#5:706\n217#5:709\n216#5:730\n217#5:733\n216#5,2:751\n1#6:727\n1321#7,2:740\n*S KotlinDebug\n*F\n+ 1 AnalyzeDisposer.kt\ncom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer\n*L\n76#1:661,2\n83#1:663,2\n91#1:665\n91#1:673\n273#1:681,2\n280#1:683,2\n282#1:685,2\n289#1:687,2\n402#1:691\n403#1:692\n403#1:693,3\n403#1:703,3\n407#1:707,2\n417#1:710,2\n483#1:712,2\n516#1:714,2\n541#1:716\n542#1:717,10\n544#1:728,2\n563#1:731,2\n579#1:734\n580#1:735,2\n596#1:737\n601#1:738,2\n596#1:742\n619#1:743\n619#1:753\n634#1:754\n635#1:755\n635#1:756,3\n641#1:759\n642#1:760\n642#1:761,3\n348#1:771,2\n353#1:773\n353#1:781\n107#1:666,7\n160#1:674,7\n403#1:696,7\n621#1:744,7\n322#1:764,7\n394#1:774,7\n325#1:689,2\n404#1:706\n404#1:709\n560#1:730\n560#1:733\n622#1:751,2\n604#1:740,2\n*E\n"})
public final class AnalyzeDisposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalysisContext analysisContext;
    @Nullable
    private Exception prepareException;
    @NotNull
    private static final Set<String> TOP_REPORTED_CLASSES = SetsKt.setOf((Object)"com.intellij.openapi.project.impl.ProjectImpl");

    public AnalyzeDisposer(@NotNull AnalysisContext analysisContext) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
    }

    public final void prepareDisposerChildren() {
        this.prepareException = null;
        Long2ObjectOpenHashMap<LongArrayList> result2 = this.analysisContext.getDisposerParentToChildren();
        result2.clear();
        if (!this.analysisContext.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
            return;
        }
        try {
            boolean bl;
            ObjectNavigator nav;
            block7: {
                nav = this.analysisContext.getNavigator();
                nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
                this.analysisContext.setDisposerTreeObjectId((int)nav.getId());
                InstanceField[] $this$any$iv = nav.getClass().getRefInstanceFields();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    InstanceField element$iv;
                    InstanceField it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"myObject2NodeMap")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                this.goToArrayOfDisposableObjectNodes(nav);
                this.collectDisposerParentToChildren(nav, result2);
            } else {
                this.collectDisposerParentToChildrenNew(nav, result2);
            }
            Collection collection = result2.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LongArrayList p0 = (LongArrayList)element$iv;
                boolean bl3 = false;
                p0.trim();
            }
        }
        catch (Exception ex) {
            this.prepareException = ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectDisposerParentToChildren(ObjectNavigator nav, Long2ObjectOpenHashMap<LongArrayList> result2) {
        Iterable $this$forEach$iv = (Iterable)nav.getReferencesCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            Long it = (Long)element$iv;
            boolean bl = false;
            Long l = it;
            long l2 = 0L;
            if (l != null && l == l2) continue;
            Intrinsics.checkNotNull((Object)it);
            ObjectNavigator.goTo$default(nav, it, null, 2, null);
            this.verifyClassIsObjectNode(nav.getClass());
            long objectNodeParentId = nav.getInstanceFieldObjectId(null, "myParent");
            long childId = nav.getInstanceFieldObjectId(null, "myObject");
            ObjectNavigator.goTo$default(nav, objectNodeParentId, null, 2, null);
            long parentId = nav.isNull() ? 0L : nav.getInstanceFieldObjectId(null, "myObject");
            Map map2 = (Map)result2;
            Long key$iv = parentId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                LongArrayList answer$iv = new LongArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            LongArrayList childrenList = (LongArrayList)object;
            childrenList.add(childId);
        }
    }

    private final void goToArrayOfDisposableObjectNodes(ObjectNavigator nav) {
        nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
        this.analysisContext.setDisposerTreeObjectId((int)nav.getId());
        this.verifyClassIsObjectTree(nav.getClass());
        if (nav.isNull()) {
            throw new ObjectNavigator.NavigationException("Disposer.ourTree == null");
        }
        nav.goToInstanceField(null, "myObject2NodeMap");
        if (Intrinsics.areEqual((Object)nav.getClass().getName(), (Object)"gnu.trove.THashMap")) {
            nav.goToInstanceField("gnu.trove.THashMap", "_values");
        } else {
            nav.goToInstanceField("it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap", "value");
        }
        if (nav.isNull()) {
            throw new ObjectNavigator.NavigationException("Collection of children is null");
        }
        if (!nav.getClass().isArray()) {
            throw new ObjectNavigator.NavigationException("Invalid type of map values collection: " + nav.getClass().getName());
        }
    }

    private final void collectDisposerParentToChildrenNew(ObjectNavigator nav, Long2ObjectOpenHashMap<LongArrayList> result2) {
        nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
        this.analysisContext.setDisposerTreeObjectId((int)nav.getId());
        nav.goToInstanceField("com.intellij.openapi.util.ObjectTree", "myRootNode");
        LongList rootObjectNodeIds = this.getObjectNodeChildrenIds(nav);
        int n = rootObjectNodeIds.size();
        for (int i2 = 0; i2 < n; ++i2) {
            long rootObjectNodeId = rootObjectNodeIds.getLong(i2);
            ObjectNavigator.goTo$default(nav, rootObjectNodeId, null, 2, null);
            if (nav.isNull()) continue;
            long rootObjectId = nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myObject");
            ObjectNavigator.goTo$default(nav, rootObjectNodeId, null, 2, null);
            this.visitObjectTreeRecursively(nav, rootObjectNodeId, 0L, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitObjectTreeRecursively(ObjectNavigator nav, long currentNodeId, long parentObjectId, Long2ObjectOpenHashMap<LongArrayList> result2) {
        Object object;
        void $this$getOrPut$iv;
        ObjectNavigator.goTo$default(nav, currentNodeId, null, 2, null);
        if (nav.isNull()) {
            return;
        }
        long currentObjectId = nav.getInstanceFieldObjectId("com.intellij.openapi.util.ObjectNode", "myObject");
        Map map2 = (Map)result2;
        Long key$iv = parentObjectId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            LongArrayList answer$iv = new LongArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((LongArrayList)object).add(currentObjectId);
        LongList childrenNodeIds = this.getObjectNodeChildrenIds(nav);
        int n = childrenNodeIds.size();
        for (int i2 = 0; i2 < n; ++i2) {
            long childNodeId = childrenNodeIds.getLong(i2);
            this.visitObjectTreeRecursively(nav, childNodeId, currentObjectId, result2);
        }
    }

    private final LongList getObjectNodeChildrenIds(ObjectNavigator nav) {
        LongList longList;
        nav.goToInstanceField("com.intellij.openapi.util.ObjectNode", "myChildren");
        String string = nav.getClass().getName();
        if (Intrinsics.areEqual((Object)string, (Object)Collections.emptyList().getClass().getName()) || Intrinsics.areEqual((Object)string, (Object)"com.intellij.openapi.util.ObjectNode$1")) {
            LongList longList2 = LongList.of();
            Intrinsics.checkNotNull((Object)longList2);
            longList = longList2;
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.intellij.openapi.util.ObjectNode$ListNodeChildren")) {
            nav.goToInstanceField("com.intellij.openapi.util.ObjectNode$ListNodeChildren", "myChildren");
            longList = this.getSmartListChildren(nav);
        } else if (Intrinsics.areEqual((Object)string, (Object)"com.intellij.openapi.util.ObjectNode$MapNodeChildren")) {
            nav.goToInstanceField("com.intellij.openapi.util.ObjectNode$MapNodeChildren", "myChildren");
            longList = this.getMapNodeChildren(nav);
        } else {
            longList = this.getSmartListChildren(nav);
        }
        return longList;
    }

    private final LongList getSmartListChildren(ObjectNavigator nav) {
        nav.goToInstanceField("com.intellij.util.SmartList", "myElem");
        if (nav.isNull()) {
            LongList longList = LongList.of();
            Intrinsics.checkNotNullExpressionValue((Object)longList, (String)"of(...)");
            return longList;
        }
        if (nav.getClass().isArray()) {
            return nav.getReferencesCopy();
        }
        LongList longList = LongList.of((long)nav.getId());
        Intrinsics.checkNotNullExpressionValue((Object)longList, (String)"of(...)");
        return longList;
    }

    private final LongList getMapNodeChildren(ObjectNavigator nav) {
        nav.goToInstanceField("it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap", "value");
        return nav.getReferencesCopy();
    }

    private final void verifyClassIsObjectNode(ClassDefinition clazzObjectTree) {
        if (!Intrinsics.areEqual((Object)clazzObjectTree.getUndecoratedName(), (Object)"com.intellij.openapi.util.objectTree.ObjectNode") && !Intrinsics.areEqual((Object)clazzObjectTree.getUndecoratedName(), (Object)"com.intellij.openapi.util.ObjectNode")) {
            throw new ObjectNavigator.NavigationException("Wrong type, expected ObjectNode: " + clazzObjectTree.getName());
        }
    }

    private final void verifyClassIsObjectTree(ClassDefinition clazzObjectTree) {
        if (!Intrinsics.areEqual((Object)clazzObjectTree.getUndecoratedName(), (Object)"com.intellij.openapi.util.objectTree.ObjectTree") && !Intrinsics.areEqual((Object)clazzObjectTree.getUndecoratedName(), (Object)"com.intellij.openapi.util.ObjectTree")) {
            throw new ObjectNavigator.NavigationException("Wrong type, expected ObjectTree: " + clazzObjectTree.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String prepareDisposerTreeSummarySection(@NotNull Long2ObjectOpenHashMap<LongArrayList> disposerParentToChildren, @NotNull AnalysisConfig.DisposerTreeSummaryOptions options2) {
        StringBuilder stringBuilder;
        block18: {
            Intrinsics.checkNotNullParameter(disposerParentToChildren, (String)"disposerParentToChildren");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            StringBuilder $this$prepareDisposerTreeSummarySection_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Closeable closeable = new TruncatingPrintBuffer(options2.getHeadLimit(), 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareDisposerTreeSummarySection_u24lambda_u240){

                public final StringBuilder invoke(String p0) {
                    return ((StringBuilder)this.receiver).append(p0).append('\n');
                }
            }));
            Throwable throwable = null;
            try {
                TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)closeable;
                boolean bl2 = false;
                if (!this.analysisContext.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
                    break block18;
                }
                Exception exception = this.prepareException;
                if (exception != null) {
                    Exception it = exception;
                    boolean bl3 = false;
                    String string = ExceptionUtil.getThrowableText((Throwable)it);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getThrowableText(...)");
                    buffer2.println(string);
                    break block18;
                }
                ObjectNavigator nav = this.analysisContext.getNavigator();
                try {
                    DisposerNode rootNode = this.buildDisposerTree(this.analysisContext.getDisposerParentToChildren(), nav);
                    Stack<SubtreeSizeUpdateStackObject> nodeStack = new Stack<SubtreeSizeUpdateStackObject>();
                    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"com/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$prepareDisposerTreeSummarySection$1$2$SubtreeSizeUpdateStackObject", "", "node", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;", "operation", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$SubTreeUpdaterOperation;", "<init>", "(Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$SubTreeUpdaterOperation;)V", "getNode", "()Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;", "getOperation", "()Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$SubTreeUpdaterOperation;", "component1", "component2", "copy", "(Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$SubTreeUpdaterOperation;)Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$prepareDisposerTreeSummarySection$1$2$SubtreeSizeUpdateStackObject;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
                    public final class SubtreeSizeUpdateStackObject {
                        private final DisposerNode node;
                        private final SubTreeUpdaterOperation operation;

                        public SubtreeSizeUpdateStackObject(DisposerNode node, SubTreeUpdaterOperation operation2) {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            Intrinsics.checkNotNullParameter((Object)((Object)operation2), (String)"operation");
                            this.node = node;
                            this.operation = operation2;
                        }

                        public final DisposerNode getNode() {
                            return this.node;
                        }

                        public final SubTreeUpdaterOperation getOperation() {
                            return this.operation;
                        }

                        public final DisposerNode component1() {
                            return this.node;
                        }

                        public final SubTreeUpdaterOperation component2() {
                            return this.operation;
                        }

                        public final SubtreeSizeUpdateStackObject copy(DisposerNode node, SubTreeUpdaterOperation operation2) {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            Intrinsics.checkNotNullParameter((Object)((Object)operation2), (String)"operation");
                            return new SubtreeSizeUpdateStackObject(node, operation2);
                        }

                        public static /* synthetic */ SubtreeSizeUpdateStackObject copy$default(SubtreeSizeUpdateStackObject subtreeSizeUpdateStackObject, DisposerNode disposerNode, SubTreeUpdaterOperation subTreeUpdaterOperation, int n, Object object) {
                            if ((n & 1) != 0) {
                                disposerNode = subtreeSizeUpdateStackObject.node;
                            }
                            if ((n & 2) != 0) {
                                subTreeUpdaterOperation = subtreeSizeUpdateStackObject.operation;
                            }
                            return subtreeSizeUpdateStackObject.copy(disposerNode, subTreeUpdaterOperation);
                        }

                        public String toString() {
                            return "SubtreeSizeUpdateStackObject(node=" + this.node + ", operation=" + this.operation + ")";
                        }

                        public int hashCode() {
                            int result2 = this.node.hashCode();
                            result2 = result2 * 31 + this.operation.hashCode();
                            return result2;
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (!(other instanceof SubtreeSizeUpdateStackObject)) {
                                return false;
                            }
                            SubtreeSizeUpdateStackObject subtreeSizeUpdateStackObject = (SubtreeSizeUpdateStackObject)other;
                            if (!Intrinsics.areEqual((Object)this.node, (Object)subtreeSizeUpdateStackObject.node)) {
                                return false;
                            }
                            return this.operation == subtreeSizeUpdateStackObject.operation;
                        }
                    }
                    nodeStack.push(new SubtreeSizeUpdateStackObject(rootNode, SubTreeUpdaterOperation.PROCESS_CHILDREN));
                    while (!nodeStack.isEmpty()) {
                        boolean $this$forEach$iv;
                        DisposerNode it;
                        boolean $i$f$forEach;
                        Iterable $this$forEach$iv2;
                        SubtreeSizeUpdateStackObject bl3 = (SubtreeSizeUpdateStackObject)nodeStack.pop();
                        DisposerNode currentNode = bl3.component1();
                        SubTreeUpdaterOperation operation2 = bl3.component2();
                        if (operation2 == SubTreeUpdaterOperation.PROCESS_CHILDREN) {
                            currentNode.setSubtreeSize(currentNode.getCount());
                            currentNode.setFilteredSubtreeSize(currentNode.getCount());
                            nodeStack.push(new SubtreeSizeUpdateStackObject(currentNode, SubTreeUpdaterOperation.UPDATE_SIZE));
                            Collection<DisposerNode> collection = currentNode.getChildren().values();
                            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                            $this$forEach$iv2 = collection;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv2) {
                                it = (DisposerNode)element$iv;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull((Object)it);
                                nodeStack.push(new SubtreeSizeUpdateStackObject(it, SubTreeUpdaterOperation.PROCESS_CHILDREN));
                            }
                            continue;
                        }
                        boolean bl5 = $this$forEach$iv = operation2 == SubTreeUpdaterOperation.UPDATE_SIZE;
                        if (_Assertions.ENABLED && !$this$forEach$iv) {
                            String $i$f$forEach2 = "Assertion failed";
                            throw new AssertionError((Object)$i$f$forEach2);
                        }
                        Collection<DisposerNode> collection = currentNode.getChildren().values();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                        $this$forEach$iv2 = collection;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            it = (DisposerNode)element$iv;
                            boolean bl6 = false;
                            currentNode.setSubtreeSize(currentNode.getSubtreeSize() + it.getSubtreeSize());
                        }
                        currentNode.getChildren().entrySet().removeIf(arg_0 -> AnalyzeDisposer.prepareDisposerTreeSummarySection$lambda$0$0$4(arg_0 -> AnalyzeDisposer.prepareDisposerTreeSummarySection$lambda$0$0$3(options2, arg_0), arg_0));
                        Collection<DisposerNode> collection2 = currentNode.getChildren().values();
                        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
                        $this$forEach$iv2 = collection2;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            it = (DisposerNode)element$iv;
                            boolean bl7 = false;
                            currentNode.setFilteredSubtreeSize(currentNode.getFilteredSubtreeSize() + it.getSubtreeSize());
                        }
                    }
                    TreeVisualizer visualizer = new TreeVisualizer();
                    buffer2.println("Cutoff: " + options2.getNodeCutoff());
                    buffer2.println("Count of disposable objects: " + rootNode.getSubtreeSize());
                    buffer2.println();
                    Iterable $this$forEach$iv = rootNode.children();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TreeNode it = (TreeNode)element$iv;
                        boolean bl8 = false;
                        visualizer.visualizeTree(it, buffer2, this.analysisContext.getConfig().getDisposerOptions().getDisposerTreeSummaryOptions());
                        buffer2.println();
                    }
                }
                catch (Exception ex) {
                    String string = ExceptionUtil.getThrowableText((Throwable)ex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getThrowableText(...)");
                    buffer2.println(string);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return stringBuilder.toString();
    }

    private final DisposerNode buildDisposerTree(Long2ObjectOpenHashMap<LongArrayList> disposerParentToChildren, ObjectNavigator nav) {
        DisposerNode rootNode = new DisposerNode("<root>");
        Stack<StackObject> stack = new Stack<StackObject>();
        Object object = disposerParentToChildren.get(0L);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"com/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$buildDisposerTree$StackObject", "", "node", "Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;", "childrenIds", "Lit/unimi/dsi/fastutil/longs/LongCollection;", "<init>", "(Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;Lit/unimi/dsi/fastutil/longs/LongCollection;)V", "getNode", "()Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;", "getChildrenIds", "()Lit/unimi/dsi/fastutil/longs/LongCollection;", "component1", "component2", "copy", "(Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;Lit/unimi/dsi/fastutil/longs/LongCollection;)Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$buildDisposerTree$StackObject;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
        public final class StackObject {
            private final DisposerNode node;
            private final LongCollection childrenIds;

            public StackObject(DisposerNode node, LongCollection childrenIds) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)childrenIds, (String)"childrenIds");
                this.node = node;
                this.childrenIds = childrenIds;
            }

            public final DisposerNode getNode() {
                return this.node;
            }

            public final LongCollection getChildrenIds() {
                return this.childrenIds;
            }

            public final DisposerNode component1() {
                return this.node;
            }

            public final LongCollection component2() {
                return this.childrenIds;
            }

            public final StackObject copy(DisposerNode node, LongCollection childrenIds) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)childrenIds, (String)"childrenIds");
                return new StackObject(node, childrenIds);
            }

            public static /* synthetic */ StackObject copy$default(StackObject stackObject, DisposerNode disposerNode, LongCollection longCollection, int n, Object object) {
                if ((n & 1) != 0) {
                    disposerNode = stackObject.node;
                }
                if ((n & 2) != 0) {
                    longCollection = stackObject.childrenIds;
                }
                return stackObject.copy(disposerNode, longCollection);
            }

            public String toString() {
                return "StackObject(node=" + this.node + ", childrenIds=" + this.childrenIds + ")";
            }

            public int hashCode() {
                int result2 = this.node.hashCode();
                result2 = result2 * 31 + this.childrenIds.hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackObject)) {
                    return false;
                }
                StackObject stackObject = (StackObject)other;
                if (!Intrinsics.areEqual((Object)this.node, (Object)stackObject.node)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.childrenIds, (Object)stackObject.childrenIds);
            }
        }
        stack.push(new StackObject(rootNode, (LongCollection)object));
        while (!stack.empty()) {
            StackObject stackObject = (StackObject)stack.pop();
            DisposerNode currentNode = stackObject.component1();
            LongCollection childrenIds = stackObject.component2();
            HashMap nodeToChildren = new HashMap();
            childrenIds.forEach(arg_0 -> AnalyzeDisposer.buildDisposerTree$lambda$0(nav, currentNode, disposerParentToChildren, nodeToChildren, arg_0));
            Map $this$forEach$iv = nodeToChildren;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                DisposerNode node = (DisposerNode)entry.getKey();
                LongArrayList children2 = (LongArrayList)entry.getValue();
                stack.push(new StackObject(node, (LongCollection)children2));
            }
        }
        return rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareDisposerTreeSection() {
        StringBuilder stringBuilder;
        StringBuilder $this$prepareDisposerTreeSection_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.analysisContext.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
            Exception exception = this.prepareException;
            if (exception != null) {
                Exception it = exception;
                boolean bl2 = false;
                $this$prepareDisposerTreeSection_u24lambda_u240.append(ExceptionUtil.getThrowableText((Throwable)it)).append('\n');
            } else {
                ObjectNavigator nav = this.analysisContext.getNavigator();
                try {
                    HashMap groupingToObjectStats = new HashMap();
                    HashSet tooDeepObjectClasses = new HashSet();
                    Long2LongOpenHashMap parentMap = new Long2LongOpenHashMap();
                    this.analysisContext.getDisposerParentToChildren().forEach((arg_0, arg_1) -> AnalyzeDisposer.prepareDisposerTreeSection$lambda$0$2((arg_0, arg_1) -> AnalyzeDisposer.prepareDisposerTreeSection$lambda$0$1(parentMap, arg_0, arg_1), arg_0, arg_1));
                    int maxTreeDepth = 200;
                    this.analysisContext.getDisposerParentToChildren().forEach((arg_0, arg_1) -> AnalyzeDisposer.prepareDisposerTreeSection$lambda$0$4((arg_0, arg_1) -> AnalyzeDisposer.prepareDisposerTreeSection$lambda$0$3(nav, parentMap, maxTreeDepth, tooDeepObjectClasses, groupingToObjectStats, arg_0, arg_1), arg_0, arg_1));
                    Closeable closeable = new TruncatingPrintBuffer(400, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareDisposerTreeSection_u24lambda_u240){

                        public final StringBuilder invoke(String p0) {
                            return ((StringBuilder)this.receiver).append(p0).append('\n');
                        }
                    }));
                    Throwable throwable = null;
                    try {
                        void $this$forEach$iv;
                        Map map2;
                        void $this$groupByTo$iv$iv;
                        Map $this$groupBy$iv;
                        Iterable $this$sortedByDescending$iv;
                        TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)closeable;
                        boolean bl3 = false;
                        Set set = groupingToObjectStats.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                        Iterable iterable = set;
                        boolean $i$f$sortedByDescending = false;
                        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Map.Entry it = (Map.Entry)b;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(((InstanceStats)it.getValue()).objectCount());
                                it = (Map.Entry)a;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((InstanceStats)it.getValue()).objectCount()));
                            }
                        });
                        boolean $i$f$groupBy = false;
                        Iterator iterator2 = $this$groupBy$iv;
                        Map destination$iv$iv = new LinkedHashMap();
                        boolean $i$f$groupByTo = false;
                        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                            Object object;
                            void $this$getOrPut$iv$iv$iv;
                            Map.Entry it = (Map.Entry)element$iv$iv;
                            boolean bl4 = false;
                            ClassDefinition key$iv$iv = ((Grouping)it.getKey()).getRootClass();
                            map2 = destination$iv$iv;
                            ClassDefinition key$iv$iv$iv = key$iv$iv;
                            boolean $i$f$getOrPut = false;
                            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                            if (value$iv$iv$iv == null) {
                                boolean bl5 = false;
                                List answer$iv$iv$iv = new ArrayList();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                                object = answer$iv$iv$iv;
                            } else {
                                object = value$iv$iv$iv;
                            }
                            List list$iv$iv = (List)object;
                            list$iv$iv.add(element$iv$iv);
                        }
                        $this$groupBy$iv = destination$iv$iv;
                        boolean $i$f$forEach = false;
                        iterator2 = $this$forEach$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry entry = element$iv = iterator2.next();
                            boolean bl6 = false;
                            ClassDefinition rootClass = (ClassDefinition)entry.getKey();
                            List entries2 = (List)entry.getValue();
                            buffer2.println("Root: " + rootClass.getName());
                            Closeable closeable2 = new TruncatingPrintBuffer(100, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>((Object)buffer2){

                                public final void invoke(String p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    ((TruncatingPrintBuffer)this.receiver).println(p0);
                                }
                            }));
                            Throwable throwable2 = null;
                            try {
                                TruncatingPrintBuffer buffer3 = (TruncatingPrintBuffer)closeable2;
                                boolean bl7 = false;
                                Iterable $this$forEach$iv2 = entries2;
                                boolean $i$f$forEach2 = false;
                                for (Object element$iv2 : $this$forEach$iv2) {
                                    Map.Entry entry2 = (Map.Entry)element$iv2;
                                    boolean bl8 = false;
                                    Intrinsics.checkNotNull((Object)entry2);
                                    Object k = entry2.getKey();
                                    Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                                    Grouping mapping = (Grouping)k;
                                    Object v = entry2.getValue();
                                    Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                                    InstanceStats groupedObjects = (InstanceStats)v;
                                    this.printDisposerTreeReportLine(buffer3, mapping, groupedObjects);
                                }
                                map2 = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                            }
                            buffer2.println();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable bl3) {
                        throwable = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (tooDeepObjectClasses.size() > 0) {
                        $this$prepareDisposerTreeSection_u24lambda_u240.append("Skipped analysis of objects too deep in disposer tree:").append('\n');
                        Iterable $this$forEach$iv = tooDeepObjectClasses;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ClassDefinition it = (ClassDefinition)element$iv;
                            boolean bl9 = false;
                            $this$prepareDisposerTreeSection_u24lambda_u240.append(" * " + nav.getClassStore().getShortPrettyNameForClass(it)).append('\n');
                        }
                    }
                }
                catch (Exception ex) {
                    $this$prepareDisposerTreeSection_u24lambda_u240.append(ExceptionUtil.getThrowableText((Throwable)ex)).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    private final void printDisposerTreeReportLine(TruncatingPrintBuffer buffer2, Grouping mapping, InstanceStats groupedObjects) {
        ClassDefinition sourceClass = mapping.component1();
        ClassDefinition parentClass = mapping.component2();
        ClassDefinition rootClass = mapping.component3();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int objectCount = groupedObjects.objectCount();
        int parentCount = groupedObjects.parentCount();
        if (parentClass != null && objectCount == parentCount) {
            return;
        }
        Object parentString = null;
        if (parentClass == null) {
            parentString = "(no parent)";
        } else {
            String parentClassName = nav.getClassStore().getShortPrettyNameForClass(parentClass);
            int rootCount = groupedObjects.rootCount();
            parentString = !Intrinsics.areEqual((Object)rootClass, (Object)parentClass) || rootCount != parentCount ? "<-- " + parentCount + " " + parentClassName + " [...] " + rootCount : "<-- " + parentCount;
        }
        String sourceClassName = nav.getClassStore().getShortPrettyNameForClass(sourceClass);
        String string = "%6d";
        Object[] objectArray = new Object[]{objectCount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        buffer2.println("  " + string2 + " " + sourceClassName + " " + (String)parentString);
    }

    public final void computeDisposedObjectsIDs() {
        IntOpenHashSet disposedObjectsIDs = this.analysisContext.getDisposedObjectsIDs();
        disposedObjectsIDs.clear();
        if (this.prepareException != null) {
            return;
        }
        try {
            ObjectNavigator nav = this.analysisContext.getNavigator();
            IntList parentList = this.analysisContext.getParentList();
            if (!nav.getClassStore().containsClass("com.intellij.openapi.util.Disposer")) {
                return;
            }
            nav.goToStaticField("com.intellij.openapi.util.Disposer", "ourTree");
            if (nav.isNull()) {
                throw new ObjectNavigator.NavigationException("ourTree is null");
            }
            this.verifyClassIsObjectTree(nav.getClass());
            nav.goToInstanceField(null, "myDisposedObjects");
            nav.goToInstanceField("com.intellij.util.containers.WeakHashMap", "myMap");
            nav.goToInstanceField("com.intellij.util.containers.RefHashMap$MyMap", "key");
            ClassDefinition weakKeyClass = nav.getClassStore().getClassIfExists("com.intellij.util.containers.WeakHashMap$WeakKey");
            Iterable $this$forEach$iv = (Iterable)nav.getReferencesCopy();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int leakId;
                Long it = (Long)element$iv;
                boolean bl = false;
                Long l = it;
                long l2 = 0L;
                if (l != null && l == l2) continue;
                Intrinsics.checkNotNull((Object)it);
                nav.goTo(it, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                if (!Intrinsics.areEqual((Object)nav.getClass(), (Object)weakKeyClass)) continue;
                nav.goToInstanceField("com.intellij.util.containers.WeakHashMap$WeakKey", "referent");
                if (nav.getId() == 0L || parentList.get(leakId = (int)nav.getId()) == 0) continue;
                disposedObjectsIDs.add(leakId);
            }
        }
        catch (ObjectNavigator.NavigationException navEx) {
            this.prepareException = navEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareDisposedObjectsSection() {
        Throwable throwable;
        Iterator<Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>>> element$iv4;
        Object object;
        StringBuilder stringBuilder;
        StringBuilder $this$prepareDisposedObjectsSection_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        HashMap<ClassDefinition, LongList> leakedInstancesByClass = new HashMap<ClassDefinition, LongList>();
        Object2IntOpenHashMap countByClass = new Object2IntOpenHashMap();
        int totalCount = 0;
        ObjectNavigator nav = this.analysisContext.getNavigator();
        IntOpenHashSet disposedObjectsIDs = this.analysisContext.getDisposedObjectsIDs();
        AnalysisConfig.DisposerOptions disposerOptions = this.analysisContext.getConfig().getDisposerOptions();
        Iterable $this$forEach$iv = (Iterable)disposedObjectsIDs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Integer it = (Integer)element$iv2;
            boolean bl2 = false;
            nav.goTo(it.intValue(), ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            ClassDefinition leakClass = nav.getClass();
            long leakId = nav.getId();
            leakedInstancesByClass.computeIfAbsent(leakClass, arg_0 -> AnalyzeDisposer.prepareDisposedObjectsSection$lambda$0$0$1(AnalyzeDisposer::prepareDisposedObjectsSection$lambda$0$0$0, arg_0)).add(leakId);
            countByClass.put((Object)leakClass, countByClass.getInt((Object)leakClass) + 1);
            ++totalCount;
        }
        List entries2 = new ArrayList();
        countByClass.object2IntEntrySet().fastForEach(arg_0 -> AnalyzeDisposer.prepareDisposedObjectsSection$lambda$0$2(arg_0 -> AnalyzeDisposer.prepareDisposedObjectsSection$lambda$0$1(entries2, arg_0), arg_0));
        if (disposerOptions.getIncludeDisposedObjectsSummary()) {
            Closeable $i$f$forEach2 = new TruncatingPrintBuffer(100, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareDisposedObjectsSection_u24lambda_u240){

                public final StringBuilder invoke(String p0) {
                    return ((StringBuilder)this.receiver).append(p0).append('\n');
                }
            }));
            object = null;
            try {
                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000%\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"com/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$prepareDisposedObjectsSection$1$TObjectIntMapEntry", "T", "", "key", "value", "", "<init>", "(Ljava/lang/Object;I)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "()I", "component1", "component2", "copy", "(Ljava/lang/Object;I)Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$prepareDisposedObjectsSection$1$TObjectIntMapEntry;", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
                public final class TObjectIntMapEntry<T> {
                    private final T key;
                    private final int value;

                    public TObjectIntMapEntry(T key, int value) {
                        this.key = key;
                        this.value = value;
                    }

                    public final T getKey() {
                        return this.key;
                    }

                    public final int getValue() {
                        return this.value;
                    }

                    public final T component1() {
                        return this.key;
                    }

                    public final int component2() {
                        return this.value;
                    }

                    public final TObjectIntMapEntry<T> copy(T key, int value) {
                        return new TObjectIntMapEntry<T>(key, value);
                    }

                    public static /* synthetic */ TObjectIntMapEntry copy$default(TObjectIntMapEntry tObjectIntMapEntry, Object object, int n, int n2, Object object2) {
                        if ((n2 & 1) != 0) {
                            object = tObjectIntMapEntry.key;
                        }
                        if ((n2 & 2) != 0) {
                            n = tObjectIntMapEntry.value;
                        }
                        return tObjectIntMapEntry.copy(object, n);
                    }

                    public String toString() {
                        return "TObjectIntMapEntry(key=" + this.key + ", value=" + this.value + ")";
                    }

                    public int hashCode() {
                        int result2 = this.key == null ? 0 : this.key.hashCode();
                        result2 = result2 * 31 + Integer.hashCode(this.value);
                        return result2;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof TObjectIntMapEntry)) {
                            return false;
                        }
                        TObjectIntMapEntry tObjectIntMapEntry = (TObjectIntMapEntry)other;
                        if (!Intrinsics.areEqual(this.key, tObjectIntMapEntry.key)) {
                            return false;
                        }
                        return this.value == tObjectIntMapEntry.value;
                    }
                }
                void $this$forEach$iv2;
                Iterable $this$partition$iv;
                Iterable $this$sortedByDescending$iv;
                TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)$i$f$forEach2;
                boolean bl3 = false;
                buffer2.println("Count of disposed-but-strong-referenced objects: " + totalCount);
                Iterable bl2 = entries2;
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TObjectIntMapEntry it = (TObjectIntMapEntry)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getValue());
                        it = (TObjectIntMapEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getValue()));
                    }
                });
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv3 : $this$partition$iv) {
                    TObjectIntMapEntry it = (TObjectIntMapEntry)element$iv3;
                    boolean bl4 = false;
                    boolean bl5 = TOP_REPORTED_CLASSES.contains(((ClassDefinition)it.getKey()).getName()) ? first$iv.add(element$iv3) : second$iv.add(element$iv3);
                }
                Pair it = new Pair(first$iv, second$iv);
                boolean bl6 = false;
                $this$partition$iv = CollectionsKt.plus((Collection)((Collection)it.getFirst()), (Iterable)((Iterable)it.getSecond()));
                boolean $i$f$forEach3 = false;
                for (Iterator<Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>>> element$iv4 : $this$forEach$iv2) {
                    TObjectIntMapEntry entry = (TObjectIntMapEntry)((Object)element$iv4);
                    boolean bl7 = false;
                    buffer2.println("  " + entry.getValue() + " " + ((ClassDefinition)entry.getKey()).getPrettyName());
                }
                buffer2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$f$forEach2, (Throwable)object);
            }
            $this$prepareDisposedObjectsSection_u24lambda_u240.append('\n');
        }
        GCRootPathsTree disposedTree = new GCRootPathsTree(this.analysisContext, AnalysisConfig.TreeDisplayOptions.Companion.all$default(AnalysisConfig.TreeDisplayOptions.Companion, false, false, 3, null), null);
        IntIterator intIterator = disposedObjectsIDs.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        object = intIterator;
        while (object.hasNext()) {
            Integer disposedObjectsID = object.next();
            Intrinsics.checkNotNull((Object)disposedObjectsID);
            disposedTree.registerObject(disposedObjectsID);
        }
        Map<ClassDefinition, List<GCRootPathsTree.RegularNode>> disposedDominatorNodesByClass = disposedTree.getDisposedDominatorNodes();
        long allDominatorsCount = 0L;
        long allDominatorsSubgraphSize = 0L;
        List disposedDominatorClassSizeList = new ArrayList();
        Object $this$forEach$iv3 = disposedDominatorNodesByClass;
        boolean $i$f$forEach4 = false;
        element$iv4 = $this$forEach$iv3.entrySet().iterator();
        while (element$iv4.hasNext()) {
            Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>> element$iv5;
            Map.Entry<ClassDefinition, List<GCRootPathsTree.RegularNode>> bl7 = element$iv5 = element$iv4.next();
            boolean bl8 = false;
            ClassDefinition classDefinition = bl7.getKey();
            List<GCRootPathsTree.RegularNode> nodeList = bl7.getValue();
            long dominatorClassSubgraphSize = 0L;
            long dominatorClassInstanceCount = 0L;
            Iterable $this$forEach$iv4 = nodeList;
            boolean $i$f$forEach5 = false;
            for (Object element$iv6 : $this$forEach$iv4) {
                GCRootPathsTree.RegularNode it = (GCRootPathsTree.RegularNode)element$iv6;
                boolean bl9 = false;
                dominatorClassInstanceCount += (long)it.getInstances().size();
                dominatorClassSubgraphSize += (long)it.getTotalSizeInDwords() * (long)4;
            }
            allDominatorsCount += dominatorClassInstanceCount;
            allDominatorsSubgraphSize += dominatorClassSubgraphSize;
            disposedDominatorClassSizeList.add(new DisposedDominatorReportEntry(classDefinition, dominatorClassInstanceCount, dominatorClassSubgraphSize));
        }
        if (disposerOptions.getIncludeDisposedObjectsSummary()) {
            $this$forEach$iv3 = new TruncatingPrintBuffer(30, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareDisposedObjectsSection_u24lambda_u240){

                public final StringBuilder invoke(String p0) {
                    return ((StringBuilder)this.receiver).append(p0).append('\n');
                }
            }));
            Throwable throwable3 = null;
            try {
                void $this$forEach$iv5;
                Iterable $this$sortedByDescending$iv;
                TruncatingPrintBuffer buffer3 = (TruncatingPrintBuffer)$this$forEach$iv3;
                boolean bl10 = false;
                buffer3.println("Disposed-but-strong-referenced dominator object count: " + allDominatorsCount);
                buffer3.println("Disposed-but-strong-referenced dominator sub-graph size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(allDominatorsSubgraphSize));
                Iterable bl7 = disposedDominatorClassSizeList;
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DisposedDominatorReportEntry it = (DisposedDominatorReportEntry)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getSize());
                        it = (DisposedDominatorReportEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSize()));
                    }
                });
                boolean $i$f$forEach6 = false;
                for (Object element$iv7 : $this$forEach$iv5) {
                    DisposedDominatorReportEntry entry = (DisposedDominatorReportEntry)element$iv7;
                    boolean bl11 = false;
                    buffer3.println("  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getSize()) + " - " + HeapReportUtils.INSTANCE.toShortStringAsCount(entry.getCount()) + " " + entry.getClassDefinition().getName());
                }
                throwable = Unit.INSTANCE;
            }
            catch (Throwable bl10) {
                throwable3 = bl10;
                throw bl10;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv3, (Throwable)throwable3);
            }
            $this$prepareDisposedObjectsSection_u24lambda_u240.append('\n');
        }
        if (disposerOptions.getIncludeDisposedObjectsDetails()) {
            List<LongList> instancesListInOrder = this.getInstancesListInPriorityOrder(leakedInstancesByClass, disposedDominatorClassSizeList);
            Closeable closeable = new TruncatingPrintBuffer(700, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareDisposedObjectsSection_u24lambda_u240){

                public final StringBuilder invoke(String p0) {
                    return ((StringBuilder)this.receiver).append(p0).append('\n');
                }
            }));
            throwable = null;
            try {
                void $this$forEach$iv6;
                TruncatingPrintBuffer buffer4 = (TruncatingPrintBuffer)closeable;
                boolean bl12 = false;
                Iterable $i$f$forEach6 = instancesListInOrder;
                boolean $i$f$forEach7 = false;
                for (Object element$iv8 : $this$forEach$iv6) {
                    LongList instances = (LongList)element$iv8;
                    boolean bl13 = false;
                    ObjectNavigator.goTo$default(nav, instances.getLong(0), null, 2, null);
                    buffer4.println("Disposed but still strong-referenced objects: " + instances.size() + " " + nav.getClass().getPrettyName() + ", most common paths from GC-roots:");
                    GCRootPathsTree gcRootPathsTree = new GCRootPathsTree(this.analysisContext, disposerOptions.getDisposedObjectsDetailsTreeDisplayOptions(), nav.getClass());
                    Iterable $this$forEach$iv7 = (Iterable)instances;
                    boolean $i$f$forEach8 = false;
                    for (Object element$iv9 : $this$forEach$iv7) {
                        Long leakId = (Long)element$iv9;
                        boolean bl14 = false;
                        gcRootPathsTree.registerObject((int)leakId.longValue());
                    }
                    $this$forEach$iv7 = StringsKt.lineSequence((CharSequence)gcRootPathsTree.printTree());
                    $i$f$forEach8 = false;
                    for (Object element$iv9 : $this$forEach$iv7) {
                        String p0 = (String)element$iv9;
                        boolean bl15 = false;
                        buffer4.println(p0);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<LongList> getInstancesListInPriorityOrder(HashMap<ClassDefinition, LongList> classToLeakedIdsList, List<DisposedDominatorReportEntry> disposedDominatorReportEntries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$sortedByDescending$iv2;
        Object result$iv;
        Object element$iv22;
        List result2 = new ArrayList();
        HashMap classToLeakedIdsListCopy = new HashMap(classToLeakedIdsList);
        Iterable $this$forEach$iv = TOP_REPORTED_CLASSES;
        boolean $i$f$forEach232 = false;
        for (Object element$iv22 : $this$forEach$iv) {
            Iterator $this$forEach$iv2;
            Map $this$filterKeys$iv;
            String topClassName = (String)element$iv22;
            boolean bl = false;
            Map map2 = classToLeakedIdsListCopy;
            boolean $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
                ClassDefinition it = (ClassDefinition)entry.getKey();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)topClassName)) continue;
                ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
            }
            $this$filterKeys$iv = (Map)result$iv;
            boolean $i$f$forEach = false;
            result$iv = $this$forEach$iv2.entrySet().iterator();
            while (result$iv.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = (Map.Entry)result$iv.next();
                boolean bl3 = false;
                ClassDefinition classDefinition = (ClassDefinition)entry.getKey();
                LongList list2 = (LongList)entry.getValue();
                Intrinsics.checkNotNull((Object)list2);
                result2.add(list2);
                classToLeakedIdsListCopy.remove(classDefinition);
            }
        }
        Set set = classToLeakedIdsListCopy.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $i$f$forEach232 = set;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((LongList)it.getValue()).size());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((LongList)it.getValue()).size()));
            }
        });
        boolean $i$f$map232 = false;
        element$iv22 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            result$iv = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ClassDefinition)it.getKey());
        }
        Collection collection2 = (List)destination$iv$iv;
        ArrayDeque classOrderByInstanceCount = new ArrayDeque(collection2);
        Iterable $i$f$map232 = disposedDominatorReportEntries;
        boolean $i$f$sortedByDescending2 = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DisposedDominatorReportEntry it = (DisposedDominatorReportEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSize());
                it = (DisposedDominatorReportEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSize()));
            }
        });
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisposedDominatorReportEntry bl = (DisposedDominatorReportEntry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getClassDefinition());
        }
        Collection collection3 = (List)destination$iv$iv2;
        ArrayDeque classOrderByByteCount = new ArrayDeque(collection3);
        boolean nextByInstanceCount = true;
        while (!classOrderByInstanceCount.isEmpty() || !classOrderByByteCount.isEmpty()) {
            ArrayDeque nextCollection;
            ArrayDeque arrayDeque = nextCollection = nextByInstanceCount ? classOrderByInstanceCount : classOrderByByteCount;
            if (!nextCollection.isEmpty()) {
                LongList list3;
                ClassDefinition nextClass = (ClassDefinition)nextCollection.removeFirst();
                if ((LongList)classToLeakedIdsListCopy.remove(nextClass) == null) continue;
                result2.add(list3);
            }
            nextByInstanceCount = !nextByInstanceCount;
        }
        return result2;
    }

    private static final boolean prepareDisposerTreeSummarySection$lambda$0$0$3(AnalysisConfig.DisposerTreeSummaryOptions $options, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((DisposerNode)it.getValue()).getFilteredSubtreeSize() < $options.getNodeCutoff();
    }

    private static final boolean prepareDisposerTreeSummarySection$lambda$0$0$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildDisposerTree$lambda$0(ObjectNavigator $nav, DisposerNode $currentNode, Long2ObjectOpenHashMap $disposerParentToChildren, HashMap $nodeToChildren, long it) {
        block2: {
            Object object;
            void $this$getOrPut$iv;
            String childClassName = $nav.getClassForObjectId(it).getName();
            DisposerNode childNode = $currentNode.getChildForClassName(childClassName);
            childNode.addInstance();
            LongArrayList longArrayList = (LongArrayList)$disposerParentToChildren.get(it);
            if (longArrayList == null) break block2;
            LongArrayList it2 = longArrayList;
            boolean bl = false;
            Map map2 = $nodeToChildren;
            DisposerNode key$iv = childNode;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                LongArrayList answer$iv = new LongArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((LongArrayList)object).addAll((LongList)it2);
        }
    }

    private static final Unit prepareDisposerTreeSection$lambda$0$1(Long2LongOpenHashMap $parentMap, Long parentId, LongArrayList childrenId) {
        Intrinsics.checkNotNull((Object)childrenId);
        Iterable $this$forEach$iv = (Iterable)childrenId;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long childId = (Long)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)childId);
            long l = childId;
            Intrinsics.checkNotNull((Object)parentId);
            $parentMap.put(l, parentId.longValue());
        }
        return Unit.INSTANCE;
    }

    private static final void prepareDisposerTreeSection$lambda$0$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit prepareDisposerTreeSection$lambda$0$3(ObjectNavigator $nav, Long2LongOpenHashMap $parentMap, int $maxTreeDepth, HashSet $tooDeepObjectClasses, HashMap $groupingToObjectStats, Long parentId, LongArrayList childrenId) {
        Intrinsics.checkNotNull((Object)childrenId);
        Iterable $this$forEach$iv = (Iterable)childrenId;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            ClassDefinition classDefinition;
            Long childId = (Long)element$iv;
            boolean bl = false;
            Long l = parentId;
            long l2 = 0L;
            if (l != null && l == l2) {
                classDefinition = null;
            } else {
                Intrinsics.checkNotNull((Object)parentId);
                ObjectNavigator.goTo$default($nav, parentId, null, 2, null);
                classDefinition = $nav.getClass();
            }
            ClassDefinition parentClass = classDefinition;
            Intrinsics.checkNotNull((Object)childId);
            ObjectNavigator.goTo$default($nav, childId, null, 2, null);
            ClassDefinition objectClass = $nav.getClass();
            ClassDefinition rootClass = null;
            long rootId = 0L;
            Long l3 = parentId;
            long l4 = 0L;
            if (l3 != null && l3 == l4) {
                rootClass = objectClass;
                rootId = childId;
            } else {
                Intrinsics.checkNotNull((Object)parentId);
                long rootObjectId = parentId;
                int iterationCount = 0;
                while ($parentMap.get(rootObjectId) != 0L) {
                    rootObjectId = $parentMap.get(rootObjectId);
                    if (++iterationCount != $maxTreeDepth) continue;
                }
                if (iterationCount >= $maxTreeDepth) {
                    $tooDeepObjectClasses.add(objectClass);
                    rootId = parentId;
                    ClassDefinition classDefinition2 = parentClass;
                    Intrinsics.checkNotNull((Object)classDefinition2);
                    rootClass = classDefinition2;
                } else {
                    ObjectNavigator.goTo$default($nav, rootObjectId, null, 2, null);
                    rootId = rootObjectId;
                    rootClass = $nav.getClass();
                }
            }
            Map map2 = $groupingToObjectStats;
            Grouping key$iv = new Grouping(objectClass, parentClass, rootClass);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                InstanceStats answer$iv = new InstanceStats();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            InstanceStats instanceStats = (InstanceStats)object;
            Intrinsics.checkNotNull((Object)parentId);
            instanceStats.registerObject(parentId, rootId);
        }
        return Unit.INSTANCE;
    }

    private static final void prepareDisposerTreeSection$lambda$0$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final LongList prepareDisposedObjectsSection$lambda$0$0$0(ClassDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LongList)new LongArrayList();
    }

    private static final LongList prepareDisposedObjectsSection$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (LongList)$tmp0.invoke(p0);
    }

    private static final Unit prepareDisposedObjectsSection$lambda$0$1(List $entries, Object2IntMap.Entry it) {
        $entries.add(new TObjectIntMapEntry<Object>(it.getKey(), it.getIntValue()));
        return Unit.INSTANCE;
    }

    private static final void prepareDisposedObjectsSection$lambda$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Companion;", "", "<init>", "()V", "TOP_REPORTED_CLASSES", "", "", "getTOP_REPORTED_CLASSES", "()Ljava/util/Set;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getTOP_REPORTED_CLASSES() {
            return TOP_REPORTED_CLASSES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposedDominatorReportEntry;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "count", "", "size", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;JJ)V", "getClassDefinition", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getCount", "()J", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class DisposedDominatorReportEntry {
        @NotNull
        private final ClassDefinition classDefinition;
        private final long count;
        private final long size;

        public DisposedDominatorReportEntry(@NotNull ClassDefinition classDefinition, long count, long size2) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.count = count;
            this.size = size2;
        }

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final long component2() {
            return this.count;
        }

        public final long component3() {
            return this.size;
        }

        @NotNull
        public final DisposedDominatorReportEntry copy(@NotNull ClassDefinition classDefinition, long count, long size2) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            return new DisposedDominatorReportEntry(classDefinition, count, size2);
        }

        public static /* synthetic */ DisposedDominatorReportEntry copy$default(DisposedDominatorReportEntry disposedDominatorReportEntry, ClassDefinition classDefinition, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = disposedDominatorReportEntry.classDefinition;
            }
            if ((n & 2) != 0) {
                l = disposedDominatorReportEntry.count;
            }
            if ((n & 4) != 0) {
                l2 = disposedDominatorReportEntry.size;
            }
            return disposedDominatorReportEntry.copy(classDefinition, l, l2);
        }

        @NotNull
        public String toString() {
            return "DisposedDominatorReportEntry(classDefinition=" + this.classDefinition + ", count=" + this.count + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result2 = this.classDefinition.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.count);
            result2 = result2 * 31 + Long.hashCode(this.size);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisposedDominatorReportEntry)) {
                return false;
            }
            DisposedDominatorReportEntry disposedDominatorReportEntry = (DisposedDominatorReportEntry)other;
            if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)disposedDominatorReportEntry.classDefinition)) {
                return false;
            }
            if (this.count != disposedDominatorReportEntry.count) {
                return false;
            }
            return this.size == disposedDominatorReportEntry.size;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode;", "Lcom/intellij/diagnostic/hprof/util/TreeNode;", "className", "", "<init>", "(Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "count", "", "getCount", "()I", "setCount", "(I)V", "subtreeSize", "getSubtreeSize", "setSubtreeSize", "filteredSubtreeSize", "getFilteredSubtreeSize", "setFilteredSubtreeSize", "children", "Ljava/util/HashMap;", "getChildren", "()Ljava/util/HashMap;", "equals", "", "other", "", "hashCode", "description", "", "addInstance", "", "getChildForClassName", "name", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nAnalyzeDisposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeDisposer.kt\ncom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,660:1\n1068#2:661\n382#3,7:662\n*S KotlinDebug\n*F\n+ 1 AnalyzeDisposer.kt\ncom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$DisposerNode\n*L\n231#1:661\n237#1:662,7\n*E\n"})
    private static final class DisposerNode
    implements TreeNode {
        @NotNull
        private final String className;
        private int count;
        private int subtreeSize;
        private int filteredSubtreeSize;
        @NotNull
        private final HashMap<String, DisposerNode> children;

        public DisposerNode(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.className = className;
            this.children = new HashMap();
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int getSubtreeSize() {
            return this.subtreeSize;
        }

        public final void setSubtreeSize(int n) {
            this.subtreeSize = n;
        }

        public final int getFilteredSubtreeSize() {
            return this.filteredSubtreeSize;
        }

        public final void setFilteredSubtreeSize(int n) {
            this.filteredSubtreeSize = n;
        }

        @NotNull
        public final HashMap<String, DisposerNode> getChildren() {
            return this.children;
        }

        public final boolean equals(@NotNull DisposerNode other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.areEqual((Object)this.className, (Object)other.className);
        }

        public boolean equals(@Nullable Object other) {
            return other != null && other instanceof DisposerNode && this.equals((DisposerNode)other);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        @NotNull
        public String description() {
            return "[" + this.subtreeSize + "] " + this.count + " " + this.className;
        }

        @Override
        @NotNull
        public Collection<TreeNode> children() {
            Collection<DisposerNode> collection = this.children.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$sortedByDescending$iv = collection;
            boolean $i$f$sortedByDescending = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DisposerNode it = (DisposerNode)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getSubtreeSize());
                    it = (DisposerNode)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSubtreeSize()));
                }
            });
        }

        public final void addInstance() {
            int n = this.count;
            this.count = n + 1;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DisposerNode getChildForClassName(@NotNull String name2) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Map map2 = this.children;
            String key$iv = name2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                DisposerNode answer$iv = new DisposerNode(name2);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (DisposerNode)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$Grouping;", "", "childClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "parentClass", "rootClass", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "getChildClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getParentClass", "getRootClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class Grouping {
        @NotNull
        private final ClassDefinition childClass;
        @Nullable
        private final ClassDefinition parentClass;
        @NotNull
        private final ClassDefinition rootClass;

        public Grouping(@NotNull ClassDefinition childClass, @Nullable ClassDefinition parentClass, @NotNull ClassDefinition rootClass) {
            Intrinsics.checkNotNullParameter((Object)childClass, (String)"childClass");
            Intrinsics.checkNotNullParameter((Object)rootClass, (String)"rootClass");
            this.childClass = childClass;
            this.parentClass = parentClass;
            this.rootClass = rootClass;
        }

        @NotNull
        public final ClassDefinition getChildClass() {
            return this.childClass;
        }

        @Nullable
        public final ClassDefinition getParentClass() {
            return this.parentClass;
        }

        @NotNull
        public final ClassDefinition getRootClass() {
            return this.rootClass;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.childClass;
        }

        @Nullable
        public final ClassDefinition component2() {
            return this.parentClass;
        }

        @NotNull
        public final ClassDefinition component3() {
            return this.rootClass;
        }

        @NotNull
        public final Grouping copy(@NotNull ClassDefinition childClass, @Nullable ClassDefinition parentClass, @NotNull ClassDefinition rootClass) {
            Intrinsics.checkNotNullParameter((Object)childClass, (String)"childClass");
            Intrinsics.checkNotNullParameter((Object)rootClass, (String)"rootClass");
            return new Grouping(childClass, parentClass, rootClass);
        }

        public static /* synthetic */ Grouping copy$default(Grouping grouping, ClassDefinition classDefinition, ClassDefinition classDefinition2, ClassDefinition classDefinition3, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = grouping.childClass;
            }
            if ((n & 2) != 0) {
                classDefinition2 = grouping.parentClass;
            }
            if ((n & 4) != 0) {
                classDefinition3 = grouping.rootClass;
            }
            return grouping.copy(classDefinition, classDefinition2, classDefinition3);
        }

        @NotNull
        public String toString() {
            return "Grouping(childClass=" + this.childClass + ", parentClass=" + this.parentClass + ", rootClass=" + this.rootClass + ")";
        }

        public int hashCode() {
            int result2 = this.childClass.hashCode();
            result2 = result2 * 31 + (this.parentClass == null ? 0 : this.parentClass.hashCode());
            result2 = result2 * 31 + this.rootClass.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Grouping)) {
                return false;
            }
            Grouping grouping = (Grouping)other;
            if (!Intrinsics.areEqual((Object)this.childClass, (Object)grouping.childClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentClass, (Object)grouping.parentClass)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rootClass, (Object)grouping.rootClass);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$InstanceStats;", "", "<init>", "()V", "parentIds", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "rootIds", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "parentCount", "", "rootCount", "objectCount", "registerObject", "", "parentId", "", "rootId", "intellij.platform.ide.impl"})
    public static final class InstanceStats {
        @NotNull
        private final LongArrayList parentIds = new LongArrayList();
        @NotNull
        private final LongOpenHashSet rootIds = new LongOpenHashSet();

        public final int parentCount() {
            return new LongOpenHashSet((LongCollection)this.parentIds).size();
        }

        public final int rootCount() {
            return this.rootIds.size();
        }

        public final int objectCount() {
            return this.parentIds.size();
        }

        public final void registerObject(long parentId, long rootId) {
            this.parentIds.add(parentId);
            this.rootIds.add(rootId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeDisposer$SubTreeUpdaterOperation;", "", "<init>", "(Ljava/lang/String;I)V", "PROCESS_CHILDREN", "UPDATE_SIZE", "intellij.platform.ide.impl"})
    private static final class SubTreeUpdaterOperation
    extends Enum<SubTreeUpdaterOperation> {
        public static final /* enum */ SubTreeUpdaterOperation PROCESS_CHILDREN = new SubTreeUpdaterOperation();
        public static final /* enum */ SubTreeUpdaterOperation UPDATE_SIZE = new SubTreeUpdaterOperation();
        private static final /* synthetic */ SubTreeUpdaterOperation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SubTreeUpdaterOperation[] values() {
            return (SubTreeUpdaterOperation[])$VALUES.clone();
        }

        public static SubTreeUpdaterOperation valueOf(String value) {
            return Enum.valueOf(SubTreeUpdaterOperation.class, value);
        }

        @NotNull
        public static EnumEntries<SubTreeUpdaterOperation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = subTreeUpdaterOperationArray = new SubTreeUpdaterOperation[]{SubTreeUpdaterOperation.PROCESS_CHILDREN, SubTreeUpdaterOperation.UPDATE_SIZE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

