/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeDisposer;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.AnalysisReport;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.ListProvider;
import com.intellij.diagnostic.hprof.util.PartialProgressIndicator;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import com.intellij.diagnostic.hprof.util.UByteList;
import com.intellij.diagnostic.hprof.util.UShortList;
import com.intellij.diagnostic.hprof.visitors.HistogramVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 >2\u00020\u0001:\u0002=>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010 \u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0010H\u0002J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020\u001fH\u0004J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J0\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u00132\u0006\u0010,\u001a\u00020+2\u0006\u0010(\u001a\u00020\u001fH\u0002J\u0014\u00102\u001a\u00020\u0015*\u00020\u00132\u0006\u00103\u001a\u00020+H\u0002J\"\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020+2\b\b\u0002\u0010\u0018\u001a\u00020+H\u0002J\"\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020\u001d2\u0006\u00108\u001a\u00020+2\b\b\u0002\u0010\u0018\u001a\u00020+H\u0002J\b\u0010;\u001a\u00020\rH\u0002J\b\u0010<\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "listProvider", "Lcom/intellij/diagnostic/hprof/util/ListProvider;", "<init>", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;Lcom/intellij/diagnostic/hprof/util/ListProvider;)V", "getAnalysisContext", "()Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "unreachableDisposableObjects", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "strongRefHistogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "softWeakRefHistogram", "traverseReport", "", "dominatorFlameGraph", "parentList", "Lcom/intellij/diagnostic/hprof/util/IntList;", "setParentForObjectId", "", "objectId", "", "parentId", "getParentIdForObjectId", "nominatedInstances", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lit/unimi/dsi/fastutil/ints/IntSet;", "analyze", "Lcom/intellij/diagnostic/hprof/util/AnalysisReport;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "preparePerClassSection", "Lcom/intellij/diagnostic/hprof/util/PartialProgressIndicator;", "prepareHistogramSection", "config", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig;", "traverseInstanceGraph", "report", "estimateDominatorTempFilesSize", "objectCount", "", "edgeCount", "computeDominatorFlameGraph", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "rootsSet", "sizesList", "clear", "size", "addIdToListAndSetParentIfOrphan", "", "list", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "id", "addIdToSetIfOrphan", "set", "getAndClearStrongRefHistogram", "getAndClearSoftWeakHistogram", "WalkGraphPhase", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAnalyzeGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeGraph.kt\ncom/intellij/diagnostic/hprof/analysis/AnalyzeGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,1024:1\n1869#2:1025\n1870#2:1027\n1869#2:1028\n1869#2,2:1029\n1870#2:1031\n1869#2,2:1032\n1869#2,2:1034\n1869#2,2:1043\n1869#2,2:1045\n1563#2:1047\n1634#2,3:1048\n1068#2:1051\n1563#2:1052\n1634#2,3:1053\n1068#2:1056\n1869#2,2:1057\n1869#2,2:1059\n1869#2,2:1061\n1068#2:1071\n1869#2,2:1072\n1#3:1026\n382#4,7:1036\n13805#5,2:1063\n13833#5,2:1065\n389#6,4:1067\n*S KotlinDebug\n*F\n+ 1 AnalyzeGraph.kt\ncom/intellij/diagnostic/hprof/analysis/AnalyzeGraph\n*L\n131#1:1025\n131#1:1027\n144#1:1028\n152#1:1029,2\n144#1:1031\n213#1:1032,2\n336#1:1034,2\n409#1:1043,2\n430#1:1045,2\n481#1:1047\n481#1:1048,3\n482#1:1051\n488#1:1052\n488#1:1053,3\n489#1:1056\n524#1:1057,2\n527#1:1059,2\n933#1:1061,2\n919#1:1071\n919#1:1072,2\n388#1:1036,7\n243#1:1063,2\n246#1:1065,2\n884#1:1067,4\n*E\n"})
public class AnalyzeGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalysisContext analysisContext;
    @NotNull
    private final ListProvider listProvider;
    @NotNull
    private final LongArrayList unreachableDisposableObjects;
    @Nullable
    private Histogram strongRefHistogram;
    @Nullable
    private Histogram softWeakRefHistogram;
    @Nullable
    private String traverseReport;
    @Nullable
    private String dominatorFlameGraph;
    @NotNull
    private final com.intellij.diagnostic.hprof.util.IntList parentList;
    @NotNull
    private final HashMap<ClassDefinition, IntSet> nominatedInstances;
    @NotNull
    private final AnalysisConfig config;
    @NotNull
    private static final Logger LOG;

    public AnalyzeGraph(@NotNull AnalysisContext analysisContext, @NotNull ListProvider listProvider) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        Intrinsics.checkNotNullParameter((Object)listProvider, (String)"listProvider");
        this.analysisContext = analysisContext;
        this.listProvider = listProvider;
        this.unreachableDisposableObjects = new LongArrayList();
        this.parentList = this.analysisContext.getParentList();
        this.nominatedInstances = new HashMap();
        this.config = this.analysisContext.getConfig();
    }

    @NotNull
    protected final AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    private final void setParentForObjectId(long objectId, long parentId) {
        this.parentList.set((int)objectId, (int)parentId);
    }

    private final long getParentIdForObjectId(long objectId) {
        return this.parentList.get((int)objectId);
    }

    @NotNull
    public AnalysisReport analyze(@NotNull ProgressIndicator progress) {
        AnalysisReport analysisReport;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        AnalysisReport $this$analyze_u24lambda_u240 = analysisReport = new AnalysisReport(null, null, 3, null);
        boolean bl = false;
        boolean includePerClassSection = !((Collection)this.analysisContext.getConfig().getPerClassOptions().getClassNames()).isEmpty();
        ProgressIndicator traverseProgress = includePerClassSection ? (ProgressIndicator)new PartialProgressIndicator(progress, 0.0, 0.5) : progress;
        AnalyzeDisposer analyzeDisposer = new AnalyzeDisposer(this.analysisContext);
        analyzeDisposer.prepareDisposerChildren();
        this.traverseInstanceGraph(traverseProgress, $this$analyze_u24lambda_u240);
        analyzeDisposer.computeDisposedObjectsIDs();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        if (histogramOptions.getIncludeByCount() || histogramOptions.getIncludeBySize()) {
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Histogram")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(this.prepareHistogramSection());
        }
        if (histogramOptions.getIncludeSummary()) {
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Heap summary")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(this.traverseReport);
        }
        if (includePerClassSection) {
            PartialProgressIndicator perClassProgress = new PartialProgressIndicator(progress, 0.5, 0.5);
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Instances of each nominated class")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(this.preparePerClassSection(perClassProgress));
        }
        if (this.config.getDisposerOptions().getIncludeDisposerTree()) {
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Disposer tree")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(analyzeDisposer.prepareDisposerTreeSection());
        }
        if (this.config.getDisposerOptions().getIncludeDisposerTreeSummary()) {
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Disposer tree summary")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(analyzeDisposer.prepareDisposerTreeSummarySection(this.analysisContext.getDisposerParentToChildren(), this.config.getDisposerOptions().getDisposerTreeSummaryOptions()));
        }
        if (this.config.getDisposerOptions().getIncludeDisposedObjectsSummary() || this.config.getDisposerOptions().getIncludeDisposedObjectsDetails()) {
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Disposed objects")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(analyzeDisposer.prepareDisposedObjectsSection());
        }
        if (this.config.getDominatorTreeOptions().getIncludeDominatorTree()) {
            $this$analyze_u24lambda_u240.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Dominator tree flame graph")).append('\n');
            $this$analyze_u24lambda_u240.getMainReport().append(this.dominatorFlameGraph);
        }
        return analysisReport;
    }

    private final String preparePerClassSection(PartialProgressIndicator progress) {
        Object[] classDefinition;
        StringBuilder stringBuilder;
        StringBuilder $this$preparePerClassSection_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.PerClassOptions perClassOptions = this.analysisContext.getConfig().getPerClassOptions();
        if (perClassOptions.getIncludeClassList()) {
            $this$preparePerClassSection_u24lambda_u240.append("Nominated classes:").append('\n');
            Iterable $this$forEach$iv = perClassOptions.getClassNames();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry histogramEntry;
                Object v0;
                block6: {
                    String name2 = (String)element$iv;
                    boolean bl2 = false;
                    Iterable iterable = histogram.getEntries();
                    Iterator iterator2 = iterable.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        HistogramEntry entry = (HistogramEntry)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)entry.getClassDefinition().getName(), (Object)name2)) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                if ((HistogramEntry)v0 == null) continue;
                classDefinition = histogramEntry.component1();
                long totalInstances = histogramEntry.component2();
                long totalBytes = histogramEntry.component3();
                String prettyName = classDefinition.getPrettyName();
                $this$preparePerClassSection_u24lambda_u240.append(" --> [" + HeapReportUtils.INSTANCE.toShortStringAsCount(totalInstances) + "/" + HeapReportUtils.INSTANCE.toShortStringAsSize(totalBytes) + "] " + prettyName).append('\n');
            }
            $this$preparePerClassSection_u24lambda_u240.append('\n');
        }
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int counter = 0;
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createUnstarted(...)");
        Stopwatch stopwatch2 = stopwatch;
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntSet set;
            ClassDefinition classDefinition2;
            String className = (String)element$iv;
            boolean bl4 = false;
            if (nav.getClassStore().getClassIfExists(className) == null) continue;
            Intrinsics.checkNotNull((Object)this.nominatedInstances.get(classDefinition2));
            progress.setFraction((double)counter / (double)this.nominatedInstances.size());
            classDefinition = new Object[]{set.size(), classDefinition2.getPrettyName()};
            progress.setText2(DiagnosticBundle.message("hprof.analysis.progress", classDefinition));
            stopwatch2.reset().start();
            $this$preparePerClassSection_u24lambda_u240.append("CLASS: " + classDefinition2.getPrettyName() + " (" + set.size() + " objects)").append('\n');
            GCRootPathsTree referenceRegistry = new GCRootPathsTree(this.analysisContext, perClassOptions.getTreeDisplayOptions(), classDefinition2);
            Iterable $this$forEach$iv2 = (Iterable)set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Integer objectId = (Integer)element$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)objectId);
                referenceRegistry.registerObject(objectId);
            }
            set.clear();
            $this$preparePerClassSection_u24lambda_u240.append(referenceRegistry.printTree());
            if (this.config.getMetaInfoOptions().getInclude()) {
                $this$preparePerClassSection_u24lambda_u240.append("Report for " + classDefinition2.getPrettyName() + " created in " + stopwatch2).append('\n');
            }
            $this$preparePerClassSection_u24lambda_u240.append('\n');
            ++counter;
        }
        progress.setFraction(1.0);
        return stringBuilder.toString();
    }

    private final String prepareHistogramSection() {
        StringBuilder result2 = new StringBuilder();
        Histogram strongRefHistogram = this.getAndClearStrongRefHistogram();
        Histogram softWeakRefHistogram = this.getAndClearSoftWeakHistogram();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        result2.append(Histogram.Companion.prepareMergedHistogramReport(histogram, "All", strongRefHistogram, "Strong-ref", histogramOptions));
        long unreachableObjectsCount = histogram.getInstanceCount() - strongRefHistogram.getInstanceCount() - softWeakRefHistogram.getInstanceCount();
        long unreachableObjectsSize = histogram.getBytesCount() - strongRefHistogram.getBytesCount() - softWeakRefHistogram.getBytesCount();
        result2.append("Unreachable objects: " + HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(unreachableObjectsCount) + "  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(unreachableObjectsSize)).append('\n');
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void traverseInstanceGraph(@NotNull ProgressIndicator progress, @NotNull AnalysisReport report) {
        void $this$traverseInstanceGraph_u24lambda_u2410;
        StringBuilder stringBuilder;
        Iterable $this$sortedByDescending$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        AnalysisConfig.TraverseOptions traverseOptions = this.config.getTraverseOptions();
        boolean onlyStrongReferences = traverseOptions.getOnlyStrongReferences();
        boolean includeDisposerRelationships = traverseOptions.getIncludeDisposerRelationships();
        boolean includeFieldInformation = traverseOptions.getIncludeFieldInformation();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        ClassStore classStore = this.analysisContext.getClassStore();
        com.intellij.diagnostic.hprof.util.IntList sizesList = this.analysisContext.getSizesList();
        com.intellij.diagnostic.hprof.util.IntList visitedList = this.analysisContext.getVisitedList();
        UByteList refIndexList = this.analysisContext.getRefIndexList();
        Iterator<ObjectNavigator.RootObject> roots = nav.createRootsIterator();
        this.nominatedInstances.clear();
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassDefinition classDefinition;
            String it = (String)element$iv;
            boolean bl = false;
            if (classStore.getClassIfExists(it) != null) {
                ClassDefinition classDefinition2;
                ClassDefinition classDefinition3 = classDefinition2;
                boolean bl2 = false;
                ((Map)this.nominatedInstances).put(classDefinition3, new IntOpenHashSet());
                classDefinition = classDefinition2;
                continue;
            }
            classDefinition = null;
        }
        progress.setText2(DiagnosticBundle.message("analyze.graph.progress.details.collect.roots", new Object[0]));
        IntArrayList toVisit = null;
        toVisit = new IntArrayList();
        IntArrayList toVisit2 = new IntArrayList();
        IntOpenHashSet rootsSet = new IntOpenHashSet();
        IntOpenHashSet frameRootsSet = new IntOpenHashSet();
        while (roots.hasNext()) {
            ObjectNavigator.RootObject rootObject = roots.next();
            int rootObjectId = (int)rootObject.getId();
            boolean bl = rootObject.getReason().getJavaFrame() ? frameRootsSet.add(rootObjectId) : AnalyzeGraph.addIdToSetIfOrphan$default(this, (IntSet)rootsSet, rootObjectId, 0, 4, null);
        }
        if (this.analysisContext.getConfig().getTraverseOptions().getIncludeClassesAsRoots()) {
            classStore.forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)arg_0 -> AnalyzeGraph.traverseInstanceGraph$lambda$1(this, rootsSet, arg_0)));
        }
        toVisit.addAll((IntCollection)rootsSet);
        int leafCounter = 0;
        progress.setText2(DiagnosticBundle.message("analyze.graph.progress.details.traversing.instance.graph", new Object[0]));
        HashMap strongRefHistogramEntries = new HashMap();
        HashMap reachableNonStrongHistogramEntries = new HashMap();
        Int2IntOpenHashMap softReferenceIdToParentMap = new Int2IntOpenHashMap();
        Int2IntOpenHashMap weakReferenceIdToParentMap = new Int2IntOpenHashMap();
        int visitedInstancesCount = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createStarted(...)");
        Stopwatch stopwatch2 = stopwatch;
        LongArrayList references = new LongArrayList();
        int visitedCount = 0;
        int strongRefVisitedCount = 0;
        int softWeakVisitedCount = 0;
        int edgeCount = 0;
        long finalizableBytes = 0L;
        long softBytes = 0L;
        long weakBytes = 0L;
        WalkGraphPhase phase = WalkGraphPhase.StrongReferencesNonLocalVariables;
        IntArrayList cleanerObjects = new IntArrayList();
        ClassDefinition sunMiscCleanerClass = classStore.getClassIfExists("sun.misc.Cleaner");
        ClassDefinition finalizerClass = classStore.getClassIfExists("java.lang.ref.Finalizer");
        while (!toVisit.isEmpty()) {
            int n = toVisit.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Object object;
                void $this$getOrPut$iv;
                int $i$f$forEach2;
                int id2 = toVisit.getInt(i2);
                if (includeDisposerRelationships && id2 == this.analysisContext.getDisposerTreeObjectId() && phase.compareTo((Enum)WalkGraphPhase.DisposerTree) < 0) continue;
                nav.goTo(id2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                ClassDefinition currentObjectClass = nav.getClass();
                if ((Intrinsics.areEqual((Object)currentObjectClass, (Object)sunMiscCleanerClass) || Intrinsics.areEqual((Object)currentObjectClass, (Object)finalizerClass)) && phase.compareTo((Enum)WalkGraphPhase.CleanerFinalizerReferences) < 0) {
                    if (onlyStrongReferences) continue;
                    cleanerObjects.add(id2);
                    continue;
                }
                int n2 = visitedInstancesCount;
                visitedInstancesCount = n2 + 1;
                IntSet intSet = this.nominatedInstances.get(currentObjectClass);
                Boolean bl = intSet != null ? Boolean.valueOf(intSet.add(id2)) : null;
                boolean isLeaf = true;
                nav.copyReferencesTo((LongList)references);
                boolean currentObjectIsArray = currentObjectClass.isArray();
                if (phase.compareTo((Enum)WalkGraphPhase.SoftReferences) < 0 && nav.getSoftReferenceId() != 0L) {
                    if (!onlyStrongReferences) {
                        softReferenceIdToParentMap.put((int)nav.getSoftReferenceId(), id2);
                    }
                    references.set(nav.getSoftWeakReferenceIndex(), 0L);
                }
                if (phase.compareTo((Enum)WalkGraphPhase.WeakReferences) < 0 && nav.getWeakReferenceId() != 0L) {
                    if (!onlyStrongReferences) {
                        weakReferenceIdToParentMap.put((int)nav.getWeakReferenceId(), id2);
                    }
                    references.set(nav.getSoftWeakReferenceIndex(), 0L);
                }
                int size2 = nav.getObjectSize();
                int nonDisposerReferences = references.size();
                if (includeDisposerRelationships && ((Map)this.analysisContext.getDisposerParentToChildren()).containsKey(id2)) {
                    if (phase.compareTo((Enum)WalkGraphPhase.DisposerTree) >= 0) {
                        this.unreachableDisposableObjects.add((long)id2);
                    }
                    Object object2 = this.analysisContext.getDisposerParentToChildren().get((long)id2);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                    Iterable $this$forEach$iv2 = (Iterable)object2;
                    $i$f$forEach2 = 0;
                    for (Object element$iv : $this$forEach$iv2) {
                        Long it = (Long)element$iv;
                        boolean bl3 = false;
                        references.add(it.longValue());
                    }
                }
                $i$f$forEach2 = references.size();
                for (int j = 0; j < $i$f$forEach2; ++j) {
                    int referenceId = (int)references.getLong(j);
                    if (referenceId != 0) {
                        ++edgeCount;
                    }
                    if (!this.addIdToListAndSetParentIfOrphan(toVisit2, referenceId, id2)) continue;
                    if (includeFieldInformation) {
                        refIndexList.set(referenceId, currentObjectIsArray ? 254 : (j >= nonDisposerReferences ? 255 : (j < 250 ? j + 1 : 0)));
                    }
                    isLeaf = false;
                }
                visitedList.set(visitedCount++, id2);
                int sizeDivBy4 = (size2 + 3) / 4;
                if (sizeDivBy4 == 0) {
                    sizeDivBy4 = 1;
                }
                sizesList.set(id2, sizeDivBy4);
                HashMap histogramEntries = null;
                if (phase == WalkGraphPhase.StrongReferencesNonLocalVariables || phase == WalkGraphPhase.StrongReferencesLocalVariables || phase == WalkGraphPhase.DisposerTree) {
                    histogramEntries = strongRefHistogramEntries;
                    if (isLeaf) {
                        int referenceId = leafCounter;
                        leafCounter = referenceId + 1;
                    }
                    v6 = strongRefVisitedCount++;
                } else {
                    histogramEntries = reachableNonStrongHistogramEntries;
                    switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                        case 1: {
                            finalizableBytes += (long)size2;
                            Unit unit = Unit.INSTANCE;
                            break;
                        }
                        case 2: {
                            softBytes += (long)size2;
                            Unit unit = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            boolean it;
                            boolean bl4 = it = phase == WalkGraphPhase.WeakReferences;
                            if (_Assertions.ENABLED && !it) {
                                String bl3 = "Assertion failed";
                                throw new AssertionError((Object)bl3);
                            }
                            weakBytes += (long)size2;
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    v6 = softWeakVisitedCount++;
                }
                Map referenceId = histogramEntries;
                ClassDefinition key$iv = currentObjectClass;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl5 = false;
                    HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(currentObjectClass);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HistogramVisitor.InternalHistogramEntry)object).addInstance(size2);
            }
            progress.setFraction(1.0 * (double)visitedInstancesCount / (double)nav.getInstanceCount());
            toVisit.clear();
            IntArrayList tmp = toVisit;
            toVisit = toVisit2;
            toVisit2 = tmp;
            while (toVisit.size() == 0 && phase != WalkGraphPhase.Finished) {
                phase = (WalkGraphPhase)((Object)WalkGraphPhase.getEntries().get(phase.ordinal() + 1));
                switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                    case 3: {
                        Iterable $this$forEach$iv3 = (Iterable)frameRootsSet;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv : $this$forEach$iv3) {
                            Integer id3 = (Integer)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)id3);
                            this.addIdToListAndSetParentIfOrphan(toVisit, id3, id3);
                        }
                        Object object = Unit.INSTANCE;
                        break;
                    }
                    case 1: {
                        toVisit.addAll((IntList)cleanerObjects);
                        cleanerObjects.clear();
                        Object object = Unit.INSTANCE;
                        break;
                    }
                    case 2: {
                        Iterable $this$forEach$iv3;
                        Intrinsics.checkNotNullExpressionValue((Object)softReferenceIdToParentMap.int2IntEntrySet().iterator(), (String)"iterator(...)");
                        while ($this$forEach$iv3.hasNext()) {
                            int parentId;
                            Int2IntMap.Entry entry = (Int2IntMap.Entry)$this$forEach$iv3.next();
                            int softId = entry.getIntKey();
                            if (!this.addIdToListAndSetParentIfOrphan(toVisit, softId, parentId = entry.getIntValue())) continue;
                            refIndexList.set(softId, 252);
                        }
                        softReferenceIdToParentMap.clear();
                        Object object = softReferenceIdToParentMap.trim();
                        break;
                    }
                    case 4: {
                        Int2IntMap.FastEntrySet fastEntrySet = weakReferenceIdToParentMap.int2IntEntrySet();
                        Intrinsics.checkNotNullExpressionValue((Object)fastEntrySet, (String)"int2IntEntrySet(...)");
                        Iterable $this$forEach$iv3 = (Iterable)fastEntrySet;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv : $this$forEach$iv3) {
                            int parentId;
                            Int2IntMap.Entry it = (Int2IntMap.Entry)element$iv;
                            boolean bl = false;
                            int weakId = it.getIntKey();
                            if (!this.addIdToListAndSetParentIfOrphan(toVisit, weakId, parentId = it.getIntValue())) continue;
                            refIndexList.set(weakId, 253);
                        }
                        weakReferenceIdToParentMap.clear();
                        Object object = weakReferenceIdToParentMap.trim();
                        break;
                    }
                    case 5: {
                        if (this.analysisContext.getDisposerTreeObjectId() != 0) {
                            toVisit.add(this.analysisContext.getDisposerTreeObjectId());
                        }
                        Object object = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        Object object = Unit.INSTANCE;
                    }
                }
            }
        }
        if (this.config.getDominatorTreeOptions().getIncludeDominatorTree()) {
            long usableDiskSpace22 = new File(FileUtil.getTempDirectory()).getUsableSpace();
            if (usableDiskSpace22 - this.estimateDominatorTempFilesSize(visitedCount, edgeCount) > this.config.getDominatorTreeOptions().getDiskSpaceThreshold()) {
                try {
                    rootsSet.addAll((IntCollection)frameRootsSet);
                    this.computeDominatorFlameGraph(nav, (IntSet)rootsSet, sizesList, edgeCount, report);
                }
                catch (Exception e) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintWriter pw = new PrintWriter(baos);
                    e.printStackTrace(pw);
                    pw.flush();
                    this.dominatorFlameGraph = baos.toString();
                }
            } else {
                this.dominatorFlameGraph = "Omitted due to low disk space";
            }
        }
        rootsSet.clear();
        boolean usableDiskSpace22 = cleanerObjects.isEmpty();
        if (_Assertions.ENABLED && !usableDiskSpace22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        usableDiskSpace22 = softReferenceIdToParentMap.isEmpty();
        if (_Assertions.ENABLED && !usableDiskSpace22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        usableDiskSpace22 = weakReferenceIdToParentMap.isEmpty();
        if (_Assertions.ENABLED && !usableDiskSpace22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Collection collection2 = strongRefHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable usableDiskSpace22 = collection2;
        AnalyzeGraph analyzeGraph = this;
        boolean $i$f$map = false;
        void e = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HistogramVisitor.InternalHistogramEntry it = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asHistogramEntry());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        long l = strongRefVisitedCount;
        List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
            }
        });
        analyzeGraph.strongRefHistogram = new Histogram(list2, l);
        Collection collection3 = reachableNonStrongHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"<get-values>(...)");
        $this$sortedByDescending$iv = collection3;
        analyzeGraph = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HistogramVisitor.InternalHistogramEntry it = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asHistogramEntry());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        long l2 = softWeakVisitedCount;
        List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
            }
        });
        analyzeGraph.softWeakRefHistogram = new Histogram(list3, l2);
        Stopwatch stopwatch3 = Stopwatch.createStarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch3, (String)"createStarted(...)");
        Stopwatch stopwatchUpdateSizes = stopwatch3;
        for (int index = visitedCount - 1; index >= 0; --index) {
            int parentId;
            int id4 = visitedList.get(index);
            if (id4 == (parentId = this.parentList.get(id4))) continue;
            sizesList.set(parentId, sizesList.get(parentId) + sizesList.get(id4));
        }
        stopwatchUpdateSizes.stop();
        StringBuilder parentId = stringBuilder = new StringBuilder();
        analyzeGraph = this;
        boolean bl = false;
        if (this.config.getMetaInfoOptions().getInclude()) {
            $this$traverseInstanceGraph_u24lambda_u2410.append("Analysis completed! Visited instances: " + visitedInstancesCount + ", time: " + stopwatch2).append('\n');
            $this$traverseInstanceGraph_u24lambda_u2410.append("Update sizes time: " + stopwatchUpdateSizes).append('\n');
            $this$traverseInstanceGraph_u24lambda_u2410.append("Leaves found: " + leafCounter).append('\n');
        }
        $this$traverseInstanceGraph_u24lambda_u2410.append("Class count: " + classStore.size()).append('\n');
        $this$traverseInstanceGraph_u24lambda_u2410.append("Finalizable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(finalizableBytes)).append('\n');
        $this$traverseInstanceGraph_u24lambda_u2410.append("Soft-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(softBytes)).append('\n');
        $this$traverseInstanceGraph_u24lambda_u2410.append("Weak-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(weakBytes)).append('\n');
        $this$traverseInstanceGraph_u24lambda_u2410.append("Reachable only from disposer tree: " + this.unreachableDisposableObjects.size()).append('\n');
        Closeable closeable = new TruncatingPrintBuffer(10, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$traverseInstanceGraph_u24lambda_u2410){

            public final StringBuilder invoke(String p0) {
                return ((StringBuilder)this.receiver).append(p0).append('\n');
            }
        }));
        Throwable throwable = null;
        try {
            Long id5;
            TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)closeable;
            boolean bl6 = false;
            LongOpenHashSet unreachableChildren = new LongOpenHashSet();
            Iterable $this$forEach$iv4 = (Iterable)this.unreachableDisposableObjects;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                Unit unit;
                id5 = (Long)element$iv;
                boolean bl7 = false;
                if ((LongArrayList)this.analysisContext.getDisposerParentToChildren().get(id5.longValue()) != null) {
                    LongArrayList it;
                    boolean bl8 = false;
                    unreachableChildren.addAll((LongCollection)it);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            $this$forEach$iv4 = (Iterable)this.unreachableDisposableObjects;
            $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                id5 = (Long)element$iv;
                boolean bl9 = false;
                Intrinsics.checkNotNull((Object)id5);
                if (unreachableChildren.contains(id5.longValue())) continue;
                buffer2.println(" * " + nav.getClassForObjectId(id5).getName() + " (" + HeapReportUtils.INSTANCE.toShortStringAsSize((long)sizesList.get((int)id5.longValue()) * (long)4) + ")");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        analyzeGraph.traverseReport = stringBuilder.toString();
    }

    private final long estimateDominatorTempFilesSize(int objectCount, int edgeCount) {
        return 20L * (long)objectCount + 10L * (long)edgeCount;
    }

    /*
     * WARNING - void declaration
     */
    private final void computeDominatorFlameGraph(ObjectNavigator nav, IntSet rootsSet, com.intellij.diagnostic.hprof.util.IntList sizesList, int edgeCount, AnalysisReport report) {
        void $this$computeDominatorFlameGraph_u24lambda_u246;
        StringBuilder stringBuilder;
        int i2;
        int chunk2;
        int chunkIndex;
        int i3;
        int target;
        int j;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createUnstarted(...)");
        Stopwatch totalStopwatch = stopwatch;
        Stopwatch stopwatch2 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"createUnstarted(...)");
        Stopwatch postorderStopwatch = stopwatch2;
        Stopwatch stopwatch3 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch3, (String)"createUnstarted(...)");
        Stopwatch incomingEdgesStopwatch = stopwatch3;
        Stopwatch stopwatch4 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch4, (String)"createUnstarted(...)");
        Stopwatch sortIncomingEdgesStopwatch = stopwatch4;
        Stopwatch stopwatch5 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch5, (String)"createUnstarted(...)");
        Stopwatch dominatorsStopwatch = stopwatch5;
        Stopwatch stopwatch6 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch6, (String)"createUnstarted(...)");
        Stopwatch retainedSizesStopwatch = stopwatch6;
        Stopwatch stopwatch7 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch7, (String)"createUnstarted(...)");
        Stopwatch flameGraphStopwatch = stopwatch7;
        totalStopwatch.start();
        postorderStopwatch.start();
        int objectCount = (int)nav.getInstanceCount();
        com.intellij.diagnostic.hprof.util.IntList postorderList = this.listProvider.createIntList("postorderList", objectCount + 2);
        com.intellij.diagnostic.hprof.util.IntList postorderNumbers = this.listProvider.createIntList("postorderNumbers", objectCount + 2);
        com.intellij.diagnostic.hprof.util.IntList nodeStack = this.listProvider.createIntList("dominatorBuf1", objectCount + 2);
        com.intellij.diagnostic.hprof.util.IntList childrenStack = this.listProvider.createIntList("childStack", edgeCount + rootsSet.size());
        com.intellij.diagnostic.hprof.util.IntList childrenStackOffsets = this.listProvider.createIntList("dominatorBuf2", objectCount + 2);
        com.intellij.diagnostic.hprof.util.IntList childrenStackSizes = this.listProvider.createIntList("dominatorBuf3", objectCount + 2);
        int csEntries = 0;
        int poEdgeCount = 0;
        poEdgeCount = rootsSet.size();
        IntIterator intIterator = rootsSet.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator2 = intIterator;
        while (iterator2.hasNext()) {
            childrenStack.set(csEntries++, iterator2.nextInt());
        }
        childrenStackSizes.set(0, csEntries);
        childrenStackOffsets.set(0, 0);
        childrenStackOffsets.set(1, csEntries);
        int nsSize = 0;
        int csSize = 1;
        int maxPonum = 0;
        maxPonum = 1;
        int maxStackDepth = 0;
        LongArrayList refList = new LongArrayList();
        while (csSize != 0) {
            int n;
            if (childrenStackSizes.get(csSize - 1) > 0) {
                int child = childrenStack.get(childrenStackOffsets.get(csSize - 1) + childrenStackSizes.get(csSize - 1) - 1);
                n = csSize - 1;
                int n2 = childrenStackSizes.get(n);
                childrenStackSizes.set(n, n2 + -1);
                if (postorderNumbers.get(child) != 0) continue;
                postorderNumbers.set(child, -1);
                nodeStack.set(nsSize++, child);
                ObjectNavigator.goTo$default(nav, child, null, 2, null);
                nav.copyReferencesTo((LongList)refList);
                int refsAdded = 0;
                int n3 = refList.size();
                for (int i4 = 0; i4 < n3; ++i4) {
                    if (refList.getLong(i4) == 0L) continue;
                    childrenStack.set(csEntries++, (int)refList.getLong(i4));
                    ++refsAdded;
                    int n4 = poEdgeCount;
                    poEdgeCount = n4 + 1;
                }
                childrenStackSizes.set(csSize, refsAdded);
                childrenStackOffsets.set(csSize + 1, childrenStackOffsets.get(csSize) + refsAdded);
                maxStackDepth = Math.max(++csSize, maxStackDepth);
                continue;
            }
            if (--csSize == 0) break;
            csEntries = childrenStackOffsets.get(csSize);
            if (nsSize == 0) continue;
            int n5 = nodeStack.get(nsSize - 1);
            postorderList.set(maxPonum, n5);
            n = maxPonum;
            maxPonum = n + 1;
            postorderNumbers.set(n5, n);
            --nsSize;
        }
        int rootPonum = maxPonum;
        postorderNumbers.set(objectCount + 1, rootPonum);
        postorderStopwatch.stop();
        incomingEdgesStopwatch.start();
        int cardBits = maxPonum < 65536 ? 0 : (int)(Math.log((double)maxPonum / 65536.0) / Math.log(2.0) + 1.0);
        int cardSize = 1 << cardBits;
        int ncards = (maxPonum + cardSize - 1) / cardSize;
        int ncardChunks = (ncards + 63) / 64;
        long[] dirtyCards = new long[ncardChunks];
        ArraysKt.fill$default((long[])dirtyCards, (long)-1L, (int)0, (int)0, (int)6, null);
        UShortList outgoingCardRefs = this.listProvider.createUShortList("cardRefs", poEdgeCount);
        com.intellij.diagnostic.hprof.util.IntList outgoingCardListOffsets = nodeStack;
        this.clear(outgoingCardListOffsets, maxPonum + 1);
        com.intellij.diagnostic.hprof.util.IntList edgeListOffsets = childrenStackOffsets;
        this.clear(edgeListOffsets, maxPonum + 1);
        LongArrayList references = new LongArrayList();
        int ncardrefs = 0;
        int n = maxPonum;
        for (int i5 = 1; i5 < n; ++i5) {
            int n6;
            int id2 = postorderList.get(i5);
            ObjectNavigator.goTo$default(nav, id2, null, 2, null);
            nav.copyReferencesTo((LongList)references);
            if (rootsSet.contains(id2)) {
                int n7 = i5;
                n6 = edgeListOffsets.get(n7);
                edgeListOffsets.set(n7, n6 + 1);
            }
            outgoingCardListOffsets.set(i5, ncardrefs);
            n6 = references.size();
            for (j = 0; j < n6; ++j) {
                if (references.getLong(j) == 0L) continue;
                target = postorderNumbers.get((int)references.getLong(j));
                int n8 = edgeListOffsets.get(target);
                edgeListOffsets.set(target, n8 + 1);
                outgoingCardRefs.set(ncardrefs++, target >> cardBits);
            }
        }
        outgoingCardListOffsets.set(maxPonum, ncardrefs);
        int next = 0;
        int psum = edgeListOffsets.get(0);
        j = maxPonum;
        for (int i6 = 0; i6 < j; ++i6) {
            next = edgeListOffsets.get(i6 + 1);
            edgeListOffsets.set(i6 + 1, psum);
            psum += next;
        }
        edgeListOffsets.set(0, 0);
        com.intellij.diagnostic.hprof.util.IntList incomingEdges = null;
        if (poEdgeCount < edgeCount + rootsSet.size()) {
            incomingEdges = childrenStack;
            this.clear(incomingEdges, poEdgeCount);
        } else {
            incomingEdges = this.listProvider.createIntList("incoming", poEdgeCount);
        }
        com.intellij.diagnostic.hprof.util.IntList edgeListIndices = childrenStackSizes;
        this.clear(edgeListIndices, maxPonum + 1);
        target = maxPonum;
        for (i3 = 1; i3 < target; ++i3) {
            int id3 = postorderList.get(i3);
            ObjectNavigator.goTo$default(nav, id3, null, 2, null);
            nav.copyReferencesTo((LongList)references);
            if (rootsSet.contains(id3)) {
                AnalyzeGraph.computeDominatorFlameGraph$addEdge(edgeListOffsets, edgeListIndices, incomingEdges, i3, rootPonum);
            }
            int n9 = references.size();
            for (int j2 = 0; j2 < n9; ++j2) {
                if (references.getLong(j2) == 0L) continue;
                int target2 = postorderNumbers.get((int)references.getLong(j2));
                AnalyzeGraph.computeDominatorFlameGraph$addEdge(edgeListOffsets, edgeListIndices, incomingEdges, target2, i3);
            }
        }
        incomingEdgesStopwatch.stop();
        sortIncomingEdgesStopwatch.start();
        target = maxPonum - 1;
        for (i3 = 0; i3 < target; ++i3) {
            int j3;
            int size2 = edgeListOffsets.get(i3 + 1) - edgeListOffsets.get(i3);
            if (size2 <= 1) continue;
            int[] arr = new int[size2];
            for (j3 = 0; j3 < size2; ++j3) {
                arr[j3] = incomingEdges.get(edgeListOffsets.get(i3) + j3);
            }
            Arrays.sort(arr);
            for (j3 = 0; j3 < size2; ++j3) {
                incomingEdges.set(edgeListOffsets.get(i3) + j3, arr[j3]);
            }
        }
        sortIncomingEdgesStopwatch.stop();
        dominatorsStopwatch.start();
        com.intellij.diagnostic.hprof.util.IntList idomList = edgeListIndices;
        this.clear(idomList, maxPonum + 1);
        idomList.set(rootPonum, rootPonum);
        Ref.IntRef intersectCalls = new Ref.IntRef();
        Ref.IntRef rootSkipIntersectCalls = new Ref.IntRef();
        int nchanged = 1;
        int iter2 = 0;
        int idomUpdates = 0;
        int prevIntersectCalls = 0;
        long updateCallsSavedByCardTable = 0L;
        while (nchanged != 0 && iter2 < this.config.getDominatorTreeOptions().getMaxDominatorIterations()) {
            Stopwatch iterationStopwatch;
            Intrinsics.checkNotNullExpressionValue((Object)Stopwatch.createStarted(), (String)"createStarted(...)");
            int nupdates = 0;
            nchanged = 0;
            chunkIndex = ncardChunks - 1;
            while (chunkIndex >= 0) {
                long chunk2 = dirtyCards[chunkIndex];
                if (chunk2 == 0L) {
                    updateCallsSavedByCardTable += (long)(cardSize * 64);
                    --chunkIndex;
                    continue;
                }
                for (int card = 63; card >= 0; --card) {
                    if ((chunk2 & 1L << card) != 0L) {
                        int ponum;
                        int basePonum = cardSize * (chunkIndex * 64 + card);
                        int i7 = cardSize - 1;
                        AnalyzeGraph.computeDominatorFlameGraph$markCard(dirtyCards, chunkIndex * 64 + card, false);
                        while (i7 >= 0 && (ponum = basePonum + i7) != 0) {
                            if (ponum >= rootPonum) {
                                --i7;
                                continue;
                            }
                            if (idomList.get(ponum) == rootPonum) {
                                --i7;
                                continue;
                            }
                            int n10 = idomUpdates;
                            idomUpdates = n10 + 1;
                            ++nupdates;
                            if (AnalyzeGraph.computeDominatorFlameGraph$updateIdom(rootPonum, rootSkipIntersectCalls, idomList, edgeListOffsets, incomingEdges, intersectCalls, ponum)) {
                                for (int chidx = outgoingCardListOffsets.get(ponum); chidx < outgoingCardListOffsets.get(ponum + 1); ++chidx) {
                                    int targetCard = outgoingCardRefs.get(chidx);
                                    AnalyzeGraph.computeDominatorFlameGraph$markCard(dirtyCards, targetCard, true);
                                }
                                ++nchanged;
                            }
                            --i7;
                        }
                        continue;
                    }
                    updateCallsSavedByCardTable += (long)cardSize;
                }
                --chunkIndex;
            }
            LOG.debug("iteration " + iter2 + " recomputed " + nupdates + " and changed " + nchanged + " idoms in " + iterationStopwatch + "; called intersect() " + (intersectCalls.element - prevIntersectCalls) + " times");
            prevIntersectCalls = intersectCalls.element;
            chunk2 = iter2;
            iter2 = chunk2 + 1;
        }
        dominatorsStopwatch.stop();
        retainedSizesStopwatch.start();
        com.intellij.diagnostic.hprof.util.IntList retainedSizes = outgoingCardListOffsets;
        chunkIndex = maxPonum;
        for (i2 = 1; i2 < chunkIndex; ++i2) {
            retainedSizes.set(i2, sizesList.get(postorderList.get(i2)));
        }
        chunkIndex = maxPonum;
        for (i2 = 1; i2 < chunkIndex; ++i2) {
            chunk2 = idomList.get(i2);
            retainedSizes.set(chunk2, retainedSizes.get(chunk2) + retainedSizes.get(i2));
        }
        retainedSizesStopwatch.stop();
        flameGraphStopwatch.start();
        Map idomTreeChildren = new LinkedHashMap();
        chunk2 = maxPonum;
        for (int i8 = 1; i8 < chunk2; ++i8) {
            if ((long)retainedSizes.get(i8) * 4L < (long)this.config.getDominatorTreeOptions().getMinNodeSize()) continue;
            idomTreeChildren.computeIfAbsent(idomList.get(i8), arg_0 -> AnalyzeGraph.computeDominatorFlameGraph$lambda$1(AnalyzeGraph::computeDominatorFlameGraph$lambda$0, arg_0)).add(i8);
        }
        Map stringToIndex = new LinkedHashMap();
        List indexToString = new ArrayList();
        Ref.IntRef renderedNodes = new Ref.IntRef();
        StringBuilder sb = new StringBuilder();
        AnalyzeGraph.computeDominatorFlameGraph$dumpCompressedFlameGraph$default(sb, idomTreeChildren, this, retainedSizes, renderedNodes, rootPonum, nav, postorderList, stringToIndex, indexToString, rootPonum, 0, 1024, null);
        StringBuilder i7 = stringBuilder = new StringBuilder();
        int n11 = 0;
        StringBuilder stringBuilder2 = sb;
        boolean bl = false;
        StringBuilder stringBuilder3 = $this$computeDominatorFlameGraph_u24lambda_u246.append(indexToString.size());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        stringBuilder3.append('\n');
        Iterable $this$forEach$iv = indexToString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$computeDominatorFlameGraph_u24lambda_u246.append(it).append('\n');
        }
        Unit unit = Unit.INSTANCE;
        stringBuilder2.insert(n11, stringBuilder.toString());
        this.dominatorFlameGraph = sb.toString();
        flameGraphStopwatch.stop();
        totalStopwatch.stop();
        StringBuilder $this$computeDominatorFlameGraph_u24lambda_u247 = stringBuilder = report.getMetaInfo();
        boolean bl3 = false;
        $this$computeDominatorFlameGraph_u24lambda_u247.append("Dominator phase total time: " + totalStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("  Compute postorder numbers: " + postorderStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    edgeCount = " + edgeCount + ", poEdgeCount = " + poEdgeCount + ", rootsSet size = " + rootsSet.size() + ", maxPonum = " + maxPonum + "; max stack depth = " + maxStackDepth).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("  Compute incoming edges + card refs: " + incomingEdgesStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("  Sort incoming edges: " + sortIncomingEdgesStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("  Dominator computation: " + dominatorsStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    " + iter2 + " iterations").append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    " + idomUpdates + " idom updates (" + AnalyzeGraph.computeDominatorFlameGraph$round((double)idomUpdates / (double)maxPonum) + "x per node); " + intersectCalls.element + " calls to intersect (" + AnalyzeGraph.computeDominatorFlameGraph$round((double)intersectCalls.element / (double)idomUpdates) + " per idomUpdate)").append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    card table is " + ncards + " bits x " + cardSize + " obj/bit, saved " + updateCallsSavedByCardTable + " idom updates").append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    aborting updateIdom when root is hit saved " + rootSkipIntersectCalls.element + " intersect calls").append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("  Compute retained sizes: " + retainedSizesStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("  Emit flame graph: " + flameGraphStopwatch).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    retained size cutoff: " + this.config.getDominatorTreeOptions().getMinNodeSize()).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    depth cutoff: " + this.config.getDominatorTreeOptions().getMaxDepth()).append('\n');
        $this$computeDominatorFlameGraph_u24lambda_u247.append("    pruned tree contains " + renderedNodes.element + " nodes " + (String)(renderedNodes.element > this.config.getDominatorTreeOptions().getHeadLimit() ? "(truncated to " + this.config.getDominatorTreeOptions().getHeadLimit() + ")" : "")).append('\n');
    }

    private final void clear(com.intellij.diagnostic.hprof.util.IntList $this$clear, int size2) {
        for (int i2 = 0; i2 < size2; ++i2) {
            $this$clear.set(i2, 0);
        }
    }

    private final boolean addIdToListAndSetParentIfOrphan(IntArrayList list2, int id2, int parentId) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L) {
            this.setParentForObjectId(id2, parentId);
            list2.add(id2);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToListAndSetParentIfOrphan$default(AnalyzeGraph analyzeGraph, IntArrayList intArrayList, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addIdToListAndSetParentIfOrphan");
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToListAndSetParentIfOrphan(intArrayList, n, n2);
    }

    private final boolean addIdToSetIfOrphan(IntSet set, int id2, int parentId) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L && set.add(id2)) {
            this.setParentForObjectId(id2, parentId);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToSetIfOrphan$default(AnalyzeGraph analyzeGraph, IntSet intSet, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addIdToSetIfOrphan");
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToSetIfOrphan(intSet, n, n2);
    }

    private final Histogram getAndClearStrongRefHistogram() {
        Histogram result2 = this.strongRefHistogram;
        this.strongRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    private final Histogram getAndClearSoftWeakHistogram() {
        Histogram result2 = this.softWeakRefHistogram;
        this.softWeakRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    private static final Unit traverseInstanceGraph$lambda$1(AnalyzeGraph this$0, IntOpenHashSet $rootsSet, ClassDefinition classDefinition) {
        int n;
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        AnalyzeGraph.addIdToSetIfOrphan$default(this$0, (IntSet)$rootsSet, (int)classDefinition.getId(), 0, 4, null);
        Object[] $this$forEach$iv = classDefinition.getObjectStaticFields();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            StaticField element$iv;
            StaticField staticField = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            AnalyzeGraph.addIdToSetIfOrphan$default(this$0, (IntSet)$rootsSet, (int)staticField.getValue(), 0, 4, null);
        }
        $this$forEach$iv = classDefinition.getConstantFields();
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            StaticField element$iv;
            StaticField objectId = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            AnalyzeGraph.addIdToSetIfOrphan$default(this$0, (IntSet)$rootsSet, (int)objectId, 0, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final int computeDominatorFlameGraph$getEdge(com.intellij.diagnostic.hprof.util.IntList incomingEdges, com.intellij.diagnostic.hprof.util.IntList edgeListOffsets, int ponum, int index) {
        return incomingEdges.get(edgeListOffsets.get(ponum) + index);
    }

    private static final void computeDominatorFlameGraph$addEdge(com.intellij.diagnostic.hprof.util.IntList edgeListOffsets, com.intellij.diagnostic.hprof.util.IntList edgeListIndices, com.intellij.diagnostic.hprof.util.IntList incomingEdges, int ponum, int parent) {
        int nextFreeSlot = edgeListOffsets.get(ponum) + edgeListIndices.get(ponum);
        incomingEdges.set(nextFreeSlot, parent);
        int n = edgeListIndices.get(ponum);
        edgeListIndices.set(ponum, n + 1);
    }

    private static final int computeDominatorFlameGraph$numIncomingEdges(com.intellij.diagnostic.hprof.util.IntList edgeListOffsets, int ponum) {
        return edgeListOffsets.get(ponum + 1) - edgeListOffsets.get(ponum);
    }

    private static final int computeDominatorFlameGraph$intersect(Ref.IntRef intersectCalls, com.intellij.diagnostic.hprof.util.IntList idomList, int a, int b) {
        int n = intersectCalls.element;
        intersectCalls.element = n + 1;
        int i2 = a;
        int j = b;
        while (i2 != j) {
            while (i2 < j) {
                if (i2 == 0) {
                    return j;
                }
                i2 = idomList.get(i2);
            }
            while (j < i2) {
                if (j == 0) {
                    return i2;
                }
                j = idomList.get(j);
            }
        }
        return i2;
    }

    private static final boolean computeDominatorFlameGraph$updateIdom(int rootPonum, Ref.IntRef rootSkipIntersectCalls, com.intellij.diagnostic.hprof.util.IntList idomList, com.intellij.diagnostic.hprof.util.IntList edgeListOffsets, com.intellij.diagnostic.hprof.util.IntList incomingEdges, Ref.IntRef intersectCalls, int i2) {
        int parent;
        int numIncoming = AnalyzeGraph.computeDominatorFlameGraph$numIncomingEdges(edgeListOffsets, i2);
        int newIdom = AnalyzeGraph.computeDominatorFlameGraph$getEdge(incomingEdges, edgeListOffsets, i2, numIncoming - 1);
        for (int j = numIncoming - 2; j >= 0 && (parent = AnalyzeGraph.computeDominatorFlameGraph$getEdge(incomingEdges, edgeListOffsets, i2, j)) != 0; --j) {
            int intersection = AnalyzeGraph.computeDominatorFlameGraph$intersect(intersectCalls, idomList, newIdom, parent);
            if (intersection != 0) {
                newIdom = intersection;
            }
            if (newIdom != rootPonum) continue;
            rootSkipIntersectCalls.element += j;
            break;
        }
        if (newIdom != idomList.get(i2)) {
            idomList.set(i2, newIdom);
            return true;
        }
        return false;
    }

    private static final void computeDominatorFlameGraph$markCard(long[] dirtyCards, int cardNumber, boolean value) {
        int chunk = cardNumber >> 6;
        int card = cardNumber & 0x3F;
        dirtyCards[chunk] = value ? dirtyCards[chunk] | 1L << card : dirtyCards[chunk] & (1L << card ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static final List computeDominatorFlameGraph$lambda$0(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List computeDominatorFlameGraph$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final String computeDominatorFlameGraph$signatureFor(int rootPonum, ObjectNavigator $nav, com.intellij.diagnostic.hprof.util.IntList postorderList, int ponum) {
        String string;
        block3: {
            if (ponum == rootPonum) {
                string = "root";
            } else {
                String $this$dropLastWhile$iv = $nav.getClassForObjectId(postorderList.get(ponum)).getName();
                boolean $i$f$dropLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$dropLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ';') continue;
                    String string2 = $this$dropLastWhile$iv;
                    int n = 0;
                    int n2 = index$iv + 1;
                    String string3 = string2.substring(n, n2);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block3;
                }
                string = "";
            }
        }
        return string;
    }

    private static final int computeDominatorFlameGraph$addStringToPool(Map<String, Integer> stringToIndex, List<String> indexToString, String s) {
        if (!stringToIndex.containsKey(s)) {
            stringToIndex.put(s, stringToIndex.size());
            indexToString.add(s);
        }
        Integer n = stringToIndex.get(s);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final void computeDominatorFlameGraph$dumpCompressedFlameGraph(StringBuilder $this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph, Map<Integer, List<Integer>> idomTreeChildren, AnalyzeGraph this$0, com.intellij.diagnostic.hprof.util.IntList retainedSizes, Ref.IntRef renderedNodes, int rootPonum, ObjectNavigator $nav, com.intellij.diagnostic.hprof.util.IntList postorderList, Map<String, Integer> stringToIndex, List<String> indexToString, int poNumber, int depth) {
        int signatureIndex = AnalyzeGraph.computeDominatorFlameGraph$addStringToPool(stringToIndex, indexToString, AnalyzeGraph.computeDominatorFlameGraph$signatureFor(rootPonum, $nav, postorderList, poNumber));
        List<Integer> children2 = idomTreeChildren.get(poNumber);
        if (depth < this$0.config.getDominatorTreeOptions().getMaxDepth() && children2 != null) {
            void $this$forEach$iv;
            int p;
            Iterable iterable = children2;
            int n = 0;
            for (Object t : iterable) {
                int n2 = ((Number)t).intValue();
                int n3 = n;
                boolean bl = false;
                int n4 = retainedSizes.get(p);
                n = n3 + n4;
            }
            int childrenSize = n;
            $this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph.append(signatureIndex + " " + (retainedSizes.get(poNumber) - childrenSize) + " " + children2.size()).append('\n');
            int n5 = renderedNodes.element;
            renderedNodes.element = n5 + 1;
            Iterable $this$sortedByDescending$iv = children2;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(retainedSizes){
                final /* synthetic */ com.intellij.diagnostic.hprof.util.IntList $retainedSizes$inlined;
                {
                    this.$retainedSizes$inlined = intList;
                }

                public final int compare(T a, T b) {
                    int p = ((Number)b).intValue();
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$retainedSizes$inlined.get(p));
                    p = ((Number)a).intValue();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$retainedSizes$inlined.get(p)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p = ((Number)element$iv).intValue();
                boolean bl = false;
                if (renderedNodes.element >= this$0.config.getDominatorTreeOptions().getHeadLimit()) continue;
                AnalyzeGraph.computeDominatorFlameGraph$dumpCompressedFlameGraph($this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph, idomTreeChildren, this$0, retainedSizes, renderedNodes, rootPonum, $nav, postorderList, stringToIndex, indexToString, p, depth + 1);
            }
        } else {
            $this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph.append(signatureIndex + " " + retainedSizes.get(poNumber) + " 0").append('\n');
            int n = renderedNodes.element;
            renderedNodes.element = n + 1;
        }
    }

    static /* synthetic */ void computeDominatorFlameGraph$dumpCompressedFlameGraph$default(StringBuilder stringBuilder, Map map2, AnalyzeGraph analyzeGraph, com.intellij.diagnostic.hprof.util.IntList intList, Ref.IntRef intRef, int n, ObjectNavigator objectNavigator, com.intellij.diagnostic.hprof.util.IntList intList2, Map map3, List list2, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: computeDominatorFlameGraph$dumpCompressedFlameGraph");
        }
        if ((n4 & 0x400) != 0) {
            n3 = 0;
        }
        AnalyzeGraph.computeDominatorFlameGraph$dumpCompressedFlameGraph(stringBuilder, map2, analyzeGraph, intList, intRef, n, objectNavigator, intList2, map3, list2, n2, n3);
    }

    private static final String computeDominatorFlameGraph$round(double $this$computeDominatorFlameGraph_u24round) {
        String s = String.valueOf($this$computeDominatorFlameGraph_u24round);
        if (!StringsKt.contains$default((CharSequence)s, (char)'.', (boolean)false, (int)2, null)) {
            return s;
        }
        String string = s.substring(0, Math.min(StringsKt.indexOf$default((CharSequence)s, (String)".", (int)0, (boolean)false, (int)6, null) + 3, s.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    static {
        Logger logger2 = Logger.getInstance(AnalyzeGraph.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph$WalkGraphPhase;", "", "<init>", "(Ljava/lang/String;I)V", "StrongReferencesNonLocalVariables", "StrongReferencesLocalVariables", "DisposerTree", "SoftReferences", "WeakReferences", "CleanerFinalizerReferences", "Finished", "intellij.platform.ide.impl"})
    public static final class WalkGraphPhase
    extends Enum<WalkGraphPhase> {
        public static final /* enum */ WalkGraphPhase StrongReferencesNonLocalVariables = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase StrongReferencesLocalVariables = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase DisposerTree = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase SoftReferences = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase WeakReferences = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase CleanerFinalizerReferences = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase Finished = new WalkGraphPhase();
        private static final /* synthetic */ WalkGraphPhase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WalkGraphPhase[] values() {
            return (WalkGraphPhase[])$VALUES.clone();
        }

        public static WalkGraphPhase valueOf(String value) {
            return Enum.valueOf(WalkGraphPhase.class, value);
        }

        @NotNull
        public static EnumEntries<WalkGraphPhase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = walkGraphPhaseArray = new WalkGraphPhase[]{WalkGraphPhase.StrongReferencesNonLocalVariables, WalkGraphPhase.StrongReferencesLocalVariables, WalkGraphPhase.DisposerTree, WalkGraphPhase.SoftReferences, WalkGraphPhase.WeakReferences, WalkGraphPhase.CleanerFinalizerReferences, WalkGraphPhase.Finished};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WalkGraphPhase.values().length];
            try {
                nArray[WalkGraphPhase.CleanerFinalizerReferences.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WalkGraphPhase.SoftReferences.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WalkGraphPhase.StrongReferencesLocalVariables.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WalkGraphPhase.WeakReferences.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WalkGraphPhase.DisposerTree.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

