/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/ClassNomination;", "", "histogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "classLimitPerCategory", "", "<init>", "(Lcom/intellij/diagnostic/hprof/histogram/Histogram;I)V", "nominateClasses", "", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "isInterestingClass", "", "name", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nClassNomination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNomination.kt\ncom/intellij/diagnostic/hprof/analysis/ClassNomination\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1068#2:72\n774#2:73\n865#2,2:74\n1869#2,2:76\n1869#2,2:78\n1068#2:80\n1068#2:81\n1869#2,2:82\n1869#2,2:84\n1068#2:87\n1#3:86\n*S KotlinDebug\n*F\n+ 1 ClassNomination.kt\ncom/intellij/diagnostic/hprof/analysis/ClassNomination\n*L\n27#1:72\n28#1:73\n28#1:74,2\n30#1:76,2\n31#1:78,2\n33#1:80\n34#1:81\n36#1:82,2\n37#1:84,2\n42#1:87\n*E\n"})
public final class ClassNomination {
    @NotNull
    private final Histogram histogram;
    private final int classLimitPerCategory;

    public ClassNomination(@NotNull Histogram histogram, int classLimitPerCategory) {
        Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
        this.histogram = histogram;
        this.classLimitPerCategory = classLimitPerCategory;
    }

    @NotNull
    public final List<HistogramEntry> nominateClasses() {
        Object v0;
        Object it5;
        boolean $i$f$sortedByDescending;
        Iterable $this$sortedByDescending$iv;
        HashSet<Object> resultClasses;
        block7: {
            HistogramEntry it2;
            Object element$iv3;
            Iterator $this$filterTo$iv$iv;
            resultClasses = new HashSet<Object>();
            List<HistogramEntry> entries2 = this.histogram.getEntries();
            Iterable $this$sortedByDescending$iv2 = entries2;
            boolean $i$f$sortedByDescending2 = false;
            List histogramByInstances = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HistogramEntry it = (HistogramEntry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTotalInstances());
                    it = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
                }
            });
            Iterable $this$filter$iv = histogramByInstances;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                HistogramEntry it3 = (HistogramEntry)element$iv$iv;
                boolean bl = false;
                if (!this.isInterestingClass(it3.getClassDefinition().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List interestingClasses = (List)destination$iv$iv;
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)histogramByInstances, (int)this.classLimitPerCategory);
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                HistogramEntry it4 = (HistogramEntry)element$iv2;
                boolean bl = false;
                resultClasses.add(it4);
            }
            $this$forEach$iv = CollectionsKt.take((Iterable)interestingClasses, (int)this.classLimitPerCategory);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                HistogramEntry it5 = (HistogramEntry)element$iv2;
                boolean bl = false;
                resultClasses.add(it5);
            }
            Iterable $this$sortedByDescending$iv3 = entries2;
            boolean $i$f$sortedByDescending3 = false;
            List histogramByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv3, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HistogramEntry it = (HistogramEntry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTotalBytes());
                    it = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
                }
            });
            $this$sortedByDescending$iv = interestingClasses;
            $i$f$sortedByDescending = false;
            List interestingClassesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HistogramEntry it = (HistogramEntry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTotalBytes());
                    it = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
                }
            });
            Iterable $this$forEach$iv2 = CollectionsKt.take((Iterable)histogramByBytes, (int)this.classLimitPerCategory);
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                it2 = (HistogramEntry)element$iv3;
                boolean bl = false;
                resultClasses.add(it2);
            }
            $this$forEach$iv2 = CollectionsKt.take((Iterable)interestingClassesByBytes, (int)this.classLimitPerCategory);
            $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                it2 = (HistogramEntry)element$iv3;
                boolean bl = false;
                resultClasses.add(it2);
            }
            it5 = entries2;
            element$iv3 = it5.iterator();
            while (element$iv3.hasNext()) {
                Object e = element$iv3.next();
                HistogramEntry it6 = (HistogramEntry)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it6.getClassDefinition().getName(), (Object)"java.nio.DirectByteBuffer")) continue;
                v0 = e;
                break block7;
            }
            v0 = null;
        }
        HistogramEntry histogramEntry = v0;
        if (histogramEntry != null) {
            it5 = histogramEntry;
            boolean bl = false;
            resultClasses.add(it5);
        }
        $this$sortedByDescending$iv = new ArrayList(resultClasses);
        $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
            }
        });
    }

    private final boolean isInterestingClass(String name2) {
        String localName = name2;
        int lastBracketIndex = StringsKt.lastIndexOf$default((CharSequence)localName, (char)'[', (int)0, (boolean)false, (int)6, null);
        if (lastBracketIndex >= 1) {
            String string = localName.substring(lastBracketIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            localName = string;
        }
        if (localName.length() == 2 && localName.charAt(0) == '[') {
            return false;
        }
        if (StringsKt.startsWith$default((String)localName, (String)"[L", (boolean)false, (int)2, null)) {
            boolean bl;
            boolean bl2 = bl = StringsKt.last((CharSequence)localName) == ';';
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = localName.substring(2, localName.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            localName = string;
        }
        return !StringsKt.startsWith$default((String)localName, (String)"java.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)localName, (String)"com.google.common.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)localName, (String)"kotlin.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)localName, (String)"com.intellij.util.", (boolean)false, (int)2, null);
    }
}

