/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.RefIndexUtil;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import com.intellij.diagnostic.hprof.util.UByteList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\t\u001b\u001c\u001d\u001e\u001f !\"#B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "treeDisplayOptions", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "allObjectsOfClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "<init>", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "getAnalysisContext", "()Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "topNode", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode;", "countOfIgnoredObjects", "", "objectSizeStrategy", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "registerObject", "", "objectId", "printTree", "", "getDisposedDominatorNodes", "", "", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Status", "ObjectSizeCalculationStrategy", "AllObjectsSameSizeStrategy", "SizeFromObjectNavigatorStrategy", "DirectByteBufferNativeSizeStrategy", "Node", "Edge", "RegularNode", "RootNode", "intellij.platform.ide.impl"})
public final class GCRootPathsTree {
    @NotNull
    private final AnalysisContext analysisContext;
    @NotNull
    private final AnalysisConfig.TreeDisplayOptions treeDisplayOptions;
    @NotNull
    private final RootNode topNode;
    private int countOfIgnoredObjects;
    @NotNull
    private final ObjectSizeCalculationStrategy objectSizeStrategy;

    public GCRootPathsTree(@NotNull AnalysisContext analysisContext, @NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @Nullable ClassDefinition allObjectsOfClass) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        Intrinsics.checkNotNullParameter((Object)treeDisplayOptions, (String)"treeDisplayOptions");
        this.analysisContext = analysisContext;
        this.treeDisplayOptions = treeDisplayOptions;
        this.topNode = new RootNode(this.analysisContext.getClassStore());
        this.objectSizeStrategy = ObjectSizeCalculationStrategy.Companion.getBestStrategyForClass(allObjectsOfClass);
    }

    @NotNull
    public final AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public final void registerObject(int objectId) {
        boolean bl;
        ObjectNavigator nav = this.analysisContext.getNavigator();
        IntList parentMapping = this.analysisContext.getParentList();
        UByteList refIndexMapping = this.analysisContext.getRefIndexList();
        IntList sizesMapping = this.analysisContext.getSizesList();
        IntOpenHashSet disposedObjectsIDsSet = this.analysisContext.getDisposedObjectsIDs();
        IntArrayList gcPath = new IntArrayList();
        IntArrayList fieldsPath = new IntArrayList();
        IntArrayList sizesPath = new IntArrayList();
        int objectIterationId = objectId;
        int parentId = parentMapping.get(objectIterationId);
        int maxTreeDepth = this.treeDisplayOptions.getMaximumTreeDepth();
        for (int count = 0; count < maxTreeDepth && parentId != objectIterationId; ++count) {
            gcPath.add(objectIterationId);
            fieldsPath.add(refIndexMapping.get(objectIterationId));
            sizesPath.add(sizesMapping.get(objectIterationId));
            objectIterationId = parentId;
            parentId = parentMapping.get(objectIterationId);
        }
        fieldsPath.add(251);
        if (parentId != objectIterationId) {
            int n = this.countOfIgnoredObjects;
            this.countOfIgnoredObjects = n + 1;
            return;
        }
        gcPath.add(objectIterationId);
        sizesPath.add(sizesMapping.get(objectIterationId));
        boolean bl2 = bl = gcPath.size() == fieldsPath.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int size2 = this.objectSizeStrategy.calculateObjectSize(nav, objectId);
        Node currentNode = this.topNode;
        for (int i2 = gcPath.size() - 1; -1 < i2; --i2) {
            int id2 = gcPath.getInt(i2);
            ClassDefinition classDefinition = nav.getClassForObjectId(id2);
            currentNode = currentNode.addEdge(id2, size2, sizesPath.getInt(i2), classDefinition, (byte)fieldsPath.getInt(i2), disposedObjectsIDsSet.contains(id2));
        }
    }

    @NotNull
    public final String printTree() {
        StringBuilder result2 = new StringBuilder();
        if (this.countOfIgnoredObjects > 0) {
            result2.append("Ignored " + this.countOfIgnoredObjects + " too-deep objects\n");
        }
        Function1 rootReasonGetter = arg_0 -> GCRootPathsTree.printTree$lambda$0(this, arg_0);
        result2.append(this.topNode.createHotPathReport(this.treeDisplayOptions, (Function1<? super Integer, String>)rootReasonGetter));
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Map<ClassDefinition, List<RegularNode>> getDisposedDominatorNodes() {
        HashMap result2 = new HashMap();
        this.topNode.collectDisposedDominatorNodes(result2);
        return result2;
    }

    private static final String printTree$lambda$0(GCRootPathsTree this$0, int id2) {
        Object object = this$0.analysisContext.getNavigator().getRootReasonForObjectId(id2);
        if (object == null || (object = ((RootReason)object).getDescription()) == null) {
            object = "<Couldn't find root description>";
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$AllObjectsSameSizeStrategy;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "size", "", "<init>", "(I)V", "objectSize", "calculateObjectSize", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "intellij.platform.ide.impl"})
    private static final class AllObjectsSameSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final int objectSize;

        public AllObjectsSameSizeStrategy(int size2) {
            this.objectSize = size2;
        }

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
            return this.objectSize;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$DirectByteBufferNativeSizeStrategy;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "calculateObjectSize", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "intellij.platform.ide.impl"})
    private static final class DirectByteBufferNativeSizeStrategy
    implements ObjectSizeCalculationStrategy {
        @NotNull
        private final ClassDefinition classDefinition;

        public DirectByteBufferNativeSizeStrategy(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            boolean bl = Intrinsics.areEqual((Object)this.classDefinition.getName(), (Object)"java.nio.DirectByteBuffer");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
            nav.goTo(id2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            boolean bl = Intrinsics.areEqual((Object)nav.getClass(), (Object)this.classDefinition);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return nav.getExtraData() + nav.getObjectSize();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;BZ)V", "getClassDefinition", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getRefIndex", "()B", "getDisposed", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class Edge {
        @NotNull
        private final ClassDefinition classDefinition;
        private final byte refIndex;
        private final boolean disposed;

        public Edge(@NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.refIndex = refIndex;
            this.disposed = disposed;
        }

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final byte getRefIndex() {
            return this.refIndex;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final byte component2() {
            return this.refIndex;
        }

        public final boolean component3() {
            return this.disposed;
        }

        @NotNull
        public final Edge copy(@NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            return new Edge(classDefinition, refIndex, disposed);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, ClassDefinition classDefinition, byte by, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = edge.classDefinition;
            }
            if ((n & 2) != 0) {
                by = edge.refIndex;
            }
            if ((n & 4) != 0) {
                bl = edge.disposed;
            }
            return edge.copy(classDefinition, by, bl);
        }

        @NotNull
        public String toString() {
            return "Edge(classDefinition=" + this.classDefinition + ", refIndex=" + this.refIndex + ", disposed=" + this.disposed + ")";
        }

        public int hashCode() {
            int result2 = this.classDefinition.hashCode();
            result2 = result2 * 31 + Byte.hashCode(this.refIndex);
            result2 = result2 * 31 + Boolean.hashCode(this.disposed);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)edge.classDefinition)) {
                return false;
            }
            if (this.refIndex != edge.refIndex) {
                return false;
            }
            return this.disposed == edge.disposed;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "intellij.platform.ide.impl"})
    public static interface Node {
        @NotNull
        public Node addEdge(int var1, int var2, int var3, @NotNull ClassDefinition var4, byte var5, boolean var6);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "", "calculateObjectSize", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "Companion", "intellij.platform.ide.impl"})
    public static interface ObjectSizeCalculationStrategy {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public int calculateObjectSize(@NotNull ObjectNavigator var1, int var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy$Companion;", "", "<init>", "()V", "getBestStrategyForClass", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "intellij.platform.ide.impl"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final ObjectSizeCalculationStrategy getBestStrategyForClass(@Nullable ClassDefinition classDefinition) {
                if (classDefinition == null || classDefinition.isArray()) {
                    return new SizeFromObjectNavigatorStrategy();
                }
                if (Intrinsics.areEqual((Object)classDefinition.getName(), (Object)"java.nio.DirectByteBuffer")) {
                    return new DirectByteBufferNativeSizeStrategy(classDefinition);
                }
                return new AllObjectsSameSizeStrategy(classDefinition.getInstanceSize() + 8);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020&2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000)0(R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "<init>", "()V", "edges", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Ljava/util/HashMap;", "setEdges", "(Ljava/util/HashMap;)V", "pathsCount", "", "getPathsCount", "()I", "setPathsCount", "(I)V", "pathsSize", "getPathsSize", "setPathsSize", "totalSizeInDwords", "getTotalSizeInDwords", "setTotalSizeInDwords", "instances", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "getInstances", "()Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "addEdge", "objectId", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "collectDisposedDominatorNodes", "", "result", "", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nGCRootPathsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCRootPathsTree.kt\ncom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,455:1\n382#2,7:456\n382#2,7:464\n216#3:463\n217#3:471\n*S KotlinDebug\n*F\n+ 1 GCRootPathsTree.kt\ncom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode\n*L\n210#1:456,7\n238#1:464,7\n236#1:463\n236#1:471\n*E\n"})
    public static final class RegularNode
    implements Node {
        @Nullable
        private HashMap<Edge, RegularNode> edges;
        private int pathsCount;
        private int pathsSize;
        private int totalSizeInDwords;
        @NotNull
        private final IntOpenHashSet instances = new IntOpenHashSet(1);

        @Nullable
        public final HashMap<Edge, RegularNode> getEdges() {
            return this.edges;
        }

        public final void setEdges(@Nullable HashMap<Edge, RegularNode> hashMap) {
            this.edges = hashMap;
        }

        public final int getPathsCount() {
            return this.pathsCount;
        }

        public final void setPathsCount(int n) {
            this.pathsCount = n;
        }

        public final int getPathsSize() {
            return this.pathsSize;
        }

        public final void setPathsSize(int n) {
            this.pathsSize = n;
        }

        public final int getTotalSizeInDwords() {
            return this.totalSizeInDwords;
        }

        public final void setTotalSizeInDwords(int n) {
            this.totalSizeInDwords = n;
        }

        @NotNull
        public final IntOpenHashSet getInstances() {
            return this.instances;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Object object;
            void $this$getOrPut$iv22;
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            HashMap<Edge, RegularNode> localEdges = this.edges;
            if (localEdges == null) {
                this.edges = localEdges = new HashMap(1);
            }
            Map map2 = localEdges;
            Edge key$iv = new Edge(classDefinition, refIndex, disposed);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RegularNode answer$iv = new RegularNode();
                $this$getOrPut$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RegularNode node = (RegularNode)object;
            int $this$getOrPut$iv22 = node.pathsCount;
            node.pathsCount = $this$getOrPut$iv22 + 1;
            node.pathsSize = (long)node.pathsSize + (long)objectSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.pathsSize += objectSize);
            boolean added = node.instances.add(objectId);
            if (added) {
                node.totalSizeInDwords = (long)node.totalSizeInDwords + (long)subgraphSizeInDwords > Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.totalSizeInDwords += subgraphSizeInDwords);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            ArrayDeque<RegularNode> stack = new ArrayDeque<RegularNode>();
            stack.push(this);
            while (!((Collection)stack).isEmpty()) {
                RegularNode currentNode = (RegularNode)stack.pop();
                HashMap<Edge, RegularNode> hashMap = currentNode.edges;
                if (hashMap == null) continue;
                Map $this$forEach$iv = hashMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    Edge edge = (Edge)entry.getKey();
                    RegularNode childNode = (RegularNode)entry.getValue();
                    if (edge.getDisposed()) {
                        Object object;
                        void $this$getOrPut$iv;
                        Map<ClassDefinition, List<RegularNode>> map2 = result2;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(childNode);
                        continue;
                    }
                    stack.push(childNode);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a0\u001eJ\u0087\u0001\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\"0\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u000f2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\u000f2\u0006\u0010)\u001a\u00020*2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010+\u001a\u0004\u0018\u00010\u001a2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u00020 2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00064"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "edges", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lkotlin/Pair;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "calculateTotalInstanceCount", "createHotPathReport", "", "treeDisplayOptions", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "rootReasonGetter", "Lkotlin/Function1;", "printReportLine", "", "printFunc", "", "pathsCount", "percent", "instanceSize", "subgraphSize", "", "instanceCount", "status", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Status;", "fieldName", "indent", "text", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Integer;Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Status;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "collectDisposedDominatorNodes", "result", "", "", "StackEntry", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nGCRootPathsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCRootPathsTree.kt\ncom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1068#2:456\n785#2:457\n796#2:458\n1878#2,2:459\n797#2,2:461\n1880#2:463\n799#2:464\n1878#2,2:465\n785#2:467\n796#2:468\n1878#2,2:469\n797#2,2:471\n1880#2:473\n799#2:474\n1878#2,3:475\n1880#2:478\n1#3:479\n*S KotlinDebug\n*F\n+ 1 GCRootPathsTree.kt\ncom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode\n*L\n317#1:456\n318#1:457\n318#1:458\n318#1:459,2\n318#1:461,2\n318#1:463\n318#1:464\n323#1:465,2\n385#1:467\n385#1:468\n385#1:469,2\n385#1:471,2\n385#1:473\n385#1:474\n407#1:475,3\n323#1:478\n*E\n"})
    public static final class RootNode
    implements Node {
        @NotNull
        private final ClassStore classStore;
        @NotNull
        private final Int2ObjectOpenHashMap<Pair<RegularNode, Edge>> edges;

        public RootNode(@NotNull ClassStore classStore) {
            Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
            this.classStore = classStore;
            this.edges = new Int2ObjectOpenHashMap();
        }

        @NotNull
        public final Int2ObjectOpenHashMap<Pair<RegularNode, Edge>> getEdges() {
            return this.edges;
        }

        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            Pair pair = (Pair)this.edges.get(objectId);
            RegularNode nullableNode = pair != null ? (RegularNode)pair.getFirst() : null;
            RegularNode node = null;
            if (nullableNode != null) {
                node = nullableNode;
            } else {
                RegularNode newNode = new RegularNode();
                Pair pair2 = new Pair((Object)newNode, (Object)new Edge(classDefinition, refIndex, disposed));
                newNode.getInstances().add(objectId);
                this.edges.put(objectId, (Object)pair2);
                node = newNode;
                node.setTotalSizeInDwords(subgraphSizeInDwords);
            }
            int n = node.getPathsCount();
            node.setPathsCount(n + 1);
            if ((long)node.getPathsSize() + (long)objectSize > Integer.MAX_VALUE) {
                node.setPathsSize(Integer.MAX_VALUE);
            } else {
                node.setPathsSize(node.getPathsSize() + objectSize);
            }
            return node;
        }

        private final int calculateTotalInstanceCount() {
            int result2 = 0;
            ObjectIterator objectIterator = ((ObjectCollection)this.edges.values()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                Pair node = (Pair)objectIterator2.next();
                result2 += ((RegularNode)node.getFirst()).getPathsCount();
            }
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String createHotPathReport(@NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @NotNull Function1<? super Integer, String> rootReasonGetter) {
            void $this$forEachIndexed$iv;
            Object object;
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv;
            Iterable $this$sortedByDescending$iv;
            Intrinsics.checkNotNullParameter((Object)treeDisplayOptions, (String)"treeDisplayOptions");
            Intrinsics.checkNotNullParameter(rootReasonGetter, (String)"rootReasonGetter");
            List rootList = new ArrayList();
            StringBuilder result2 = new StringBuilder();
            Function1 printFunc = arg_0 -> RootNode.createHotPathReport$lambda$0(result2, arg_0);
            ObjectIterator objectIterator = this.edges.int2ObjectEntrySet().fastIterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (((Iterator)objectIterator2).hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
                rootList.add(new Triple((Object)entry.getIntKey(), ((Pair)entry.getValue()).getFirst(), ((Pair)entry.getValue()).getSecond()));
            }
            int totalInstanceCount = this.calculateTotalInstanceCount();
            int minimumObjectsForReport = Math.min(treeDisplayOptions.getMinimumObjectCount(), (int)(Math.ceil((double)totalInstanceCount / 100.0) * (double)treeDisplayOptions.getMinimumObjectCountPercent()));
            Iterable iterable = rootList;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Triple it = (Triple)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize());
                    it = (Triple)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize()));
                }
            });
            boolean $i$f$filterIndexed = false;
            void var10_12 = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                object = (Triple)element$iv$iv;
                int index = index$iv$iv;
                boolean bl2 = false;
                RegularNode node = (RegularNode)object.component2();
                if (!(index < treeDisplayOptions.getMinimumPaths() || node.getPathsCount() >= minimumObjectsForReport || node.getPathsSize() >= treeDisplayOptions.getMinimumObjectSize())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Triple triple = (Triple)item$iv;
                int index = n;
                boolean bl = false;
                int rootObjectId = ((Number)triple.component1()).intValue();
                RegularNode rootNode = (RegularNode)triple.component2();
                Edge rootEdge = (Edge)triple.component3();
                String rootReasonString = (String)rootReasonGetter.invoke((Object)rootObjectId);
                int rootPercent = (int)(100.0 * (double)rootNode.getPathsCount() / (double)totalInstanceCount);
                result2.append("Root " + (index + 1) + ":").append('\n');
                this.printReportLine((Function1<? super String, ? extends Object>)printFunc, treeDisplayOptions, rootNode.getPathsCount(), rootPercent, rootNode.getPathsSize(), (long)rootNode.getTotalSizeInDwords() * (long)4, 1, Status.Companion.getStatus(251, false, false), false, null, "", "ROOT: " + rootReasonString);
                object = new TruncatingPrintBuffer(treeDisplayOptions.getHeadLimit(), treeDisplayOptions.getTailLimit(), (Function1<? super String, ? extends Object>)printFunc);
                Throwable throwable = null;
                try {
                    TruncatingPrintBuffer buffer2 = (TruncatingPrintBuffer)object;
                    boolean bl3 = false;
                    ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
                    stack.push(new StackEntry(null, rootEdge, rootNode, "", ""));
                    while (!stack.isEmpty()) {
                        void $this$filterIndexedTo$iv$iv2;
                        void $this$filterIndexed$iv2;
                        HashMap<Edge, RegularNode> currentNodeEdges;
                        StackEntry stackEntry = (StackEntry)stack.pop();
                        ClassDefinition parentClass = stackEntry.component1();
                        Edge edge = stackEntry.component2();
                        RegularNode node = stackEntry.component3();
                        String indent = stackEntry.component4();
                        String nextIndent = stackEntry.component5();
                        ClassDefinition classDefinition = edge.component1();
                        byte refIndexByte = edge.component2();
                        boolean disposed = edge.component3();
                        int refIndex = Byte.toUnsignedInt(refIndexByte);
                        this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>((Object)buffer2){

                            public final void invoke(String p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                ((TruncatingPrintBuffer)this.receiver).println(p0);
                            }
                        }), treeDisplayOptions, node.getPathsCount(), (int)(100.0 * (double)node.getPathsCount() / (double)totalInstanceCount), node.getPathsSize(), (long)node.getTotalSizeInDwords() * (long)4, node.getInstances().size(), Status.Companion.getStatus(refIndex, node.getEdges() == null, disposed), disposed, RefIndexUtil.INSTANCE.getFieldDescription(refIndex, parentClass, this.classStore), indent, classDefinition.getPrettyName());
                        if (node.getEdges() == null) continue;
                        Set<Map.Entry<Edge, RegularNode>> set = currentNodeEdges.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                        Iterable iterable2 = CollectionsKt.sortedWith((Iterable)set, (arg_0, arg_1) -> RootNode.createHotPathReport$lambda$3$0$1(RootNode::createHotPathReport$lambda$3$0$0, arg_0, arg_1));
                        boolean $i$f$filterIndexed2 = false;
                        void var40_55 = $this$filterIndexed$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIndexedTo2 = false;
                        void $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv2;
                        boolean $i$f$forEachIndexed32 = false;
                        int index$iv$iv$iv2 = 0;
                        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
                            void e;
                            void element$iv$iv;
                            int n2;
                            if ((n2 = index$iv$iv$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Object t = item$iv$iv$iv;
                            int index$iv$iv = n2;
                            boolean bl4 = false;
                            Map.Entry entry = (Map.Entry)element$iv$iv;
                            int index2 = index$iv$iv;
                            boolean bl5 = false;
                            if (!(index2 == 0 || ((RegularNode)e.getValue()).getPathsCount() >= minimumObjectsForReport || ((RegularNode)e.getValue()).getPathsSize() >= treeDisplayOptions.getMinimumObjectSize() || (long)((RegularNode)e.getValue()).getTotalSizeInDwords() * (long)4 >= treeDisplayOptions.getMinimumSubgraphSize())) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List childrenToReport = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
                        if (childrenToReport.size() == 1 && treeDisplayOptions.getSmartIndent()) {
                            Object k = ((Map.Entry)childrenToReport.get(0)).getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                            Edge edge2 = (Edge)k;
                            Object v = ((Map.Entry)childrenToReport.get(0)).getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            stack.push(new StackEntry(classDefinition, edge2, (RegularNode)v, nextIndent, nextIndent));
                            continue;
                        }
                        if (nextIndent.length() >= treeDisplayOptions.getMaximumIndent()) {
                            this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>((Object)buffer2){

                                public final void invoke(String p0) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    ((TruncatingPrintBuffer)this.receiver).println(p0);
                                }
                            }), treeDisplayOptions, null, null, null, null, null, Status.LastInPath, null, null, nextIndent, "\\-[...]");
                            continue;
                        }
                        Iterable $this$forEachIndexed$iv2 = childrenToReport;
                        boolean $i$f$forEachIndexed4 = false;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $this$forEachIndexed$iv2) {
                            void e;
                            int n3;
                            if ((n3 = index$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Map.Entry $i$f$forEachIndexed32 = (Map.Entry)item$iv2;
                            int index3 = n3;
                            boolean bl6 = false;
                            if (index3 == 0) {
                                Object k = e.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                                Edge edge3 = (Edge)k;
                                Object v = e.getValue();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                                stack.push(new StackEntry(classDefinition, edge3, (RegularNode)v, nextIndent + "\\-", nextIndent + "  "));
                                continue;
                            }
                            Object k = e.getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                            Edge edge4 = (Edge)k;
                            Object v = e.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            stack.push(new StackEntry(classDefinition, edge4, (RegularNode)v, nextIndent + "+-", nextIndent + "| "));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void printReportLine(Function1<? super String, ? extends Object> printFunc, AnalysisConfig.TreeDisplayOptions treeDisplayOptions, Integer pathsCount, Integer percent, Integer instanceSize, Long subgraphSize, Integer instanceCount, Status status2, Boolean disposed, String fieldName, String indent, String text2) {
            Object object;
            String disposedString;
            Object fieldNameString;
            String instanceCountString;
            String instanceSizeString;
            String percentString;
            String pathsCountString;
            block20: {
                block19: {
                    Object object2;
                    block18: {
                        block17: {
                            Object object3;
                            block16: {
                                block15: {
                                    Object object4;
                                    block14: {
                                        block13: {
                                            object4 = pathsCount;
                                            if (object4 == null) break block13;
                                            int it = ((Number)object4).intValue();
                                            boolean bl = false;
                                            String string = HeapReportUtils.INSTANCE.toShortStringAsCount(it);
                                            object4 = string;
                                            if (string != null) break block14;
                                        }
                                        object4 = "";
                                    }
                                    pathsCountString = StringsKt.padStart$default((String)object4, (int)5, (char)'\u0000', (int)2, null);
                                    object3 = percent;
                                    if (object3 == null) break block15;
                                    int it = ((Number)object3).intValue();
                                    boolean bl = false;
                                    String string = it + "%";
                                    object3 = string;
                                    if (string != null) break block16;
                                }
                                object3 = "";
                            }
                            percentString = StringsKt.padStart$default((String)object3, (int)4, (char)'\u0000', (int)2, null);
                            object2 = instanceSize;
                            if (object2 == null) break block17;
                            int it = ((Number)object2).intValue();
                            boolean bl = false;
                            String string = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                            object2 = string;
                            if (string != null) break block18;
                        }
                        object2 = "";
                    }
                    instanceSizeString = StringsKt.padStart$default((String)object2, (int)6, (char)'\u0000', (int)2, null);
                    Object object5 = instanceCount;
                    if (object5 == null) {
                        object5 = "";
                    }
                    instanceCountString = StringsKt.padStart$default((String)object5.toString(), (int)10, (char)'\u0000', (int)2, null);
                    String string = fieldName;
                    fieldNameString = string != null ? string + ": " : "";
                    disposedString = Intrinsics.areEqual((Object)disposed, (Object)true) ? " (disposed)" : "";
                    object = subgraphSize;
                    if (object == null) break block19;
                    long it = ((Number)object).longValue();
                    boolean bl = false;
                    String string2 = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                    object = string2;
                    if (string2 != null) break block20;
                }
                object = "";
            }
            String subgraphSizeString = StringsKt.padStart$default((String)object, (int)6, (char)'\u0000', (int)2, null);
            Object object6 = treeDisplayOptions.getShowSize() ? printFunc.invoke((Object)("[" + pathsCountString + "/" + percentString + "/" + instanceSizeString + "] " + subgraphSizeString + " " + instanceCountString + " " + status2 + " " + indent + (String)fieldNameString + text2 + disposedString)) : printFunc.invoke((Object)(status2 + " " + indent + (String)fieldNameString + text2 + disposedString));
        }

        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            ObjectIterator objectIterator = ((ObjectCollection)this.edges.values()).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                Pair value = (Pair)objectIterator2.next();
                ((RegularNode)value.getFirst()).collectDisposedDominatorNodes(result2);
            }
        }

        private static final Unit createHotPathReport$lambda$0(StringBuilder $result, String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            $result.append(s).append('\n');
            return Unit.INSTANCE;
        }

        private static final int createHotPathReport$lambda$3$0$0(Map.Entry a, Map.Entry b) {
            int compareByPathsSizeDesc = Intrinsics.compare((int)((RegularNode)b.getValue()).getPathsSize(), (int)((RegularNode)a.getValue()).getPathsSize());
            if (compareByPathsSizeDesc != 0) {
                return compareByPathsSizeDesc;
            }
            int compareByTotalSizeDesc = Intrinsics.compare((int)((RegularNode)b.getValue()).getTotalSizeInDwords(), (int)((RegularNode)a.getValue()).getTotalSizeInDwords());
            if (compareByTotalSizeDesc != 0) {
                return compareByTotalSizeDesc;
            }
            int compareByRefIndex = Intrinsics.compare((int)((Edge)a.getKey()).getRefIndex(), (int)((Edge)b.getKey()).getRefIndex());
            if (compareByRefIndex != 0) {
                return compareByRefIndex;
            }
            int compareByClassName = ((Edge)a.getKey()).getClassDefinition().getName().compareTo(((Edge)b.getKey()).getClassDefinition().getName());
            return compareByClassName;
        }

        private static final int createHotPathReport$lambda$3$0$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode$StackEntry;", "", "parentClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "edge", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "node", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "indent", "", "nextIndent", "<init>", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;Ljava/lang/String;Ljava/lang/String;)V", "getParentClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getEdge", "()Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getNode", "()Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
        public static final class StackEntry {
            @Nullable
            private final ClassDefinition parentClass;
            @NotNull
            private final Edge edge;
            @NotNull
            private final RegularNode node;
            @NotNull
            private final String indent;
            @NotNull
            private final String nextIndent;

            public StackEntry(@Nullable ClassDefinition parentClass, @NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                Intrinsics.checkNotNullParameter((Object)nextIndent, (String)"nextIndent");
                this.parentClass = parentClass;
                this.edge = edge;
                this.node = node;
                this.indent = indent;
                this.nextIndent = nextIndent;
            }

            @Nullable
            public final ClassDefinition getParentClass() {
                return this.parentClass;
            }

            @NotNull
            public final Edge getEdge() {
                return this.edge;
            }

            @NotNull
            public final RegularNode getNode() {
                return this.node;
            }

            @NotNull
            public final String getIndent() {
                return this.indent;
            }

            @NotNull
            public final String getNextIndent() {
                return this.nextIndent;
            }

            @Nullable
            public final ClassDefinition component1() {
                return this.parentClass;
            }

            @NotNull
            public final Edge component2() {
                return this.edge;
            }

            @NotNull
            public final RegularNode component3() {
                return this.node;
            }

            @NotNull
            public final String component4() {
                return this.indent;
            }

            @NotNull
            public final String component5() {
                return this.nextIndent;
            }

            @NotNull
            public final StackEntry copy(@Nullable ClassDefinition parentClass, @NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                Intrinsics.checkNotNullParameter((Object)nextIndent, (String)"nextIndent");
                return new StackEntry(parentClass, edge, node, indent, nextIndent);
            }

            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, ClassDefinition classDefinition, Edge edge, RegularNode regularNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    classDefinition = stackEntry.parentClass;
                }
                if ((n & 2) != 0) {
                    edge = stackEntry.edge;
                }
                if ((n & 4) != 0) {
                    regularNode = stackEntry.node;
                }
                if ((n & 8) != 0) {
                    string = stackEntry.indent;
                }
                if ((n & 0x10) != 0) {
                    string2 = stackEntry.nextIndent;
                }
                return stackEntry.copy(classDefinition, edge, regularNode, string, string2);
            }

            @NotNull
            public String toString() {
                return "StackEntry(parentClass=" + this.parentClass + ", edge=" + this.edge + ", node=" + this.node + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
            }

            public int hashCode() {
                int result2 = this.parentClass == null ? 0 : this.parentClass.hashCode();
                result2 = result2 * 31 + this.edge.hashCode();
                result2 = result2 * 31 + this.node.hashCode();
                result2 = result2 * 31 + this.indent.hashCode();
                result2 = result2 * 31 + this.nextIndent.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackEntry)) {
                    return false;
                }
                StackEntry stackEntry = (StackEntry)other;
                if (!Intrinsics.areEqual((Object)this.parentClass, (Object)stackEntry.parentClass)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.edge, (Object)stackEntry.edge)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$SizeFromObjectNavigatorStrategy;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "<init>", "()V", "calculateObjectSize", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "intellij.platform.ide.impl"})
    private static final class SizeFromObjectNavigatorStrategy
    implements ObjectSizeCalculationStrategy {
        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkNotNullParameter((Object)nav, (String)"nav");
            nav.goTo(id2, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            return nav.getObjectSize();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\nj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Status;", "", "<init>", "(Ljava/lang/String;I)V", "None", "Warning", "LastInPath", "toString", "", "getStatusCharacter", "", "Companion", "intellij.platform.ide.impl"})
    private static final class Status
    extends Enum<Status> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Status None;
        public static final /* enum */ Status Warning;
        public static final /* enum */ Status LastInPath;
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String toString() {
            return String.valueOf(this.getStatusCharacter());
        }

        public final char getStatusCharacter() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> ' ';
                case 2 -> '!';
                case 3 -> '*';
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            None = new Status();
            Warning = new Status();
            LastInPath = new Status();
            $VALUES = statusArray = new Status[]{Status.None, Status.Warning, Status.LastInPath};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Status$Companion;", "", "<init>", "()V", "getStatus", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Status;", "refIndex", "", "lastInPath", "", "disposed", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Status getStatus(int refIndex, boolean lastInPath, boolean disposed) {
                return lastInPath ? LastInPath : (disposed ? Warning : (refIndex == 252 ? Warning : (refIndex == 253 ? Warning : None)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Status.values().length];
                try {
                    nArray[Status.None.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.Warning.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.LastInPath.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

