/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.ClassNomination;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.diagnostic.hprof.classstore.HProfMetadata;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.util.FileBackedIntList;
import com.intellij.diagnostic.hprof.util.FileBackedUByteList;
import com.intellij.diagnostic.hprof.util.FileBackedUShortList;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IDMapper;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.ListProvider;
import com.intellij.diagnostic.hprof.util.PartialProgressIndicator;
import com.intellij.diagnostic.hprof.util.UByteList;
import com.intellij.diagnostic.hprof.util.UShortList;
import com.intellij.diagnostic.hprof.visitors.RemapIDsVisitor;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004*\u0001!\u0018\u00002\u00020\u0001:\u0002/0B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J\u0012\u0010\u001e\u001a\u00020\u00032\b\b\u0001\u0010\u001f\u001a\u00020\u000bH\u0002J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\nJ\u001c\u0010%\u001a\u00020\u000b2\n\u0010&\u001a\u00060'j\u0002`(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u00061"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis;", "", "hprofFileChannel", "Ljava/nio/channels/FileChannel;", "tempFilenameSupplier", "Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "analysisCallback", "Lkotlin/Function3;", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "Lcom/intellij/diagnostic/hprof/util/ListProvider;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "<init>", "(Ljava/nio/channels/FileChannel;Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFilenameSupplier;Lkotlin/jvm/functions/Function3;)V", "tempFiles", "", "Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFile;", "includeMetaInfo", "", "setIncludeMetaInfo", "", "value", "onlyStrongReferences", "getOnlyStrongReferences", "()Z", "setOnlyStrongReferences", "(Z)V", "includeClassesAsRoots", "getIncludeClassesAsRoots", "setIncludeClassesAsRoots", "openTempEmptyFileChannel", "type", "fileBackedListProvider", "com/intellij/diagnostic/hprof/analysis/HProfAnalysis$fileBackedListProvider$1", "Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$fileBackedListProvider$1;", "analyze", "progress", "prepareSimplifiedReport", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "histogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "isSupported", "instanceCount", "", "closeAndDeleteTemporaryFiles", "TempFilenameSupplier", "TempFile", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHProfAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProfAnalysis.kt\ncom/intellij/diagnostic/hprof/analysis/HProfAnalysis\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1563#2:226\n1634#2,3:227\n1869#2,2:230\n1869#2:232\n1870#2:234\n1#3:233\n*S KotlinDebug\n*F\n+ 1 HProfAnalysis.kt\ncom/intellij/diagnostic/hprof/analysis/HProfAnalysis\n*L\n152#1:226\n152#1:227,3\n183#1:230,2\n210#1:232\n210#1:234\n*E\n"})
public final class HProfAnalysis {
    @NotNull
    private final FileChannel hprofFileChannel;
    @NotNull
    private final TempFilenameSupplier tempFilenameSupplier;
    @NotNull
    private final Function3<AnalysisContext, ListProvider, ProgressIndicator, String> analysisCallback;
    @NotNull
    private final List<TempFile> tempFiles;
    private boolean includeMetaInfo;
    private boolean onlyStrongReferences;
    private boolean includeClassesAsRoots;
    @NotNull
    private final fileBackedListProvider.1 fileBackedListProvider;

    public HProfAnalysis(@NotNull FileChannel hprofFileChannel, @NotNull TempFilenameSupplier tempFilenameSupplier, @NotNull Function3<? super AnalysisContext, ? super ListProvider, ? super ProgressIndicator, String> analysisCallback) {
        Intrinsics.checkNotNullParameter((Object)hprofFileChannel, (String)"hprofFileChannel");
        Intrinsics.checkNotNullParameter((Object)tempFilenameSupplier, (String)"tempFilenameSupplier");
        Intrinsics.checkNotNullParameter(analysisCallback, (String)"analysisCallback");
        this.hprofFileChannel = hprofFileChannel;
        this.tempFilenameSupplier = tempFilenameSupplier;
        this.analysisCallback = analysisCallback;
        this.tempFiles = new ArrayList();
        this.includeMetaInfo = true;
        this.includeClassesAsRoots = true;
        this.fileBackedListProvider = new ListProvider(this){
            final /* synthetic */ HProfAnalysis this$0;
            {
                this.this$0 = $receiver;
            }

            public UByteList createUByteList(String name2, long size2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return FileBackedUByteList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name2), size2);
            }

            public UShortList createUShortList(String name2, long size2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return FileBackedUShortList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name2), size2);
            }

            public IntList createIntList(String name2, long size2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return FileBackedIntList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name2), size2);
            }
        };
    }

    public final void setIncludeMetaInfo(boolean value) {
        this.includeMetaInfo = value;
    }

    public final boolean getOnlyStrongReferences() {
        return this.onlyStrongReferences;
    }

    public final void setOnlyStrongReferences(boolean bl) {
        this.onlyStrongReferences = bl;
    }

    public final boolean getIncludeClassesAsRoots() {
        return this.includeClassesAsRoots;
    }

    public final void setIncludeClassesAsRoots(boolean bl) {
        this.includeClassesAsRoots = bl;
    }

    private final FileChannel openTempEmptyFileChannel(@NonNls String type) {
        Path tempPath = this.tempFilenameSupplier.getTempFilePath(type);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE};
        FileChannel tempChannel = FileChannel.open(tempPath, openOptionArray);
        Intrinsics.checkNotNull((Object)tempChannel);
        this.tempFiles.add(new TempFile(type, tempPath, tempChannel));
        return tempChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        Stopwatch stopwatch = Stopwatch.createStarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createStarted(...)");
        Stopwatch totalStopwatch = stopwatch;
        Stopwatch stopwatch2 = Stopwatch.createStarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"createStarted(...)");
        Stopwatch prepareFilesStopwatch = stopwatch2;
        Stopwatch stopwatch3 = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch3, (String)"createUnstarted(...)");
        Stopwatch analysisStopwatch = stopwatch3;
        progress.setText(DiagnosticBundle.message("hprof.analysis.progress.text.analyze.heap", new Object[0]));
        progress.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.open.heap.file", new Object[0]));
        progress.setFraction(0.0);
        HProfEventBasedParser parser = new HProfEventBasedParser(this.hprofFileChannel);
        try {
            AnalysisConfig.MetaInfoOptions $this$mapTo$iv$iv;
            ObjectNavigator objectNavigator;
            progress.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.class.definition.map", new Object[0]));
            progress.setFraction(0.0);
            HProfMetadata hprofMetadata = HProfMetadata.Companion.create(parser);
            progress.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.class.histogram", new Object[0]));
            progress.setFraction(0.1);
            Histogram histogram = Histogram.Companion.create(parser, hprofMetadata.getClassStore());
            List<HistogramEntry> nominatedClasses = new ClassNomination(histogram, 10).nominateClasses();
            progress.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.id.mapping.file", new Object[0]));
            progress.setFraction(0.2);
            if (!this.isSupported(histogram.getInstanceCount())) {
                String string = this.prepareSimplifiedReport(result2, histogram);
                return string;
            }
            FileChannel idMappingChannel = this.openTempEmptyFileChannel("id-mapping");
            RemapIDsVisitor remapIDsVisitor = RemapIDsVisitor.Companion.createFileBased(idMappingChannel, histogram.getInstanceCount());
            parser.accept(remapIDsVisitor, "id mapping");
            IDMapper idMapper = remapIDsVisitor.getIDMapper();
            parser.setIDMapper(idMapper);
            hprofMetadata.remapIds(idMapper);
            progress.setText2(DiagnosticBundle.message("hprof.analysis.progress.details.create.object.graph.files", new Object[0]));
            progress.setFraction(0.3);
            try {
                objectNavigator = ObjectNavigator.Companion.createOnAuxiliaryFiles(parser, this.openTempEmptyFileChannel("auxOffset"), this.openTempEmptyFileChannel("aux"), hprofMetadata, histogram.getInstanceCount());
            }
            catch (IllegalArgumentException e) {
                String string = this.prepareSimplifiedReport(result2, histogram);
                parser.close();
                this.closeAndDeleteTemporaryFiles();
                return string;
            }
            ObjectNavigator navigator = objectNavigator;
            prepareFilesStopwatch.stop();
            IntList parentList = this.fileBackedListProvider.createIntList("parents", navigator.getInstanceCount() + 1L);
            IntList sizesList = this.fileBackedListProvider.createIntList("sizes", navigator.getInstanceCount() + 1L);
            IntList visitedList = this.fileBackedListProvider.createIntList("visited", navigator.getInstanceCount() + 1L);
            UByteList refIndexList = this.fileBackedListProvider.createUByteList("refIndex", navigator.getInstanceCount() + 1L);
            analysisStopwatch.start();
            Iterable $this$map$iv = nominatedClasses;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                HistogramEntry histogramEntry = (HistogramEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getClassDefinition().getName());
            }
            List nominatedClassNames = (List)destination$iv$iv;
            AnalysisConfig.PerClassOptions $i$f$map22 = new AnalysisConfig.PerClassOptions(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)nominatedClassNames, (Iterable)CollectionsKt.listOf((Object)"com.intellij.openapi.editor.impl.EditorImpl")), (Iterable)CollectionsKt.listOf((Object)"com.intellij.openapi.project.impl.ProjectImpl")), false, null, 6, null);
            AnalysisConfig analysisConfig = new AnalysisConfig($i$f$map22, null, null, (AnalysisConfig.TraverseOptions)(destination$iv$iv = new AnalysisConfig.TraverseOptions(this.onlyStrongReferences, this.includeClassesAsRoots, false, false, 12, null)), $this$mapTo$iv$iv = new AnalysisConfig.MetaInfoOptions(this.includeMetaInfo), null, 38, null);
            AnalysisContext analysisContext = new AnalysisContext(navigator, analysisConfig, parentList, sizesList, visitedList, refIndexList, histogram);
            String analysisReport = (String)this.analysisCallback.invoke((Object)analysisContext, (Object)this.fileBackedListProvider, (Object)new PartialProgressIndicator(progress, 0.4, 0.4));
            if (!StringsKt.isBlank((CharSequence)analysisReport)) {
                result2.append(analysisReport).append('\n');
            }
            analysisStopwatch.stop();
            if (this.includeMetaInfo) {
                result2.append(HeapReportUtils.INSTANCE.sectionHeader("Analysis information")).append('\n');
                result2.append("Prepare files duration: " + prepareFilesStopwatch).append('\n');
                result2.append("Analysis duration: " + analysisStopwatch).append('\n');
                result2.append("TOTAL DURATION: " + totalStopwatch).append('\n');
                result2.append("Temp files:").append('\n');
                result2.append("  heapdump = " + HeapReportUtils.INSTANCE.toShortStringAsCount(this.hprofFileChannel.size())).append('\n');
                Iterable $this$forEach$iv = this.tempFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TempFile temp = (TempFile)element$iv;
                    boolean bl = false;
                    FileChannel channel = temp.getChannel();
                    if (!channel.isOpen()) continue;
                    result2.append("  " + temp.getType() + " = " + HeapReportUtils.INSTANCE.toShortStringAsCount(channel.size())).append('\n');
                }
            }
        }
        finally {
            parser.close();
            this.closeAndDeleteTemporaryFiles();
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String prepareSimplifiedReport(StringBuilder result2, Histogram histogram) {
        result2.append(histogram.prepareReport("All", 50)).append('\n');
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isSupported(long instanceCount) {
        return RemapIDsVisitor.Companion.isSupported(instanceCount) && instanceCount <= Integer.MAX_VALUE;
    }

    private final void closeAndDeleteTemporaryFiles() {
        Iterable $this$forEach$iv = this.tempFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TempFile tempFile = (TempFile)element$iv;
            boolean bl = false;
            try {
                tempFile.getChannel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Path it = tempFile.getPath();
                boolean bl2 = false;
                Files.deleteIfExists(it);
            }
            catch (Throwable throwable) {
            }
        }
        this.tempFiles.clear();
    }

    public static final /* synthetic */ FileChannel access$openTempEmptyFileChannel(HProfAnalysis $this, String type) {
        return $this.openTempEmptyFileChannel(type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFile;", "", "type", "", "path", "Ljava/nio/file/Path;", "channel", "Ljava/nio/channels/FileChannel;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/channels/FileChannel;)V", "getType", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "getChannel", "()Ljava/nio/channels/FileChannel;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class TempFile {
        @NotNull
        private final String type;
        @NotNull
        private final Path path;
        @NotNull
        private final FileChannel channel;

        public TempFile(@NotNull String type, @NotNull Path path, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.type = type;
            this.path = path;
            this.channel = channel;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final FileChannel getChannel() {
            return this.channel;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final FileChannel component3() {
            return this.channel;
        }

        @NotNull
        public final TempFile copy(@NotNull String type, @NotNull Path path, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            return new TempFile(type, path, channel);
        }

        public static /* synthetic */ TempFile copy$default(TempFile tempFile, String string, Path path, FileChannel fileChannel, int n, Object object) {
            if ((n & 1) != 0) {
                string = tempFile.type;
            }
            if ((n & 2) != 0) {
                path = tempFile.path;
            }
            if ((n & 4) != 0) {
                fileChannel = tempFile.channel;
            }
            return tempFile.copy(string, path, fileChannel);
        }

        @NotNull
        public String toString() {
            return "TempFile(type=" + this.type + ", path=" + this.path + ", channel=" + this.channel + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            result2 = result2 * 31 + this.channel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempFile)) {
                return false;
            }
            TempFile tempFile = (TempFile)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)tempFile.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)tempFile.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.channel, (Object)tempFile.channel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "", "getTempFilePath", "Ljava/nio/file/Path;", "type", "", "intellij.platform.ide.impl"})
    public static interface TempFilenameSupplier {
        @NotNull
        public Path getTempFilePath(@NotNull String var1);
    }
}

